/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.db;

import com.polyhedra.sql.Connection;
import com.polyhedra.sql.DatabaseMetaData;
import com.polyhedra.sql.DriverManager;
import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import com.polyhedra.sql.Statement;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.PreparedStatementWrapper;
import se.ericsson.crbs.omf.aue.common.db.PreparedStatementWrapperImpl;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class DbWrapperImpl
implements DbWrapper {
    private static final Class THIS_CLASS = DbWrapperImpl.class;
    private static String POLYHEDRA_JDBC_DRIVER = "com.polyhedra.jdbc.JdbcDriver";
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private Connection connection;

    public DbWrapperImpl() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class.forName(POLYHEDRA_JDBC_DRIVER).newInstance();
    }

    protected DbWrapperImpl(Connection connection) {
        this.connection = connection;
    }

    public void openConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            logger.traceDebug(THIS_CLASS, "getConnection: opening a new Connection");
            this.connection = DriverManager.getConnection((String)"jdbc:polyhedra://127.0.0.1:5434");
        }
    }

    public void closeConnection(int inStep) throws SQLException {
        if (inStep == 2 && this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String updateString) throws SQLException {
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            logger.traceDebug(THIS_CLASS, "executeUpdate: " + AueUtil.doubleQuote(updateString));
            stmt.executeUpdate(updateString);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void executeUpdate(Sql.Modification modification) throws SQLException {
        this.executeUpdate(modification.toString());
    }

    public ResultSet executeQuery(String queryString) throws SQLException {
        logger.traceDebug(THIS_CLASS, "executeQuery: " + AueUtil.doubleQuote(queryString));
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery(queryString);
    }

    public ResultSet executeQuery(Sql.Select select) throws SQLException {
        return this.executeQuery(select.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doTableExist(String tableName) throws SQLException {
        boolean tableExists = false;
        ResultSet resultSet = null;
        try {
            resultSet = this.executeQuery("SELECT COUNT(*) FROM tables WHERE name=" + AueUtil.quote(tableName.toLowerCase()));
            if (resultSet.next()) {
                tableExists = resultSet.getInt(1) == 1;
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception ignore) {}
        }
        return tableExists;
    }

    public PreparedStatementWrapper getPrepareStatementWrapper(String queryStr) throws SQLException {
        return new PreparedStatementWrapperImpl(this.connection.prepareStatement(queryStr));
    }

    public PreparedStatementWrapper getPrepareStatementWrapper(Sql sql) throws SQLException {
        return this.getPrepareStatementWrapper(sql.toString());
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }
}

