/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.jar;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import se.ericsson.crbs.omf.aue.common.jar.JarFileManager;
import se.ericsson.crbs.omf.aue.common.jar.PackageHelper;
import se.ericsson.crbs.omf.aue.common.jar.PackageHelperFactory;
import se.ericsson.crbs.omf.aue.common.jar.XmlHolder;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class JarFileManagerImpl
implements JarFileManager {
    private static final Class THIS_CLASS = JarFileManagerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final String propertiesFile;
    private final List xmlFiles = new ArrayList();

    public JarFileManagerImpl(String propertiesFile) throws IOException {
        this.propertiesFile = propertiesFile;
    }

    public void readJarFile() throws IOException {
        logger.traceEnter(THIS_CLASS, "readJarFile()");
        PackageHelper packageHelper = PackageHelperFactory.getInstance().getPackageHelper(this.propertiesFile);
        logger.traceEnter(THIS_CLASS, "readJarFile(" + packageHelper.getJarFilePath() + ")");
        JarFile jarFile = new JarFile(packageHelper.getJarFilePath());
        byte[] chunk = new byte[1024];
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry entry = jarEntries.nextElement();
            if (!entry.toString().endsWith(".xml")) continue;
            InputStream inputStream = jarFile.getInputStream(entry);
            StringBuffer xmlFileContents = new StringBuffer();
            int readLength = inputStream.read(chunk);
            while (readLength > 0) {
                xmlFileContents.append(new String(chunk, 0, readLength));
                readLength = inputStream.read(chunk);
            }
            inputStream.close();
            XmlHolder xmlHolder = new XmlHolder(entry.toString(), xmlFileContents.toString());
            this.xmlFiles.add(xmlHolder);
        }
        jarFile.close();
        logger.traceReturn(THIS_CLASS, "readJarFile(" + packageHelper.getJarFilePath() + ")");
    }

    public XmlHolder[] getXmlHolders() {
        XmlHolder[] xmlHolders = new XmlHolder[this.xmlFiles.size()];
        this.xmlFiles.toArray(xmlHolders);
        return xmlHolders;
    }
}

