/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.util;

import com.polyhedra.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtilHelper;
import se.ericsson.crbs.omf.aue.common.util.HelperClassUtil;

public class AueUtil {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$common$util$AueUtil == null ? (class$se$ericsson$crbs$omf$aue$common$util$AueUtil = AueUtil.class$("se.ericsson.crbs.omf.aue.common.util.AueUtil")) : class$se$ericsson$crbs$omf$aue$common$util$AueUtil;
    private static final String AUE_UTIL_HELPER_IMPL = "se.ericsson.crbs.omf.aue.common.util.AueUtilHelperImpl";
    private static final String INSTANCE_METHOD = "instance";
    public static final String PERFORMED_UPGRADES = "performedUpgrades";
    public static final String MAO = "MAO";
    public static final String FRO = "FRO";
    public static final String FROM_UP = "fromUp";
    public static final String TO_UP = "toUp";
    public static final String UNKNOWN_UP = "-";
    public static final String QUOTE_STRING = "'";
    public static final String DOUBLE_QUOTE_STRING = "\"";
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    protected static final String REASON_STR = " Reason: ";
    private static AueUtilHelper helper = null;
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$common$util$AueUtil;

    private AueUtil() {
    }

    public static final String quote(String strToQuote) {
        return helper.quote(strToQuote);
    }

    public static final String doubleQuote(String strToDoubleQuote) {
        return helper.doubleQuote(strToDoubleQuote);
    }

    public static String convertToString(Throwable throwable) {
        return helper.convertToString(throwable);
    }

    public static String getExceptionMessage(Throwable throwable) {
        return helper.getExceptionMessage(throwable);
    }

    public static String appendReason(String msgToAppendTo, Throwable throwable) {
        return helper.appendReason(msgToAppendTo, throwable);
    }

    public static String replaceInString(String stringToBeReplace, String oldValue, String newValue) {
        int currentIndex = 0;
        int startIndex = 0;
        StringBuffer strBuf = new StringBuffer(stringToBeReplace);
        while (currentIndex != -1) {
            currentIndex = strBuf.indexOf(oldValue, startIndex);
            if (currentIndex <= -1) continue;
            strBuf.replace(currentIndex, currentIndex + oldValue.length(), newValue);
            startIndex = currentIndex + newValue.length();
        }
        return strBuf.toString();
    }

    public static String replaceInLdn(String ldn, String oldValue, String newValue) {
        ArrayList<String> changedLdnElementsList = new ArrayList<String>();
        String correctedLdn = AueUtil.replaceInString(ldn, " ", "");
        String manipulatedOldValue = oldValue + "=";
        String manipulatedNewValue = newValue + "=";
        StringTokenizer tokenizer = new StringTokenizer(correctedLdn, ",");
        while (tokenizer.hasMoreElements()) {
            String ldnElement = (String)tokenizer.nextElement();
            if (ldnElement.startsWith(manipulatedOldValue)) {
                String correctedValue = AueUtil.replaceInString(ldnElement, manipulatedOldValue, manipulatedNewValue);
                changedLdnElementsList.add(correctedValue);
                continue;
            }
            changedLdnElementsList.add(ldnElement);
        }
        StringBuffer newLdnBuffer = new StringBuffer();
        for (int i = 0; i < changedLdnElementsList.size(); ++i) {
            newLdnBuffer.append(changedLdnElementsList.get(i));
            if (i >= changedLdnElementsList.size() - 1) continue;
            newLdnBuffer.append(",");
        }
        return newLdnBuffer.toString();
    }

    public static String getLastLdnElement(String ldn) {
        String lastLdnElement = "";
        if (AueUtil.isLdn(ldn)) {
            String correctedLdn = AueUtil.replaceInString(ldn, " ", "");
            StringTokenizer commaTokenizer = new StringTokenizer(correctedLdn, ",");
            while (commaTokenizer.hasMoreElements()) {
                lastLdnElement = (String)commaTokenizer.nextElement();
            }
            StringTokenizer equalsTokenizer = new StringTokenizer(lastLdnElement, "=");
            lastLdnElement = equalsTokenizer.hasMoreElements() ? (String)equalsTokenizer.nextElement() : "";
        } else {
            lastLdnElement = "";
        }
        return lastLdnElement;
    }

    public static String getRdnElement(String ldn) {
        String rdn = "";
        if (AueUtil.isLdn(ldn)) {
            String correctedLdn = AueUtil.replaceInString(ldn, " ", "");
            rdn = correctedLdn.substring(correctedLdn.lastIndexOf(44) + 1);
        }
        return rdn;
    }

    public static String getRdnAttributeValue(String ldn) {
        logger.traceEnter(THIS_CLASS, "getRdnAttributeValue() " + ldn);
        String rdnElement = "";
        if (AueUtil.isLdn(ldn)) {
            rdnElement = AueUtil.getRdnElement(ldn);
            rdnElement = rdnElement.substring(rdnElement.lastIndexOf(61) + 1);
        }
        logger.traceReturn(THIS_CLASS, "getRdnAttributeValue() " + rdnElement);
        return rdnElement;
    }

    public static boolean isLdn(String stringToBeCkecked) {
        boolean stringIsLdn = true;
        try {
            String correctedString = AueUtil.replaceInString(stringToBeCkecked, " ", "");
            StringTokenizer commaTokenizer = new StringTokenizer(correctedString, ",");
            int numberOfCommas = commaTokenizer.countTokens();
            while (commaTokenizer.hasMoreElements()) {
                String possibleLdnElement = (String)commaTokenizer.nextElement();
                int index = possibleLdnElement.indexOf("=");
                stringIsLdn = stringIsLdn && index > 0 && index < possibleLdnElement.length() - 1;
            }
            StringTokenizer equalsTokenizer = new StringTokenizer(correctedString, "=");
            stringIsLdn = stringIsLdn && equalsTokenizer.countTokens() == numberOfCommas + 1;
        }
        catch (Exception e) {
            logger.traceGeneral(THIS_CLASS, "The String " + AueUtil.doubleQuote(stringToBeCkecked) + " is not a valid LDN.");
            stringIsLdn = false;
        }
        return stringIsLdn;
    }

    public static void appendToFile(String filePath, String message) {
        helper.appendToFile(filePath, message);
    }

    public static void writeToFile(String filePath, String message, boolean append) {
        helper.writeToFile(filePath, message, append);
    }

    public static long getUsedMemory() {
        return helper.getUsedMemory();
    }

    public static void storePerformedUpgradeSequence(boolean isStep1, String aueName, String fromVersionStr, String fromUpStr, String toVersionStr, String toUpStr, String timeStamp, int timeConsumption, int memoryConsumption) throws SQLException, CrbsAueException {
        helper.storePerformedUpgradeSequence(isStep1, aueName, fromVersionStr, fromUpStr, toVersionStr, toUpStr, timeStamp, timeConsumption, memoryConsumption);
    }

    public static FromAndToUpHolder getFromAndToUp(CollectorContext collectorContext) throws MoAccessException {
        return helper.getFromAndToUp(collectorContext);
    }

    public static String getToVersionFromPreviousUpgrade(String aueName) {
        return helper.getToVersionFromPreviousUpgrade(aueName);
    }

    public static String getAndCheckParamMapString(String key, Map paramMap, String errorMsg) throws CrbsAueException {
        String keyValue = (String)paramMap.get(key);
        if (keyValue == null || keyValue.equals("")) {
            throw new CrbsAueException(errorMsg);
        }
        return keyValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        helper = (AueUtilHelper)HelperClassUtil.getInstance(AUE_UTIL_HELPER_IMPL, INSTANCE_METHOD);
    }

    public static class FromAndToUpHolder {
        public final String fromUp;
        public final String toUp;

        public FromAndToUpHolder(String fromUp, String toUp) {
            this.fromUp = fromUp;
            this.toUp = toUp;
        }
    }
}

