/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import se.ericsson.crbs.omf.aue.common.LayerException;
import se.ericsson.crbs.omf.aue.common.actions.ConversionAction;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.xml.AbstractModificationXmlHandler;

public class ModificationXmlStep1Handler
extends AbstractModificationXmlHandler {
    private static final Class THIS_CLASS = ModificationXmlStep1Handler.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final List moActionList = new ArrayList();

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("ModificationFile".equals(localName)) {
            this.fromMomInfo = this.getMomInfo("fromVersion", attributes);
            this.toMomInfo = this.getMomInfo("toVersion", attributes);
        } else if ("Mo".equals(localName)) {
            this.moName = this.getMoName(attributes);
            this.tablePrefix = this.getTablePrefix(attributes);
        } else if ("MoAction".equals(localName)) {
            try {
                this.moActionName = this.getMoActionName(attributes, "FRO");
            }
            catch (LayerException le) {
                this.moActionName = "";
            }
        } else if ("Arg".equals(localName) && this.moActionName != null && this.moActionName.length() > 0) {
            AbstractModificationXmlHandler.NameValue nameValue = this.getNameAndValue(attributes);
            this.moActionArgsMap.put(nameValue.name, nameValue.value);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("Mo".equals(localName)) {
            this.notifyConversionActionListeners(this.moName, this.moActionList);
            this.moActionList.clear();
        } else if ("MoAction".equals(localName) && this.moActionName != null && this.moActionName.length() > 0) {
            try {
                if (this.moActionName.indexOf(46) < 0) {
                    this.moActionName = "se.ericsson.crbs.omf.aue.step1.actions." + this.moActionName;
                }
                this.moActionArgsMap.put("Mo", this.moName);
                this.moActionArgsMap.put("fromVersion", this.fromMomInfo.toString());
                this.moActionArgsMap.put("toVersion", this.toMomInfo.toString());
                Class<?> actionClass = Class.forName(this.moActionName);
                ConversionAction conversionAction = (ConversionAction)actionClass.newInstance();
                conversionAction.setMoActionArgs(this.moActionArgsMap);
                logger.traceDebug(THIS_CLASS, "adding MoAction " + conversionAction.getClass().getName());
                this.moActionList.add(conversionAction);
            }
            catch (Exception e) {
                String errorMsg = "Cannot construct instance of " + AueUtil.doubleQuote(this.moActionName);
                logger.traceError(THIS_CLASS, AueUtil.appendReason(errorMsg, e), e);
                throw new SAXException(errorMsg, e);
            }
            this.moActionName = "";
            this.moActionArgsMap.clear();
        }
    }
}

