/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class AddAttributeAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$AddAttributeAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$AddAttributeAction = AddAttributeAction.class$("se.ericsson.crbs.omf.aue.step1.actions.AddAttributeAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$AddAttributeAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$AddAttributeAction;

    public void convert(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String attrToBeAdded = this.getAndCheckParamMapString("name", this.paramMap, "No attribute name specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String momType = this.getAndCheckParamMapString("type", this.paramMap, "No MOM type specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String defaultValueStr = (String)this.paramMap.get("defaultValue");
        if (defaultValueStr == null) {
            throw new CrbsAueException("No default value specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        }
        this.checkMomType(momType, defaultValueStr);
        if (momType.equalsIgnoreCase("ENUMREF")) {
            momType = "S32";
        }
        try {
            TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
            TableData tableData = tableHandler.getTableData(froTypeName);
            if (tableData != null && tableData.isNotEmpty()) {
                tableData.addAttribute(attrToBeAdded, momType, defaultValueStr);
                tableHandler.checkAndDropIfNotUpdated(true, tableData);
                logger.traceGeneral(THIS_CLASS, "Attribute, " + AueUtil.doubleQuote(attrToBeAdded) + ", added with default value: " + defaultValueStr + ", to " + AueUtil.doubleQuote(froTypeName));
            }
        }
        catch (TableDataException tde) {
            String errorMsg = "Could not add attribute, " + AueUtil.doubleQuote(attrToBeAdded) + ", to, " + AueUtil.doubleQuote(froTypeName);
            logger.traceError(THIS_CLASS, AueUtil.appendReason(errorMsg, tde), tde);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    protected void checkMomType(String momType, String defaultValueStr) throws CrbsAueException {
        if (momType.equalsIgnoreCase("S32") || momType.equalsIgnoreCase("U32") || momType.equalsIgnoreCase("ENUMREF")) {
            this.checkIntegerMomType(momType, defaultValueStr);
        } else if (momType.equalsIgnoreCase("S64")) {
            this.checkDefaultValue(defaultValueStr);
        } else if (!(momType.equalsIgnoreCase("array") || momType.equalsIgnoreCase("moref") || momType.equalsIgnoreCase("STRING") || momType.equalsIgnoreCase("struct"))) {
            throw new CrbsAueException("Incorrect MOM type specified: " + AueUtil.doubleQuote(momType));
        }
        logger.traceDebug(THIS_CLASS, "checkMomType(" + momType + ", " + defaultValueStr + ") - is OK");
    }

    private void checkDefaultValue(String defaultValueStr) throws CrbsAueException {
        try {
            Long.valueOf(defaultValueStr);
        }
        catch (NumberFormatException nfe) {
            throw new CrbsAueException("Specified default value is not a long. Has to be when MOM type is: S64. Default value was: " + AueUtil.doubleQuote(defaultValueStr));
        }
    }

    private void checkIntegerMomType(String momType, String defaultValueStr) throws CrbsAueException {
        try {
            Integer.valueOf(defaultValueStr);
        }
        catch (NumberFormatException nfe) {
            throw new CrbsAueException("Specified default value is not an integer. Has to be when MOM type is: " + AueUtil.doubleQuote(momType) + ". Default value was: " + AueUtil.doubleQuote(defaultValueStr));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

