/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import com.polyhedra.sql.SQLException;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CreateSiblingInstanceAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$CreateSiblingInstanceAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$CreateSiblingInstanceAction = CreateSiblingInstanceAction.class$("se.ericsson.crbs.omf.aue.step1.actions.CreateSiblingInstanceAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$CreateSiblingInstanceAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$CreateSiblingInstanceAction;

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String oldSiblingType = this.getAndCheckParamMapString("fromMo", this.paramMap, "The from Mo type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String oldRdn = this.getAndCheckParamMapString("fromRdn", this.paramMap, "The FROM RDN is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String rdn = this.getAndCheckParamMapString("rdn", this.paramMap, "The RDN is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        try {
            TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
            TableData tableData = tableHandler.getTableData(oldSiblingType);
            this.addInstance(tableData, rdn, oldRdn);
            tableHandler.checkAndDropIfNotUpdated(tableData);
        }
        catch (SQLException e) {
            throw new CrbsAueException(e.getMessage());
        }
        catch (TableDataException e) {
            throw new CrbsAueException(e.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void addInstance(TableData tableData, String rdn, String oldRdn) throws SQLException, CrbsAueException, TableDataException {
        logger.traceEnter(THIS_CLASS, "addInstance()");
        if (tableData.isNotEmpty()) {
            String oldSiblingLdn = this.getLdn(tableData, oldRdn);
            if (!AueUtil.isLdn(oldSiblingLdn)) {
                throw new CrbsAueException("LDN of sibling to get parent ref from is not a real LDN, " + AueUtil.doubleQuote(oldSiblingLdn));
            }
            String ldn = oldSiblingLdn.substring(0, oldSiblingLdn.lastIndexOf(61) + 1) + rdn;
            Object[] columnDatasParentRef = tableData.getAttributeValues("parentRef");
            Object[] columnDatasLdn = tableData.getAttributeValues("ldn");
            String pRef = "";
            for (int i = 0; i < columnDatasParentRef.length; ++i) {
                if (!oldSiblingLdn.equalsIgnoreCase(columnDatasLdn[i].toString())) continue;
                pRef = columnDatasParentRef[i].toString();
            }
            Object[] columnDatasFroId = tableData.getAttributeValues("froid");
            int froId = this.getNextAvailableFroId(columnDatasFroId);
            String[] attributeNames = new String[]{"froid", "ldn", "parentRef"};
            Object[] attributeValues = new Object[]{new Integer(froId), ldn, pRef};
            tableData.addAttributeValues(attributeNames, attributeValues);
        }
        logger.traceReturn(THIS_CLASS, "addInstance()");
    }

    private String getLdn(TableData tableData, String rdnValue) throws CrbsAueException, TableDataException {
        logger.traceEnter(THIS_CLASS, "getLdn()");
        Object[] columnDatasLdn = tableData.getAttributeValues("ldn");
        String ldn = "";
        for (int row = 0; row < columnDatasLdn.length; ++row) {
            String ldnTmp = columnDatasLdn[row].toString();
            if (!ldnTmp.endsWith(rdnValue)) continue;
            ldn = ldnTmp;
        }
        logger.traceReturn(THIS_CLASS, "getLdn()");
        return ldn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

