/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class RenameAttributeAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$RenameAttributeAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$RenameAttributeAction = RenameAttributeAction.class$("se.ericsson.crbs.omf.aue.step1.actions.RenameAttributeAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$RenameAttributeAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$RenameAttributeAction;

    public void convert(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String attrToBeRenamed = this.getAndCheckParamMapString("name", this.paramMap, "The attribute to be renamed is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String newAttrName = this.getAndCheckParamMapString("newName", this.paramMap, "The new attribute name is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        try {
            TableData tableData;
            TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
            try {
                tableData = tableHandler.getTableData(froTypeName);
            }
            catch (TableDataException e) {
                String errorMsg = "Failed to rename attribute, \"" + attrToBeRenamed + "\", to, \"" + newAttrName + "\", in, " + AueUtil.doubleQuote(froTypeName);
                logger.traceDebug(THIS_CLASS, errorMsg);
                throw new CrbsAueException(AueUtil.appendReason(errorMsg, e));
            }
            String[] attributeNames = tableData.getAttributeNames();
            for (int i = 0; i < attributeNames.length; ++i) {
                if (!attributeNames[i].equalsIgnoreCase(attrToBeRenamed)) continue;
                tableData.setAttributeName(attrToBeRenamed, newAttrName);
                this.updateColumnData(tableData, attrToBeRenamed, newAttrName);
                logger.traceGeneral(THIS_CLASS, "Attribute, " + AueUtil.doubleQuote(attrToBeRenamed) + ", in, " + AueUtil.doubleQuote(froTypeName) + ", renamed to, " + AueUtil.doubleQuote(newAttrName));
                break;
            }
        }
        catch (TableDataException tde) {
            throw new CrbsAueException("Failed to execute action class: " + THIS_CLASS.getName(), tde);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void updateColumnData(TableData tableData, String oldAttrName, String newAttrName) throws CrbsAueException, TableDataException {
        Object[] newAttrDatas = tableData.getAttributeValues(newAttrName);
        String oldAttrNameTag = "name=\"" + oldAttrName + "\"";
        String newAttrNameTag = "name=\"" + newAttrName + "\"";
        for (int i = 0; i < newAttrDatas.length; ++i) {
            if (!(newAttrDatas[i] instanceof String)) continue;
            String filteredValue = AueUtil.replaceInString(newAttrDatas[i].toString(), oldAttrNameTag, newAttrNameTag);
            try {
                tableData.setAttributeValue(i, newAttrName, filteredValue);
                continue;
            }
            catch (TableDataException exception) {
                throw new CrbsAueException("Unble to change attribute name within attribute " + oldAttrName, exception);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

