/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions.data;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroAttributesData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroAttributesTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;

public class FroAttributesTableImpl
implements FroAttributesTable {
    private static final Class THIS_CLASS = FroAttributesTableImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final List froAttributesList;
    private final String froAttributesTableName;
    private final DbWrapper dbWrapper;

    public FroAttributesTableImpl(String froAttributesTableName, DbWrapper dbWrapper) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "FroAttributesTableImpl(" + froAttributesTableName + ")");
        this.froAttributesTableName = froAttributesTableName;
        this.dbWrapper = dbWrapper;
        this.froAttributesList = new ArrayList();
        ResultSet resultSet = null;
        try {
            Sql.Select queryFroAttributes = new Sql.Select(froAttributesTableName, new String[]{"frotype", "attrName", "attrType"});
            dbWrapper.openConnection();
            resultSet = dbWrapper.executeQuery(queryFroAttributes);
            while (resultSet.next()) {
                int froType = resultSet.getInt(1);
                String attrName = resultSet.getString(2);
                String attrType = resultSet.getString(3);
                this.froAttributesList.add(new FroAttributesData(froType, attrName, attrType));
            }
            logger.traceDebug(THIS_CLASS, "Read " + this.froAttributesList.size() + " number of elements from: " + AueUtil.doubleQuote(froAttributesTableName));
        }
        catch (SQLException se) {
            throw new CrbsAueException("Failed to read " + AueUtil.doubleQuote(froAttributesTableName), se);
        }
        logger.traceReturn(THIS_CLASS, "FroAttributesTableImpl(" + froAttributesTableName + ")");
    }

    public String getTableName() {
        return this.froAttributesTableName;
    }

    public FroAttributesData[] getDatas() {
        logger.traceEnter(THIS_CLASS, "getDatas()");
        FroAttributesData[] froAttributeDatas = new FroAttributesData[this.froAttributesList.size()];
        this.froAttributesList.toArray(froAttributeDatas);
        logger.traceReturn(THIS_CLASS, "getDatas()");
        return froAttributeDatas;
    }

    public void storePersistently(String tableName) throws TableDataException {
        try {
            this.dbWrapper.openConnection();
            Sql.DropTable dropTable = new Sql.DropTable(tableName);
            try {
                this.dbWrapper.executeUpdate(dropTable);
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            Sql.CreateTable createTable = new Sql.CreateTable(tableName, new Sql.CreateTable.ColumnSpec[]{new Sql.CreateTable.ColumnSpec("frotype", Sql.MomDataType.MOM_S32, 0, null, true), new Sql.CreateTable.ColumnSpec("attrName", Sql.MomDataType.MOM_STRING, 0, null, true), new Sql.CreateTable.ColumnSpec("attrType", Sql.MomDataType.MOM_STRING, 0, null, false)});
            this.dbWrapper.executeUpdate(createTable);
            for (int i = 0; i < this.froAttributesList.size(); ++i) {
                FroAttributesData froAttributesData = (FroAttributesData)this.froAttributesList.get(i);
                Sql.InsertRow insertRow = new Sql.InsertRow(tableName, new Sql.InsertRow.ColumnValue[]{new Sql.InsertRow.ColumnValue("frotype", froAttributesData.froType), new Sql.InsertRow.ColumnValue("attrName", froAttributesData.attrName), new Sql.InsertRow.ColumnValue("attrType", froAttributesData.attrType)});
                this.dbWrapper.executeUpdate(insertRow);
            }
        }
        catch (SQLException sqle) {
            String errorMsg = "Failed to store FRO attributes to persistent table: " + AueUtil.doubleQuote(tableName);
            throw new TableDataException(AueUtil.appendReason(errorMsg, sqle), sqle);
        }
    }

    public void deleteAllData() {
        this.froAttributesList.clear();
    }

    public FroAttributesData[] deleteFromTable(int froType) throws TableDataException {
        ArrayList<FroAttributesData> existingRecordsList = new ArrayList<FroAttributesData>();
        for (int i = this.froAttributesList.size() - 1; i >= 0; --i) {
            FroAttributesData froAttributeData = (FroAttributesData)this.froAttributesList.get(i);
            if (froAttributeData.froType != froType) continue;
            existingRecordsList.add(froAttributeData);
            this.froAttributesList.remove(i);
        }
        if (existingRecordsList.size() == 0) {
            throw new TableDataException("FRO type id, \"" + froType + "\" not found in: " + AueUtil.doubleQuote(this.froAttributesTableName));
        }
        FroAttributesData[] froAttributesDatas = new FroAttributesData[existingRecordsList.size()];
        existingRecordsList.toArray(froAttributesDatas);
        return froAttributesDatas;
    }

    public FroAttributesData deleteFromTable(int froType, String attributeName) throws TableDataException {
        FroAttributesData removedData = null;
        for (int i = this.froAttributesList.size() - 1; i >= 0; --i) {
            FroAttributesData froAttributeData = (FroAttributesData)this.froAttributesList.get(i);
            if (froAttributeData.froType != froType || !froAttributeData.attrName.equalsIgnoreCase(attributeName)) continue;
            removedData = froAttributeData;
            this.froAttributesList.remove(i);
        }
        if (removedData == null) {
            throw new TableDataException("Combination of FRO type id, \"" + froType + "\", and attribute name, \"" + attributeName + "\", was not found in: " + AueUtil.doubleQuote(this.froAttributesTableName));
        }
        return removedData;
    }

    public void updateFroTypeId(int froType, int newFroType) throws TableDataException {
        FroAttributesData[] existingRecords = this.deleteFromTable(froType);
        for (int i = 0; i < existingRecords.length; ++i) {
            FroAttributesData newFroAttributesData = new FroAttributesData(newFroType, existingRecords[i].attrName, existingRecords[i].attrType);
            this.froAttributesList.add(newFroAttributesData);
        }
    }

    public void updateTable(int froType, String currentAttributeName, String newAttributeName) throws TableDataException {
        FroAttributesData existingRecord = this.deleteFromTable(froType, currentAttributeName);
        FroAttributesData newFroAttributesData = new FroAttributesData(froType, newAttributeName, existingRecord.attrType);
        this.froAttributesList.add(newFroAttributesData);
    }

    public boolean isCombinationPresent(int froType, String attrName) {
        boolean combinationPresent = false;
        for (int i = 0; i < this.froAttributesList.size(); ++i) {
            FroAttributesData froAttributesData = (FroAttributesData)this.froAttributesList.get(i);
            if (froAttributesData.froType != froType || !froAttributesData.attrName.equalsIgnoreCase(attrName)) continue;
            combinationPresent = true;
            break;
        }
        return combinationPresent;
    }

    public void insertIntoTable(int froType, String attrName, String attrType) throws TableDataException {
        if (this.isCombinationPresent(froType, attrName)) {
            throw new TableDataException("Combination of FRO type id \"" + froType + "\" and \"" + attrName + "\", already exists in " + AueUtil.doubleQuote(this.froAttributesTableName));
        }
        FroAttributesData newFroAttributesData = new FroAttributesData(froType, attrName, attrType);
        this.froAttributesList.add(newFroAttributesData);
    }
}

