/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.AbstractFroXmlHelperImpl;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroArray;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroMoRef;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroStruct;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroStructHelper;
import se.ericsson.crbs.omf.aue.step1.actions.util.NameTypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.ParseException;

public class FroStructHelperImpl
extends AbstractFroXmlHelperImpl
implements FroStructHelper {
    protected static final FroStruct EMPTY = new FroStruct(null);
    private FroMoRef subMoRef = FroMoRef.EMPTY;
    private FroStruct subStruct = FroStruct.EMPTY;
    private FroArray subArray = FroArray.EMPTY;
    private boolean initiated = false;
    private final TableHandler tableHandler;

    public FroStructHelperImpl(TableHandler tableHandler) {
        super(FroStruct.class);
        this.tableHandler = tableHandler;
    }

    public String getXmlTagName() {
        return "struct";
    }

    public int getTagType() {
        return 4;
    }

    public String convertStructToXml(String attributeName, Struct structToBeConverted) throws CrbsAueException {
        try {
            String[] structNames = structToBeConverted.getNames();
            Object[] structValues = structToBeConverted.getValues();
            if (structNames.length != structValues.length) {
                throw new CrbsAueException("Inconsistent struct. Names (" + structNames.length + ") and values (" + structValues.length + ") are of different length");
            }
            this.name = attributeName;
            for (int i = 0; i < structNames.length; ++i) {
                if (structValues[i] instanceof String) {
                    NameTypeValue nameTypeValue = new NameTypeValue(structNames[i], "STRING", structValues[i].toString());
                    this.xmlTagsList.add(nameTypeValue);
                    continue;
                }
                if (structValues[i] instanceof Integer) {
                    NameTypeValue nameTypeValue = new NameTypeValue(structNames[i], "S32", structValues[i].toString());
                    this.xmlTagsList.add(nameTypeValue);
                    continue;
                }
                if (structValues[i] instanceof Boolean) {
                    boolean isTrue = (Boolean)structValues[i];
                    NameTypeValue nameTypeValue = new NameTypeValue(structNames[i], "S32", isTrue ? BOOLEAN_TRUE.toString() : BOOLEAN_FALSE.toString());
                    this.xmlTagsList.add(nameTypeValue);
                    continue;
                }
                if (structValues[i] instanceof Struct) {
                    FroStruct localSubStruct = new FroStruct(this.tableHandler);
                    localSubStruct.convertStructToXml("", (Struct)structValues[i]);
                    this.xmlTagsList.add(localSubStruct);
                    continue;
                }
                if (structValues[i] instanceof ManagedObject) {
                    FroMoRef localMoRef = new FroMoRef(this.tableHandler);
                    localMoRef.convertManagedObjectToXml("", (ManagedObject)structValues[i]);
                    this.xmlTagsList.add(localMoRef);
                    continue;
                }
                if (!(structValues[i] instanceof Object[])) continue;
                FroArray localFroArray = new FroArray(this.tableHandler);
                localFroArray.convertObjectArrayToXml("", (Object[])structValues[i]);
                this.xmlTagsList.add(localFroArray);
            }
        }
        catch (MoAccessException mae) {
            String errorMsg = "Could not read the struct: " + structToBeConverted;
            throw new CrbsAueException(AueUtil.appendReason(errorMsg, mae), mae);
        }
        return this.toXmlString();
    }

    public void parse(String xmlTagToBeParsed) throws ParseException {
        InputStream inputStream = null;
        try {
            this.initiated = false;
            this.subMoRef = FroMoRef.EMPTY;
            this.subStruct = FroStruct.EMPTY;
            this.subArray = FroArray.EMPTY;
            this.name = "";
            this.xmlTagsList.clear();
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setContentHandler(this);
            inputStream = new ByteArrayInputStream(xmlTagToBeParsed.getBytes());
            parser.parse(new InputSource(inputStream));
        }
        catch (Exception e) {
            String errorMsg = AueUtil.appendReason("Could not parse the struct information.", e);
            this.logger.traceError(this.thisClass, errorMsg, e);
            throw new ParseException(errorMsg, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception ignore) {}
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean insideSubArrayTag;
        boolean insideSubMoRefTag = !FroMoRef.EMPTY.equals(this.subMoRef);
        boolean insideSubStructTag = !FroStruct.EMPTY.equals(this.subStruct);
        boolean bl = insideSubArrayTag = !FroArray.EMPTY.equals(this.subArray);
        if (insideSubStructTag) {
            this.subStruct.startElement(uri, localName, qName, attributes);
        } else if (insideSubArrayTag) {
            this.subArray.startElement(uri, localName, qName, attributes);
        } else if (insideSubMoRefTag) {
            this.subMoRef.startElement(uri, localName, qName, attributes);
        } else if ("array".equals(localName)) {
            this.subArray = new FroArray(this.tableHandler);
            this.subArray.startElement(uri, localName, qName, attributes);
        } else if ("struct".equals(localName)) {
            if (this.initiated) {
                this.subStruct = new FroStruct(this.tableHandler);
                this.subStruct.startElement(uri, localName, qName, attributes);
            } else {
                this.name = attributes.getValue("name");
                this.initiated = true;
            }
        } else if ("moref".equals(localName)) {
            this.subMoRef = new FroMoRef(this.tableHandler);
            this.subMoRef.startElement(uri, localName, qName, attributes);
        } else if ("attr".equals(localName)) {
            String tmpName = attributes.getValue("name");
            String tmpType = attributes.getValue("type");
            String tmpValue = attributes.getValue("value");
            NameTypeValue nameTypeValue = new NameTypeValue(tmpName, tmpType, tmpValue);
            this.xmlTagsList.add(nameTypeValue);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean insideSubArrayTag;
        boolean insidSubMoRefTag = !FroMoRef.EMPTY.equals(this.subMoRef);
        boolean insideSubStructTag = !FroStruct.EMPTY.equals(this.subStruct);
        boolean bl = insideSubArrayTag = !FroArray.EMPTY.equals(this.subArray);
        if (insideSubStructTag) {
            if ("struct".equals(localName)) {
                this.xmlTagsList.add(this.subStruct);
                this.subStruct = FroStruct.EMPTY;
            } else {
                this.subStruct.endElement(uri, localName, qName);
            }
        } else if (insideSubArrayTag) {
            if ("array".equals(localName)) {
                this.xmlTagsList.add(this.subArray);
                this.subArray = FroArray.EMPTY;
            } else {
                this.subArray.endElement(uri, localName, qName);
            }
        } else if (insidSubMoRefTag) {
            if ("moref".equals(localName)) {
                this.xmlTagsList.add(this.subMoRef);
                this.subMoRef = FroMoRef.EMPTY;
            } else {
                this.subMoRef.endElement(uri, localName, qName);
            }
        } else if ("struct".equals(localName)) {
            this.initiated = false;
        }
    }
}

