/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmapplication;

import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.PmStateListener;
import se.ericsson.cello.pms.generic.PmsPortal;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.crbs.cat.pmapplication.PmApplicationController;
import se.ericsson.crbs.cat.pmapplication.PmStateListenerImpl;
import se.ericsson.crbs.cat.pmapplication.PmThreadSwitcher;
import se.ericsson.crbs.cat.pmapplication.PmThreadSwitcherI;
import se.ericsson.crbs.cat.pmapplication.PmTimer;
import se.ericsson.crbs.cat.pmcommon.PmBase;
import se.ericsson.crbs.cat.pmcommon.PmClassCounter;
import se.ericsson.crbs.cat.pmcommon.PmMoRepository;
import se.ericsson.crbs.cat.pmcommon.PmMoRepositoryI;
import se.ericsson.crbs.cat.pminstantcounters.PmInstantCountersHandler;
import se.ericsson.crbs.cat.pmpms.PmMeasuredData;
import se.ericsson.crbs.cat.pmpms.PmMeasuredDataI;
import se.ericsson.crbs.cat.pmpms.PmMeasuredInstantData;
import se.ericsson.crbs.cat.pmpms.PmScanner;
import se.ericsson.crbs.cat.pmpms.PmScannerFactory;
import se.ericsson.crbs.cat.pmpms.PmScannerI;
import se.ericsson.crbs.cat.pmproxy.PmProxy;
import se.ericsson.crbs.cat.pmproxy.PmProxyI;
import se.ericsson.crbs.cat.pmproxy.PmSessionHandler;

public class PmApplication
extends PmBase
implements Mopplet,
PmStateListenerImpl.Callback,
PmSessionHandler.Callback,
PmApplicationController.Callback,
PmScanner.Callback,
PmInstantCountersHandler.Callback {
    private PmsPortal m_pmsPortal = null;
    private PmProxyI m_pmProxy = null;
    private PmThreadSwitcherI m_threadSwitcher = null;
    private PmScannerFactory m_scannerFactory = null;
    private PmStateListenerImpl m_pmStateListenerImpl = null;
    private PmSessionHandler m_sessionHandler = null;
    private PmApplicationController m_applicationController = null;
    private Thread m_mainThread = null;
    private PmInstantCountersHandler m_instantCountersHandler = null;
    private PmMoRepositoryI m_moRepository = null;
    private PmTimer m_jobTimer = null;
    private Runnable m_jobRunnable = null;
    private PmTimer m_startupDeadlineTimer = null;
    private Runnable m_startupDeadlineRunnable = null;

    public PmApplication() {
        this.general("PmApplication created");
    }

    public void init() {
        this.enter("init");
        this.general("Starting rbsPmApplicationLm");
        this.m_pmsPortal = PmsPortalImpl.getPortal();
        this.m_pmProxy = new PmProxy();
        this.m_threadSwitcher = new PmThreadSwitcher(this.m_pmProxy);
        this.m_scannerFactory = new PmScannerFactory(this.m_threadSwitcher, this);
        this.m_sessionHandler = new PmSessionHandler(this.m_pmProxy, this, this.m_threadSwitcher);
        this.m_applicationController = new PmApplicationController(this);
        this.m_moRepository = new PmMoRepository();
        this.m_instantCountersHandler = new PmInstantCountersHandler(this.m_threadSwitcher, this.m_moRepository, this);
        this.m_jobRunnable = new PmJobRunnable();
        this.m_startupDeadlineRunnable = new PmStartupDeadlineRunnable();
        this.m_applicationController.init();
        this.m_instantCountersHandler.publishService();
        this.m_pmStateListenerImpl = new PmStateListenerImpl(this, this.m_pmsPortal, this.m_scannerFactory, this.m_threadSwitcher);
        this.m_pmStateListenerImpl.publishService();
        this.m_pmsPortal.addPmStateListener((PmStateListener)this.m_pmStateListenerImpl);
    }

    public void test_init(PmsPortal pmsPortal, PmProxyI pmProxy, PmThreadSwitcherI threadSwitcher, PmStateListenerImpl pmStateListenerImpl, Runnable jobRunnable, Runnable startupDeadlineRunnable, PmApplicationController.Callback controllerCallback, PmScanner.Callback scannerCallback, PmSessionHandler.Callback sessionCallback, PmInstantCountersHandler.Callback instantCountersCallback) {
        this.enter("test_init");
        this.general("Unit test of PmApplication");
        this.m_pmsPortal = pmsPortal;
        this.m_pmProxy = pmProxy;
        this.m_threadSwitcher = threadSwitcher;
        this.m_scannerFactory = new PmScannerFactory(this.m_threadSwitcher, scannerCallback);
        this.m_pmStateListenerImpl = pmStateListenerImpl;
        this.m_sessionHandler = new PmSessionHandler(this.m_pmProxy, sessionCallback, this.m_threadSwitcher);
        this.m_applicationController = new PmApplicationController(controllerCallback);
        this.m_moRepository = new PmMoRepository();
        this.m_instantCountersHandler = new PmInstantCountersHandler(this.m_threadSwitcher, this.m_moRepository, instantCountersCallback);
        this.m_jobRunnable = jobRunnable;
        this.m_startupDeadlineRunnable = startupDeadlineRunnable;
        this.m_applicationController.init();
        this.m_instantCountersHandler.publishService();
        this.m_pmStateListenerImpl.publishService();
        this.m_pmsPortal.addPmStateListener((PmStateListener)this.m_pmStateListenerImpl);
    }

    public void start() {
        this.enter("start");
        this.info("Started rbsPmApplicationLm");
        this.m_applicationController.mopplet_applicationStarted();
    }

    public void stateListener_mopplet_startEvent() {
        this.enter("stateListener_mopplet_startEvent");
        this.m_applicationController.mopplet_pmServiceStarted();
    }

    public boolean sessionHandler_registerCounters() {
        this.enter("sessionHandler_registerCounters");
        return this.m_applicationController.countersRegistered();
    }

    public boolean sessionHandler_reportCounterValues(PmMeasuredDataI[] measurements, boolean dataToReport) {
        this.enter("sessionHandler_reportCounterValues");
        return this.m_applicationController.reportCounterValues(measurements, dataToReport);
    }

    public boolean sessionHandler_reportInstantCounterValues(PmMeasuredInstantData measuredInstantData) {
        this.enter("sessionHandler_reportInstantCounterValues");
        return this.m_applicationController.reportInstantCounterValues(measuredInstantData);
    }

    public boolean sessionHandler_allSessionsAreDoneUpdatingActive() {
        this.enter("sessionHandler_allSessionsAreDoneUpdatingActive");
        return this.m_applicationController.allSessionsAreDoneUpdatingActive();
    }

    public boolean sessionHandler_allSessionsAreDoneFreezing() {
        this.enter("sessionHandler_allSessionsAreDoneFreezing");
        return this.m_applicationController.allSessionsAreDoneFreezing();
    }

    public boolean sessionHandler_allSessionsAreDoneReporting() {
        this.enter("sessionHandler_allSessionsAreDoneReporting");
        return this.m_applicationController.allSessionsAreDoneReporting();
    }

    public boolean sessionHandler_allSessionsAreDoneReportingInstantCounters() {
        this.enter("sessionHandler_allSessionsAreDoneReportingInstantCounters");
        return this.m_applicationController.allSessionsAreDoneReportingInstantCounters();
    }

    public PmMeasuredDataI sessionHandler_createMeasuredDataContainer(String[] scalarCounterNames, String[] pdfCounterNames) {
        return new PmMeasuredData(scalarCounterNames, pdfCounterNames);
    }

    public boolean applicationController_mopplet_startThread(Runnable runnable, String name) {
        this.enter("applicationController_mopplet_startThread");
        this.m_mainThread = new Thread(runnable, name);
        this.m_mainThread.start();
        return true;
    }

    public boolean applicationController_listenToSignals() {
        this.enter("applicationController_listenToSignals");
        this.m_pmProxy.start();
        return true;
    }

    public boolean applicationController_freezeCountersEvent() {
        this.enter("applicationController_freezeCountersEvent");
        return this.m_sessionHandler.freezeCounters();
    }

    public boolean applicationController_reportCountersEvent() {
        this.enter("applicationController_reportCountersEvent");
        return this.m_sessionHandler.reportCounters();
    }

    public boolean applicationController_reportInstantCountersEvent(String moLocalDistinguishedName, String moClassName, String[] counterNames) {
        this.enter("applicationController_reportInstantCountersEvent");
        return this.m_sessionHandler.reportInstantCounters(moLocalDistinguishedName, moClassName, counterNames);
    }

    public boolean applicationController_activateCounters(PmClassCounter[] activatedClassCounters) {
        this.enter("applicationController_activateCounters");
        return this.m_sessionHandler.activateCounters(activatedClassCounters);
    }

    public boolean applicationController_deactivateCounters(PmClassCounter[] deactivatedClassCounters) {
        this.enter("applicationController_deactivateCounters");
        return this.m_sessionHandler.deactivateCounters(deactivatedClassCounters);
    }

    public boolean applicationController_enableCounters(PmClassCounter[] enabledForReportingClassCounters) {
        this.enter("applicationController_enableCounters");
        this.m_sessionHandler.enableCountersForReporting(enabledForReportingClassCounters);
        return true;
    }

    public boolean applicationController_startJobTimer(int milliseconds) {
        this.enter("applicationController_startJobTimer");
        if (this.m_jobTimer != null) {
            this.abnormal("Tried to create job timer, but a job timer already exists");
        } else {
            this.m_jobTimer = new PmTimer(this.m_threadSwitcher, milliseconds, this.m_jobRunnable);
        }
        return true;
    }

    public boolean applicationController_cancelJobTimer() {
        this.enter("applicationController_cancelJobTimer");
        if (this.m_jobTimer == null) {
            this.abnormal("Tried to cancel job timer, but no job timer is active");
        } else {
            this.m_jobTimer.cancel();
            this.m_jobTimer = null;
        }
        return true;
    }

    public boolean applicationController_startCounterRegistrationDeadlineTimer(int milliseconds) {
        this.enter("applicationController_startCounterRegistrationDeadlineTimer");
        if (this.m_startupDeadlineTimer != null) {
            this.abnormal("Tried to create startup timer, but a startup timer already exists");
        } else {
            this.m_startupDeadlineTimer = new PmTimer(this.m_threadSwitcher, milliseconds, this.m_startupDeadlineRunnable);
        }
        return true;
    }

    public boolean applicationController_resetNonRespondingSessions() {
        this.enter("applicationController_resetNonRespondingSessions");
        this.m_sessionHandler.resetNonRespondingSessions();
        return true;
    }

    public boolean scanner_addScannerEvent(PmScannerI scanner, PmClassCounter[] classCounters, boolean activated) {
        this.enter("scanner_addScannerEvent");
        if (!this.m_applicationController.addScanner(scanner)) {
            return false;
        }
        if (activated) {
            return this.m_applicationController.activateScannerCounters(classCounters);
        }
        return true;
    }

    public boolean scanner_removeScannerEvent(int scannerId) {
        int numScanners = this.m_applicationController.removeScanner(scannerId);
        if (numScanners == 0) {
            this.m_scannerFactory.resetAllowedGranularityPeriod();
        }
        return true;
    }

    public boolean scanner_reportScannerEvent(PmScanner scanner, DataConsumer consumer, boolean enableCounters, int seqNo, PmClassCounter[] classCounters) {
        this.enter("scanner_reportScannerEvent");
        return this.m_applicationController.reportScannerCounters(consumer, enableCounters, seqNo, classCounters);
    }

    public boolean scanner_activateCountersEvent(PmScanner scanner, PmClassCounter[] activatedClassCounters) {
        this.enter("scanner_activateCountersEvent");
        return this.m_applicationController.activateScannerCounters(activatedClassCounters);
    }

    public boolean scanner_deactivateCountersEvent(PmClassCounter[] deactivedClassCounters) {
        this.enter("scanner_deactivateCountersEvent");
        return this.m_applicationController.deactivateScannerCounters(deactivedClassCounters);
    }

    public void instantCounter_getCounterValues(String moLocalDistinguishedName, String moClassName, String[] counterNames, PmInstantCountersHandler.InstantCounterReceiver receiver) {
        this.enter("instantCounter_getCounterValues");
        this.m_applicationController.reportInstantCounters(moLocalDistinguishedName, moClassName, counterNames, receiver);
    }

    public class PmStartupDeadlineRunnable
    implements Runnable {
        public void run() {
            PmApplication.this.enter("PmRegistrationRunnable.run");
            PmApplication.this.m_applicationController.startupDeadlineReached();
            PmApplication.this.m_startupDeadlineTimer = null;
        }
    }

    public class PmJobRunnable
    implements Runnable {
        public void run() {
            PmApplication.this.enter("PmJobRunnable.run");
            PmApplication.this.m_applicationController.jobTimeoutReached();
            PmApplication.this.m_jobTimer = null;
        }
    }
}

