/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmcommon;

import java.util.Arrays;
import se.ericsson.crbs.cat.pmcommon.PmCounterDefinition;
import se.ericsson.crbs.cat.pmcommon.PmDeepCloneable;
import se.ericsson.crbs.cat.pmcommon.PmMaps;

public class PmClassCounterDefinition
implements Comparable,
PmDeepCloneable {
    public final int moClassId;
    public final long maxNumberOfMoInstances;
    public final String moClassName;
    private final PmMaps.PmCounterDefinitionIdMap counterIdMap;
    private final PmMaps.PmCounterDefinitionNameMap counterNameMap;

    public PmClassCounterDefinition(int clsId, long clsMaxInstances, String clsName) {
        this.moClassId = clsId;
        this.maxNumberOfMoInstances = clsMaxInstances;
        this.moClassName = clsName;
        this.counterIdMap = new PmMaps.PmCounterDefinitionIdMap();
        this.counterNameMap = new PmMaps.PmCounterDefinitionNameMap();
    }

    public PmClassCounterDefinition(int clsId, long clsMaxInstances, String clsName, PmMaps.PmCounterDefinitionIdMap idMap, PmMaps.PmCounterDefinitionNameMap nameMap) {
        this.moClassId = clsId;
        this.maxNumberOfMoInstances = clsMaxInstances;
        this.moClassName = clsName;
        this.counterIdMap = idMap;
        this.counterNameMap = nameMap;
    }

    public boolean addCounterDefinition(PmCounterDefinition counterDef) {
        return this.counterIdMap.add(counterDef.counterId, counterDef) && this.counterNameMap.add(counterDef.counterName, counterDef);
    }

    public PmCounterDefinition findCounterDefinitionById(int counterId) {
        return this.counterIdMap.get(counterId);
    }

    public PmCounterDefinition findCounterDefinitionByName(String counterName) {
        return this.counterNameMap.get(counterName);
    }

    public PmCounterDefinition[] getCounterDefs() {
        Object[] result = this.counterIdMap.getValues();
        Arrays.sort(result);
        return result;
    }

    public int compareTo(Object other) {
        if (other instanceof PmClassCounterDefinition) {
            PmClassCounterDefinition o = (PmClassCounterDefinition)other;
            if (this.moClassId < o.moClassId) {
                return -1;
            }
            if (this.moClassId > o.moClassId) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public PmClassCounterDefinition typeSafeClone() {
        return new PmClassCounterDefinition(this.moClassId, this.maxNumberOfMoInstances, this.moClassName, this.counterIdMap.typeSafeClone(), this.counterNameMap.typeSafeClone());
    }

    public PmDeepCloneable deepClone() {
        return this.typeSafeClone();
    }
}

