/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmcommon;

import java.util.Arrays;
import se.ericsson.crbs.cat.pmcommon.PmClassCounterDefinition;
import se.ericsson.crbs.cat.pmcommon.PmMaps;

public class PmClassCounterDefinitions {
    private final PmMaps.PmClassCounterDefinitionIdMap classCounterIdMap = new PmMaps.PmClassCounterDefinitionIdMap();
    private final PmMaps.PmClassCounterDefinitionNameMap classCounterNameMap = new PmMaps.PmClassCounterDefinitionNameMap();

    public PmClassCounterDefinition getClassCounterDefinition(int moClassId, long maxNumberOfMoInstances, String moClassName) {
        PmClassCounterDefinition classCounterDef = this.classCounterIdMap.get(moClassId);
        if (classCounterDef == null) {
            classCounterDef = new PmClassCounterDefinition(moClassId, maxNumberOfMoInstances, moClassName);
            this.classCounterIdMap.add(classCounterDef.moClassId, classCounterDef);
            this.classCounterNameMap.add(classCounterDef.moClassName, classCounterDef);
        }
        return classCounterDef;
    }

    public PmClassCounterDefinition findClassCounterDefinitionById(int moClassId) {
        return this.classCounterIdMap.get(moClassId);
    }

    public PmClassCounterDefinition findClassCounterDefinitionByName(String moClassName) {
        return this.classCounterNameMap.get(moClassName);
    }

    public PmClassCounterDefinition[] getClassCounterDefs() {
        Object[] result = this.classCounterIdMap.getValues();
        Arrays.sort(result);
        return result;
    }
}

