/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmcommon;

import java.util.Arrays;
import se.ericsson.crbs.cat.pmcommon.PmDeepCloneable;
import se.ericsson.crbs.cat.pmcommon.PmInstanceGroup;
import se.ericsson.crbs.cat.pmcommon.PmMaps;

public class PmClassGroup
implements Comparable,
PmDeepCloneable {
    public final int moClassId;
    private final PmMaps.PmInstanceGroupMap instanceGroupMap;

    public PmClassGroup(int clsId) {
        this.moClassId = clsId;
        this.instanceGroupMap = new PmMaps.PmInstanceGroupMap();
    }

    public PmClassGroup(int clsId, PmMaps.PmInstanceGroupMap groupMap) {
        this.moClassId = clsId;
        this.instanceGroupMap = groupMap;
    }

    public PmInstanceGroup getInstanceGroup(long moInstanceId) {
        PmInstanceGroup instanceGroup = this.instanceGroupMap.get(moInstanceId);
        if (instanceGroup == null) {
            instanceGroup = new PmInstanceGroup(moInstanceId);
            this.instanceGroupMap.add(instanceGroup.moInstanceId, instanceGroup);
        }
        return instanceGroup;
    }

    public PmInstanceGroup[] getInstanceGroups() {
        Object[] result = this.instanceGroupMap.getValues();
        Arrays.sort(result);
        return result;
    }

    public int compareTo(Object other) {
        if (other instanceof PmClassGroup) {
            PmClassGroup o = (PmClassGroup)other;
            if (this.moClassId < o.moClassId) {
                return -1;
            }
            if (this.moClassId > o.moClassId) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public PmClassGroup typeSafeClone() {
        return new PmClassGroup(this.moClassId, this.instanceGroupMap.typeSafeClone());
    }

    public PmDeepCloneable deepClone() {
        return this.typeSafeClone();
    }
}

