/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DERInteger
extends DERObject {
    byte[] vb;

    public static DERInteger getInstance(Object object) {
        if (object == null || object instanceof DERInteger) {
            return (DERInteger)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERInteger(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERInteger.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERInteger getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERInteger.getInstance(aSN1TaggedObject.getObject());
    }

    public DERInteger(int n) {
        this.vb = BigInteger.valueOf(n).toByteArray();
    }

    public DERInteger(BigInteger bigInteger) {
        this.vb = bigInteger.toByteArray();
    }

    public DERInteger(byte[] byArray) {
        this.vb = byArray;
    }

    public BigInteger getValue() {
        return new BigInteger(this.vb);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.vb);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.b(2, this.vb);
    }

    public int hashCode() {
        int n = 0;
        for (int k = 0; k != this.vb.length; ++k) {
            n ^= (this.vb[k] & 0xFF) << k % 4;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERInteger)) {
            return false;
        }
        DERInteger dERInteger = (DERInteger)object;
        if (this.vb.length != dERInteger.vb.length) {
            return false;
        }
        for (int k = 0; k != this.vb.length; ++k) {
            if (this.vb[k] == dERInteger.vb[k]) continue;
            return false;
        }
        return true;
    }
}

