/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import com.maverick.crypto.asn1.DERString;
import java.io.IOException;

public class DERNumericString
extends DERObject
implements DERString {
    String gb;

    public static DERNumericString getInstance(Object object) {
        if (object == null || object instanceof DERNumericString) {
            return (DERNumericString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERNumericString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERNumericString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERNumericString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERNumericString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERNumericString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int k = 0; k != cArray.length; ++k) {
            cArray[k] = (char)(byArray[k] & 0xFF);
        }
        this.gb = new String(cArray);
    }

    public DERNumericString(String string) {
        this.gb = string;
    }

    public String getString() {
        return this.gb;
    }

    public byte[] getOctets() {
        char[] cArray = this.gb.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int k = 0; k != cArray.length; ++k) {
            byArray[k] = (byte)cArray[k];
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.b(18, this.getOctets());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERNumericString)) {
            return false;
        }
        DERNumericString dERNumericString = (DERNumericString)object;
        return this.getString().equals(dERNumericString.getString());
    }
}

