/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERBitString;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERInteger;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DERTaggedObject;
import com.maverick.crypto.asn1.pkcs.PKCSObjectIdentifiers;
import com.maverick.crypto.asn1.x509.AlgorithmIdentifier;
import com.maverick.crypto.asn1.x509.SubjectPublicKeyInfo;
import com.maverick.crypto.asn1.x509.Time;
import com.maverick.crypto.asn1.x509.X509Extensions;
import com.maverick.crypto.asn1.x509.X509Name;
import com.maverick.crypto.asn1.x509.X509ObjectIdentifiers;

public class TBSCertificateStructure
implements DEREncodable,
X509ObjectIdentifiers,
PKCSObjectIdentifiers {
    ASN1Sequence o;
    DERInteger l;
    DERInteger h;
    AlgorithmIdentifier g;
    X509Name k;
    Time f;
    Time j;
    X509Name n;
    SubjectPublicKeyInfo d;
    DERBitString e;
    DERBitString i;
    X509Extensions m;

    public static TBSCertificateStructure getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return TBSCertificateStructure.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static TBSCertificateStructure getInstance(Object object) {
        if (object instanceof TBSCertificateStructure) {
            return (TBSCertificateStructure)object;
        }
        if (object instanceof ASN1Sequence) {
            return new TBSCertificateStructure((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public TBSCertificateStructure(ASN1Sequence aSN1Sequence) {
        int n = 0;
        this.o = aSN1Sequence;
        if (aSN1Sequence.getObjectAt(0) instanceof DERTaggedObject) {
            this.l = DERInteger.getInstance(aSN1Sequence.getObjectAt(0));
        } else {
            n = -1;
            this.l = new DERInteger(0);
        }
        this.h = DERInteger.getInstance(aSN1Sequence.getObjectAt(n + 1));
        this.g = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n + 2));
        this.k = X509Name.getInstance(aSN1Sequence.getObjectAt(n + 3));
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(n + 4);
        this.f = Time.getInstance(aSN1Sequence2.getObjectAt(0));
        this.j = Time.getInstance(aSN1Sequence2.getObjectAt(1));
        this.n = X509Name.getInstance(aSN1Sequence.getObjectAt(n + 5));
        this.d = SubjectPublicKeyInfo.getInstance(aSN1Sequence.getObjectAt(n + 6));
        block5: for (int k = aSN1Sequence.size() - (n + 6) - 1; k > 0; --k) {
            DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence.getObjectAt(n + 6 + k);
            switch (dERTaggedObject.getTagNo()) {
                case 1: {
                    this.e = DERBitString.getInstance(dERTaggedObject);
                    continue block5;
                }
                case 2: {
                    this.i = DERBitString.getInstance(dERTaggedObject);
                    continue block5;
                }
                case 3: {
                    this.m = X509Extensions.getInstance(dERTaggedObject);
                }
            }
        }
    }

    public int getVersion() {
        return this.l.getValue().intValue() + 1;
    }

    public DERInteger getVersionNumber() {
        return this.l;
    }

    public DERInteger getSerialNumber() {
        return this.h;
    }

    public AlgorithmIdentifier getSignature() {
        return this.g;
    }

    public X509Name getIssuer() {
        return this.k;
    }

    public Time getStartDate() {
        return this.f;
    }

    public Time getEndDate() {
        return this.j;
    }

    public X509Name getSubject() {
        return this.n;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.d;
    }

    public DERBitString getIssuerUniqueId() {
        return this.e;
    }

    public DERBitString getSubjectUniqueId() {
        return this.i;
    }

    public X509Extensions getExtensions() {
        return this.m;
    }

    public DERObject getDERObject() {
        return this.o;
    }
}

