/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1EncodableVector;
import com.maverick.crypto.asn1.ASN1InputStream;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1Set;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERIA5String;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DERObjectIdentifier;
import com.maverick.crypto.asn1.DERPrintableString;
import com.maverick.crypto.asn1.DERSequence;
import com.maverick.crypto.asn1.DERSet;
import com.maverick.crypto.asn1.DERString;
import com.maverick.crypto.asn1.DERUTF8String;
import com.maverick.crypto.asn1.x509.X509NameTokenizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class X509Name
implements DEREncodable {
    public static final DERObjectIdentifier C = new DERObjectIdentifier("2.5.4.6");
    public static final DERObjectIdentifier O = new DERObjectIdentifier("2.5.4.10");
    public static final DERObjectIdentifier OU = new DERObjectIdentifier("2.5.4.11");
    public static final DERObjectIdentifier T = new DERObjectIdentifier("2.5.4.12");
    public static final DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
    public static final DERObjectIdentifier SN = new DERObjectIdentifier("2.5.4.5");
    public static final DERObjectIdentifier L = new DERObjectIdentifier("2.5.4.7");
    public static final DERObjectIdentifier ST = new DERObjectIdentifier("2.5.4.8");
    public static final DERObjectIdentifier SURNAME = new DERObjectIdentifier("2.5.4.4");
    public static final DERObjectIdentifier GIVENNAME = new DERObjectIdentifier("2.5.4.42");
    public static final DERObjectIdentifier INITIALS = new DERObjectIdentifier("2.5.4.43");
    public static final DERObjectIdentifier GENERATION = new DERObjectIdentifier("2.5.4.44");
    public static final DERObjectIdentifier UNIQUE_IDENTIFIER = new DERObjectIdentifier("2.5.4.45");
    public static final DERObjectIdentifier EmailAddress;
    public static final DERObjectIdentifier E;
    public static final DERObjectIdentifier DC;
    public static final DERObjectIdentifier UID;
    public static Hashtable OIDLookUp;
    public static boolean DefaultReverse;
    public static Hashtable DefaultSymbols;
    public static Hashtable RFC2253Symbols;
    public static Hashtable SymbolLookUp;
    public static Hashtable DefaultLookUp;
    private Vector x = new Vector();
    private Vector u = new Vector();
    private Vector v = new Vector();
    private ASN1Sequence w;

    public static X509Name getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return X509Name.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static X509Name getInstance(Object object) {
        if (object == null || object instanceof X509Name) {
            return (X509Name)object;
        }
        if (object instanceof ASN1Sequence) {
            return new X509Name((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public X509Name(ASN1Sequence aSN1Sequence) {
        this.w = aSN1Sequence;
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Set aSN1Set = (ASN1Set)enumeration.nextElement();
            for (int k = 0; k < aSN1Set.size(); ++k) {
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Set.getObjectAt(k);
                this.x.addElement(aSN1Sequence2.getObjectAt(0));
                this.u.addElement(((DERString)((Object)aSN1Sequence2.getObjectAt(1))).getString());
                this.v.addElement(k != 0 ? new Boolean(true) : new Boolean(false));
            }
        }
    }

    public X509Name(Hashtable hashtable) {
        this(null, hashtable);
    }

    public X509Name(Vector vector, Hashtable hashtable) {
        int n;
        if (vector != null) {
            for (n = 0; n != vector.size(); ++n) {
                this.x.addElement(vector.elementAt(n));
                this.v.addElement(new Boolean(false));
            }
        } else {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                this.x.addElement(enumeration.nextElement());
                this.v.addElement(new Boolean(false));
            }
        }
        for (n = 0; n != this.x.size(); ++n) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)this.x.elementAt(n);
            if (hashtable.get(dERObjectIdentifier) == null) {
                throw new IllegalArgumentException("No attribute for object id - " + dERObjectIdentifier.getId() + " - passed to distinguished name");
            }
            this.u.addElement(hashtable.get(dERObjectIdentifier));
        }
    }

    public X509Name(Vector vector, Vector vector2) {
        if (vector.size() != vector2.size()) {
            throw new IllegalArgumentException("oids vector must be same length as values.");
        }
        for (int k = 0; k < vector.size(); ++k) {
            this.x.addElement(vector.elementAt(k));
            this.u.addElement(vector2.elementAt(k));
            this.v.addElement(new Boolean(false));
        }
    }

    public X509Name(String string) {
        this(DefaultReverse, DefaultLookUp, string);
    }

    public X509Name(boolean bl, String string) {
        this(bl, DefaultLookUp, string);
    }

    public X509Name(boolean bl, Hashtable hashtable, String string) {
        Object object;
        X509NameTokenizer x509NameTokenizer = new X509NameTokenizer(string);
        while (x509NameTokenizer.hasMoreTokens()) {
            object = x509NameTokenizer.nextToken();
            int n = ((String)object).indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String string2 = ((String)object).substring(0, n);
            String string3 = ((String)object).substring(n + 1);
            DERObjectIdentifier dERObjectIdentifier = null;
            if (string2.toUpperCase().startsWith("OID.")) {
                dERObjectIdentifier = new DERObjectIdentifier(string2.substring(4));
            } else if (string2.charAt(0) >= '0' && string2.charAt(0) <= '9') {
                dERObjectIdentifier = new DERObjectIdentifier(string2);
            } else {
                dERObjectIdentifier = (DERObjectIdentifier)hashtable.get(string2.toLowerCase());
                if (dERObjectIdentifier == null) {
                    throw new IllegalArgumentException("Unknown object id - " + string2 + " - passed to distinguished name");
                }
            }
            this.x.addElement(dERObjectIdentifier);
            this.u.addElement(string3);
            this.v.addElement(new Boolean(false));
        }
        if (bl) {
            object = new Vector();
            Vector vector = new Vector();
            for (int k = this.x.size() - 1; k >= 0; --k) {
                ((Vector)object).addElement(this.x.elementAt(k));
                vector.addElement(this.u.elementAt(k));
                this.v.addElement(new Boolean(false));
            }
            this.x = object;
            this.u = vector;
        }
    }

    public Vector getOIDs() {
        Vector vector = new Vector();
        for (int k = 0; k != this.x.size(); ++k) {
            vector.addElement(this.x.elementAt(k));
        }
        return vector;
    }

    public Vector getValues() {
        Vector vector = new Vector();
        for (int k = 0; k != this.u.size(); ++k) {
            vector.addElement(this.u.elementAt(k));
        }
        return vector;
    }

    private boolean b(String string) {
        for (int k = string.length() - 1; k >= 0; --k) {
            if (string.charAt(k) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public DERObject getDERObject() {
        if (this.w == null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            for (int k = 0; k != this.x.size(); ++k) {
                ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)this.x.elementAt(k);
                aSN1EncodableVector2.add(dERObjectIdentifier);
                String string = (String)this.u.elementAt(k);
                if (string.charAt(0) == '#') {
                    string = string.toLowerCase();
                    byte[] byArray = new byte[string.length() / 2];
                    for (int i2 = 0; i2 != byArray.length; ++i2) {
                        char c2 = string.charAt(i2 * 2 + 1);
                        char c3 = string.charAt(i2 * 2 + 2);
                        byArray[i2] = c2 < 'a' ? (byte)(c2 - 48 << 4) : (byte)(c2 - 97 + 10 << 4);
                        if (c3 < 'a') {
                            int n = i2;
                            byArray[n] = (byte)(byArray[n] | (byte)(c3 - 48));
                            continue;
                        }
                        int n = i2;
                        byArray[n] = (byte)(byArray[n] | (byte)(c3 - 97 + 10));
                    }
                    ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
                    try {
                        aSN1EncodableVector2.add(aSN1InputStream.readObject());
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("bad object in '#' string");
                    }
                } else if (dERObjectIdentifier.equals(EmailAddress)) {
                    aSN1EncodableVector2.add(new DERIA5String(string));
                } else if (this.b(string)) {
                    aSN1EncodableVector2.add(new DERPrintableString(string));
                } else {
                    aSN1EncodableVector2.add(new DERUTF8String(string));
                }
                aSN1EncodableVector.add(new DERSet(new DERSequence(aSN1EncodableVector2)));
            }
            this.w = new DERSequence(aSN1EncodableVector);
        }
        return this.w;
    }

    public boolean equals(Object object, boolean bl) {
        if (object == this) {
            return true;
        }
        if (!bl) {
            return this.equals(object);
        }
        if (object == null || !(object instanceof X509Name)) {
            return false;
        }
        X509Name x509Name = (X509Name)object;
        int n = this.x.size();
        if (n != x509Name.x.size()) {
            return false;
        }
        for (int k = 0; k < n; ++k) {
            char c2;
            int n2;
            char c3;
            String string = ((DERObjectIdentifier)this.x.elementAt(k)).getId();
            String string2 = (String)this.u.elementAt(k);
            String string3 = ((DERObjectIdentifier)x509Name.x.elementAt(k)).getId();
            String string4 = (String)x509Name.u.elementAt(k);
            if (!string.equals(string3) || (string2 = string2.trim().toLowerCase()).equals(string4 = string4.trim().toLowerCase())) continue;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (string2.length() != 0) {
                c3 = string2.charAt(0);
                stringBuffer.append(c3);
                for (n2 = 1; n2 < string2.length(); ++n2) {
                    c2 = string2.charAt(n2);
                    if (c3 != ' ' || c2 != ' ') {
                        stringBuffer.append(c2);
                    }
                    c3 = c2;
                }
            }
            if (string4.length() != 0) {
                c3 = string4.charAt(0);
                stringBuffer2.append(c3);
                for (n2 = 1; n2 < string4.length(); ++n2) {
                    c2 = string4.charAt(n2);
                    if (c3 != ' ' || c2 != ' ') {
                        stringBuffer2.append(c2);
                    }
                    c3 = c2;
                }
            }
            if (stringBuffer.toString().equals(stringBuffer2.toString())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof X509Name)) {
            return false;
        }
        X509Name x509Name = (X509Name)object;
        if (this.getDERObject().equals(x509Name.getDERObject())) {
            return true;
        }
        int n = this.x.size();
        if (n != x509Name.x.size()) {
            return false;
        }
        boolean[] blArray = new boolean[n];
        for (int k = 0; k < n; ++k) {
            boolean bl = false;
            String string = ((DERObjectIdentifier)this.x.elementAt(k)).getId();
            String string2 = (String)this.u.elementAt(k);
            for (int i2 = 0; i2 < n; ++i2) {
                char c2;
                int n2;
                char c3;
                if (blArray[i2]) continue;
                String string3 = ((DERObjectIdentifier)x509Name.x.elementAt(i2)).getId();
                String string4 = (String)x509Name.u.elementAt(i2);
                if (!string.equals(string3)) continue;
                if ((string2 = string2.trim().toLowerCase()).equals(string4 = string4.trim().toLowerCase())) {
                    blArray[i2] = true;
                    bl = true;
                    break;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                if (string2.length() != 0) {
                    c3 = string2.charAt(0);
                    stringBuffer.append(c3);
                    for (n2 = 1; n2 < string2.length(); ++n2) {
                        c2 = string2.charAt(n2);
                        if (c3 != ' ' || c2 != ' ') {
                            stringBuffer.append(c2);
                        }
                        c3 = c2;
                    }
                }
                if (string4.length() != 0) {
                    c3 = string4.charAt(0);
                    stringBuffer2.append(c3);
                    for (n2 = 1; n2 < string4.length(); ++n2) {
                        c2 = string4.charAt(n2);
                        if (c3 != ' ' || c2 != ' ') {
                            stringBuffer2.append(c2);
                        }
                        c3 = c2;
                    }
                }
                if (!stringBuffer.toString().equals(stringBuffer2.toString())) continue;
                blArray[i2] = true;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)this.getDERObject();
        Enumeration enumeration = aSN1Sequence.getObjects();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            n ^= enumeration.nextElement().hashCode();
        }
        return n;
    }

    private void b(StringBuffer stringBuffer, Hashtable hashtable, DERObjectIdentifier dERObjectIdentifier, String string) {
        String string2 = (String)hashtable.get(dERObjectIdentifier);
        if (string2 != null) {
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(dERObjectIdentifier.getId());
        }
        stringBuffer.append("=");
        stringBuffer.append(string);
        int n = stringBuffer.length();
        for (int k = stringBuffer.length(); k != n; ++k) {
            if (stringBuffer.charAt(k) != ',' && stringBuffer.charAt(k) != '\"' && stringBuffer.charAt(k) != '\\' && stringBuffer.charAt(k) != '+' && stringBuffer.charAt(k) != '<' && stringBuffer.charAt(k) != '>' && stringBuffer.charAt(k) != ';') continue;
            stringBuffer.insert(k, "\\");
            ++k;
            ++n;
        }
    }

    public String toString(boolean bl, Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        if (bl) {
            for (int k = this.x.size() - 1; k >= 0; --k) {
                if (bl2) {
                    bl2 = false;
                } else if (((Boolean)this.v.elementAt(k + 1)).booleanValue()) {
                    stringBuffer.append(" + ");
                } else {
                    stringBuffer.append(",");
                }
                this.b(stringBuffer, hashtable, (DERObjectIdentifier)this.x.elementAt(k), (String)this.u.elementAt(k));
            }
        } else {
            for (int k = 0; k < this.x.size(); ++k) {
                if (bl2) {
                    bl2 = false;
                } else if (((Boolean)this.v.elementAt(k)).booleanValue()) {
                    stringBuffer.append(" + ");
                } else {
                    stringBuffer.append(",");
                }
                this.b(stringBuffer, hashtable, (DERObjectIdentifier)this.x.elementAt(k), (String)this.u.elementAt(k));
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(DefaultReverse, DefaultSymbols);
    }

    static {
        E = EmailAddress = new DERObjectIdentifier("1.2.840.113549.1.9.1");
        DC = new DERObjectIdentifier("0.9.2342.19200300.100.1.25");
        UID = new DERObjectIdentifier("0.9.2342.19200300.100.1.1");
        OIDLookUp = new Hashtable();
        DefaultReverse = false;
        DefaultSymbols = OIDLookUp;
        RFC2253Symbols = new Hashtable();
        SymbolLookUp = new Hashtable();
        DefaultLookUp = SymbolLookUp;
        DefaultSymbols.put(C, "C");
        DefaultSymbols.put(O, "O");
        DefaultSymbols.put(T, "T");
        DefaultSymbols.put(OU, "OU");
        DefaultSymbols.put(CN, "CN");
        DefaultSymbols.put(L, "L");
        DefaultSymbols.put(ST, "ST");
        DefaultSymbols.put(SN, "SN");
        DefaultSymbols.put(EmailAddress, "E");
        DefaultSymbols.put(DC, "DC");
        DefaultSymbols.put(UID, "UID");
        DefaultSymbols.put(SURNAME, "SURNAME");
        DefaultSymbols.put(GIVENNAME, "GIVENNAME");
        DefaultSymbols.put(INITIALS, "INITIALS");
        DefaultSymbols.put(GENERATION, "GENERATION");
        RFC2253Symbols.put(C, "C");
        RFC2253Symbols.put(O, "O");
        RFC2253Symbols.put(T, "T");
        RFC2253Symbols.put(OU, "OU");
        RFC2253Symbols.put(CN, "CN");
        RFC2253Symbols.put(L, "L");
        RFC2253Symbols.put(ST, "ST");
        RFC2253Symbols.put(SN, "SN");
        RFC2253Symbols.put(EmailAddress, "EMAILADDRESS");
        RFC2253Symbols.put(DC, "DC");
        RFC2253Symbols.put(UID, "UID");
        RFC2253Symbols.put(SURNAME, "SURNAME");
        RFC2253Symbols.put(GIVENNAME, "GIVENNAME");
        RFC2253Symbols.put(INITIALS, "INITIALS");
        RFC2253Symbols.put(GENERATION, "GENERATION");
        DefaultLookUp.put("c", C);
        DefaultLookUp.put("o", O);
        DefaultLookUp.put("t", T);
        DefaultLookUp.put("ou", OU);
        DefaultLookUp.put("cn", CN);
        DefaultLookUp.put("l", L);
        DefaultLookUp.put("st", ST);
        DefaultLookUp.put("sn", SN);
        DefaultLookUp.put("emailaddress", E);
        DefaultLookUp.put("dc", DC);
        DefaultLookUp.put("e", E);
        DefaultLookUp.put("uid", UID);
        DefaultLookUp.put("surname", SURNAME);
        DefaultLookUp.put("givenname", GIVENNAME);
        DefaultLookUp.put("initials", INITIALS);
        DefaultLookUp.put("generation", GENERATION);
    }
}

