/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.publickey;

import com.maverick.crypto.publickey.DsaPrivateKey;
import com.maverick.crypto.publickey.b;
import com.maverick.crypto.publickey.d;
import com.maverick.crypto.security.SecureRandom;
import java.math.BigInteger;

public final class Dsa {
    public static byte[] sign(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray) {
        BigInteger bigInteger5 = new BigInteger(1, byArray);
        BigInteger bigInteger6 = new BigInteger(1024, SecureRandom.getInstance());
        bigInteger5 = bigInteger5.mod(bigInteger3);
        BigInteger bigInteger7 = bigInteger4.modPow(bigInteger6, bigInteger2).mod(bigInteger3);
        BigInteger bigInteger8 = bigInteger6.modInverse(bigInteger3).multiply(bigInteger5.add(bigInteger.multiply(bigInteger7))).mod(bigInteger3);
        int n = byArray.length;
        byte[] byArray2 = new byte[n * 2];
        byte[] byArray3 = Dsa.b(bigInteger7, n);
        System.arraycopy(byArray3, 0, byArray2, 0, n);
        byArray3 = Dsa.b(bigInteger8, n);
        System.arraycopy(byArray3, 0, byArray2, n, n);
        return byArray2;
    }

    public static boolean verify(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray, byte[] byArray2) {
        int n = byArray.length / 2;
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray, n, byArray4, 0, n);
        BigInteger bigInteger5 = new BigInteger(1, byArray2);
        BigInteger bigInteger6 = new BigInteger(1, byArray3);
        if (System.getProperty("maverick.debug.dsa.rvalue", "false").equals("true")) {
            System.out.println("DSA Signature R Value is: " + bigInteger6.toString(16));
        }
        BigInteger bigInteger7 = new BigInteger(1, byArray4);
        bigInteger5 = bigInteger5.mod(bigInteger3);
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger3);
        BigInteger bigInteger9 = bigInteger5.multiply(bigInteger8).mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger6.multiply(bigInteger8).mod(bigInteger3);
        BigInteger bigInteger11 = bigInteger4.modPow(bigInteger9, bigInteger2).multiply(bigInteger.modPow(bigInteger10, bigInteger2)).mod(bigInteger2).mod(bigInteger3);
        return bigInteger11.compareTo(bigInteger6) == 0;
    }

    private static byte[] b(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = null;
        if (byArray.length > n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, byArray.length - n, byArray2, 0, n);
        } else if (byArray.length < n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static BigInteger generatePublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger.modPow(bigInteger3, bigInteger2);
    }

    public static DsaPrivateKey generateKey(int n, SecureRandom secureRandom) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        d d2 = new d();
        d2.b(n, 80, secureRandom);
        b b2 = d2.b();
        BigInteger bigInteger3 = b2.b();
        BigInteger bigInteger4 = b2.c();
        BigInteger bigInteger5 = b2.d();
        while ((bigInteger = new BigInteger(160, secureRandom)).equals(bigInteger2) || bigInteger.compareTo(bigInteger3) >= 0) {
        }
        return new DsaPrivateKey(bigInteger4, bigInteger3, bigInteger5, bigInteger);
    }
}

