/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.components.SshCipher;
import com.maverick.ssh.components.jce.JCEProvider;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AbstractJCECipher
extends SshCipher {
    Cipher u;
    String v;
    String x;
    int w;

    public AbstractJCECipher(String string, String string2, int n, String string3) throws IOException {
        super(string3);
        this.v = string;
        this.w = n;
        this.x = string2;
        try {
            this.u = JCEProvider.getProviderForAlgorithm(string) == null ? Cipher.getInstance(string) : Cipher.getInstance(string, JCEProvider.getProviderForAlgorithm(string));
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new IOException("Padding type not supported");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Algorithm not supported:" + string);
        }
        if (this.u == null) {
            throw new IOException("Failed to create cipher engine for " + string);
        }
    }

    public void transform(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws IOException {
        if (n3 > 0) {
            byte[] byArray3 = this.u.update(byArray, n, n3);
            System.arraycopy(byArray3, 0, byArray2, n2, n3);
        }
    }

    public String getProvider() {
        return this.u.getProvider().getName();
    }

    public void init(int n, byte[] byArray, byte[] byArray2) throws IOException {
        try {
            byte[] byArray3 = new byte[this.w];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, this.x);
            this.u.init(n == 0 ? 1 : 2, (Key)secretKeySpec, new IvParameterSpec(byArray, 0, this.u.getBlockSize()));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Invalid encryption key");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IOException("Invalid algorithm parameter");
        }
    }

    public int getBlockSize() {
        return this.u.getBlockSize();
    }
}

