/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.standalone;

import com.maverick.crypto.publickey.Rsa;
import com.maverick.crypto.publickey.RsaPublicKey;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshKeyFingerprint;
import com.maverick.ssh.components.SshRsaPublicKey;
import java.math.BigInteger;

public class Ssh1RsaPublicKey
extends RsaPublicKey
implements SshRsaPublicKey {
    public Ssh1RsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger, bigInteger2);
    }

    public byte[] getEncoded() throws SshException {
        try {
            byte[] byArray = this.getModulus().toByteArray();
            byte[] byArray2 = this.getPublicExponent().toByteArray();
            int n = byArray[0] == 0 ? 1 : 0;
            int n2 = byArray2[0] == 0 ? 1 : 0;
            byte[] byArray3 = new byte[byArray.length + byArray2.length - n - n2];
            System.arraycopy(byArray, n, byArray3, 0, byArray.length - n);
            System.arraycopy(byArray2, n2, byArray3, byArray.length - n, byArray2.length - n2);
            return byArray3;
        }
        catch (Throwable throwable) {
            throw new SshException("Ssh1RsaPublicKey.getEncoded() caught an exception: " + throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName(), 5);
        }
    }

    public void init(byte[] byArray, int n, int n2) {
    }

    public String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint(this.getEncoded());
    }

    public String getAlgorithm() {
        return "rsa1";
    }

    public boolean equals(Object object) {
        if (object instanceof Ssh1RsaPublicKey) {
            try {
                return ((Ssh1RsaPublicKey)object).getFingerprint().equals(this.getFingerprint());
            }
            catch (SshException sshException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (SshException sshException) {
            return 0;
        }
    }

    public int getVersion() {
        return 1;
    }

    public BigInteger doPublic(BigInteger bigInteger) {
        bigInteger = Rsa.padPKCS1(bigInteger, 2, (this.getModulus().bitLength() + 7) / 8);
        return Rsa.doPublic(bigInteger, this.getModulus(), this.getPublicExponent());
    }
}

