/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh1;

import com.maverick.events.EventLog;
import com.maverick.ssh.ChannelEventListener;
import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.ForwardingRequestListener;
import com.maverick.ssh.PasswordAuthentication;
import com.maverick.ssh.PublicKeyAuthentication;
import com.maverick.ssh.SshAuthentication;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshConnector;
import com.maverick.ssh.SshContext;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshSession;
import com.maverick.ssh.SshTransport;
import com.maverick.ssh.SshTunnel;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.Digest;
import com.maverick.ssh.components.SshRsaPrivateCrtKey;
import com.maverick.ssh.components.SshRsaPublicKey;
import com.maverick.ssh.message.SshMessage;
import com.maverick.ssh1.Ssh1ChallengeResponseAuthentication;
import com.maverick.ssh1.Ssh1RhostsRsaAuthentication;
import com.maverick.ssh1.b;
import com.maverick.ssh1.f;
import com.maverick.util.ByteArrayWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class Ssh1Client
implements SshClient {
    String bc;
    boolean ac = false;
    boolean wb;
    b yb;
    f zb;
    String ub;
    SshAuthentication xb;
    SshConnector vb;

    public void connect(SshTransport sshTransport, SshContext sshContext, SshConnector sshConnector, String string, String string2, String string3, boolean bl) throws SshException {
        if (sshConnector == null || !sshConnector.isLicensed()) {
            throw new SshException("You cannot create Ssh1Client instances directly", 4);
        }
        this.zb = new f(sshTransport, sshContext);
        this.bc = string;
        this.wb = bl;
        this.vb = sshConnector;
        this.ub = string3;
        if (string == null) {
            throw new SshException("You must supply a valid username!", 4);
        }
        this.zb.b();
        this.zb.g();
        this.ac = this.zb.b(string);
    }

    public String getRemoteIdentification() {
        return this.ub;
    }

    public boolean isAuthenticated() {
        return this.ac;
    }

    public int authenticate(SshAuthentication sshAuthentication) throws SshException {
        try {
            if (this.ac) {
                throw new SshException("The connection has already been authenticated!", 4);
            }
            if (sshAuthentication.getUsername() == null) {
                sshAuthentication.setUsername(this.bc);
            }
            if (sshAuthentication instanceof PasswordAuthentication) {
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.write(9);
                byteArrayWriter.writeString(((PasswordAuthentication)sshAuthentication).getPassword());
                this.zb.d(byteArrayWriter.toByteArray());
                this.ac = this.zb.f();
                if (this.ac) {
                    this.xb = sshAuthentication;
                    return 1;
                }
                return 2;
            }
            if (sshAuthentication instanceof Ssh1RhostsRsaAuthentication) {
                Ssh1RhostsRsaAuthentication ssh1RhostsRsaAuthentication = (Ssh1RhostsRsaAuthentication)sshAuthentication;
                if (ssh1RhostsRsaAuthentication.getPublicKey() instanceof SshRsaPublicKey && ssh1RhostsRsaAuthentication.getPrivateKey() instanceof SshRsaPrivateCrtKey) {
                    SshRsaPublicKey sshRsaPublicKey = (SshRsaPublicKey)ssh1RhostsRsaAuthentication.getPublicKey();
                    ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                    byteArrayWriter.write(35);
                    byteArrayWriter.writeString(ssh1RhostsRsaAuthentication.getClientUsername());
                    byteArrayWriter.writeInt(sshRsaPublicKey.getBitLength());
                    byteArrayWriter.writeMPINT(sshRsaPublicKey.getPublicExponent());
                    byteArrayWriter.writeMPINT(sshRsaPublicKey.getModulus());
                    EventLog.LogEvent(this, "Sending SSH_CMSG_AUTH_RHOSTS_RSA");
                    this.zb.d(byteArrayWriter.toByteArray());
                    this.ac = this.b(true, (SshRsaPrivateCrtKey)ssh1RhostsRsaAuthentication.getPrivateKey());
                    if (this.ac) {
                        this.xb = sshAuthentication;
                        return 1;
                    }
                    return 2;
                }
                throw new SshException("Only SSH1 RSA keys are suitable for SSH1 hostbased authentication", 4);
            }
            if (sshAuthentication instanceof PublicKeyAuthentication) {
                PublicKeyAuthentication publicKeyAuthentication = (PublicKeyAuthentication)sshAuthentication;
                if (publicKeyAuthentication.getPublicKey() instanceof SshRsaPublicKey) {
                    SshRsaPublicKey sshRsaPublicKey = (SshRsaPublicKey)publicKeyAuthentication.getPublicKey();
                    ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                    byteArrayWriter.write(6);
                    byteArrayWriter.writeMPINT(sshRsaPublicKey.getModulus());
                    EventLog.LogEvent(this, "Sending SSH_CMSG_AUTH_RSA");
                    this.zb.d(byteArrayWriter.toByteArray());
                    this.ac = this.b(publicKeyAuthentication.isAuthenticating(), (SshRsaPrivateCrtKey)publicKeyAuthentication.getPrivateKey());
                    if (publicKeyAuthentication.isAuthenticating()) {
                        if (this.ac) {
                            this.xb = sshAuthentication;
                            return 1;
                        }
                        return 2;
                    }
                    return 5;
                }
                throw new SshException("Only SSH1 RSA private keys are acceptable for SSH1 RSA Authentication", 4);
            }
            if (sshAuthentication instanceof Ssh1ChallengeResponseAuthentication) {
                if (((Ssh1ChallengeResponseAuthentication)sshAuthentication).getPrompt() == null) {
                    throw new SshException("SSH1 challenge-response requires prompt!", 4);
                }
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.write(39);
                EventLog.LogEvent(this, "Sending SSH_CMSG_AUTH_TIS");
                this.zb.d(byteArrayWriter.toByteArray());
                this.ac = this.b((Ssh1ChallengeResponseAuthentication)sshAuthentication);
                if (this.ac) {
                    this.xb = sshAuthentication;
                    return 1;
                }
                return 2;
            }
            throw new SshException("Unsupported SSH1 authentication type!", 4);
        }
        catch (IOException iOException) {
            throw new SshException("Ssh1Client.authenticate caught an IOException: " + iOException.getMessage(), 5);
        }
    }

    private boolean b(Ssh1ChallengeResponseAuthentication ssh1ChallengeResponseAuthentication) throws SshException {
        try {
            SshMessage sshMessage = new SshMessage(this.zb.nextMessage());
            if (sshMessage.getMessageId() == 40) {
                EventLog.LogEvent(this, "Received SSH_SMSG_AUTH_TIS_CHALLENGE");
                String string = sshMessage.readString();
                String string2 = ssh1ChallengeResponseAuthentication.getPrompt().getResponse(string);
                if (string2 != null) {
                    ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                    byteArrayWriter.write(41);
                    byteArrayWriter.writeString(string2);
                    EventLog.LogEvent(this, "Sending SSH_CMSG_AUTH_TIS_RESPONSE");
                    this.zb.d(byteArrayWriter.toByteArray());
                    return this.zb.f();
                }
                return false;
            }
            return false;
        }
        catch (IOException iOException) {
            throw new SshException("Ssh1Client.performChallengeResponse() caught an IOException: " + iOException.getMessage(), 5);
        }
    }

    private boolean b(boolean bl, SshRsaPrivateCrtKey sshRsaPrivateCrtKey) throws SshException {
        try {
            SshMessage sshMessage = new SshMessage(this.zb.nextMessage());
            if (sshMessage.getMessageId() == 7) {
                Object object;
                EventLog.LogEvent(this, "Received SSH_SMSG_AUTH_RSA_CHALLENGE");
                byte[] byArray = new byte[16];
                if (bl && sshRsaPrivateCrtKey != null) {
                    object = sshMessage.readMPINT();
                    object = sshRsaPrivateCrtKey.doPrivate((BigInteger)object);
                    byArray = ((BigInteger)object).toByteArray();
                    Digest digest = (Digest)ComponentManager.getInstance().supportedDigests().getInstance("MD5");
                    if (byArray[0] == 0) {
                        digest.putBytes(byArray, 1, 32);
                    } else {
                        digest.putBytes(byArray, 0, 32);
                    }
                    digest.putBytes(this.zb.p);
                    byArray = digest.doFinal();
                }
                object = new ByteArrayWriter();
                ((ByteArrayOutputStream)object).write(8);
                ((OutputStream)object).write(byArray);
                EventLog.LogEvent(this, "Sending SSH_CMSG_AUTH_RSA_RESPONSE");
                this.zb.d(((ByteArrayOutputStream)object).toByteArray());
                return this.zb.f();
            }
            return false;
        }
        catch (IOException iOException) {
            throw new SshException("Ssh1Client.performRSAChallenge() caught an IOException: " + iOException.getMessage(), 5);
        }
    }

    public SshSession openSessionChannel() throws SshException, ChannelOpenException {
        return this.openSessionChannel(null);
    }

    public SshSession openSessionChannel(ChannelEventListener channelEventListener) throws SshException, ChannelOpenException {
        if (!this.ac) {
            throw new SshException("The connection must be authenticated first!", 4);
        }
        if (this.yb == null) {
            this.yb = new b(this.zb, this, channelEventListener, this.wb);
            if (this.zb.b.getX11Display() != null && !this.yb.vc) {
                this.yb.b(this.zb.b.getX11Display(), this.zb.b.getX11RequestListener());
            }
            return this.yb;
        }
        return this.duplicate().openSessionChannel(channelEventListener);
    }

    public SshTunnel openForwardingChannel(String string, int n, String string2, int n2, String string3, int n3, SshTransport sshTransport, ChannelEventListener channelEventListener) throws SshException, ChannelOpenException {
        if (this.yb == null || !this.yb.hd) {
            throw new SshException("SSH1 forwarding channels can only be opened after the user's shell has been started!", 4);
        }
        return this.yb.b(string, n, string2, n2, string3, n3, sshTransport, channelEventListener);
    }

    public SshClient openRemoteClient(String string, int n, String string2, SshConnector sshConnector) throws SshException, ChannelOpenException {
        SshTunnel sshTunnel = this.openForwardingChannel(string, n, "127.0.0.1", 22, "127.0.0.1", 22, null, null);
        return sshConnector.connect(sshTunnel, string2);
    }

    public SshClient openRemoteClient(String string, int n, String string2) throws SshException, ChannelOpenException {
        return this.openRemoteClient(string, n, string2, this.vb);
    }

    public boolean requestXForwarding(String string, ForwardingRequestListener forwardingRequestListener) throws SshException {
        if (this.yb != null && this.yb.hd) {
            throw new SshException("SSH1 X forwarding requests must be made after opening the session but before starting the shell!", 4);
        }
        if (this.yb == null) {
            throw new SshException("SSH1 X forwarding requests must be made after opening the session but before starting the shell!", 4);
        }
        this.zb.b.setX11Display(string);
        this.zb.b.setX11RequestListener(forwardingRequestListener);
        this.yb.b(string, forwardingRequestListener);
        return this.yb.vc;
    }

    public boolean requestRemoteForwarding(String string, int n, String string2, int n2, ForwardingRequestListener forwardingRequestListener) throws SshException {
        if (this.yb != null && this.yb.hd) {
            throw new SshException("SSH1 forwarding requests must be made after opening the session but before starting the shell!", 4);
        }
        if (this.yb == null) {
            throw new SshException("SSH1 forwarding requests must be made after opening the session but before starting the shell!", 4);
        }
        return this.yb.b(n, string2, n2, forwardingRequestListener);
    }

    public boolean cancelRemoteForwarding(String string, int n) throws SshException {
        return false;
    }

    public void disconnect() {
        try {
            if (this.yb != null) {
                this.yb.signalClosingState();
            }
            this.zb.c("The user disconnected the application");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void exit() {
        try {
            if (this.yb != null) {
                this.yb.signalClosingState();
            }
            this.zb.c("The user disconnected the application");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.zb.e() == 2;
    }

    public String getUsername() {
        return this.bc;
    }

    public SshClient duplicate() throws SshException {
        if (this.bc == null || this.xb == null) {
            throw new SshException("Cannot duplicate! The existing connection does not have a set of credentials", 4);
        }
        try {
            SshClient sshClient = this.vb.connect(this.zb.q.duplicate(), this.bc, this.wb, this.zb.b);
            if (!sshClient.isAuthenticated() && sshClient.authenticate(this.xb) != 1) {
                throw new SshException("Duplication attempt failed to authenicate user!", 5);
            }
            return sshClient;
        }
        catch (IOException iOException) {
            throw new SshException("Failed to duplicate SshClient", 10);
        }
    }

    public SshContext getContext() {
        return this.zb.b;
    }

    public int getChannelCount() {
        if (this.yb == null) {
            return 0;
        }
        return this.yb.getChannelCount();
    }

    public int getVersion() {
        return 1;
    }

    public boolean isBuffered() {
        return this.wb;
    }

    public String toString() {
        return "SSH1 " + this.zb.q.getHost() + ":" + this.zb.q.getPort() + "[" + "cipher=" + (this.zb.s == null ? "none" : this.zb.s.getAlgorithm()) + "]";
    }
}

