/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.events.Event;
import com.maverick.events.EventLog;
import com.maverick.events.EventServiceImplementation;
import com.maverick.ssh.SocketTimeoutSupport;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import com.maverick.ssh.SshTransport;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.Digest;
import com.maverick.ssh.components.SshCipher;
import com.maverick.ssh.components.SshHmac;
import com.maverick.ssh.components.SshKeyExchangeClient;
import com.maverick.ssh.components.SshPublicKey;
import com.maverick.ssh.compression.SshCompression;
import com.maverick.ssh.message.SshMessageReader;
import com.maverick.ssh2.Ssh2Client;
import com.maverick.ssh2.Ssh2Context;
import com.maverick.ssh2.TransportProtocolListener;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class TransportProtocol
implements SshMessageReader {
    public static String CHARSET_ENCODING = "UTF8";
    DataInputStream hb;
    OutputStream ac;
    SshTransport kb;
    Ssh2Context pb;
    Ssh2Client ec;
    String yb;
    String qb;
    byte[] kc;
    byte[] ab;
    byte[] mc;
    public static final int NEGOTIATING_PROTOCOL = 1;
    public static final int PERFORMING_KEYEXCHANGE = 2;
    public static final int CONNECTED = 3;
    public static final int DISCONNECTED = 4;
    int ob;
    Throwable w;
    String bb;
    SshKeyExchangeClient lc;
    SshKeyExchangeClient fb;
    SshCipher bc;
    SshCipher wb;
    SshHmac eb;
    SshHmac sb;
    SshCompression jc;
    SshCompression mb;
    SshPublicKey y;
    boolean jb = false;
    boolean gc = false;
    int v = 8;
    int gb = 0;
    boolean lb = false;
    byte[] z;
    ByteArrayWriter ib;
    int ub = 8;
    int ic = 0;
    long dc = 0L;
    long hc = 0L;
    int db;
    int xb;
    int vb;
    int tb;
    long fc = 0L;
    long cb = 0L;
    Object rb = new Object();
    Vector zb = new Vector();
    Vector x = new Vector();
    Vector cc = new Vector();
    long nb = System.currentTimeMillis();
    public static final int HOST_NOT_ALLOWED = 1;
    public static final int PROTOCOL_ERROR = 2;
    public static final int KEY_EXCHANGE_FAILED = 3;
    public static final int RESERVED = 4;
    public static final int MAC_ERROR = 5;
    public static final int COMPRESSION_ERROR = 6;
    public static final int SERVICE_NOT_AVAILABLE = 7;
    public static final int PROTOCOL_VERSION_NOT_SUPPORTED = 8;
    public static final int HOST_KEY_NOT_VERIFIABLE = 9;
    public static final int CONNECTION_LOST = 10;
    public static final int BY_APPLICATION = 11;
    public static final int TOO_MANY_CONNECTIONS = 12;
    public static final int AUTH_CANCELLED_BY_USER = 13;
    public static final int NO_MORE_AUTH_METHODS_AVAILABLE = 14;
    public static final int ILLEGAL_USER_NAME = 15;

    public SshTransport getProvider() {
        return this.kb;
    }

    public void addListener(TransportProtocolListener transportProtocolListener) {
        this.cc.addElement(transportProtocolListener);
    }

    public Ssh2Client getClient() {
        return this.ec;
    }

    public boolean isConnected() {
        return this.ob == 3 || this.ob == 2;
    }

    public Throwable getLastError() {
        return this.w;
    }

    public Ssh2Context getContext() {
        return this.pb;
    }

    public boolean getIgnoreHostKeyifEmpty() {
        return this.lb;
    }

    public void setIgnoreHostKeyifEmpty(boolean bl) {
        this.lb = bl;
    }

    public void startTransportProtocol(SshTransport sshTransport, Ssh2Context ssh2Context, String string, String string2, Ssh2Client ssh2Client) throws SshException {
        try {
            this.hb = new DataInputStream(sshTransport.getInputStream());
            this.ac = sshTransport.getOutputStream();
            this.kb = sshTransport;
            this.yb = string;
            this.qb = string2;
            this.pb = ssh2Context;
            this.z = new byte[this.pb.getMaximumPacketLength()];
            this.ib = new ByteArrayWriter(this.pb.getMaximumPacketLength());
            this.ec = ssh2Client;
            if (ssh2Context.getSocketTimeout() > 0 && sshTransport instanceof SocketTimeoutSupport) {
                ((SocketTimeoutSupport)((Object)sshTransport)).setSoTimeout(ssh2Context.getSocketTimeout());
            } else if (ssh2Context.getSocketTimeout() > 0) {
                EventLog.LogEvent(this, "Socket timeout is set on SshContext but SshTransport does not support socket timeouts");
            }
            this.ob = 1;
            this.b(false);
            EventLog.LogEvent(this, "Waiting for transport protocol to complete initialization");
            while (this.processMessage(this.j()) && this.ob != 3) {
            }
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 10);
        }
        EventLog.LogEvent(this, "Transport protocol initialized");
    }

    public String getRemoteIdentification() {
        return this.qb;
    }

    public byte[] getSessionIdentifier() {
        return this.mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(int n, String string) {
        try {
            this.bb = string;
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(1);
            byteArrayWriter.writeInt(n);
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeString("");
            EventLog.LogDebugEvent(this, "Sending SSH_MSG_DISCONNECT");
            this.sendMessage(byteArrayWriter.toByteArray(), true);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.k();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] byArray, boolean bl) throws SshException {
        Object object = this.zb;
        synchronized (object) {
            if (this.ob == 2 && !this.d(byArray[0])) {
                this.zb.addElement(byArray);
                return;
            }
        }
        EventLog.LogDebugEvent(this, "Sending transport protocol message");
        object = this.ac;
        synchronized (object) {
            try {
                this.ib.reset();
                int n = 4;
                if (this.jc != null && this.gc) {
                    byArray = this.jc.compress(byArray, 0, byArray.length);
                }
                n += (this.v - (byArray.length + 5 + n) % this.v) % this.v;
                this.ib.writeInt(byArray.length + 1 + n);
                this.ib.write(n);
                this.ib.write(byArray, 0, byArray.length);
                ComponentManager.getInstance().getRND().nextBytes(this.ib.array(), this.ib.size(), n);
                this.ib.move(n);
                if (this.eb != null) {
                    this.eb.generate(this.dc, this.ib.array(), 0, this.ib.size(), this.ib.array(), this.ib.size());
                }
                if (this.bc != null) {
                    this.bc.transform(this.ib.array(), 0, this.ib.array(), 0, this.ib.size());
                }
                this.ib.move(this.gb);
                this.fc += (long)this.ib.size();
                this.ac.write(this.ib.array(), 0, this.ib.size());
                this.ac.flush();
                if (bl) {
                    this.nb = System.currentTimeMillis();
                }
                EventLog.LogDebugEvent(this, "Sent " + this.ib.size() + " bytes of transport data outgoingSequence=" + this.dc + " totalBytesSinceKEX=" + this.vb);
                ++this.dc;
                this.vb += byArray.length;
                ++this.tb;
                if (this.dc >= 0x100000000L) {
                    this.dc = 0L;
                }
                if (!(this.pb.isKeyReExchangeDisabled() || this.vb < 0x40000000 && this.tb < Integer.MAX_VALUE)) {
                    EventLog.LogDebugEvent(this, "Requesting key re-exchange");
                    this.b(false);
                }
            }
            catch (IOException iOException) {
                this.k();
                throw new SshException("Unexpected termination: " + iOException.getMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] nextMessage() throws SshException {
        EventLog.LogEvent(this, "transport next message");
        Object object = this.rb;
        synchronized (object) {
            byte[] byArray;
            while (this.processMessage(byArray = this.j())) {
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void b(byte[] byArray, int n, int n2, int n3, boolean bl) throws SshException {
        int n4 = 0;
        int n5 = 0;
        if (bl) {
            n5 = this.c(this.pb.getPartialMessageTimeout());
        }
        try {
            do {
                try {
                    int n6 = this.hb.read(byArray, n + n4, n2 - n4);
                    if (n6 == -1) {
                        throw new SshException("EOF received from remote side", 1);
                    }
                    n4 += n6;
                }
                catch (InterruptedIOException interruptedIOException) {
                    Object object;
                    EventLog.LogEvent(this, "Socket timed out during read!  isPartialMessage=" + bl + " bytesTransfered=" + interruptedIOException.bytesTransferred);
                    if (bl && interruptedIOException.bytesTransferred > 0) {
                        n4 += interruptedIOException.bytesTransferred;
                        continue;
                    }
                    if (bl) {
                        this.k();
                        throw new SshException("Remote host failed to respond during message receive!", 19);
                    }
                    if (this.getContext().getIdleConnectionTimeoutSeconds() > 0 && System.currentTimeMillis() - this.nb > (long)(this.getContext().getIdleConnectionTimeoutSeconds() * 1000)) {
                        EventLog.LogEvent(this, "Connection is idle, disconnecting idleMax=" + this.getContext().getIdleConnectionTimeoutSeconds());
                        this.disconnect(11, "Idle connection");
                        throw new SshException("Connection has been dropped as it reached max idle time of " + this.getContext().getIdleConnectionTimeoutSeconds() + " seconds.", 12);
                    }
                    if (this.getContext().isSendIgnorePacketOnIdle()) {
                        try {
                            EventLog.LogEvent(this, "Sending SSH_MSG_IGNORE");
                            object = new ByteArrayWriter();
                            ((ByteArrayOutputStream)object).write(2);
                            int n7 = (int)(Math.random() * (double)this.getContext().getKeepAliveMaxDataLength() + 1.0);
                            byte[] byArray2 = new byte[n7];
                            ComponentManager.getInstance().getRND().nextBytes(byArray2);
                            ((ByteArrayWriter)object).writeBinaryString(byArray2);
                            this.sendMessage(((ByteArrayOutputStream)object).toByteArray(), false);
                        }
                        catch (IOException iOException) {
                            this.b("Connection failed during SSH_MSG_IGNORE packet", 10);
                        }
                    }
                    if (this.getContext().getSocketTimeout() > 0) {
                        object = this.cc.elements();
                        while (object.hasMoreElements()) {
                            TransportProtocolListener transportProtocolListener = (TransportProtocolListener)object.nextElement();
                            try {
                                transportProtocolListener.onIdle(this.nb);
                            }
                            catch (Throwable throwable) {}
                        }
                        continue;
                    }
                    throw new SshException("Socket connection timed out.", 19);
                }
                catch (IOException iOException) {
                    throw new SshException("IO error received from remote" + iOException.getMessage(), 1, iOException);
                }
            } while (n4 < n2);
        }
        finally {
            if (bl) {
                this.c(n5);
            }
        }
    }

    private int c(int n) {
        if (this.kb instanceof SocketTimeoutSupport) {
            try {
                SocketTimeoutSupport socketTimeoutSupport = (SocketTimeoutSupport)((Object)this.kb);
                int n2 = socketTimeoutSupport.getSoTimeout();
                socketTimeoutSupport.setSoTimeout(n);
                return n2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    byte[] j() throws SshException {
        EventLog.LogEvent(this, "transport read message");
        Object object = this.rb;
        synchronized (object) {
            try {
                byte[] byArray;
                int n;
                EventLog.LogEvent(this, "Waiting for transport message");
                this.b(this.z, 0, this.ub, this.pb.getPartialMessageTimeout(), false);
                if (this.wb != null) {
                    this.wb.transform(this.z, 0, this.z, 0, this.ub);
                }
                if ((n = (int)ByteArrayReader.readInt(this.z, 0)) <= 0) {
                    throw new SshException("Server sent invalid message length of " + n + "!", 3);
                }
                int n2 = this.z[4] & 0xFF;
                int n3 = n - (this.ub - 4);
                EventLog.LogEvent(this, "Incoming transport message msglen=" + n + " padlen=" + n2);
                if (n3 < 0) {
                    this.k();
                    throw new SshException("EOF whilst reading message data block", 1);
                }
                if (n3 > this.z.length - this.ub) {
                    if (n3 + this.ub + this.ic > this.pb.getMaximumPacketLength()) {
                        this.k();
                        throw new SshException("Incoming packet length violates SSH protocol [" + n3 + this.ub + " bytes]", 1);
                    }
                    byArray = new byte[n3 + this.ub + this.ic];
                    System.arraycopy(this.z, 0, byArray, 0, this.ub);
                    this.z = byArray;
                }
                if (n3 > 0) {
                    this.b(this.z, this.ub, n3, this.pb.getPartialMessageTimeout(), true);
                    if (this.wb != null) {
                        this.wb.transform(this.z, this.ub, this.z, this.ub, n3);
                    }
                }
                if (this.sb != null) {
                    this.b(this.z, this.ub + n3, this.ic, this.pb.getPartialMessageTimeout(), true);
                    if (!this.sb.verify(this.hc, this.z, 0, this.ub + n3, this.z, this.ub + n3)) {
                        this.disconnect(5, "Corrupt Mac on input");
                        throw new SshException("Corrupt Mac on input", 3);
                    }
                }
                if (++this.hc >= 0x100000000L) {
                    this.hc = 0L;
                }
                this.cb += (long)(this.ub + n3 + this.ic);
                byArray = new byte[n + 4 - n2 - 5];
                System.arraycopy(this.z, 5, byArray, 0, byArray.length);
                if (this.mb != null && this.jb) {
                    return this.mb.uncompress(byArray, 0, byArray.length);
                }
                this.db += byArray.length;
                ++this.xb;
                if (!(this.pb.isKeyReExchangeDisabled() || this.db < 0x40000000 && this.xb < Integer.MAX_VALUE)) {
                    this.b(false);
                }
                EventLog.LogDebugEvent(this, "Completed incoming transport message");
                return byArray;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new SshException("Interrupted IO; possible socket timeout detected?", 19);
            }
            catch (IOException iOException) {
                this.k();
                throw new SshException("Unexpected terminaton: " + (iOException.getMessage() != null ? iOException.getMessage() : iOException.getClass().getName()) + " sequenceNo = " + this.hc + " bytesIn = " + this.cb + " bytesOut = " + this.fc, 1, iOException);
            }
        }
    }

    public SshKeyExchangeClient getKeyExchange() {
        return this.lc;
    }

    public static boolean Arrayequals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n = byArray.length;
        if (byArray2.length != n) {
            return false;
        }
        for (int k = 0; k < n; ++k) {
            if (byArray[k] == byArray2[k]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void e(byte[] byArray) throws SshException {
        try {
            Object object = this.rb;
            synchronized (object) {
                String string;
                if (this.kc == null) {
                    this.b(false);
                }
                this.ob = 2;
                this.ab = byArray;
                ByteArrayReader byteArrayReader = new ByteArrayReader(this.ab, 0, this.ab.length);
                byteArrayReader.skip(17L);
                String string2 = this.b("key exchange", byteArrayReader.readString());
                String string3 = this.b("public key", byteArrayReader.readString());
                String string4 = this.b("client->server cipher", byteArrayReader.readString());
                String string5 = this.b("server->client cipher", byteArrayReader.readString());
                String string6 = this.b("client->server mac", byteArrayReader.readString());
                String string7 = this.b("server->client mac", byteArrayReader.readString());
                String string8 = this.b("client->server comp", byteArrayReader.readString());
                String string9 = this.b("server->client comp", byteArrayReader.readString());
                String string10 = byteArrayReader.readString();
                String string11 = byteArrayReader.readString();
                boolean bl = byteArrayReader.readBoolean();
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 3, true).addAttribute("REMOTE_KEY_EXCHANGES", string2).addAttribute("LOCAL_KEY_EXCHANGES", this.pb.supportedKeyExchanges().list(this.pb.getPreferredKeyExchange())).addAttribute("REMOTE_PUBLICKEYS", string3).addAttribute("LOCAL_PUBLICKEYS", this.pb.supportedPublicKeys().list(this.pb.getPreferredPublicKey())).addAttribute("REMOTE_CIPHERS_CS", string4).addAttribute("LOCAL_CIPHERS_CS", this.pb.supportedCiphersCS().list(this.pb.getPreferredCipherCS())).addAttribute("REMOTE_CIPHERS_SC", string5).addAttribute("LOCAL_CIPHERS_SC", this.pb.supportedCiphersSC().list(this.pb.getPreferredCipherSC())).addAttribute("REMOTE_CS_MACS", string6).addAttribute("LOCAL_CS_MACS", this.pb.supportedMacsCS().list(this.pb.getPreferredMacCS())).addAttribute("REMOTE_SC_MACS", string7).addAttribute("LOCAL_SC_MACS", this.pb.supportedMacsSC().list(this.pb.getPreferredMacSC())).addAttribute("REMOTE_CS_COMPRESSIONS", string8).addAttribute("LOCAL_CS_COMPRESSIONS", this.pb.supportedCompressionsCS().list(this.pb.getPreferredCompressionCS())).addAttribute("REMOTE_SC_COMPRESSIONS", string9).addAttribute("LOCAL_SC_COMPRESSIONS", this.pb.supportedCompressionsSC().list(this.pb.getPreferredCompressionSC())));
                EventLog.LogDebugEvent(this, "Remote computer supports key exchanges: " + string2);
                EventLog.LogDebugEvent(this, "Remote computer supports public keys: " + string3);
                EventLog.LogDebugEvent(this, "Remote computer supports client->server ciphers: " + string4);
                String string12 = this.c(this.pb.supportedCiphersCS().list(this.pb.getPreferredCipherCS()), string4);
                EventLog.LogDebugEvent(this, "Negotiated client->server cipher: " + string12);
                EventLog.LogDebugEvent(this, "Remote computer supports client->server ciphers: " + string4);
                String string13 = this.c(this.pb.supportedCiphersSC().list(this.pb.getPreferredCipherSC()), string5);
                EventLog.LogDebugEvent(this, "Negotiated server->client cipher: " + string13);
                SshCipher sshCipher = (SshCipher)this.pb.supportedCiphersCS().getInstance(string12);
                SshCipher sshCipher2 = (SshCipher)this.pb.supportedCiphersSC().getInstance(string13);
                String string14 = this.c(this.pb.supportedMacsCS().list(this.pb.getPreferredMacCS()), this.b("client->server hmac", string6));
                String string15 = this.c(this.pb.supportedMacsSC().list(this.pb.getPreferredMacSC()), this.b("server->client hmac", string7));
                SshHmac sshHmac = (SshHmac)this.pb.supportedMacsCS().getInstance(string14);
                SshHmac sshHmac2 = (SshHmac)this.pb.supportedMacsSC().getInstance(string15);
                String string16 = this.c(this.pb.supportedCompressionsCS().list(this.pb.getPreferredCompressionCS()), this.b("client->server compression", string8));
                String string17 = this.c(this.pb.supportedCompressionsSC().list(this.pb.getPreferredCompressionSC()), this.b("server->client compression", string9));
                SshCompression sshCompression = null;
                if (!string16.equals("none")) {
                    sshCompression = (SshCompression)this.pb.supportedCompressionsCS().getInstance(string16);
                    sshCompression.init(1, 6);
                }
                SshCompression sshCompression2 = null;
                if (!string17.equals("none")) {
                    sshCompression2 = (SshCompression)this.pb.supportedCompressionsSC().getInstance(string17);
                    sshCompression2.init(0, 6);
                }
                boolean bl2 = false;
                String string18 = this.c(this.pb.supportedKeyExchanges().list(this.pb.getPreferredKeyExchange()), string2);
                if (this.fb == null || !string18.equals(this.fb.getAlgorithm())) {
                    this.lc = (SshKeyExchangeClient)this.pb.supportedKeyExchanges().getInstance(string18);
                }
                EventLog.LogDebugEvent(this, "Negotiated key exchange: " + this.lc.getAlgorithm());
                if (bl) {
                    if (!string18.equals(this.pb.getPreferredKeyExchange())) {
                        bl2 = true;
                    }
                    string = this.c(this.pb.supportedPublicKeys().list(this.pb.getPreferredPublicKey()), string3);
                    if (!bl2 && !string.equals(this.pb.getPreferredPublicKey())) {
                        bl2 = true;
                    }
                }
                this.lc.init(this, bl2);
                this.lc.performClientExchange(this.yb, this.qb, this.kc, this.ab);
                string = this.c(this.pb.supportedPublicKeys().list(this.pb.getPreferredPublicKey()), string3);
                this.y = (SshPublicKey)this.pb.supportedPublicKeys().getInstance(string);
                if (!this.lb || !TransportProtocol.Arrayequals(this.lc.getHostKey(), "".getBytes())) {
                    EventServiceImplementation.getInstance().fireEvent(new Event(this, 0, true).addAttribute("HOST_KEY", new String(this.lc.getHostKey())));
                    this.y.init(this.lc.getHostKey(), 0, this.lc.getHostKey().length);
                    if (this.pb.getHostKeyVerification() != null) {
                        if (!this.pb.getHostKeyVerification().verifyHost(this.kb.getHost(), this.y)) {
                            EventServiceImplementation.getInstance().fireEvent(new Event(this, 1, false));
                            this.disconnect(9, "Host key not accepted");
                            throw new SshException("The host key was not accepted", 8);
                        }
                        if (!this.y.verifySignature(this.lc.getSignature(), this.lc.getExchangeHash())) {
                            EventServiceImplementation.getInstance().fireEvent(new Event(this, 1, false));
                            this.disconnect(9, "Invalid host key signature");
                            throw new SshException("The host key signature is invalid", 3);
                        }
                        EventServiceImplementation.getInstance().fireEvent(new Event(this, 2, true));
                    }
                }
                if (this.mc == null) {
                    this.mc = this.lc.getExchangeHash();
                }
                this.sendMessage(new byte[]{21}, true);
                sshCipher.init(0, this.b('A'), this.b('C'));
                this.v = sshCipher.getBlockSize();
                sshHmac.init(this.b('E'));
                this.gb = sshHmac.getMacLength();
                this.bc = sshCipher;
                this.eb = sshHmac;
                this.jc = sshCompression;
                do {
                    if (this.processMessage(byArray = this.j())) continue;
                    EventServiceImplementation.getInstance().fireEvent(new Event(this, 4, true));
                    this.disconnect(2, "Invalid message received");
                    throw new SshException("Invalid message received during key exchange", 3);
                } while (byArray[0] != 21);
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 5, true).addAttribute("USING_PUBLICKEY", string).addAttribute("USING_KEY_EXCHANGE", string18).addAttribute("USING_CS_CIPHER", string12).addAttribute("USING_SC_CIPHERC", string13).addAttribute("USING_CS_MAC", string14).addAttribute("USING_SC_MAC", string15).addAttribute("USING_CS_COMPRESSION", string16).addAttribute("USING_SC_COMPRESSION", string17));
                sshCipher2.init(1, this.b('B'), this.b('D'));
                this.ub = sshCipher2.getBlockSize();
                sshHmac2.init(this.b('F'));
                this.ic = sshHmac2.getMacLength();
                this.wb = sshCipher2;
                this.sb = sshHmac2;
                this.mb = sshCompression2;
                if (sshCompression2 != null && !sshCompression2.getAlgorithm().equals("zlib@openssh.com")) {
                    this.jb = true;
                }
                if (sshCompression != null && !sshCompression.getAlgorithm().equals("zlib@openssh.com")) {
                    this.gc = true;
                }
                Vector vector = this.zb;
                synchronized (vector) {
                    this.ob = 3;
                    Enumeration enumeration = this.zb.elements();
                    while (enumeration.hasMoreElements()) {
                        this.sendMessage((byte[])enumeration.nextElement(), true);
                    }
                    this.zb.removeAllElements();
                }
                this.kc = null;
                this.ab = null;
            }
        }
        catch (IOException iOException) {
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 4, true));
            throw new SshException(iOException, 5);
        }
        catch (SshException sshException) {
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 4, true));
            throw sshException;
        }
    }

    void i() {
        if (this.mb != null && this.mb.getAlgorithm().equals("zlib@openssh.com")) {
            this.jb = true;
        }
        if (this.jc != null && this.jc.getAlgorithm().equals("zlib@openssh.com")) {
            this.gc = true;
        }
    }

    public void startService(String string) throws SshException {
        try {
            byte[] byArray;
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(5);
            byteArrayWriter.writeString(string);
            EventLog.LogEvent(this, "Sending SSH_MSG_SERVICE_REQUEST");
            this.sendMessage(byteArrayWriter.toByteArray(), true);
            while (this.processMessage(byArray = this.j()) || byArray[0] != 6) {
            }
            EventLog.LogEvent(this, "Received SSH_MSG_SERVICE_ACCEPT");
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    void b(String string, int n) {
        this.ob = 4;
        try {
            this.kb.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Enumeration enumeration = this.cc.elements();
        while (enumeration.hasMoreElements()) {
            TransportProtocolListener transportProtocolListener = (TransportProtocolListener)enumeration.nextElement();
            try {
                transportProtocolListener.onDisconnect(string, n);
            }
            catch (Throwable throwable) {}
        }
        for (int k = 0; k < this.x.size(); ++k) {
            try {
                ((Runnable)this.x.elementAt(k)).run();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void k() {
        this.ob = 4;
        try {
            this.kb.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int k = 0; k < this.x.size(); ++k) {
            try {
                ((Runnable)this.x.elementAt(k)).run();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void b(Runnable runnable) {
        if (runnable != null) {
            this.x.addElement(runnable);
        }
    }

    public boolean processMessage(byte[] byArray) throws SshException {
        try {
            if (byArray.length < 1) {
                this.disconnect(2, "Invalid message received");
                throw new SshException("Invalid transport protocol message", 5);
            }
            switch (byArray[0]) {
                case 1: {
                    EventLog.LogEvent(this, "Received SSH_MSG_DISCONNECT");
                    this.k();
                    ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, 5, byArray.length - 5);
                    EventServiceImplementation.getInstance().fireEvent(new Event(this, 21, true));
                    throw new SshException(byteArrayReader.readString(), 2);
                }
                case 2: {
                    EventLog.LogEvent(this, "Received SSH_MSG_IGNORE");
                    return true;
                }
                case 4: {
                    this.nb = System.currentTimeMillis();
                    EventLog.LogEvent(this, "Received SSH_MSG_DEBUG");
                    return true;
                }
                case 21: {
                    this.nb = System.currentTimeMillis();
                    EventLog.LogEvent(this, "Received SSH_MSG_NEWKEYS");
                    return true;
                }
                case 20: {
                    this.nb = System.currentTimeMillis();
                    EventLog.LogEvent(this, "Received SSH_MSG_KEX_INIT");
                    if (this.ab != null) {
                        this.disconnect(2, "Key exchange already in progress!");
                        throw new SshException("Key exchange already in progress!", 3);
                    }
                    this.e(byArray);
                    return true;
                }
            }
            this.nb = System.currentTimeMillis();
            return false;
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 5);
        }
    }

    boolean d(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 20: 
            case 21: {
                return true;
            }
        }
        if (this.lc != null) {
            return this.lc.isKeyExchangeMessage(n);
        }
        return false;
    }

    String c(String string, String string2) throws SshException {
        int n;
        String string3 = string2;
        String string4 = string;
        Vector<String> vector = new Vector<String>();
        while ((n = string3.indexOf(",")) > -1) {
            vector.addElement(string3.substring(0, n).trim());
            string3 = string3.substring(n + 1).trim();
        }
        vector.addElement(string3.trim());
        while ((n = string4.indexOf(",")) > -1) {
            String string5 = string4.substring(0, n).trim();
            if (vector.contains(string5)) {
                return string5;
            }
            string4 = string4.substring(n + 1).trim();
        }
        if (vector.contains(string4)) {
            return string4;
        }
        EventServiceImplementation.getInstance().fireEvent(new Event(this, 32, true).addAttribute("LOCAL_COMPONENT_LIST", string).addAttribute("REMOTE_COMPONENT_LIST", string2));
        throw new SshException("Failed to negotiate a transport component [" + string + "] [" + string2 + "]", 9);
    }

    void b(boolean bl) throws SshException {
        try {
            this.db = 0;
            this.xb = 0;
            this.vb = 0;
            this.tb = 0;
            this.ob = 2;
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byte[] byArray = new byte[16];
            ComponentManager.getInstance().getRND().nextBytes(byArray);
            byteArrayWriter.write(20);
            byteArrayWriter.write(byArray);
            byteArrayWriter.writeString(this.pb.supportedKeyExchanges().list(this.pb.getPreferredKeyExchange()));
            byteArrayWriter.writeString(this.pb.supportedPublicKeys().list(this.pb.getPreferredPublicKey()));
            byteArrayWriter.writeString(this.pb.supportedCiphersCS().list(this.pb.getPreferredCipherCS()));
            byteArrayWriter.writeString(this.pb.supportedCiphersSC().list(this.pb.getPreferredCipherSC()));
            byteArrayWriter.writeString(this.pb.supportedMacsCS().list(this.pb.getPreferredMacCS()));
            byteArrayWriter.writeString(this.pb.supportedMacsSC().list(this.pb.getPreferredMacSC()));
            byteArrayWriter.writeString(this.pb.supportedCompressionsCS().list(this.pb.getPreferredCompressionCS()));
            byteArrayWriter.writeString(this.pb.supportedCompressionsSC().list(this.pb.getPreferredCompressionSC()));
            byteArrayWriter.writeString("");
            byteArrayWriter.writeString("");
            byteArrayWriter.writeBoolean(bl);
            byteArrayWriter.writeInt(0);
            EventLog.LogEvent(this, "Sending SSH_MSG_KEX_INIT");
            this.kc = byteArrayWriter.toByteArray();
            this.sendMessage(this.kc, true);
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    byte[] b(char c2) throws IOException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byte[] byArray = new byte[20];
            Digest digest = (Digest)ComponentManager.getInstance().supportedDigests().getInstance(this.lc.getHashAlgorithm());
            digest.putBigInteger(this.lc.getSecret());
            digest.putBytes(this.lc.getExchangeHash());
            digest.putByte((byte)c2);
            digest.putBytes(this.mc);
            byArray = digest.doFinal();
            byteArrayWriter.write(byArray);
            digest.reset();
            digest.putBigInteger(this.lc.getSecret());
            digest.putBytes(this.lc.getExchangeHash());
            digest.putBytes(byArray);
            byArray = digest.doFinal();
            byteArrayWriter.write(byArray);
            return byteArrayWriter.toByteArray();
        }
        catch (SshException sshException) {
            throw new SshIOException(sshException);
        }
    }

    private String b(String string, String string2) throws IOException {
        if (string2.trim().equals("")) {
            throw new IOException("Server sent invalid " + string + " value '" + string2 + "'");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        if (!stringTokenizer.hasMoreElements()) {
            throw new IOException("Server sent invalid " + string + " value '" + string2 + "'");
        }
        return string2;
    }
}

