/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.net;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class HttpHeader {
    protected static final String white_SPACE = " \t\r";
    Hashtable b = new Hashtable();
    protected String begin;

    protected HttpHeader() {
    }

    protected String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = inputStream.read()) == -1) {
                throw new IOException("Failed to read expected HTTP header line");
            }
            if (n == 10) continue;
            if (n == 13) break;
            stringBuffer.append((char)n);
        }
        return new String(stringBuffer);
    }

    public String getStartLine() {
        return this.begin;
    }

    public Hashtable getHeaderFields() {
        return this.b;
    }

    public Enumeration getHeaderFieldNames() {
        return this.b.keys();
    }

    public String getHeaderField(String string) {
        Enumeration enumeration = this.b.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return (String)this.b.get(string2);
        }
        return null;
    }

    public void setHeaderField(String string, String string2) {
        this.b.put(string, string2);
    }

    public String toString() {
        String string = this.begin + "\r\n";
        Enumeration enumeration = this.getHeaderFieldNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + string2 + ": " + this.getHeaderField(string2) + "\r\n";
        }
        string = string + "\r\n";
        return string;
    }

    protected void processHeaderFields(InputStream inputStream) throws IOException {
        int n;
        this.b = new Hashtable();
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        while (true) {
            if ((n = inputStream.read()) == -1) {
                throw new IOException("EOF returned from server but HTTP response is not complete!");
            }
            if (n == 10) continue;
            if (n != 13) {
                stringBuffer.append((char)n);
                continue;
            }
            if (stringBuffer.length() == 0) break;
            String string2 = stringBuffer.toString();
            string = this.b(string2, string);
            stringBuffer.setLength(0);
        }
        n = inputStream.read();
    }

    private String b(String string, String string2) throws IOException {
        String string3;
        String string4;
        char c2 = string.charAt(0);
        if (c2 == ' ' || c2 == '\t') {
            string4 = string2;
            string3 = this.getHeaderField(string2) + " " + string.trim();
        } else {
            int n = string.indexOf(58);
            if (n == -1) {
                throw new IOException("HTTP Header encoutered a corrupt field: '" + string + "'");
            }
            string4 = string.substring(0, n).toLowerCase();
            string3 = string.substring(n + 1).trim();
        }
        this.setHeaderField(string4, string3);
        return string4;
    }
}

