/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import se.ericsson.cello.neal.JarVersionError;
import se.ericsson.cello.neal.NealRuntimeException;

public abstract class JarVersionInfo {
    public static final String JAVA_VERSION = System.getProperty("java.version", "(??Unknown java.version)");
    public static final String JAVA_CLASS_VERSION = JAVA_VERSION + ", class version " + System.getProperty("java.class.version", "(??Unknown java.class.version)");
    private String jarName;
    private final Class requiredClass;
    private final ClassLoader loader;

    protected JarVersionInfo(String string, String string2, ClassLoader classLoader) {
        this.jarName = string;
        this.loader = classLoader;
        this.requiredClass = string2 == null ? null : this.tryGetClass(string2);
        if (this.requiredClass != null) {
            this.jarName = JarVersionInfo.getJar(this.requiredClass);
        }
    }

    public void setJarName(String string) {
        if (string != null) {
            this.jarName = string;
        }
    }

    public String getJarName() {
        return this.jarName;
    }

    public boolean isJarOnClasspath() {
        return this.getRequiredClass() != null;
    }

    public abstract String getJarVersion();

    public String whatJar() {
        String string = this.getJarVersion();
        return this.getJarName() + (string == null ? "" : " " + string);
    }

    public Class getRequiredClass() {
        return this.requiredClass;
    }

    private Class innerGetClass(String string) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string, false, this.loader);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            throw new JarVersionError(null, "Is current jvm " + JAVA_CLASS_VERSION + " too old for file " + this.whatJar() + " on classpath?" + "\n   Failed loading existing class " + string + "!", unsupportedClassVersionError);
        }
        catch (LinkageError linkageError) {
            throw new JarVersionError(this, "Failed loading class " + string + "!", linkageError);
        }
        catch (Throwable throwable) {
            throw new JarVersionError(this, "Failed loading class " + string + "!", throwable);
        }
    }

    public Class tryGetClass(String string) {
        try {
            return this.innerGetClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Class getClass(String string) {
        try {
            return this.innerGetClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JarVersionError(null, "Didn't find " + string + "!\n   Expected in " + this.whatJar(), classNotFoundException);
        }
    }

    public Class getClass(String string, String string2) {
        Class clazz = this.tryGetClass(string);
        Class clazz2 = this.tryGetClass(string2);
        if (clazz != null) {
            return clazz;
        }
        if (clazz2 != null) {
            return clazz2;
        }
        throw new JarVersionError(null, "Didn't find neither " + string + "\n   nor " + string2 + "!\n   Expected in " + this.whatJar());
    }

    public Constructor getConstructor(Class clazz, Class[] classArray) {
        try {
            return clazz.getConstructor(classArray);
        }
        catch (Exception exception) {
            throw new JarVersionError(this, "Didn't find " + classArray.length + " parameter constructor in class " + clazz.getName() + "!", exception);
        }
    }

    public Method getMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            throw new JarVersionError(this, "Didn't find Method " + string + " in class " + clazz.getName() + "!", exception);
        }
    }

    public Method tryGetMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Field getField(Class clazz, String string) {
        try {
            return clazz.getField(string);
        }
        catch (Exception exception) {
            throw new JarVersionError(this, "Didn't find field " + string + " in class " + clazz.getName() + "!", exception);
        }
    }

    public Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JarVersionError(this, "Unable to call constructor " + clazz.getName() + "<init>()!", exception);
        }
    }

    public Object newInstance(Constructor constructor, Object[] objectArray) {
        try {
            return constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new NealRuntimeException("Failed invoking constructor " + constructor.getName(), invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new JarVersionError(null, "INTERNAL, JAR VERSION RELLATED ERROR when invoking constructor " + constructor + "\n   in " + this.whatJar() + "!", exception);
        }
    }

    public Object invoke(Method method, Object object, Object[] objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new NealRuntimeException("Failed invoking " + method.getName(), invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new JarVersionError(null, "INTERNAL, JAR VERSION RELLATED ERROR when invoking method " + method + "\n   in " + this.whatJar() + "!", exception);
        }
    }

    public Object getFieldValue(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JarVersionError(null, "Failed geting field value from field " + field + "\n   in Object of class=" + object.getClass().getName() + "\n   in " + this.whatJar() + "!", illegalAccessException);
        }
    }

    public static String getShortName(Class clazz) {
        int n = clazz.getName().lastIndexOf(46);
        String string = clazz.getName().substring(n + 1);
        return string;
    }

    public static URL getUrl(Class clazz) {
        URL uRL = null;
        try {
            uRL = clazz.getResource(JarVersionInfo.getShortName(clazz) + ".class");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return uRL;
    }

    public static String getJar(Class clazz) {
        URL uRL = JarVersionInfo.getUrl(clazz);
        if (uRL == null) {
            return null;
        }
        String string = uRL.toString();
        int n = string.lastIndexOf(33);
        String string2 = n == -1 ? string : string.substring(0, n);
        return string2;
    }

    public String toString() {
        return this.whatJar();
    }
}

