/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.internal;

import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import se.ericsson.cello.neal.NealRuntimeException;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.PoaType;

public class NealPoa {
    private POA securePoa;
    private POA unsecurePoa;
    private POA currPoa;
    private PoaType currState = NOT_SECURE;
    protected static final PoaType SECURE = new PoaType(true);
    protected static final PoaType NOT_SECURE = new PoaType(false);

    public NealPoa(NealPoa nealPoa) {
        this.securePoa = nealPoa.securePoa;
        this.unsecurePoa = nealPoa.unsecurePoa;
        this.currPoa = nealPoa.currPoa;
        this.currState = nealPoa.currState;
    }

    public NealPoa(POA pOA, POA pOA2) {
        this.securePoa = pOA;
        this.unsecurePoa = pOA2;
        if (pOA2 == null && pOA != null) {
            this.currPoa = pOA;
            this.currState = SECURE;
        } else {
            this.currPoa = pOA2;
            this.currState = NOT_SECURE;
        }
    }

    public boolean isOrbSecure() {
        return this.securePoa != null;
    }

    protected void startPoa() {
        PoaType poaType = SECURE;
        try {
            if (this.securePoa != null) {
                this.securePoa.the_POAManager().activate();
            }
            if (this.unsecurePoa != null) {
                poaType = NOT_SECURE;
                this.unsecurePoa.the_POAManager().activate();
            }
        }
        catch (UserException userException) {
            throw new NealRuntimeException("NEAL Failed starting " + poaType + " POA!", userException);
        }
    }

    public void useSecure(boolean bl) {
        if (bl) {
            this.currPoa = this.securePoa;
            this.currState = SECURE;
        } else {
            this.currPoa = this.unsecurePoa;
            this.currState = NOT_SECURE;
        }
        if (this.currPoa == null) {
            NealLog.warning("No " + this.currState + " POA available. Will not be able to receive notifications from remote Node!");
        }
    }

    protected void connect(Servant servant) throws UserException {
        try {
            this.currPoa.activate_object(servant);
        }
        catch (Throwable throwable) {
            String string = "Failed to connect servant=" + servant + " to " + this.currState + " POA!";
            NealLog.warning(string, throwable);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof UserException) {
                throw (UserException)throwable;
            }
            throw new NealRuntimeException(string, throwable);
        }
    }

    protected void disconnect(Servant servant) {
        try {
            byte[] byArray = this.currPoa.servant_to_id(servant);
            this.currPoa.deactivate_object(byArray);
        }
        catch (Exception exception) {
            throw new NealRuntimeException("Failed disconnecting servant for " + this, exception);
        }
    }

    public void disconnect(Object object) {
        try {
            byte[] byArray = this.currPoa.reference_to_id(object);
            this.currPoa.deactivate_object(byArray);
        }
        catch (Exception exception) {
            throw new NealRuntimeException("Failed disconnecting CORBA Object from " + this, exception);
        }
    }

    protected Object servant_to_reference(Servant servant) {
        Object object = null;
        try {
            object = this.currPoa.servant_to_reference(servant);
        }
        catch (WrongPolicy wrongPolicy) {
            throw new NealRuntimeException("Failed making servant_to_reference of " + servant, wrongPolicy);
        }
        catch (ServantNotActive servantNotActive) {
            throw new NealRuntimeException("Failed making servant_to_reference of " + servant, servantNotActive);
        }
        return object;
    }

    protected Servant reference_to_servant(Object object) {
        Servant servant = null;
        try {
            servant = this.currPoa.reference_to_servant(object);
        }
        catch (Exception exception) {
            throw new NealRuntimeException("Failed converting reference_to_servant for obj=" + object, exception);
        }
        return servant;
    }
}

