/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.pm;

import CommonIRPConstDefs.Signal;
import PerformanceIRPConstDefs.Destination;
import PerformanceIRPConstDefs.FailureInformation;
import PerformanceIRPConstDefs.FailureInformationHolder;
import PerformanceIRPConstDefs.PerformanceMonitoring;
import PerformanceIRPConstDefs.PerformanceMonitoringListHolder;
import PerformanceIRPConstDefs.PerformanceMonitoringState;
import PerformanceIRPConstDefs.Schedule;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.OamService;
import se.ericsson.cello.neal.internal.ServiceContext;
import se.ericsson.cello.neal.internal.omsi_version.SheduleAdapter;
import se.ericsson.cello.neal.internal.omsi_version.UtcTAdapter;
import se.ericsson.cello.neal.pm.CelloPm;
import se.ericsson.cello.neal.pm.CelloPmExtended;
import se.ericsson.cello.neal.pm.Pm;
import se.ericsson.cello.neal.pm.PmAttributeContainer;
import se.ericsson.cello.neal.pm.PmAttributeContainerImpl;
import se.ericsson.cello.neal.pm.PmException;
import se.ericsson.cello.neal.pm.PmInfo;
import se.ericsson.cello.neal.pm.PmService;

class CelloPmService
implements PmService,
OamService {
    private ServiceContext serviceContext;
    private static final String EXT_IRP_VERSION = "2:3";

    CelloPmService() {
    }

    public void init(ServiceContext serviceContext) throws NotFound, CannotProceed, InvalidName {
        this.serviceContext = serviceContext;
    }

    public void free() {
        this.serviceContext = null;
    }

    public Pm createPm(String string, PmAttributeContainer pmAttributeContainer, boolean bl, int n) {
        return this.createPm(string, pmAttributeContainer, bl, n, false);
    }

    public Pm createPm(PmInfo pmInfo) {
        return this.createPm(pmInfo, false);
    }

    public Pm createGenericPm(String string, PmAttributeContainer pmAttributeContainer, boolean bl, int n) {
        return this.createPm(string, pmAttributeContainer, bl, n, true);
    }

    public Pm createGenericPm(PmInfo pmInfo) {
        return this.createPm(pmInfo, true);
    }

    private Pm createPm(String string, PmAttributeContainer pmAttributeContainer, boolean bl, int n, boolean bl2) {
        try {
            Signal signal;
            IntHolder intHolder = new IntHolder();
            Schedule schedule = this.createEmptySchedule();
            int n2 = n;
            FailureInformationHolder failureInformationHolder = new FailureInformationHolder();
            if (bl2) {
                if (null == this.serviceContext.getPerfMonExtOps()) {
                    NealLog.severe("Performance Monitoring extended not supported in this version");
                    throw new PmException("Generic Pm scanners not supported in this version");
                }
                NealLog.fine("Creating generic PM");
                signal = this.serviceContext.getPerfMonExtOps().create_generic_performance_monitoring(((PmAttributeContainerImpl)pmAttributeContainer).getObservationClasses(), ((PmAttributeContainerImpl)pmAttributeContainer).getObservationObjects(), n, schedule, n2, Destination.FILE, string, bl ? PerformanceMonitoringState.ACTIVE : PerformanceMonitoringState.SUSPENDED, intHolder, failureInformationHolder);
            } else {
                NealLog.fine("Creating legacy PM");
                signal = this.serviceContext.getPerfMonitorOps().create_performance_monitoring(((PmAttributeContainerImpl)pmAttributeContainer).getObservationClasses(), ((PmAttributeContainerImpl)pmAttributeContainer).getObservationObjects(), n, schedule, n2, Destination.FILE, string, bl ? PerformanceMonitoringState.ACTIVE : PerformanceMonitoringState.SUSPENDED, intHolder, failureInformationHolder);
            }
            if (signal != Signal.OK) {
                if (failureInformationHolder.value == FailureInformation.OBJECTCLASS_NOT_EXIST) {
                    throw new PmException("Object class doesn't exist");
                }
                if (failureInformationHolder.value == FailureInformation.OBJECT_NOT_EXIST) {
                    throw new PmException("Object instance doesn't exist");
                }
                if (bl2) {
                    throw new PmException("create_generic_performance_monitoring() returned NOT OK but failure information holder says NO FAILURE?!");
                }
                throw new PmException("create_performance_monitoring() returned NOT OK but failure information holder says NO FAILURE?!");
            }
            return this.createSupportedPm(intHolder.value);
        }
        catch (UserException userException) {
            throw new PmException(userException);
        }
    }

    private Pm createPm(PmInfo pmInfo, boolean bl) {
        if (bl) {
            return this.createGenericPm(pmInfo.getName(), pmInfo.getPmAttributeContainer(), pmInfo.isActive(), pmInfo.getGranularityPeriod());
        }
        return this.createPm(pmInfo.getName(), pmInfo.getPmAttributeContainer(), pmInfo.isActive(), pmInfo.getGranularityPeriod());
    }

    private Pm createSupportedPm(int n) {
        String[] stringArray = this.getIRPVersion();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!EXT_IRP_VERSION.equals(stringArray[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            NealLog.fine("Creating regular PM with ID = " + n);
            return new CelloPm(n, this.serviceContext.getPerfMonitorOps());
        }
        NealLog.fine("Creating extended PM with ID = " + n);
        return new CelloPmExtended(n, this.serviceContext.getPerfMonExtOps());
    }

    public Pm[] lookupAll() {
        try {
            String[] stringArray = new String[]{};
            PerformanceMonitoringListHolder performanceMonitoringListHolder = new PerformanceMonitoringListHolder();
            this.serviceContext.getPerfMonitorOps().list_performance_monitorings(stringArray, performanceMonitoringListHolder);
            PerformanceMonitoring[] performanceMonitoringArray = performanceMonitoringListHolder.value;
            Pm[] pmArray = new Pm[performanceMonitoringArray.length];
            for (int i = 0; i < performanceMonitoringArray.length; ++i) {
                pmArray[i] = this.createSupportedPm(performanceMonitoringArray[i].performance_monitoring_id);
            }
            return pmArray;
        }
        catch (UserException userException) {
            throw new PmException(userException);
        }
    }

    public Pm lookup(int n) {
        Pm[] pmArray = this.lookupAll();
        for (int i = 0; i < pmArray.length; ++i) {
            if (pmArray[i].getId() != n) continue;
            return pmArray[i];
        }
        return null;
    }

    public PmAttributeContainer createPmAttributeContainer() {
        return new PmAttributeContainerImpl();
    }

    private Schedule createEmptySchedule() {
        SheduleAdapter sheduleAdapter = new SheduleAdapter();
        int[] nArray = new int[]{0};
        sheduleAdapter.start_time = new UtcTAdapter();
        sheduleAdapter.end_time = new UtcTAdapter();
        sheduleAdapter.repeated_intervals = nArray;
        Schedule schedule = (Schedule)sheduleAdapter.toOmsi();
        return schedule;
    }

    public String[] getIRPVersion() {
        return this.serviceContext.getPerfIRPOps().get_performance_IRP_version();
    }
}

