/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pdhsdhtrans;

import se.ericsson.cello.common.fropxy.FroLockInd;
import se.ericsson.cello.common.fropxy.MoNotifiable;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroNotLockedException;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.pdhsdhtrans.AtmPortBuildIF;
import se.ericsson.cello.pdhsdhtrans.Ds0BundleBuildIF;
import se.ericsson.cello.pdhsdhtrans.ExchangeTerminalMoImpl;
import se.ericsson.cello.pdhsdhtrans.ImaLinkBuildIF;
import se.ericsson.cello.pdhsdhtrans.ImaReservable;
import se.ericsson.cello.pdhsdhtrans.PDHPhysPathTermInfo;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermConstants;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermRepositoryImpl;
import se.ericsson.cello.pdhsdhtrans.PhysValidator;
import se.ericsson.cello.pdhsdhtrans.T1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.TrafficReservable;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1MiAutoLockInd;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1MiCreateRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1MiDeleteRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1MiGetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1MiLockRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1MiSetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1MiShutDownRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1MiUnlockRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1Proxy;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.sync.PDHSyncReference;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.transaction.Coordinator;

public class T1PhysPathTermMoImpl
extends CelloMao
implements T1PhysPathTermMo,
PhysPathTermConstants,
MoNotifiable,
PDHPhysPathTermInfo,
TrafficReservable,
SyncReservable,
ImaReservable,
PDHSyncReference {
    private static final String T1PHY_PORT_FRO_ID = "t1PhyPortFroId";
    private static final Class[] reservedClassesForReserve = new Class[]{ImaLinkBuildIF.class};
    private static final Class[] reservedClassesForTrafficReserve = new Class[]{AtmPortBuildIF.class};
    private static PhyT1Proxy phyT1MiProxy = PhyT1Proxy.instance();
    private static PhysPathTermRepositoryImpl repository = PhysPathTermRepositoryImpl.instance();
    private MoData data;
    private StringAttribute userLabel;
    private ReferenceAttribute reservedByTraffic;
    private ReferenceAttribute reservedBySync;
    private ReferenceAttribute reservedByImaLink;
    private IntegerAttribute phyPortFroId;
    private static final int MO_DATA_REVISION_31 = 0;
    private static final int MO_DATA_REVISION_35 = 3500;
    private static final int MO_DATA_REVISION_LATEST = 3500;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"ExchangeTerminal");
        MoAttributeValidator.checkIdentity((String)"T1PhysPathTerm", (String)string);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"T1PhysPathTerm", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"lineNo", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)Integer.MAX_VALUE, (String)"T1PhysPathTerm");
        PhysValidator.checkPhysPath(managedObject, "T1PhysPathTerm", n, coordinator);
        T1PhysPathTermMoImpl.checkNumberOfPhysPaths();
        int n2 = T1PhysPathTermMoImpl.checkAndGetLoopback(attrList);
        int n3 = T1PhysPathTermMoImpl.checkAndGetAdministrativeState(attrList);
        boolean bl = T1PhysPathTermMoImpl.checkAndGetAisReporting(attrList);
        boolean bl2 = T1PhysPathTermMoImpl.checkAndGetRdiReporting(attrList);
        int n4 = T1PhysPathTermMoImpl.checkAndGetTransmissionMode(attrList);
        int n5 = T1PhysPathTermMoImpl.checkAndGetIdlePattern(attrList);
        int n6 = T1PhysPathTermMoImpl.checkAndGetShutDownTimeout(attrList);
        int n7 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"degDegThr", (AttrList)attrList, (boolean)false, (int)30, (int)0, (int)100, (String)"T1PhysPathTerm");
        int n8 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"degDegM", (AttrList)attrList, (boolean)false, (int)7, (int)2, (int)10, (String)"T1PhysPathTerm");
        T1PhysPathTermMoImpl.checkOtherAttributes(attrList);
        return new T1PhysPathTermMoImpl(managedObject, string, string2, n, n2, n3, bl, bl2, n4, n5, n6, n7, n8, coordinator);
    }

    private T1PhysPathTermMoImpl(ManagedObject managedObject, String string, String string2, int n, int n2, int n3, boolean bl, boolean bl2, int n4, int n5, int n6, int n7, int n8, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "T1PhysPathTerm", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.setRevision(3500);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedByTraffic = new ReferenceAttribute("reservedByTraffic", false);
        this.reservedByTraffic.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedByTraffic);
        this.reservedBySync = new ReferenceAttribute("reservedBySync", false);
        this.reservedBySync.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedBySync);
        this.reservedByImaLink = new ReferenceAttribute("reservedByImaLink", false);
        this.reservedByImaLink.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedByImaLink);
        int n9 = ((ExchangeTerminalMoImpl)managedObject).getFroId(coordinator);
        PhysValidator.checkPhysPathIdlePattern(this, n5, "T1PhysPathTerm", coordinator);
        if (n3 != 0 && n2 != 0) {
            throw new FroNotLockedException("loopback", "T1PhysPathTerm");
        }
        int n10 = this.createPhyT1PortFro(coordinator, n9, n, n4, n3, bl, bl2, n5, n2, n6, n7, n8);
        this.phyPortFroId = new IntegerAttribute(T1PHY_PORT_FRO_ID, false, n10);
        this.data.registerPersistentAttr((Attribute)this.phyPortFroId);
        phyT1MiProxy.registerForNotifications(coordinator, this, this.phyPortFroId.getValue(coordinator));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        repository.register(this.phyPortFroId.getValue(coordinator), this, coordinator);
    }

    public T1PhysPathTermMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3500);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(T1PHY_PORT_FRO_ID);
        moDataRecoveryHelper.assertAttribute("reservedByTraffic");
        moDataRecoveryHelper.assertAttribute("reservedBySync");
        moDataRecoveryHelper.assertAttribute("reservedByImaLink");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.phyPortFroId = (IntegerAttribute)this.data.getAttribute(T1PHY_PORT_FRO_ID);
        this.reservedByTraffic = (ReferenceAttribute)this.data.getAttribute("reservedByTraffic");
        this.reservedBySync = (ReferenceAttribute)this.data.getAttribute("reservedBySync");
        this.reservedByImaLink = (ReferenceAttribute)this.data.getAttribute("reservedByImaLink");
        phyT1MiProxy.registerForNotifications(null, this, this.phyPortFroId.getValue(null));
        repository.register(this.phyPortFroId.getValue(null), this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.reservedByTraffic.getValue(coordinator) != null || this.reservedBySync.getValue(coordinator) != null || this.reservedByImaLink.getValue(coordinator) != null) {
            throw new MoReservedNotDeletableException("T1PhysPathTerm");
        }
        phyT1MiProxy.deregisterForNotifications(coordinator, this.phyPortFroId.getValue(coordinator));
        this.deleteT1Fro(coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
        repository.remove(this.phyPortFroId.getValue(coordinator), coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"T1PhysPathTerm", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getLineNo(Coordinator coordinator) throws MoAccessException {
        return this.getPhyT1MiAttribute(coordinator, 21) + 1;
    }

    public int getLoopback(Coordinator coordinator) throws MoAccessException {
        return this.getPhyT1MiAttribute(coordinator, 22);
    }

    public void setLoopback(int n, Coordinator coordinator) throws MoAccessException {
        if (this.getAdministrativeState(coordinator) != 0 && n != 0) {
            throw new FroNotLockedException("loopback", "T1PhysPathTerm");
        }
        if (n < 0 || n > 2) {
            throw new ValueOutOfRangeException("loopback", "T1PhysPathTerm");
        }
        this.setPhyT1MiAttributes(coordinator, 22, n);
        this.sendNotification("loopback", new Integer(n), coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return this.getPhyT1MiAttribute(coordinator, 1);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n == 0) {
            this.lockT1PhyPort(coordinator);
        } else if (n == 1) {
            this.unlockT1PhyPort(coordinator);
        } else if (n == 2) {
            this.shutDownT1PhyPort(coordinator);
        } else {
            throw new ValueOutOfRangeException("administrativeState", "T1PhysPathTerm");
        }
        this.sendNotification("administrativeState", new Integer(n), coordinator);
    }

    public boolean getAisReporting(Coordinator coordinator) throws MoAccessException {
        return MaoFroTypeConverter.int2boolean((int)this.getPhyT1MiAttribute(coordinator, 26));
    }

    public void setAisReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setPhyT1MiAttributes(coordinator, 26, MaoFroTypeConverter.boolean2int((boolean)bl));
        this.sendNotification("aisReporting", bl, coordinator);
    }

    public int getDegDegThr(Coordinator coordinator) throws MoAccessException {
        return this.getPhyT1MiAttribute(coordinator, 24);
    }

    public void setDegDegThr(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkIntegerAttribute((String)"degDegThr", (int)n, (int)0, (int)100, (String)"T1PhysPathTerm");
        this.setPhyT1MiAttributes(coordinator, 24, n);
        this.sendNotification("degDegThr", new Integer(n), coordinator);
    }

    public int getDegDegM(Coordinator coordinator) throws MoAccessException {
        return this.getPhyT1MiAttribute(coordinator, 25);
    }

    public void setDegDegM(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkIntegerAttribute((String)"degDegM", (int)n, (int)2, (int)10, (String)"T1PhysPathTerm");
        this.setPhyT1MiAttributes(coordinator, 25, n);
        this.sendNotification("degDegM", new Integer(n), coordinator);
    }

    public boolean getRdiReporting(Coordinator coordinator) throws MoAccessException {
        return MaoFroTypeConverter.int2boolean((int)this.getPhyT1MiAttribute(coordinator, 27));
    }

    public void setRdiReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setPhyT1MiAttributes(coordinator, 27, MaoFroTypeConverter.boolean2int((boolean)bl));
        this.sendNotification("rdiReporting", bl, coordinator);
    }

    public int getIdlePattern(Coordinator coordinator) throws MoAccessException {
        return this.getPhyT1MiAttribute(coordinator, 29);
    }

    public void setIdlePattern(int n, Coordinator coordinator) throws MoAccessException {
        if (n < 0 || n > 2) {
            throw new ValueOutOfRangeException("idlePattern", "T1PhysPathTerm");
        }
        if (n != 0) {
            PhysValidator.checkPhysPathIdlePattern(this, n, "T1PhysPathTerm", coordinator);
        }
        this.setPhyT1MiAttributes(coordinator, 29, n);
        this.sendNotification("idlePattern", new Integer(n), coordinator);
    }

    public int getPmEs(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmEs", coordinator);
    }

    public int getPmSes(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmSes", coordinator);
    }

    public int getPmUas(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmUas", coordinator);
    }

    public int getShutDownTimeout(Coordinator coordinator) throws MoAccessException {
        return this.getPhyT1MiAttribute(coordinator, 35);
    }

    public void setShutDownTimeout(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkIntegerAttribute((String)"shutDownTimeout", (int)n, (int)0, (int)100000, (String)"T1PhysPathTerm");
        this.setPhyT1MiAttributes(coordinator, 35, n);
        this.sendNotification("shutDownTimeout", new Integer(n), coordinator);
    }

    public ManagedObject getReservedByTraffic(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedByTraffic.getValue(coordinator);
    }

    public ManagedObject getReservedBySync(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedBySync.getValue(coordinator);
    }

    public ManagedObject getReservedByImaLink(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedByImaLink.getValue(coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return this.getPhyT1MiAttribute(coordinator, 2);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return AvailConverter.convert((int)this.getPhyT1MiAttribute(coordinator, 3));
    }

    public int getTransmissionMode(Coordinator coordinator) throws MoAccessException {
        return this.getPhyT1MiAttribute(coordinator, 36);
    }

    public void setTransmissionMode(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkIntegerAttribute((String)"transmissionMode", (int)n, (int)0, (int)8, (String)"T1PhysPathTerm");
        this.setPhyT1MiAttributes(coordinator, 36, n);
        this.sendNotification("transmissionMode", new Integer(n), coordinator);
    }

    public int getSyncState(Coordinator coordinator) throws MoAccessException {
        return this.getPhyT1MiAttribute(coordinator, 34);
    }

    public String getType() {
        return "T1PhysPathTerm";
    }

    public void trafficReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        if (managedObject == null) {
            throw new InvalidReferenceException("T1PhysPathTerm", null);
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.reservedByImaLink.getValue(coordinator) != null) {
            throw new MoNotPossibleToReserveException("has been reserved by ImaLink", this.getType());
        }
        if (this.getChildren().hasMoreElements()) {
            throw new MoNotPossibleToReserveException("has Ds0Bundle children", this.getType());
        }
        this.reservedByTraffic = ReservableImpl.trafficReserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"T1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedByTraffic, (Class[])reservedClassesForTrafficReserve);
    }

    public void trafficRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedByTraffic = ReservableImpl.trafficRelease((ManagedObject)managedObject, (Coordinator)coordinator, (String)"T1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedByTraffic, (Class[])reservedClassesForTrafficReserve);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.phyPortFroId.getValue(coordinator);
    }

    private boolean checkChildren(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!(managedObject instanceof Ds0BundleBuildIF)) continue;
            if (((Ds0BundleBuildIF)managedObject).getReservedBy(coordinator) != null) {
                ManagedObject managedObject2 = ((Ds0BundleBuildIF)managedObject).getReservedBy(coordinator);
                return !(managedObject2 instanceof AtmPortBuildIF);
            }
            return true;
        }
        return false;
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedBySync = ReservableImpl.syncReserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"T1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedBySync);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedBySync = ReservableImpl.syncRelease((ManagedObject)managedObject, (Coordinator)coordinator, (String)"T1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedBySync);
    }

    public synchronized void parameterChanged(FroLockInd froLockInd, String string) {
        if (froLockInd instanceof PhyT1MiAutoLockInd) {
            String[] stringArray = new String[]{"administrativeState"};
            Object[] objectArray = new Object[]{new Integer(0)};
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
            AlarmManager.getReporter().reportEvent(41, (ManagedObject)this, "", "", null);
        }
    }

    private static void checkTransaction(Coordinator coordinator) throws TransactionRequiredException {
        if (coordinator == null) {
            throw new TransactionRequiredException();
        }
    }

    private static void checkNumberOfPhysPaths() throws MoAccessException {
        String[] stringArray = new String[]{"E1PhysPathTerm", "J1PhysPathTerm", "T1PhysPathTerm"};
        MoAttributeValidator.checkNumberOfMoTypes((String)"T1PhysPathTerm", (String[])stringArray, (int)900);
    }

    private static int checkAndGetLoopback(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("loopback");
        if (n == -1) {
            return 0;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("loopback", "T1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 0 || n2 > 2) {
            throw new ValueOutOfRangeException("loopback", "T1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetAdministrativeState(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("administrativeState");
        if (n == -1) {
            return 0;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("administrativeState", "T1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 0 || n2 > 2) {
            throw new ValueOutOfRangeException("administrativeState", "T1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static boolean checkAndGetAisReporting(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("aisReporting");
        if (n == -1) {
            return false;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            throw new WrongAttributeTypeException("aisReporting", "T1PhysPathTerm");
        }
        boolean bl = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        return bl;
    }

    private static boolean checkAndGetRdiReporting(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("rdiReporting");
        if (n == -1) {
            return false;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            throw new WrongAttributeTypeException("rdiReporting", "T1PhysPathTerm");
        }
        boolean bl = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        return bl;
    }

    private static int checkAndGetTransmissionMode(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("transmissionMode");
        if (n == -1) {
            return 0;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("transmissionMode", "T1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 0 || n2 > 8) {
            throw new ValueOutOfRangeException("transmissionMode", "T1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetIdlePattern(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("idlePattern");
        if (n == -1) {
            return 0;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("idlePattern", "T1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 0 || n2 > 2) {
            throw new ValueOutOfRangeException("idlePattern", "T1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetShutDownTimeout(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("shutDownTimeout");
        if (n == -1) {
            return 1800;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("shutDownTimeout", "T1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        MoAttributeValidator.checkIntegerAttribute((String)"shutDownTimeout", (int)n2, (int)0, (int)100000, (String)"T1PhysPathTerm");
        attrList.removeElementAt(n);
        return n2;
    }

    private static void checkOtherAttributes(AttrList attrList) throws NoSuchAttributeException {
        long l = attrList.size();
        if (l != 0L) {
            throw new NoSuchAttributeException(attrList.getName(0), "T1PhysPathTerm");
        }
    }

    private int createPhyT1PortFro(Coordinator coordinator, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, int n6, int n7, int n8, int n9) throws MoAccessException {
        PhyT1MiCreateRsp phyT1MiCreateRsp = phyT1MiProxy.sendPhyT1MiCreateReq(coordinator.getTransactionID(), n, n2, n3, bl, bl2, n5, n6, n4, n7, n8, n9);
        if (phyT1MiCreateRsp == null) {
            throw new FroNotAccessibleException("T1PhysPathTerm", "T1PhysicalPortFro");
        }
        if (phyT1MiCreateRsp.getResult() != 0) {
            throw new FroRequestFailedException("T1PhysPathTerm", "T1PhysicalPortFro", "CreateFroReq: " + phyT1MiProxy.getResultMsg(phyT1MiCreateRsp.getResult()), phyT1MiCreateRsp.getResult());
        }
        return phyT1MiCreateRsp.getFroId();
    }

    private int getPhyT1MiAttribute(Coordinator coordinator, int n) throws MoAccessException {
        PhyT1MiGetAttributeRsp phyT1MiGetAttributeRsp;
        int n2 = 0;
        if (coordinator != null) {
            n2 = coordinator.getTransactionID();
        }
        if ((phyT1MiGetAttributeRsp = phyT1MiProxy.sendPhyT1MiGetAttributeReq(n2, this.phyPortFroId.getValue(coordinator), n)) == null) {
            throw new FroNotAccessibleException("T1PhysPathTerm", "T1PhysicalPortFro");
        }
        if (phyT1MiGetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("T1PhysPathTerm", "T1PhysicalPortFro", "GetAttrReq: " + phyT1MiProxy.getResultMsg(phyT1MiGetAttributeRsp.getResult()), phyT1MiGetAttributeRsp.getResult());
        }
        return phyT1MiGetAttributeRsp.getValue();
    }

    private void setPhyT1MiAttributes(Coordinator coordinator, int n, int n2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PhyT1MiSetAttributeRsp phyT1MiSetAttributeRsp = phyT1MiProxy.sendPhyT1MiSetAttributeReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator), n, n2);
        if (phyT1MiSetAttributeRsp == null) {
            throw new FroNotAccessibleException("T1PhysPathTerm", "T1PhysicalPortFro");
        }
        if (phyT1MiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("T1PhysPathTerm", "T1PhysicalPortFro", "SetAttrReq: " + phyT1MiProxy.getResultMsg(phyT1MiSetAttributeRsp.getResult()), phyT1MiSetAttributeRsp.getResult());
        }
    }

    private void lockT1PhyPort(Coordinator coordinator) throws MoAccessException {
        PhyT1MiLockRsp phyT1MiLockRsp = phyT1MiProxy.sendPhyT1MiLockReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator));
        if (phyT1MiLockRsp == null) {
            throw new FroNotAccessibleException("T1PhysPathTerm", "T1PhysicalPortFro");
        }
        if (phyT1MiLockRsp.getResult() != 0) {
            throw new FroRequestFailedException("T1PhysPathTerm", "T1PhysicalPortFro", "ActionReq: " + phyT1MiProxy.getResultMsg(phyT1MiLockRsp.getResult()), phyT1MiLockRsp.getResult());
        }
    }

    private void unlockT1PhyPort(Coordinator coordinator) throws MoAccessException {
        PhyT1MiUnlockRsp phyT1MiUnlockRsp = phyT1MiProxy.sendPhyT1MiUnlockReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator));
        if (phyT1MiUnlockRsp == null) {
            throw new FroNotAccessibleException("T1PhysPathTerm", "T1PhysicalPortFro");
        }
        if (phyT1MiUnlockRsp.getResult() != 0) {
            throw new FroRequestFailedException("T1PhysPathTerm", "T1PhysicalPortFro", "ActionReq: " + phyT1MiProxy.getResultMsg(phyT1MiUnlockRsp.getResult()), phyT1MiUnlockRsp.getResult());
        }
    }

    private void shutDownT1PhyPort(Coordinator coordinator) throws MoAccessException {
        PhyT1MiShutDownRsp phyT1MiShutDownRsp = phyT1MiProxy.sendPhyT1MiShutDownReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator));
        if (phyT1MiShutDownRsp == null) {
            throw new FroNotAccessibleException("T1PhysPathTerm", "T1PhysicalPortFro");
        }
        if (phyT1MiShutDownRsp.getResult() != 0) {
            throw new FroRequestFailedException("T1PhysPathTerm", "T1PhysicalPortFro", "ActionReq: " + phyT1MiProxy.getResultMsg(phyT1MiShutDownRsp.getResult()), phyT1MiShutDownRsp.getResult());
        }
    }

    private void deleteT1Fro(Coordinator coordinator) throws MoAccessException {
        PhyT1MiDeleteRsp phyT1MiDeleteRsp = phyT1MiProxy.sendPhyT1MiDeleteReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator));
        if (phyT1MiDeleteRsp == null) {
            throw new FroNotAccessibleException("T1PhysPathTerm", "T1PhysicalPortFro");
        }
        if (phyT1MiDeleteRsp.getResult() != 0) {
            throw new FroRequestFailedException("T1PhysPathTerm", "T1PhysicalPortFro", "DeleteFroReq: " + phyT1MiProxy.getResultMsg(phyT1MiDeleteRsp.getResult()), phyT1MiDeleteRsp.getResult());
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject == null) {
            MessageLog.traceError(this.getClass(), (String)"reserve: userId is null", null);
            throw new InvalidReferenceException("T1PhysPathTerm", (Object)managedObject);
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.reservedByTraffic.getValue(coordinator) != null) {
            throw new MoNotPossibleToReserveException("has been reserved by AtmPort", this.getType());
        }
        if (this.checkChildren(coordinator)) {
            throw new MoNotPossibleToReserveException("has Ds0Bundle children", this.getType());
        }
        this.reservedByImaLink = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"T1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedByImaLink, (Class[])reservedClassesForReserve);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedByImaLink = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"T1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedByImaLink, (Class[])reservedClassesForReserve);
    }

    private static int getLineNumberMax(ManagedObject managedObject) throws MoAccessException {
        if (managedObject.getParent().getType().equals("Cbu")) {
            return 4;
        }
        return 8;
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }
}

