/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.from;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.StringDatabase;
import se.ericsson.cello.aueframework.common.StringTable;
import se.ericsson.cello.cmaaue.from.Constants;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;

public class IkeDhcpCollectAction
implements DataCollectorAction,
Constants {
    private static final String IFTYPE_TABLE_NAME = "ip_hostlink_iftype";
    private static final String IP_INTERFACE_IFTYPE = "2562";
    private static final String VPN_INTERFACE_IFTYPE = "2571";
    private static final String IPv6_INTERFACE_IFTYPE = "3593";
    private static final String IP_INTERFACE_GROUP_IFTYPE = "65535";
    private static final int MAX_FRO_ID = 2;
    private String[] dbBufferIftype = new String[3];
    private static final String DHCP_TABLE_NAME = "ip_hostlink_ipAccessHostEt";
    private String[] dbBufferDhcp = new String[]{"0", "0", "0"};

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        this.hiddenLinkRefForIftype(collectorContext, coordinator);
        this.linkRefForIftype(collectorContext, coordinator);
        this.writeToDatabase(IFTYPE_TABLE_NAME, this.dbBufferIftype, collectorContext, coordinator);
        this.hiddenLinkRefForDhcp(collectorContext, coordinator);
        this.linkRefForDhcp(collectorContext, coordinator);
        this.writeToDatabase(DHCP_TABLE_NAME, this.dbBufferDhcp, collectorContext, coordinator);
    }

    private void writeToDatabase(String string, String[] stringArray, CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        StringDatabase stringDatabase = collectorContext.getStringDatabase();
        StringTable stringTable = stringDatabase.getTable(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) continue;
            stringTable.writeRow(i, string2, coordinator);
        }
    }

    private static String getIfType(String string) throws AueException {
        if (string == null) {
            throw new AueException("Type name is null");
        }
        if (string.equalsIgnoreCase("IpInterface")) {
            return IP_INTERFACE_IFTYPE;
        }
        if (string.equalsIgnoreCase("VpnInterface")) {
            return VPN_INTERFACE_IFTYPE;
        }
        if (string.equalsIgnoreCase("Ipv6Interface")) {
            return IPv6_INTERFACE_IFTYPE;
        }
        if (string.equalsIgnoreCase("IpInterfaceGroup")) {
            return IP_INTERFACE_GROUP_IFTYPE;
        }
        throw new AueException("Invalid type:" + string);
    }

    private void hiddenLinkRefForIftype(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("Ip");
        if (moIterator == null) {
            return;
        }
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            try {
                ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute("ipAccessHostEtRef", coordinator);
                if (managedObject2 == null) continue;
                ManagedObject managedObject3 = (ManagedObject)managedObject2.getAttribute("ipInterfaceMoRef", coordinator);
                String string = managedObject3.getType();
                String string2 = IkeDhcpCollectAction.getIfType(string);
                for (int i = 0; i <= 2; ++i) {
                    this.dbBufferIftype[i] = string2;
                }
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                throw new AueException("Problem resolving alternate access interface type", (Throwable)noSuchAttributeException);
            }
            catch (MoAccessException moAccessException) {
                throw new AueException("Problem resolving alternate access interface type", (Throwable)moAccessException);
            }
        }
    }

    private void linkRefForIftype(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("IpHostLink");
        if (moIterator == null) {
            return;
        }
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            try {
                ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute("ipInterfaceMoRef", coordinator);
                Integer n = (Integer)managedObject.getAttribute("froId", coordinator);
                String string = managedObject2.getType();
                String string2 = IkeDhcpCollectAction.getIfType(string);
                if (n > 2) {
                    throw new AueException("IpHostLink FroId out of bound" + n);
                }
                this.dbBufferIftype[n.intValue()] = string2;
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                throw new AueException("Attribute ipInterfaceMoRef is not found for IpHostLink", (Throwable)noSuchAttributeException);
            }
            catch (MoAccessException moAccessException) {
                throw new AueException("IpHostLink is not accessable", (Throwable)moAccessException);
            }
        }
    }

    private void hiddenLinkRefForDhcp(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("Ip");
        if (moIterator == null) {
            return;
        }
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            try {
                ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute("ipAccessHostEtRef", coordinator);
                if (managedObject2 == null) continue;
                Method method = this.findMethod("se.ericsson.cello.iptransport.IpAccessHostEtMoImpl", "getFroId");
                Integer n = (Integer)method.invoke((Object)managedObject2, coordinator);
                for (int i = 0; i <= 2; ++i) {
                    this.dbBufferDhcp[i] = n.toString();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AueException("hiddenLinkRefForDhcp: IllegalArgumentException --------------------", (Throwable)illegalArgumentException);
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                throw new AueException("Problem resolving alternate access interface type", (Throwable)noSuchAttributeException);
            }
            catch (MoAccessException moAccessException) {
                throw new AueException("Problem resolving alternate access interface type", (Throwable)moAccessException);
            }
            catch (SecurityException securityException) {
                throw new AueException("Can't access IpAccessHostEtMoImpl.getFroId()", (Throwable)securityException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AueException("Can't find IpAccessHostEtMoImpl class", (Throwable)classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AueException("Can't access IpAccessHostEtMoImpl.getFroId()", (Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AueException("Can't access IpAccessHostEtMoImpl.getFroId()", (Throwable)invocationTargetException);
            }
        }
    }

    private void linkRefForDhcp(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("IpHostLink");
        if (moIterator == null) {
            return;
        }
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            try {
                Integer n = (Integer)managedObject.getAttribute("froId", coordinator);
                if (n > 2) {
                    throw new AueException("IpHostLink FroId out of bound" + n);
                }
                this.dbBufferDhcp[n.intValue()] = "-1";
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                throw new AueException("Attribute ipInterfaceMoRef is not found for IpHostLink", (Throwable)noSuchAttributeException);
            }
            catch (MoAccessException moAccessException) {
                throw new AueException("IpHostLink is not accessable", (Throwable)moAccessException);
            }
        }
    }

    private Method findMethod(String string, String string2) throws SecurityException, ClassNotFoundException {
        Method[] methodArray = Class.forName(string).getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equalsIgnoreCase(string2)) continue;
            return methodArray[i];
        }
        return null;
    }
}

