/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sync;

import enea.ose.system.Signal;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.sync.GpsSyncRefMo;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.sync.TimingUnitMoImpl;
import se.ericsson.cello.sync.fropxy.NssGpsSyncRefCreateFroRsp;
import se.ericsson.cello.sync.fropxy.NssGpsSyncRefDeleteFroRsp;
import se.ericsson.cello.sync.fropxy.NssGpsSyncRefGetAttrRsp;
import se.ericsson.cello.sync.fropxy.NssGpsSyncRefProxy;
import se.ericsson.cello.sync.fropxy.NssSetGpsSyncRefFilterTimeGpsAlarmRsp;
import se.ericsson.cello.sync.fropxy.NssSetGpsSyncRefFroDelayRsp;
import se.ericsson.cello.transaction.Coordinator;

public class GpsSyncRefMoImpl
extends CelloMao
implements GpsSyncRefMo,
SyncReservable {
    private static NssGpsSyncRefProxy roProxy = NssGpsSyncRefProxy.instance();
    private Map myPmProxyFroIdMap = new HashMap();
    private MoData myData;
    private StringAttribute userLabel;
    private SequenceAttribute reservedBy;
    private IntegerAttribute froId;
    private static final int MO_DATA_REVISION_9 = 9000;
    private static final int MO_DATA_REVISION_LATEST = 9000;

    public static GpsSyncRefMoImpl create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TimingUnit");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"GpsSyncRef", (int)2);
        MoAttributeValidator.checkIdentity((String)"GpsSyncRef", (String)string);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"GpsSyncRef", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"GpsSyncRef");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"gpsCompensationDelay", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)65535, (String)"GpsSyncRef");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"filterTimeGpsAlarm", (AttrList)attrList, (boolean)false, (int)12, (int)1, (int)12, (String)"GpsSyncRef");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"GpsSyncRef");
        return new GpsSyncRefMoImpl(managedObject, string2, n, n2, n3, string, coordinator, initialMaoContext);
    }

    private GpsSyncRefMoImpl(ManagedObject managedObject, String string, int n, int n2, int n3, String string2, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, "GpsSyncRef", string2, coordinator, initialMaoContext);
        NssGpsSyncRefCreateFroRsp nssGpsSyncRefCreateFroRsp = roProxy.sendNssGpsSyncRefCreateFroReq(coordinator.getTransactionID(), n, ((TimingUnitMoImpl)managedObject).getFroId(coordinator), n2, n3);
        if (nssGpsSyncRefCreateFroRsp == null) {
            throw new FroNotAccessibleException("GpsSyncRef", "create NssGpsSyncReferenceFro1");
        }
        if (nssGpsSyncRefCreateFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("GpsSyncRef", "NssGpsSyncReferenceFro1", "create: " + roProxy.getResultMsg(nssGpsSyncRefCreateFroRsp.getResult()), nssGpsSyncRefCreateFroRsp.getResult());
        }
        int n4 = nssGpsSyncRefCreateFroRsp.getFroId();
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true);
        this.userLabel.setValue(string);
        this.myData.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.myData.registerPersistentAttr((Attribute)this.reservedBy);
        this.froId = new IntegerAttribute("froId", false);
        this.froId.setValue(n4);
        this.myData.registerPersistentAttr((Attribute)this.froId);
        roProxy.registerForNotifications(coordinator, this, this.froId.getValue(coordinator));
        this.myData.setRevision(9000);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public GpsSyncRefMoImpl(MoData moData, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.myData = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.myData, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.userLabel = (StringAttribute)this.myData.getAttribute("userLabel");
        this.froId = (IntegerAttribute)this.myData.getAttribute("froId");
        this.reservedBy = (SequenceAttribute)this.myData.getAttribute("reservedBy");
        roProxy.registerForNotifications(null, this, this.froId.getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException("GpsSyncRef");
        }
        NssGpsSyncRefDeleteFroRsp nssGpsSyncRefDeleteFroRsp = roProxy.sendNssGpsSyncRefDeleteFroReq(coordinator.getTransactionID(), this.froId.getValue(coordinator));
        if (nssGpsSyncRefDeleteFroRsp == null) {
            throw new FroNotAccessibleException("GpsSyncRef", "delete NssGpsSyncReferenceFro1");
        }
        if (nssGpsSyncRefDeleteFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("GpsSyncRef", "NssGpsSyncReferenceFro1", "delete: " + roProxy.getResultMsg(nssGpsSyncRefDeleteFroRsp.getResult()), nssGpsSyncRefDeleteFroRsp.getResult());
        }
        roProxy.deregisterForNotifications(coordinator, this.froId.getValue(coordinator));
        this.myData.delete(coordinator);
        super.delete(coordinator);
    }

    public String getType() {
        return "GpsSyncRef";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"GpsSyncRef", (int)128, (int)0);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = coordinator == null ? 0 : coordinator.getTransactionID();
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(n, this.froId.getValue(coordinator));
        if (nssGpsSyncRefGetAttrRsp == null) {
            throw new FroNotAccessibleException("GpsSyncRef", "get, NssGpsSyncReferenceFro1");
        }
        if (nssGpsSyncRefGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("GpsSyncRef", "NssGpsSyncReferenceFro1", "get: " + roProxy.getResultMsg(nssGpsSyncRefGetAttrRsp.getResult()), nssGpsSyncRefGetAttrRsp.getResult());
        }
        return nssGpsSyncRefGetAttrRsp.getAvailabilityStatus();
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = coordinator == null ? 0 : coordinator.getTransactionID();
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(n, this.froId.getValue(coordinator));
        if (nssGpsSyncRefGetAttrRsp == null) {
            throw new FroNotAccessibleException("GpsSyncRef", "get NssGpsSyncReferenceFro1");
        }
        if (nssGpsSyncRefGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("GpsSyncRef", "NssGpsSyncReferenceFro1", "getAttr: " + roProxy.getResultMsg(nssGpsSyncRefGetAttrRsp.getResult()), nssGpsSyncRefGetAttrRsp.getResult());
        }
        return nssGpsSyncRefGetAttrRsp.getOperState();
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = coordinator == null ? 0 : coordinator.getTransactionID();
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(n, this.froId.getValue(coordinator));
        if (nssGpsSyncRefGetAttrRsp == null) {
            throw new FroNotAccessibleException("GpsSyncRef", "get NssGpsSyncReferenceFro1");
        }
        if (nssGpsSyncRefGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("GpsSyncRef", "NssGpsSyncReferenceFro1", "getAttr: " + roProxy.getResultMsg(nssGpsSyncRefGetAttrRsp.getResult()), nssGpsSyncRefGetAttrRsp.getResult());
        }
        return nssGpsSyncRefGetAttrRsp.getAdmState();
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        Object[] objectArray;
        String[] stringArray;
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n == 2) {
            n = 0;
        }
        switch (n) {
            case 0: {
                stringArray = roProxy.sendNssLockGpsSyncRefReq(coordinator.getTransactionID(), this.froId.getValue(coordinator));
                if (stringArray == null) {
                    throw new FroNotAccessibleException("GpsSyncRef", "set NssGpsSyncReferenceFro1");
                }
                if (stringArray.getResult() == 0) break;
                throw new FroRequestFailedException("GpsSyncRef", "NssGpsSyncReferenceFro1", "set adminState locked: " + roProxy.getResultMsg(stringArray.getResult()), stringArray.getResult());
            }
            case 1: {
                objectArray = roProxy.sendNssUnlockGpsSyncRefReq(coordinator.getTransactionID(), this.froId.getValue(coordinator));
                if (objectArray == null) {
                    throw new FroNotAccessibleException("GpsSyncRef", "set NssGpsSyncReferenceFro1");
                }
                if (objectArray.getResult() == 0) break;
                throw new FroRequestFailedException("GpsSyncRef", "NssGpsSyncReferenceFro1", "set adminState unlocked: " + roProxy.getResultMsg(objectArray.getResult()), objectArray.getResult());
            }
            default: {
                throw new ValueOutOfRangeException("administrativeState", "GpsSyncRef");
            }
        }
        stringArray = new String[]{"administrativeState"};
        objectArray = new Object[]{new Integer(n)};
        GpsSyncRefMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getGpsCompensationDelay(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.froId.getValue(coordinator));
        GpsSyncRefMoImpl.checkSignal((Signal)nssGpsSyncRefGetAttrRsp);
        this.checkResult(nssGpsSyncRefGetAttrRsp.getResult(), "GetCompensationDelayAttrReq: ");
        return nssGpsSyncRefGetAttrRsp.getGpsCompensationDelay();
    }

    public void setGpsCompensationDelay(int n, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoAttributeValidator.checkIntegerAttribute((String)"gpsCompensationDelay", (int)n, (int)0, (int)65535, (String)"GpsSyncRef");
        NssSetGpsSyncRefFroDelayRsp nssSetGpsSyncRefFroDelayRsp = roProxy.sendNssSetGpsSyncRefFroDelayReq(coordinator.getTransactionID(), this.froId.getValue(coordinator), n);
        GpsSyncRefMoImpl.checkSignal((Signal)nssSetGpsSyncRefFroDelayRsp);
        this.checkResult(nssSetGpsSyncRefFroDelayRsp.getResult(), "SetCompensationDelayAttrReq: ");
        String[] stringArray = new String[]{"gpsCompensationDelay"};
        Object[] objectArray = new Object[]{new Integer(n)};
        GpsSyncRefMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getFilterTimeGpsAlarm(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.froId.getValue(coordinator));
        GpsSyncRefMoImpl.checkSignal((Signal)nssGpsSyncRefGetAttrRsp);
        this.checkResult(nssGpsSyncRefGetAttrRsp.getResult(), "GetFilterTimeGpsAlarmAttrReq: ");
        return nssGpsSyncRefGetAttrRsp.getFilterTimeGpsAlarm();
    }

    public void setFilterTimeGpsAlarm(int n, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoAttributeValidator.checkIntegerAttribute((String)"filterTimeGpsAlarm", (int)n, (int)1, (int)12, (String)"GpsSyncRef");
        NssSetGpsSyncRefFilterTimeGpsAlarmRsp nssSetGpsSyncRefFilterTimeGpsAlarmRsp = roProxy.sendNssSetGpsSyncRefFilterTimeGpsAlarmReq(coordinator.getTransactionID(), this.froId.getValue(coordinator), n);
        GpsSyncRefMoImpl.checkSignal((Signal)nssSetGpsSyncRefFilterTimeGpsAlarmRsp);
        this.checkResult(nssSetGpsSyncRefFilterTimeGpsAlarmRsp.getResult(), "SetFilterTimeGpsAlarmAttrReq: ");
        String[] stringArray = new String[]{"filterTimeGpsAlarm"};
        Object[] objectArray = new Object[]{new Integer(n)};
        GpsSyncRefMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getGpsRefState(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.froId.getValue(coordinator));
        GpsSyncRefMoImpl.checkSignal((Signal)nssGpsSyncRefGetAttrRsp);
        this.checkResult(nssGpsSyncRefGetAttrRsp.getResult(), "GetGpsRefStateAttrReq: ");
        return nssGpsSyncRefGetAttrRsp.getGpsRefState();
    }

    public int getNoOfSatellitesInView(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.froId.getValue(coordinator));
        GpsSyncRefMoImpl.checkSignal((Signal)nssGpsSyncRefGetAttrRsp);
        this.checkResult(nssGpsSyncRefGetAttrRsp.getResult(), "GetNoOfSatelliteInViewAttrReq: ");
        return nssGpsSyncRefGetAttrRsp.getNoOfSatellitesInView();
    }

    public Struct[] getSatelliteInformation(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.froId.getValue(coordinator));
        GpsSyncRefMoImpl.checkSignal((Signal)nssGpsSyncRefGetAttrRsp);
        this.checkResult(nssGpsSyncRefGetAttrRsp.getResult(), "GetSatelliteInformationAttrReq: ");
        return nssGpsSyncRefGetAttrRsp.getSatelliteInformation();
    }

    public String getLatitude(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.froId.getValue(coordinator));
        GpsSyncRefMoImpl.checkSignal((Signal)nssGpsSyncRefGetAttrRsp);
        this.checkResult(nssGpsSyncRefGetAttrRsp.getResult(), "GetLatitudeAttrReq: ");
        return nssGpsSyncRefGetAttrRsp.getLatitude();
    }

    public String getLongitude(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.froId.getValue(coordinator));
        GpsSyncRefMoImpl.checkSignal((Signal)nssGpsSyncRefGetAttrRsp);
        this.checkResult(nssGpsSyncRefGetAttrRsp.getResult(), "GetLongitudeAttrReq: ");
        return nssGpsSyncRefGetAttrRsp.getLongitude();
    }

    public String getAltitude(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.froId.getValue(coordinator));
        GpsSyncRefMoImpl.checkSignal((Signal)nssGpsSyncRefGetAttrRsp);
        this.checkResult(nssGpsSyncRefGetAttrRsp.getResult(), "GetAltitudeAttrReq: ");
        return nssGpsSyncRefGetAttrRsp.getAltitude();
    }

    public String getHdop(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.froId.getValue(coordinator));
        GpsSyncRefMoImpl.checkSignal((Signal)nssGpsSyncRefGetAttrRsp);
        this.checkResult(nssGpsSyncRefGetAttrRsp.getResult(), "GetHDopAttrReq: ");
        return nssGpsSyncRefGetAttrRsp.getHDop();
    }

    public String getVdop(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.froId.getValue(coordinator));
        GpsSyncRefMoImpl.checkSignal((Signal)nssGpsSyncRefGetAttrRsp);
        this.checkResult(nssGpsSyncRefGetAttrRsp.getResult(), "GetVDopAttrReq: ");
        return nssGpsSyncRefGetAttrRsp.getVDop();
    }

    public int getObservationPoint(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssGpsSyncRefGetAttrRsp nssGpsSyncRefGetAttrRsp = roProxy.sendNssGpsSyncRefGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.froId.getValue(coordinator));
        GpsSyncRefMoImpl.checkSignal((Signal)nssGpsSyncRefGetAttrRsp);
        this.checkResult(nssGpsSyncRefGetAttrRsp.getResult(), "GetObservationPointAttrReq: ");
        return nssGpsSyncRefGetAttrRsp.getObservationPoint();
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.myData.getAttribute("reservedBy")), (Coordinator)coordinator);
    }

    public int[] getPmGpsLos(Coordinator coordinator) throws MoAccessException {
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        return this.integerArray2primitiveArray((Integer[])pmRequestContextImpl.getPmAttribute("pmGpsLos", INTEGER_ARRAY_PM_TYPE));
    }

    private int[] integerArray2primitiveArray(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        int n = 0;
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = integerArray[n];
        }
        return nArray;
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reserve(managedObject, coordinator);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.release(managedObject, coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.froId.getValue(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.myData, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.myData, (String)"reservedBy");
    }

    private static void checkSignal(Signal signal) throws FroNotAccessibleException {
        UpgradeTrace.debug((Class)GpsSyncRefMoImpl.class, (int)70, (String)"checkSignal(enea.ose.system.Signal sig)", (String)"Resource FRO is not accessible.");
        if (signal == null) {
            throw new FroNotAccessibleException("GpsSyncRef", "Resource FRO is not accessible.");
        }
    }

    private void checkResult(int n, String string) throws FroRequestFailedException, MoAccessException {
        UpgradeTrace.debug((Class)GpsSyncRefMoImpl.class, (int)70, (String)"checkResult(int result)", (String)("result: " + n));
        if (n != 0) {
            throw new FroRequestFailedException("GpsSyncRef", "GpsSyncRef", string + roProxy.getResultMsg(n), n);
        }
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }
}

