/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sync;

import enea.ose.system.Signal;
import java.util.ArrayList;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.equipment.ProgramHeapAndPoolSizeInterfaceBase;
import se.ericsson.cello.equipment.ProgramMoInternal;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.util.library.Lib;

public class ProgramMoSyncImpl
extends ManagedObjectBase
implements ProgramMoInternal,
GenericProgramBase,
ProgramHeapAndPoolSizeInterfaceBase {
    protected static final String TU_FRO_ID = "tuFroId";
    protected static final String LOAD_MODULE_FILE_PATH = "loadModuleFilePath";
    private MoData data;
    private LongAttribute resourceId;
    private StringAttribute userLabel;
    private ReferenceAttribute loadModule;
    private BooleanAttribute isUpgradePersistent;
    private FroProxy proxy = null;

    static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoSyncImpl.class, (int)70, (String)"create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator c)", (String)("parent: " + managedObject + "\n\tattributes: " + Lib.toString((AttrList)attrList) + "\n\tidentity: " + string + "\n\tsource: " + managedObject2 + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Program", (String)string);
        String[] stringArray = new String[]{"TimingUnit"};
        MoAttributeValidator.checkParents((ManagedObject)managedObject, (String[])stringArray);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Program", (int)128, (int)0);
        LoadModuleMo loadModuleMo = (LoadModuleMo)MoAttributeValidator.checkAndGetReferenceAttribute((String)"loadModule", (AttrList)attrList, (boolean)true, (String[])ProgramMoInternal.LM_CLASSNAME, (String)"Program");
        int n = ProgramMoSyncImpl.getLoadModuleType(managedObject, loadModuleMo, coordinator);
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"startState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"Program");
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"isUpgradePersistent", (AttrList)attrList, (boolean)false, (boolean)false, (String)"Program");
        int n3 = ProgramMoSyncImpl.checkAndGetHeapSize(attrList, loadModuleMo, coordinator);
        int n4 = ProgramMoSyncImpl.checkAndGetPoolSize(attrList, loadModuleMo, coordinator);
        int n5 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"restartTimer", (AttrList)attrList, (boolean)false, (int)60, (int)-1, (int)65535, (String)"Program");
        int n6 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"restartCounterLimit", (AttrList)attrList, (boolean)false, (int)3, (int)-1, (int)65535, (String)"Program");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Program");
        return new ProgramMoSyncImpl(managedObject, string2, loadModuleMo, n2, n3, n4, n5, n6, n, string, bl, coordinator, froProxy);
    }

    private ProgramMoSyncImpl(ManagedObject managedObject, String string, LoadModuleMo loadModuleMo, int n, int n2, int n3, int n4, int n5, int n6, String string2, boolean bl, Coordinator coordinator, FroProxy froProxy) throws MoAccessException {
        super(managedObject, "Program", string2, coordinator);
        UpgradeTrace.debug((Class)ProgramMoSyncImpl.class, (int)70, (String)"ProgramMoImpl(ManagedObject parent, String userLabel, LoadModuleMo lmMo, int startState, int heapSize, int poolSize, int restartTimer, int restartCounterLimit, int loadModuleType, String identity, boolean upgradePersistent, Coordinator c)", (String)("parent: " + managedObject + "\n\tuserLabel: " + string + "\n\tlmMo: " + loadModuleMo + "\n\tstartState: " + n + "\n\theapSize: " + n2 + "\n\tpoolSize: " + n3 + "\n\trestartTimer: " + n4 + "\n\trestartCounterLimit: " + n5 + "\n\tloadModuleType: " + n6 + "\n\tidentity: " + string2 + "\n\tupgradePersistent: " + bl + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.proxy = froProxy;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SignedIntParameter(TU_FRO_ID, ((FroInfo)managedObject).getFroId(coordinator)));
        arrayList.add(new StringParameter(LOAD_MODULE_FILE_PATH, loadModuleMo.getLoadModuleFilePath(coordinator)));
        arrayList.add(new SignedIntParameter("startState", n));
        FroData froData = null;
        try {
            froData = froProxy.create(coordinator, arrayList);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            froData = froProxy.create(coordinator, arrayList);
        }
        this.initMoData(froData.getFroId(), string, loadModuleMo, bl, coordinator);
    }

    private void initMoData(long l, String string, LoadModuleMo loadModuleMo, boolean bl, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoSyncImpl.class, (int)70, (String)"initMoData(long resId, String label, LoadModuleMo lmMo, boolean upgradePersistent, Coordinator c)", (String)("resId: " + l + "\n\tlabel: " + string + "\n\tlmMo: " + loadModuleMo + "\n\tupgradePersistent: " + bl + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.setRevision(6000);
        this.isUpgradePersistent = new BooleanAttribute("isUpgradePersistent", false, bl);
        this.data.registerPersistentAttr((Attribute)this.isUpgradePersistent);
        this.resourceId = new LongAttribute("resourceId", false);
        this.resourceId.setValue(l);
        this.data.registerPersistentAttr((Attribute)this.resourceId);
        this.userLabel = new StringAttribute("userLabel", true);
        this.userLabel.setValue(string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.loadModule = new ReferenceAttribute("loadModule", false);
        this.loadModule.setValue((ManagedObject)loadModuleMo);
        this.data.registerPersistentAttr((Attribute)this.loadModule);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public ProgramMoSyncImpl(MoData moData, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"ProgramMoImpl(MoData recoveredData)", (String)("recoveredData: " + moData));
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        this.proxy = froProxy;
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("resourceId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("loadModule");
        moDataRecoveryHelper.assertAttribute("isUpgradePersistent");
        this.resourceId = (LongAttribute)moData.getAttribute("resourceId");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.loadModule = (ReferenceAttribute)moData.getAttribute("loadModule");
        this.isUpgradePersistent = (BooleanAttribute)moData.getAttribute("isUpgradePersistent");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"delete(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.proxy.delete(coordinator, (int)this.resourceId.getValue(coordinator), null);
        this.data.delete(coordinator);
        super.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"getUserLabel(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"setUserLabel(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Program", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public ManagedObject getLoadModule(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"getLoadModule(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.loadModule.getValue(coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"getOperationalState(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SignedIntParameter signedIntParameter = (SignedIntParameter)this.proxy.getAttribute(coordinator, (int)this.resourceId.getValue(coordinator), "operationalState");
        return signedIntParameter.getValue();
    }

    public int getStartState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"getStartState(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SignedIntParameter signedIntParameter = (SignedIntParameter)this.proxy.getAttribute(coordinator, (int)this.resourceId.getValue(coordinator), "startState");
        return signedIntParameter.getValue();
    }

    public void setStartState(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"setStartState(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != 1 && n != 0) {
            throw new ValueOutOfRangeException("startState", "Program");
        }
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter("startState", n));
        try {
            this.proxy.setAttributes(coordinator, (int)this.resourceId.getValue(coordinator), arrayList);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            this.proxy.setAttributes(coordinator, (int)this.resourceId.getValue(coordinator), arrayList);
        }
        String[] stringArray = new String[]{"startState"};
        Object[] objectArray = new Object[]{new Integer(n)};
        ProgramMoSyncImpl.sendChangeNotification((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getHeapSize(Coordinator coordinator) throws MoAccessException {
        return 0;
    }

    public void setHeapSize(int n, Coordinator coordinator) throws MoAccessException {
    }

    public int getPoolSize(Coordinator coordinator) throws MoAccessException {
        return 0;
    }

    public void setPoolSize(int n, Coordinator coordinator) throws MoAccessException {
    }

    public int getRestartTimer(Coordinator coordinator) throws MoAccessException {
        return 60;
    }

    public void setRestartTimer(int n, Coordinator coordinator) throws MoAccessException {
    }

    public int getRestartCounterLimit(Coordinator coordinator) throws MoAccessException {
        return 3;
    }

    public void setRestartCounterLimit(int n, Coordinator coordinator) throws MoAccessException {
    }

    public String getProgramId(Coordinator coordinator) throws MoAccessException {
        return this.getNamingAttributeValue();
    }

    public int getProgramFroId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"getProgramFroId(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return (int)this.resourceId.getValue(coordinator);
    }

    public boolean getIsUpgradePersistent(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"getIsUpgradePersistent(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.isUpgradePersistent.getValue(coordinator);
    }

    public void setIsUpgradePersistent(boolean bl, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"setIsUpgradePersistent(boolean value, Coordinator context)", (String)("value: " + bl + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.isUpgradePersistent.setValue(bl);
    }

    public void actionRestart(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"actionRestart(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        throw new ActionNotAllowedException("Program", "This action is not valid for programs on this board: " + this.getParent().getType());
    }

    public void actionStopImmediate(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"actionStopImmediate(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        throw new ActionNotAllowedException("Program", "This action is not valid for programs on this board: " + this.getParent().getType());
    }

    public void actionStartImmediate(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"actionStartImmediate(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        throw new ActionNotAllowedException("Program", "This action is not valid for programs on this board: " + this.getParent().getType());
    }

    public void programUpgrade(long l, int n) throws MoAccessException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"programUpgrade(long anOldPgmInstanceId, int aMethod)", (String)("anOldPgmInstanceId: " + l + "\n\taMethod: " + n));
        throw new NoSuchAttributeException("programUpgrade is not supported by the " + this.getParent().getType() + " Program", "Program");
    }

    public String getType() {
        return "Program";
    }

    private static int getLoadModuleType(ManagedObject managedObject, LoadModuleMo loadModuleMo, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoSyncImpl.class, (int)70, (String)"getLoadModuleType(ManagedObject parent, LoadModuleMo lmMo, Coordinator c)", (String)("parent: " + managedObject + "\n\tlmMo: " + loadModuleMo + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        if (managedObject.getType().equals("TimingUnit")) {
            if (loadModuleMo.getLoaderType(coordinator) != 4) {
                throw new ValueOutOfRangeException("loadModule", "Program");
            }
            return 1;
        }
        throw new ValueOutOfRangeException("loadModule", "Program");
    }

    private static int checkAndGetHeapSize(AttrList attrList, LoadModuleMo loadModuleMo, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoSyncImpl.class, (int)70, (String)"checkAndGetHeapSize(AttrList attributes, LoadModuleMo aLoadModule, Coordinator context)", (String)("attributes: " + Lib.toString((AttrList)attrList) + "\n\taLoadModule: " + loadModuleMo + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        LoadModuleMo loadModuleMo2 = loadModuleMo;
        int n = 0;
        int n2 = attrList.indexOf("heapSize");
        int n3 = loadModuleMo2.getOseProgramHeapSize(coordinator);
        if (n2 == -1) {
            if (n3 != 0) {
                n = n3;
            }
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("heapSize", "Program");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 0) {
            throw new ValueOutOfRangeException("heapSize", "Program");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetPoolSize(AttrList attrList, LoadModuleMo loadModuleMo, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoSyncImpl.class, (int)70, (String)"checkAndGetPoolSize(AttrList attributes, LoadModuleMo aLoadModule, Coordinator context)", (String)("attributes: " + Lib.toString((AttrList)attrList) + "\n\taLoadModule: " + loadModuleMo + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        LoadModuleMo loadModuleMo2 = loadModuleMo;
        int n = 0;
        int n2 = attrList.indexOf("poolSize");
        int n3 = loadModuleMo2.getOseProgramPoolSize(coordinator);
        if (n2 == -1) {
            if (n3 != 0) {
                n = n3;
            }
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("poolSize", "Program");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 0) {
            throw new ValueOutOfRangeException("poolSize", "Program");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetRestartTimer(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoSyncImpl.class, (int)70, (String)"checkAndGetRestartTimer(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 60;
        int n2 = attrList.indexOf("restartTimer");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("restartTimer", "Program");
        }
        n = (Integer)attrList.getValue(n2);
        if (n <= 0 && n != -1) {
            throw new ValueOutOfRangeException("restartTimer", "Program");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetRestartCounterLimit(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)ProgramMoSyncImpl.class, (int)70, (String)"checkAndGetRestartCounterLimit(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 3;
        int n2 = attrList.indexOf("restartCounterLimit");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("restartCounterLimit", "Program");
        }
        n = (Integer)attrList.getValue(n2);
        if (n <= 0 && n != -1) {
            throw new ValueOutOfRangeException("restartCounterLimit", "Program");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static void checkSignal(Signal signal) throws FroNotAccessibleException {
        UpgradeTrace.debug((Class)ProgramMoSyncImpl.class, (int)70, (String)"checkSignal(enea.ose.system.Signal sig)", (String)("sig: " + signal));
        if (signal == null) {
            throw new FroNotAccessibleException("Program", "Resource FRO is not accessible.");
        }
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        UpgradeTrace.debug((Class)ProgramMoSyncImpl.class, (int)70, (String)"sendChangeNotification(ManagedObject mo, String[] attrNames, Object[] newValues, Coordinator context)", (String)("mo: " + managedObject + "\n\tattrNames: " + Lib.toString((String[])stringArray) + "\n\tnewValues: " + Lib.toString((Object[])objectArray) + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        NotificationSender.instance().pushAVC(managedObject, stringArray, objectArray, coordinator);
    }

    public Struct[] getProgramInstances(Coordinator coordinator) {
        return new Struct[0];
    }

    public int getLoaderType(Coordinator coordinator) throws MoAccessException {
        return ((LoadModuleMo)this.getLoadModule(coordinator)).getLoaderType(coordinator);
    }

    public String getDeviceLoaderName(Coordinator coordinator) throws MoAccessException {
        return ((LoadModuleMo)this.getLoadModule(coordinator)).getDeviceLoaderName(coordinator);
    }

    public String getDeviceLoaderInformation(Coordinator coordinator) throws MoAccessException {
        return ((LoadModuleMo)this.getLoadModule(coordinator)).getDeviceLoaderInformation(coordinator);
    }
}

