/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sync;

import enea.ose.system.Signal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.SlotMoInternal;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.mao.TimeAndDateFormatException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.sync.AlreadyRegisteredException;
import se.ericsson.cello.sync.EthernetPortRef;
import se.ericsson.cello.sync.GigabitEthernetRef;
import se.ericsson.cello.sync.GpsOutSyncLinkMo;
import se.ericsson.cello.sync.GpsSyncRefMo;
import se.ericsson.cello.sync.HptsiSyncRefMo;
import se.ericsson.cello.sync.IpSyncReference;
import se.ericsson.cello.sync.MaxNoOfRefRegisteredException;
import se.ericsson.cello.sync.NotRegisteredException;
import se.ericsson.cello.sync.NotUniqueFroIdException;
import se.ericsson.cello.sync.PDHSyncReference;
import se.ericsson.cello.sync.PacketFrequencySyncRefMo;
import se.ericsson.cello.sync.PacketTimeSyncRefMo;
import se.ericsson.cello.sync.PriorityAlreadyInUseException;
import se.ericsson.cello.sync.PriorityOutOfRangeException;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.sync.SynchronizationMo;
import se.ericsson.cello.sync.SynchronizationMoFactory;
import se.ericsson.cello.sync.TuSyncRefMo;
import se.ericsson.cello.sync.fropxy.NssChangeDegrCriteriaRsp;
import se.ericsson.cello.sync.fropxy.NssReadSyncAttrRsp;
import se.ericsson.cello.sync.fropxy.NssResetLossOfTrackingRsp;
import se.ericsson.cello.sync.fropxy.NssSyncPriorityChangeRsp;
import se.ericsson.cello.sync.fropxy.NssSyncProxy;
import se.ericsson.cello.sync.fropxy.NssSyncRefDeregisterRsp;
import se.ericsson.cello.sync.fropxy.NssSynchChangeMinQualityLevelRsp;
import se.ericsson.cello.sync.fropxy.NssSynchChangeSelectionProcessModeRsp;
import se.ericsson.cello.sync.fropxy.NssSynchChangeSyncRefResourceQualityRsp;
import se.ericsson.cello.sync.fropxy.NssSynchSetFixedPositionRsp;
import se.ericsson.cello.sync.fropxy.NssSynchSetFreqHoldoverAlarmRsp;
import se.ericsson.cello.sync.fropxy.NssSynchSetPtpFreqFeatureStateRsp;
import se.ericsson.cello.sync.fropxy.NssSynchSetPtpTimeFeatureStateRsp;
import se.ericsson.cello.sync.fropxy.NssSynchSetSfnInitTimeRsp;
import se.ericsson.cello.sync.fropxy.NssSynchSetSyncEFeatureStateRsp;
import se.ericsson.cello.sync.fropxy.NssSynchSetTestModeRsp;
import se.ericsson.cello.sync.fropxy.NssSynchSetTimeHoldoverAlarmRsp;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;

public class SynchronizationMoImpl
extends CelloMao
implements SynchronizationMo {
    private MoData data;
    private static SynchronizationMoImpl instance = null;
    private static final String syncId = "1";
    private StringAttribute userLabel;
    private ReferenceAttribute syncReference1;
    private ReferenceAttribute syncReference2;
    private ReferenceAttribute syncReference3;
    private ReferenceAttribute syncReference4;
    private ReferenceAttribute syncReference5;
    private ReferenceAttribute syncReference6;
    private ReferenceAttribute syncReference7;
    private ReferenceAttribute syncReference8;
    private static NssSyncProxy syncFroProxy = NssSyncProxy.instance();
    public static final int TRANSACTION_TIME_OUT_SECONDS = 15;
    private Map myPmProxyFroIdMap = new HashMap();
    private static NotificationSender notificationSender = NotificationSender.instance();
    private static final int NSS_DEGRADATION_IS_NOT_FAULT = 0;
    private static final int NSS_DEGRADATION_IS_FAULT = 1;
    private static final int NSS_SYNCH_REF_PRESENT_AND_INACTIVE = 1;
    private static final int NSS_SYNCH_REF_STATUS_FAILED = 0;
    private static final int NSS_SYNCH_REF_NON_EXISTING = 0;
    private static final int NSS_REF_FROCLASS_PHYSICAL_PATH_TERM = 0;
    private static final int NSS_REF_FROCLASS_TU_DEDICATED = 1;
    private static final int NSS_REF_FROCLASS_IP_SYNC_REF = 2;
    private static final int NSS_REF_FROCLASS_GPS_SYNC_REF = 3;
    private static final int NSS_REF_FROCLASS_PKT_TIME_SYNC_REF = 4;
    private static final int NSS_REF_FROCLASS_PKT_FREQ_SYNC_REF = 5;
    private static final int NSS_REF_FROCLASS_HPTSI_SYNC_REF = 6;
    private static final int NSS_REF_FROCLASS_GIGABIT_ETH_REF = 7;
    private static final int NSS_REF_FROCLASS_GPS_OUT_SYNC_LINK = 8;
    private static final int NSS_REF_FROCLASS_ETHERNET_PORT_REF = 10;
    private static final int NSS_SYNCHRONIZATION_FRO_ID = 1;
    private static final String SYNC_REFERENCE_1 = "syncReference1";
    private static final String SYNC_REFERENCE_2 = "syncReference2";
    private static final String SYNC_REFERENCE_3 = "syncReference3";
    private static final String SYNC_REFERENCE_4 = "syncReference4";
    private static final String SYNC_REFERENCE_5 = "syncReference5";
    private static final String SYNC_REFERENCE_6 = "syncReference6";
    private static final String SYNC_REFERENCE_7 = "syncReference7";
    private static final String SYNC_REFERENCE_8 = "syncReference8";
    private static final int NSS_TESTMODE_DISABLED = 0;
    private static final int NSS_TESTMODE_ALWAYS_LOCK_TO_REF = 1;
    private static final int NSS_SYNCH_FEATURE_DEACTIVATED = 0;
    private static final int NSS_SYNCH_FEATURE_ACTIVATED = 1;
    private static final int NSS_FEATURE_STATE_SYNC_ETH_DEACTIVATED = 0;
    private static final int NSS_FEATURE_STATE_SYNC_ETH_ACTIVATED = 1;
    private static final int MO_DATA_REVISION_3_1 = 3000;
    private static final int MO_DATA_REVISION_LATEST = 3000;

    static synchronized SynchronizationMoImpl instance() {
        try {
            if (instance == null) {
                instance = new SynchronizationMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            MessageLog.traceError((Class)SynchronizationMoImpl.class, (String)"Create instance of Synchronization MO failed", (Throwable)moNameAlreadyTakenException);
        }
        return instance;
    }

    private SynchronizationMoImpl() throws MoNameAlreadyTakenException {
        super(((SingletonMoFactory)SynchronizationMoFactory.instance().getMaoContext().getMoAccessor().lookupFactory("TransportNetwork")).getMo(), "Synchronization", syncId, null, SynchronizationMoFactory.instance().getMaoContext());
    }

    synchronized void registerData() {
        if (this.data == null) {
            try {
                TransactionFactory transactionFactory = this.getMaoContext().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
                this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
                this.userLabel = new StringAttribute("userLabel", true, "");
                this.data.registerPersistentAttr((Attribute)this.userLabel);
                this.syncReference1 = new ReferenceAttribute(SYNC_REFERENCE_1, false);
                this.syncReference1.setValue(null);
                this.data.registerPersistentAttr((Attribute)this.syncReference1);
                this.syncReference2 = new ReferenceAttribute(SYNC_REFERENCE_2, false);
                this.syncReference2.setValue(null);
                this.data.registerPersistentAttr((Attribute)this.syncReference2);
                this.syncReference3 = new ReferenceAttribute(SYNC_REFERENCE_3, false);
                this.syncReference3.setValue(null);
                this.data.registerPersistentAttr((Attribute)this.syncReference3);
                this.syncReference4 = new ReferenceAttribute(SYNC_REFERENCE_4, false);
                this.syncReference4.setValue(null);
                this.data.registerPersistentAttr((Attribute)this.syncReference4);
                this.syncReference5 = new ReferenceAttribute(SYNC_REFERENCE_5, false);
                this.syncReference5.setValue(null);
                this.data.registerPersistentAttr((Attribute)this.syncReference5);
                this.syncReference6 = new ReferenceAttribute(SYNC_REFERENCE_6, false);
                this.syncReference6.setValue(null);
                this.data.registerPersistentAttr((Attribute)this.syncReference6);
                this.syncReference7 = new ReferenceAttribute(SYNC_REFERENCE_7, false);
                this.syncReference7.setValue(null);
                this.data.registerPersistentAttr((Attribute)this.syncReference7);
                this.syncReference8 = new ReferenceAttribute(SYNC_REFERENCE_8, false);
                this.syncReference8.setValue(null);
                this.data.registerPersistentAttr((Attribute)this.syncReference8);
                syncFroProxy.registerForNotifications(null, this, 1);
                this.data.setRevision(3000);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
            }
            catch (TransactionRequiredException transactionRequiredException) {
                MessageLog.traceError(this.getClass(), (String)"start of Synchronization failed", (Throwable)transactionRequiredException);
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                MessageLog.traceError(this.getClass(), (String)"start of Synchronization failed", (Throwable)transactionRolledBackException);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"start of Synchronization failed", (Throwable)inactiveTransactionException);
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"start of Synchronization failed", (Throwable)moAccessException);
            }
        }
    }

    public void recover(MoData moData) {
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(SYNC_REFERENCE_1);
        moDataRecoveryHelper.assertAttribute(SYNC_REFERENCE_2);
        moDataRecoveryHelper.assertAttribute(SYNC_REFERENCE_3);
        moDataRecoveryHelper.assertAttribute(SYNC_REFERENCE_4);
        moDataRecoveryHelper.assertAttribute(SYNC_REFERENCE_5);
        moDataRecoveryHelper.assertAttribute(SYNC_REFERENCE_6);
        moDataRecoveryHelper.assertAttribute(SYNC_REFERENCE_7);
        moDataRecoveryHelper.assertAttribute(SYNC_REFERENCE_8);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.syncReference1 = (ReferenceAttribute)moData.getAttribute(SYNC_REFERENCE_1);
        this.syncReference2 = (ReferenceAttribute)moData.getAttribute(SYNC_REFERENCE_2);
        this.syncReference3 = (ReferenceAttribute)moData.getAttribute(SYNC_REFERENCE_3);
        this.syncReference4 = (ReferenceAttribute)moData.getAttribute(SYNC_REFERENCE_4);
        this.syncReference5 = (ReferenceAttribute)moData.getAttribute(SYNC_REFERENCE_5);
        this.syncReference6 = (ReferenceAttribute)moData.getAttribute(SYNC_REFERENCE_6);
        this.syncReference7 = (ReferenceAttribute)moData.getAttribute(SYNC_REFERENCE_7);
        this.syncReference8 = (ReferenceAttribute)moData.getAttribute(SYNC_REFERENCE_8);
        syncFroProxy.registerForNotifications(null, this, 1);
    }

    public void delete(Coordinator coordinator) throws UndeletableMoException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public int getPmFroId(String string, Coordinator coordinator) {
        return 1;
    }

    public String getType() {
        return "Synchronization";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Synchronization", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getDegradationIsFault(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getDegradationIsFault();
    }

    public void setDegradationIsFault(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != 0 && n != 1) {
            throw new ValueOutOfRangeException("degradationIsFault", "Synchronization");
        }
        NssChangeDegrCriteriaRsp nssChangeDegrCriteriaRsp = syncFroProxy.sendChangeDegrCriteriaReq(coordinator.getTransactionID(), n);
        SynchronizationMoImpl.checkSignal((Signal)nssChangeDegrCriteriaRsp);
        int n2 = nssChangeDegrCriteriaRsp.getResult();
        switch (n2) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "SetAttrReq: " + syncFroProxy.getResultMsg(nssChangeDegrCriteriaRsp.getResult()), nssChangeDegrCriteriaRsp.getResult());
            }
        }
        String[] stringArray = new String[]{"degradationIsFault"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getNodeSystemClock(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getNodeSystemClock();
    }

    public boolean getFixedPosition(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getFixedPosition();
    }

    public void setFixedPosition(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        NssSynchSetFixedPositionRsp nssSynchSetFixedPositionRsp = syncFroProxy.sendNssSynchSetFixedPositionRsp(coordinator.getTransactionID(), MaoFroTypeConverter.boolean2int((boolean)bl));
        SynchronizationMoImpl.checkSignal((Signal)nssSynchSetFixedPositionRsp);
        int n = nssSynchSetFixedPositionRsp.getResult();
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "SetFixedPositionAttrReq: " + syncFroProxy.getResultMsg(nssSynchSetFixedPositionRsp.getResult()), nssSynchSetFixedPositionRsp.getResult());
            }
        }
        String[] stringArray = new String[]{"fixedPosition"};
        Object[] objectArray = new Object[]{bl};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getTestMode(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getTestMode();
    }

    public void setTestMode(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != 0 && n != 1) {
            throw new ValueOutOfRangeException("testMode", "Synchronization");
        }
        NssSynchSetTestModeRsp nssSynchSetTestModeRsp = syncFroProxy.sendNssSynchSetTestModeRsp(coordinator.getTransactionID(), n);
        SynchronizationMoImpl.checkSignal((Signal)nssSynchSetTestModeRsp);
        int n2 = nssSynchSetTestModeRsp.getResult();
        switch (n2) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "SetTestModeAttrReq: " + syncFroProxy.getResultMsg(nssSynchSetTestModeRsp.getResult()), nssSynchSetTestModeRsp.getResult());
            }
        }
        String[] stringArray = new String[]{"testMode"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public ManagedObject[] getSyncReference(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        return managedObjectArray;
    }

    public int[] getSyncRefPriority(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = nssReadSyncAttrRsp.getSyncRefActivity();
        int[] nArray2 = nssReadSyncAttrRsp.getFroIds();
        int[] nArray3 = nssReadSyncAttrRsp.getSyncRefPriority();
        int[] nArray4 = nssReadSyncAttrRsp.getFroClassNumbers();
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        int[] nArray5 = this.mapIndexes2Mao(managedObjectArray, nArray, nArray2, nArray4, coordinator);
        int[] nArray6 = new int[managedObjectArray.length];
        for (int i = 0; i < managedObjectArray.length; ++i) {
            nArray6[i] = nArray5[i] == -1 ? 0 : nArray3[nArray5[i]];
        }
        return nArray6;
    }

    public int[] getSyncRefActivity(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = nssReadSyncAttrRsp.getSyncRefActivity();
        int[] nArray2 = nssReadSyncAttrRsp.getFroIds();
        int[] nArray3 = nssReadSyncAttrRsp.getFroClassNumbers();
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        int[] nArray4 = this.mapIndexes2Mao(managedObjectArray, nArray, nArray2, nArray3, coordinator);
        int[] nArray5 = new int[managedObjectArray.length];
        for (int i = 0; i < managedObjectArray.length; ++i) {
            nArray5[i] = nArray4[i] == -1 ? 1 : nArray[nArray4[i]];
        }
        return nArray5;
    }

    public int[] getSyncRefStatus(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = nssReadSyncAttrRsp.getSyncRefActivity();
        int[] nArray2 = nssReadSyncAttrRsp.getFroIds();
        int[] nArray3 = nssReadSyncAttrRsp.getSyncRefStatus();
        int[] nArray4 = nssReadSyncAttrRsp.getFroClassNumbers();
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        int[] nArray5 = this.mapIndexes2Mao(managedObjectArray, nArray, nArray2, nArray4, coordinator);
        int[] nArray6 = new int[managedObjectArray.length];
        for (int i = 0; i < managedObjectArray.length; ++i) {
            nArray6[i] = nArray5[i] == -1 ? 0 : nArray3[nArray5[i]];
        }
        return nArray6;
    }

    public int getNodeGroupRole(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getNodeGroupRole();
    }

    public int getPtpFreqFeatureState(Coordinator coordinator) throws MoAccessException {
        return this.getFeatureStatePtpFreq(coordinator);
    }

    public int getFeatureStatePtpFreq(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getPtpFreqFeatureState();
    }

    public void setPtpFreqFeatureState(int n, Coordinator coordinator) throws MoAccessException {
        this.setFeatureStatePtpFreq(n, coordinator);
    }

    public void setFeatureStatePtpFreq(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != 0 && n != 1) {
            throw new ValueOutOfRangeException("featureStatePtpFreq", "Synchronization");
        }
        NssSynchSetPtpFreqFeatureStateRsp nssSynchSetPtpFreqFeatureStateRsp = syncFroProxy.sendNssSynchSetPtpFreqFeatureStateRsp(coordinator.getTransactionID(), n);
        SynchronizationMoImpl.checkSignal((Signal)nssSynchSetPtpFreqFeatureStateRsp);
        int n2 = nssSynchSetPtpFreqFeatureStateRsp.getResult();
        switch (n2) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "SetPtpFreqFeatureStateAttrReq: " + syncFroProxy.getResultMsg(nssSynchSetPtpFreqFeatureStateRsp.getResult()), nssSynchSetPtpFreqFeatureStateRsp.getResult());
            }
        }
        String[] stringArray = new String[]{"featureStatePtpFreq", "ptpFreqFeatureState"};
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getPtpFreqLicenseState(Coordinator coordinator) throws MoAccessException {
        return this.getLicenseStatePtpFreq(coordinator);
    }

    public int getLicenseStatePtpFreq(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getPtpFreqLicenseState();
    }

    public String getSfnInitializationTime(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getSfnInitializationTime();
    }

    public void setSfnInitializationTime(String string, Coordinator coordinator) throws MoAccessException {
        string = this.validateSfnInitializationTime(string);
        NssSynchSetSfnInitTimeRsp nssSynchSetSfnInitTimeRsp = syncFroProxy.sendNssSynchSetSfnInitTimeRsp(coordinator.getTransactionID(), string);
        SynchronizationMoImpl.checkSignal((Signal)nssSynchSetSfnInitTimeRsp);
        int n = nssSynchSetSfnInitTimeRsp.getResult();
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "setSfnInitializationTimeAttrReq: " + syncFroProxy.getResultMsg(nssSynchSetSfnInitTimeRsp.getResult()), nssSynchSetSfnInitTimeRsp.getResult());
            }
        }
        String[] stringArray = new String[]{"sfnInitializationTime"};
        Object[] objectArray = new Object[]{string};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public String validateSfnInitializationTime(String string) throws TimeAndDateFormatException {
        try {
            new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(string);
        }
        catch (Exception exception) {
            throw new TimeAndDateFormatException("The SfnInitializationTime : " + string + " dosent follow <YYYY-MM-DD>T<hh:mm:ss> format " + "Synchronization");
        }
        return string;
    }

    public int getPtpTimeFeatureState(Coordinator coordinator) throws MoAccessException {
        return this.getFeatureStatePtpTime(coordinator);
    }

    public int getFeatureStatePtpTime(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getPtpTimeFeatureState();
    }

    public void setPtpTimeFeatureState(int n, Coordinator coordinator) throws MoAccessException {
        this.setFeatureStatePtpTime(n, coordinator);
    }

    public void setFeatureStatePtpTime(int n, Coordinator coordinator) throws MoAccessException {
        if (n != 0 && n != 1) {
            throw new ValueOutOfRangeException("featureStatePtpTime", "Synchronization");
        }
        NssSynchSetPtpTimeFeatureStateRsp nssSynchSetPtpTimeFeatureStateRsp = syncFroProxy.sendNssSynchSetPtpTimeFeatureStateRsp(coordinator.getTransactionID(), n);
        SynchronizationMoImpl.checkSignal((Signal)nssSynchSetPtpTimeFeatureStateRsp);
        int n2 = nssSynchSetPtpTimeFeatureStateRsp.getResult();
        switch (n2) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "SetPtpTimeFeatureStateAttrReq: " + syncFroProxy.getResultMsg(nssSynchSetPtpTimeFeatureStateRsp.getResult()), nssSynchSetPtpTimeFeatureStateRsp.getResult());
            }
        }
        String[] stringArray = new String[]{"featureStatePtpTime", "ptpTimeFeatureState"};
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getFeatureStateSyncEth(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getFeatureStateSyncEth();
    }

    public void setFeatureStateSyncEth(int n, Coordinator coordinator) throws MoAccessException {
        if (n != 0 && n != 1) {
            throw new ValueOutOfRangeException("featureStateSyncEth", "Synchronization");
        }
        NssSynchSetSyncEFeatureStateRsp nssSynchSetSyncEFeatureStateRsp = syncFroProxy.sendNssSynchSetSyncEFeatureStateRsp(coordinator.getTransactionID(), n);
        SynchronizationMoImpl.checkSignal((Signal)nssSynchSetSyncEFeatureStateRsp);
        int n2 = nssSynchSetSyncEFeatureStateRsp.getResult();
        switch (n2) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "setFeatureStateSyncEthAttrReq: " + syncFroProxy.getResultMsg(nssSynchSetSyncEFeatureStateRsp.getResult()), nssSynchSetSyncEFeatureStateRsp.getResult());
            }
        }
        String[] stringArray = new String[]{"featureStateSyncEth"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getLicenseStateSyncEth(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getLicenseStateSyncEth();
    }

    public int getPtpTimeLicenseState(Coordinator coordinator) throws MoAccessException {
        return this.getLicenseStatePtpTime(coordinator);
    }

    public int getLicenseStatePtpTime(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getPtpTimeLicenseState();
    }

    public int getClockOperQuality(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getClockOperQuality();
    }

    public int getClockSettledQuality(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getClockSettledQuality();
    }

    public int getPmMaxDelayVariation(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmMaxDelayVariation", coordinator);
    }

    public int getPmHDelayVarBest10Pct(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmHDelayVarBest10Pct", coordinator);
    }

    public int getPmHDelayVarBest1Pct(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmHDelayVarBest1Pct", coordinator);
    }

    public int getPmHDelayVarBest50Pct(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmHDelayVarBest50Pct", coordinator);
    }

    public int getPmTimeHoldoverSec(Coordinator coordinator) throws MoAccessException {
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        return (Integer)pmRequestContextImpl.getPmAttribute("pmTimeHoldoverSec", INTEGER_PM_TYPE);
    }

    public int getPmTimeFreeRunningSec(Coordinator coordinator) throws MoAccessException {
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        return (Integer)pmRequestContextImpl.getPmAttribute("pmTimeFreeRunningSec", INTEGER_PM_TYPE);
    }

    public int getPmFreqHoldoverSec(Coordinator coordinator) throws MoAccessException {
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        return (Integer)pmRequestContextImpl.getPmAttribute("pmFreqHoldoverSec", INTEGER_PM_TYPE);
    }

    public int getPmFreeRunningSec(Coordinator coordinator) throws MoAccessException {
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        return (Integer)pmRequestContextImpl.getPmAttribute("pmFreeRunningSec", INTEGER_PM_TYPE);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return super.getCurrentPmRegister(coordinator);
    }

    public void setSelectionProcessMode(int n, Coordinator coordinator) throws MoAccessException {
        if (n != 0 && n != 1) {
            throw new ValueOutOfRangeException("selectionProcessMode", "Synchronization");
        }
        NssSynchChangeSelectionProcessModeRsp nssSynchChangeSelectionProcessModeRsp = syncFroProxy.sendNssSynchChangeSelectionProcessModeRsp(coordinator.getTransactionID(), n);
        SynchronizationMoImpl.checkSignal((Signal)nssSynchChangeSelectionProcessModeRsp);
        int n2 = nssSynchChangeSelectionProcessModeRsp.getResult();
        switch (n2) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "setSelectionProcessMode: " + syncFroProxy.getResultMsg(nssSynchChangeSelectionProcessModeRsp.getResult()), nssSynchChangeSelectionProcessModeRsp.getResult());
            }
        }
        String[] stringArray = new String[]{"selectionProcessMode"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getSelectionProcessMode(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getProcessMode();
    }

    public int getTelecomStandard(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getTelecomStandard();
    }

    public int getMinQualityLevel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getMinQualityLevel();
    }

    public int getOperQuality(Coordinator coordinator) throws MoAccessException {
        return 21;
    }

    public int[] getOperQualityLevel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = nssReadSyncAttrRsp.getSyncRefActivity();
        int[] nArray2 = nssReadSyncAttrRsp.getFroIds();
        int[] nArray3 = nssReadSyncAttrRsp.getOperQualityLevel();
        int[] nArray4 = nssReadSyncAttrRsp.getFroClassNumbers();
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        int[] nArray5 = this.mapIndexes2Mao(managedObjectArray, nArray, nArray2, nArray4, coordinator);
        int[] nArray6 = new int[managedObjectArray.length];
        for (int i = 0; i < managedObjectArray.length; ++i) {
            nArray6[i] = nArray5[i] == -1 ? 21 : nArray3[nArray5[i]];
        }
        return nArray6;
    }

    public int[] getAdminQuality(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = nssReadSyncAttrRsp.getSyncRefActivity();
        int[] nArray2 = nssReadSyncAttrRsp.getFroIds();
        int[] nArray3 = nssReadSyncAttrRsp.getAdminQuality();
        int[] nArray4 = nssReadSyncAttrRsp.getFroClassNumbers();
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        int[] nArray5 = this.mapIndexes2Mao(managedObjectArray, nArray, nArray2, nArray4, coordinator);
        int[] nArray6 = new int[managedObjectArray.length];
        for (int i = 0; i < managedObjectArray.length; ++i) {
            nArray6[i] = nArray5[i] == -1 ? 16 : nArray3[nArray5[i]];
        }
        return nArray6;
    }

    public int[] getUseReceivedQl(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = nssReadSyncAttrRsp.getSyncRefActivity();
        int[] nArray2 = nssReadSyncAttrRsp.getFroIds();
        int[] nArray3 = nssReadSyncAttrRsp.getUseReceivedQL();
        int[] nArray4 = nssReadSyncAttrRsp.getFroClassNumbers();
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        int[] nArray5 = this.mapIndexes2Mao(managedObjectArray, nArray, nArray2, nArray4, coordinator);
        int[] nArray6 = new int[managedObjectArray.length];
        for (int i = 0; i < managedObjectArray.length; ++i) {
            nArray6[i] = nArray5[i] == -1 ? 0 : nArray3[nArray5[i]];
        }
        return nArray6;
    }

    public Struct getTimeHoldoverAlarmConfig(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getTimeHoldoverAlarmConfig();
    }

    public Struct getFreqHoldoverAlarmConfig(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        return nssReadSyncAttrRsp.getFreqHoldoverAlarmConfig();
    }

    public void setAdminQuality(int[] nArray, Coordinator coordinator) throws MoAccessException {
        throw new OperationNotAllowedException("The attribute adminQuality can be added/changed using actions addSyncRefResourceQl and changeSyncRefResourceQl respectively.", "Synchronization");
    }

    public void setUseReceivedQl(int[] nArray, Coordinator coordinator) throws MoAccessException {
        throw new OperationNotAllowedException("The attribute useReceivedQl can be added/changed using actions addSyncRefResourceQl and changeSyncRefResourceQl respectively.", "Synchronization");
    }

    public void setMinQualityLevel(int n, Coordinator coordinator) throws MoAccessException {
        int n2 = this.getTelecomStandard(coordinator);
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new ValueOutOfRangeException("telecomStandard", "Synchronization");
        }
        boolean bl = this.isValidRangeForQL(n2, n);
        if (!bl) {
            String string = "The minQualityLevel value " + n + " does not fit in the specified range" + " as per telecomStandard value[ " + n2 + " ].";
            throw new ValueOutOfRangeException("minQualityLevel", "Synchronization", string);
        }
        NssSynchChangeMinQualityLevelRsp nssSynchChangeMinQualityLevelRsp = syncFroProxy.sendNssSynchChangeTelecomStdAndQualityLevelRsp(coordinator.getTransactionID(), n2, n);
        SynchronizationMoImpl.checkSignal((Signal)nssSynchChangeMinQualityLevelRsp);
        int n3 = nssSynchChangeMinQualityLevelRsp.getResult();
        switch (n3) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "setMinQualityLevel: " + syncFroProxy.getResultMsg(nssSynchChangeMinQualityLevelRsp.getResult()), nssSynchChangeMinQualityLevelRsp.getResult());
            }
        }
        String[] stringArray = new String[]{"telecomStandard", "minQualityLevel"};
        Object[] objectArray = new Object[]{new Integer(n2), new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void setTelecomStandard(int n, Coordinator coordinator) throws MoAccessException {
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("telecomStandard", "Synchronization");
        }
        int n2 = this.getMinQualityLevel(coordinator);
        NssSynchChangeMinQualityLevelRsp nssSynchChangeMinQualityLevelRsp = syncFroProxy.sendNssSynchChangeTelecomStdAndQualityLevelRsp(coordinator.getTransactionID(), n, n2);
        SynchronizationMoImpl.checkSignal((Signal)nssSynchChangeMinQualityLevelRsp);
        int n3 = nssSynchChangeMinQualityLevelRsp.getResult();
        switch (n3) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "setTelecomStandard: " + syncFroProxy.getResultMsg(nssSynchChangeMinQualityLevelRsp.getResult()), nssSynchChangeMinQualityLevelRsp.getResult());
            }
        }
        String[] stringArray = new String[]{"telecomStandard", "minQualityLevel"};
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void setTimeHoldoverAlarmConfig(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SynchronizationMoImpl.checkTimeHoldoverAlarmConfig(struct);
        boolean bl = (Boolean)struct.getValue("enable");
        int n = (Integer)struct.getValue("filterTime");
        NssSynchSetTimeHoldoverAlarmRsp nssSynchSetTimeHoldoverAlarmRsp = syncFroProxy.sendNssSynchSetTimeHoldoverAlarmReq(coordinator.getTransactionID(), MaoFroTypeConverter.boolean2int((boolean)bl), n);
        SynchronizationMoImpl.checkSignal((Signal)nssSynchSetTimeHoldoverAlarmRsp);
        int n2 = nssSynchSetTimeHoldoverAlarmRsp.getResult();
        switch (n2) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "SetTimeHoldoverAlarmConfig: " + syncFroProxy.getResultMsg(nssSynchSetTimeHoldoverAlarmRsp.getResult()), nssSynchSetTimeHoldoverAlarmRsp.getResult());
            }
        }
        String[] stringArray = new String[]{"TimeHoldoverAlarmConfig"};
        Object[] objectArray = new Object[]{struct};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void setFreqHoldoverAlarmConfig(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SynchronizationMoImpl.checkFreqHoldoverAlarmConfig(struct);
        boolean bl = (Boolean)struct.getValue("enable");
        int n = (Integer)struct.getValue("filterTime");
        NssSynchSetFreqHoldoverAlarmRsp nssSynchSetFreqHoldoverAlarmRsp = syncFroProxy.sendNssSynchSetFreqHoldoverAlarmReq(coordinator.getTransactionID(), MaoFroTypeConverter.boolean2int((boolean)bl), n);
        SynchronizationMoImpl.checkSignal((Signal)nssSynchSetFreqHoldoverAlarmRsp);
        int n2 = nssSynchSetFreqHoldoverAlarmRsp.getResult();
        switch (n2) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "SetFreqHoldoverAlarmConfig: " + syncFroProxy.getResultMsg(nssSynchSetFreqHoldoverAlarmRsp.getResult()), nssSynchSetFreqHoldoverAlarmRsp.getResult());
            }
        }
        String[] stringArray = new String[]{"FreqHoldoverAlarmConfig"};
        Object[] objectArray = new Object[]{struct};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private boolean isValidRangeForQL(int n, int n2) {
        boolean bl = false;
        if (n == 0) {
            if (n2 >= 0 && n2 <= 3 || n2 >= 17 && n2 <= 18) {
                bl = true;
            }
        } else if (n == 1) {
            if (n2 >= 5 && n2 <= 11 || n2 >= 17 && n2 <= 18) {
                bl = true;
            }
        } else if (n == 2 && (n2 >= 14 && n2 <= 15 || n2 >= 17 && n2 <= 18)) {
            bl = true;
        }
        return bl;
    }

    public void actionAddSyncRefResource(ManagedObject managedObject, int n, Coordinator coordinator) throws MoAccessException {
        Object object;
        int n2;
        int n3;
        int n4;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("Synchronization", null);
        }
        if (!(managedObject instanceof SyncReservable)) {
            throw new InvalidReferenceException("Synchronization", (Object)managedObject);
        }
        SyncReservable syncReservable = (SyncReservable)managedObject;
        if (n < 1 || n > 8) {
            throw new PriorityOutOfRangeException("Synchronization", n);
        }
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        boolean bl = false;
        boolean bl2 = false;
        for (n4 = 0; n4 < 8 && !bl && !bl2; ++n4) {
            bl = managedObjectArray[n4] == managedObject;
            bl2 = managedObjectArray[n4] == null;
        }
        --n4;
        if (bl) {
            throw new AlreadyRegisteredException("Synchronization", managedObject);
        }
        if (!bl2) {
            throw new MaxNoOfRefRegisteredException("Synchronization");
        }
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = nssReadSyncAttrRsp.getSyncRefPriority();
        int[] nArray2 = nssReadSyncAttrRsp.getFroIds();
        int[] nArray3 = nssReadSyncAttrRsp.getFroClassNumbers();
        boolean bl3 = false;
        for (n3 = 0; n3 < 8 && !bl3; ++n3) {
            bl3 = nArray[n3] == n;
        }
        --n3;
        if (bl3) {
            throw new PriorityAlreadyInUseException("Synchronization", n);
        }
        int n5 = this.moTypeName2FroClassNo(syncReservable);
        PlugInUnitMo plugInUnitMo = null;
        SlotMoInternal slotMoInternal = null;
        int n6 = syncReservable.getFroId(coordinator);
        boolean bl4 = false;
        int n7 = 0;
        for (n2 = 0; n2 < 8 && !bl4; ++n2) {
            bl4 = nArray2[n2] == n6 && nArray3[n2] == n5;
        }
        --n2;
        if (bl4) {
            throw new NotUniqueFroIdException("Synchronization", n6);
        }
        syncReservable.syncReserve(coordinator, this);
        if (n5 == 7) {
            object = PiuUtils.findPiuParent((ManagedObject)managedObject);
            if (object instanceof PiuDeviceMo) {
                plugInUnitMo = (PlugInUnitMo)object.getParent();
                slotMoInternal = (SlotMoInternal)plugInUnitMo.getParent();
                n7 = slotMoInternal.getAsciPortNumber(coordinator);
            } else if (object instanceof PlugInUnitMo) {
                slotMoInternal = (SlotMoInternal)object.getParent();
                n7 = slotMoInternal.getAsciPortNumber(coordinator);
            } else {
                throw new InvalidReferenceException("Synchronization", (Object)syncReservable);
            }
        }
        object = syncFroProxy.sendRefRegisterReq(coordinator.getTransactionID(), n5, n6, n, n7, this.isReservedByAnotherMO(managedObject, coordinator));
        SynchronizationMoImpl.checkSignal((Signal)object);
        int n8 = object.getResult();
        switch (n8) {
            case 0: {
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                managedObjectArray[n4] = managedObject;
                this.putRefArray(managedObjectArray);
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "ActionAddSyncRefResourceReq: " + syncFroProxy.getResultMsg(object.getResult()), object.getResult());
            }
        }
        Object[] objectArray = new Object[]{this.getSyncReference(coordinator), this.convertIntToObjArray(this.getSyncRefPriority(coordinator))};
        String[] stringArray = new String[]{"syncReference", "syncRefPriority"};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private int isReservedByAnotherMO(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray;
        int n = 0;
        if (managedObject instanceof EthernetPortRef && (managedObjectArray = ((EthernetPortRef)managedObject).getReservedBy(coordinator)) != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (managedObjectArray[i].getType().equalsIgnoreCase("Synchronization")) continue;
                n = 1;
            }
        }
        return n;
    }

    public void actionRemoveSyncRefResource(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("Synchronization", null);
        }
        if (!(managedObject instanceof SyncReservable)) {
            throw new InvalidReferenceException("Synchronization", (Object)managedObject);
        }
        SyncReservable syncReservable = (SyncReservable)managedObject;
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        boolean bl = false;
        for (n = 0; n < 8 && !bl; ++n) {
            bl = managedObjectArray[n] == managedObject;
        }
        --n;
        if (!bl) {
            throw new NotRegisteredException("Synchronization", managedObject);
        }
        syncReservable.syncRelease(coordinator, this);
        int n2 = syncReservable.getFroId(coordinator);
        int n3 = this.moTypeName2FroClassNo(syncReservable);
        NssSyncRefDeregisterRsp nssSyncRefDeregisterRsp = syncFroProxy.sendRefDeregisterReq(coordinator.getTransactionID(), n3, n2);
        SynchronizationMoImpl.checkSignal((Signal)nssSyncRefDeregisterRsp);
        int n4 = nssSyncRefDeregisterRsp.getResult();
        switch (n4) {
            case 0: {
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                managedObjectArray[n] = null;
                this.putRefArray(managedObjectArray);
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "ActionRemoveSyncRefResourceReq: " + syncFroProxy.getResultMsg(nssSyncRefDeregisterRsp.getResult()), nssSyncRefDeregisterRsp.getResult());
            }
        }
        Object[] objectArray = new Object[]{this.getSyncReference(coordinator), this.convertIntToObjArray(this.getSyncRefPriority(coordinator))};
        String[] stringArray = new String[]{"syncReference", "syncRefPriority"};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void actionChangeSyncRefPriority(ManagedObject managedObject, int n, Coordinator coordinator) throws MoAccessException {
        int n2;
        int n3;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("Synchronization", null);
        }
        if (!(managedObject instanceof SyncReservable)) {
            throw new InvalidReferenceException("Synchronization", (Object)managedObject);
        }
        SyncReservable syncReservable = (SyncReservable)managedObject;
        if (n < 1 || n > 8) {
            throw new PriorityOutOfRangeException("Synchronization", n);
        }
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        boolean bl = false;
        for (n3 = 0; n3 < 8 && !bl; ++n3) {
            bl = managedObjectArray[n3] == managedObject;
        }
        --n3;
        if (!bl) {
            throw new NotRegisteredException("Synchronization", managedObject);
        }
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = nssReadSyncAttrRsp.getSyncRefPriority();
        boolean bl2 = false;
        for (n2 = 0; n2 < 8 && !bl2; ++n2) {
            bl2 = nArray[n2] == n;
        }
        --n2;
        if (bl2) {
            throw new PriorityAlreadyInUseException("Synchronization", n);
        }
        int n4 = syncReservable.getFroId(coordinator);
        int n5 = this.moTypeName2FroClassNo(syncReservable);
        NssSyncPriorityChangeRsp nssSyncPriorityChangeRsp = syncFroProxy.sendSyncPriorityChangeReq(coordinator.getTransactionID(), n5, n4, n);
        SynchronizationMoImpl.checkSignal((Signal)nssSyncPriorityChangeRsp);
        int n6 = nssSyncPriorityChangeRsp.getResult();
        switch (n6) {
            case 0: {
                String[] stringArray = new String[]{"syncRefPriority"};
                Object[] objectArray = new Object[]{this.convertIntToObjArray(this.getSyncRefPriority(coordinator))};
                notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "ActionChangeSyncRefPriorityReq: " + syncFroProxy.getResultMsg(nssSyncPriorityChangeRsp.getResult()), nssSyncPriorityChangeRsp.getResult());
            }
        }
    }

    private Integer[] convertIntToObjArray(int[] nArray) {
        int n = nArray.length;
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            integerArray[i] = new Integer(n2);
        }
        return integerArray;
    }

    public void actionResetLossOfTracking(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("Synchronization", null);
        }
        if (!(managedObject instanceof SyncReservable)) {
            throw new InvalidReferenceException("Synchronization", (Object)managedObject);
        }
        SyncReservable syncReservable = (SyncReservable)managedObject;
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        boolean bl = false;
        for (n = 0; n < 8 && !bl; ++n) {
            bl = managedObjectArray[n] == managedObject;
        }
        --n;
        if (!bl) {
            throw new NotRegisteredException("Synchronization", managedObject);
        }
        int n2 = syncReservable.getFroId(coordinator);
        int n3 = this.moTypeName2FroClassNo(syncReservable);
        NssResetLossOfTrackingRsp nssResetLossOfTrackingRsp = syncFroProxy.sendResetLossOfTrackingReq(coordinator.getTransactionID(), n3, n2);
        SynchronizationMoImpl.checkSignal((Signal)nssResetLossOfTrackingRsp);
        int n4 = nssResetLossOfTrackingRsp.getResult();
        switch (n4) {
            case 0: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "ActionResetLossOfTrackingReq: " + syncFroProxy.getResultMsg(nssResetLossOfTrackingRsp.getResult()), nssResetLossOfTrackingRsp.getResult());
            }
        }
    }

    public void actionAddSyncRefResourceQl(ManagedObject managedObject, int n, int n2, int n3, Coordinator coordinator) throws MoAccessException {
        Object object;
        int n4;
        int n5;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("Synchronization", null);
        }
        if (!(managedObject instanceof SyncReservable)) {
            throw new InvalidReferenceException("Synchronization", (Object)managedObject);
        }
        SyncReservable syncReservable = (SyncReservable)managedObject;
        if (n < 1 || n > 8) {
            throw new PriorityOutOfRangeException("Synchronization", n);
        }
        int n6 = this.getTelecomStandard(coordinator);
        if (!this.isValidRangeForQL(n6, n3)) {
            String string = "The adminQuality value " + n3 + " does not fit in the specified range" + " as per telecomStandard value[ " + n6 + " ].";
            throw new ValueOutOfRangeException("adminQuality", "Synchronization", string);
        }
        if (n2 != 1 && n2 != 0) {
            throw new ValueOutOfRangeException("useReceivedQl", "Synchronization");
        }
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        boolean bl = false;
        boolean bl2 = false;
        for (n5 = 0; n5 < 8 && !bl && !bl2; ++n5) {
            bl = managedObjectArray[n5] == managedObject;
            bl2 = managedObjectArray[n5] == null;
        }
        --n5;
        if (bl) {
            throw new AlreadyRegisteredException("Synchronization", managedObject);
        }
        if (!bl2) {
            throw new MaxNoOfRefRegisteredException("Synchronization");
        }
        NssReadSyncAttrRsp nssReadSyncAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = nssReadSyncAttrRsp.getSyncRefPriority();
        int[] nArray2 = nssReadSyncAttrRsp.getFroIds();
        int[] nArray3 = nssReadSyncAttrRsp.getFroClassNumbers();
        boolean bl3 = false;
        for (n4 = 0; n4 < 8 && !bl3; ++n4) {
            bl3 = nArray[n4] == n;
        }
        --n4;
        if (bl3) {
            throw new PriorityAlreadyInUseException("Synchronization", n);
        }
        int n7 = this.moTypeName2FroClassNo(syncReservable);
        PlugInUnitMo plugInUnitMo = null;
        SlotMoInternal slotMoInternal = null;
        int n8 = syncReservable.getFroId(coordinator);
        int n9 = 0;
        int n10 = 0;
        boolean bl4 = false;
        if (n7 != 7 && n7 != 5 && n7 != 4 && n7 != 3 && n7 != 6 && n7 != 10 && n7 != 1) {
            MessageLog.traceError(this.getClass(), (String)"Action addSyncRefResourceQl can be performed on references from PacketFrequencySyncRef, PacketTimeSyncRef, GpsSyncRef, HptsiSyncRef, TuSyncRef, EthernetPort and GigaBitEthernet MO's only.");
            throw new InvalidReferenceException("Synchronization", (Object)managedObject);
        }
        if (n7 == 1 && n2 == 1) {
            throw new OperationNotAllowedException("TuSyncRef cannot have value true for useReceivedQl", "Synchronization");
        }
        if (n7 == 7) {
            object = PiuUtils.findPiuParent((ManagedObject)managedObject);
            if (object instanceof PiuDeviceMo) {
                plugInUnitMo = (PlugInUnitMo)object.getParent();
                slotMoInternal = (SlotMoInternal)plugInUnitMo.getParent();
                n10 = slotMoInternal.getAsciPortNumber(coordinator);
            } else if (object instanceof PlugInUnitMo) {
                slotMoInternal = (SlotMoInternal)object.getParent();
                n10 = slotMoInternal.getAsciPortNumber(coordinator);
            } else {
                throw new InvalidReferenceException("Synchronization", (Object)syncReservable);
            }
        }
        while (n9 < 8 && !bl4) {
            bl4 = nArray2[n9] == n8 && nArray3[n9] == n7;
            ++n9;
        }
        --n9;
        if (bl4) {
            throw new NotUniqueFroIdException("Synchronization", n8);
        }
        syncReservable.syncReserve(coordinator, this);
        object = syncFroProxy.sendRefRegisterQlRefReq(coordinator.getTransactionID(), n7, n8, n, n10, n2, n3, this.isReservedByAnotherMO(managedObject, coordinator));
        SynchronizationMoImpl.checkSignal((Signal)object);
        int n11 = object.getResult();
        switch (n11) {
            case 0: {
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                managedObjectArray[n5] = managedObject;
                this.putRefArray(managedObjectArray);
                break;
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "ActionAddSyncRefResourceQlReq: " + syncFroProxy.getResultMsg(object.getResult()), object.getResult());
            }
        }
        Object[] objectArray = new Object[]{this.getSyncReference(coordinator), this.convertIntToObjArray(this.getSyncRefPriority(coordinator)), new Integer(n2), new Integer(n3)};
        String[] stringArray = new String[]{"syncReference", "syncRefPriority", "useReceivedQl", "adminQuality"};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void actionChangeSyncRefResourceQl(int n, ManagedObject managedObject, int n2, Coordinator coordinator) throws MoAccessException {
        int n3;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("Synchronization", null);
        }
        if (!(managedObject instanceof SyncReservable)) {
            throw new InvalidReferenceException("Synchronization", (Object)managedObject);
        }
        int n4 = this.getTelecomStandard(coordinator);
        if (!this.isValidRangeForQL(n4, n2)) {
            String string = "The adminQuality value " + n2 + " does not fit in the specified range" + " as per telecomStandard value[ " + n4 + " ].";
            throw new ValueOutOfRangeException("adminQuality", "Synchronization", string);
        }
        if (n != 1 && n != 0) {
            throw new ValueOutOfRangeException("useReceivedQl", "Synchronization");
        }
        SyncReservable syncReservable = (SyncReservable)managedObject;
        ManagedObject[] managedObjectArray = this.retrieveRefArray(coordinator);
        boolean bl = false;
        for (n3 = 0; n3 < 8 && !bl; ++n3) {
            bl = managedObjectArray[n3] == managedObject;
        }
        --n3;
        if (!bl) {
            throw new NotRegisteredException("Synchronization", managedObject);
        }
        int n5 = syncReservable.getFroId(coordinator);
        int n6 = this.moTypeName2FroClassNo(syncReservable);
        if (n6 != 7 && n6 != 5 && n6 != 4 && n6 != 3 && n6 != 6 && n6 != 10 && n6 != 1) {
            MessageLog.traceError(this.getClass(), (String)"Action changeSyncRefResourceQl can be performed on references from PacketFrequencySyncRef, PacketTimeSyncRef, GpsSyncRef, HptsiSyncRef, TuSyncRef, EthernetPort and GigaBitEthernet MO's only.");
            throw new InvalidReferenceException("Synchronization", (Object)managedObject);
        }
        if (n6 == 1 && n == 1) {
            throw new OperationNotAllowedException("TuSyncRef cannot have value true for useReceivedQl", "Synchronization");
        }
        NssSynchChangeSyncRefResourceQualityRsp nssSynchChangeSyncRefResourceQualityRsp = syncFroProxy.sendChangeSyncRefResourceQlReq(coordinator.getTransactionID(), n6, n5, n, n2);
        SynchronizationMoImpl.checkSignal((Signal)nssSynchChangeSyncRefResourceQualityRsp);
        int n7 = nssSynchChangeSyncRefResourceQualityRsp.getResult();
        switch (n7) {
            case 0: {
                String[] stringArray = new String[]{"syncReference", "useReceivedQl", "adminQuality"};
                Object[] objectArray = new Object[]{managedObject, new Integer(n), new Integer(n2)};
                notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
                break;
            }
            case 13: {
                throw new OperationNotAllowedException("The action changeSyncRefResourceQl cannot be performed as reference " + managedObject + " is not added using action addSyncRefResourceQl.", "Synchronization");
            }
            default: {
                throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "ActionChangeSyncRefResourceQlReq: " + syncFroProxy.getResultMsg(nssSynchChangeSyncRefResourceQualityRsp.getResult()), nssSynchChangeSyncRefResourceQualityRsp.getResult());
            }
        }
    }

    private void putRefArray(ManagedObject[] managedObjectArray) {
        this.syncReference1.setValue(managedObjectArray[0]);
        this.syncReference2.setValue(managedObjectArray[1]);
        this.syncReference3.setValue(managedObjectArray[2]);
        this.syncReference4.setValue(managedObjectArray[3]);
        this.syncReference5.setValue(managedObjectArray[4]);
        this.syncReference6.setValue(managedObjectArray[5]);
        this.syncReference7.setValue(managedObjectArray[6]);
        this.syncReference8.setValue(managedObjectArray[7]);
    }

    private ManagedObject[] retrieveRefArray(Coordinator coordinator) throws MoRemovedException {
        ManagedObject[] managedObjectArray = new ManagedObject[]{this.syncReference1.getValue(coordinator), this.syncReference2.getValue(coordinator), this.syncReference3.getValue(coordinator), this.syncReference4.getValue(coordinator), this.syncReference5.getValue(coordinator), this.syncReference6.getValue(coordinator), this.syncReference7.getValue(coordinator), this.syncReference8.getValue(coordinator)};
        return managedObjectArray;
    }

    private int[] mapIndexes2Mao(ManagedObject[] managedObjectArray, int[] nArray, int[] nArray2, int[] nArray3, Coordinator coordinator) throws MoAccessException {
        int[] nArray4 = new int[managedObjectArray.length];
        int[] nArray5 = new int[managedObjectArray.length];
        int[] nArray6 = new int[managedObjectArray.length];
        block0: for (int i = 0; i < managedObjectArray.length; ++i) {
            boolean bl;
            if (managedObjectArray[i] instanceof SyncReservable) {
                SyncReservable syncReservable = (SyncReservable)managedObjectArray[i];
                bl = true;
                nArray4[i] = syncReservable.getFroId(coordinator);
                nArray5[i] = this.moTypeName2FroClassNo(syncReservable);
            } else {
                bl = false;
            }
            if (bl) {
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray2[j] != nArray4[i] || nArray3[j] != nArray5[i] || nArray[j] == 0) continue;
                    nArray6[i] = j;
                    continue block0;
                }
                continue;
            }
            nArray6[i] = -1;
        }
        return nArray6;
    }

    private NssReadSyncAttrRsp retrieveFroAttributes(Coordinator coordinator) throws FroNotAccessibleException, TransactionRequiredException, MoAccessException {
        NssReadSyncAttrRsp nssReadSyncAttrRsp = coordinator == null ? syncFroProxy.sendReadAttributesReq(0) : syncFroProxy.sendReadAttributesReq(coordinator.getTransactionID());
        SynchronizationMoImpl.checkSignal((Signal)nssReadSyncAttrRsp);
        int n = nssReadSyncAttrRsp.getResult();
        switch (n) {
            case 0: {
                return nssReadSyncAttrRsp;
            }
        }
        throw new FroRequestFailedException("Synchronization", "NssSynchronizationFro-LSV184", "GetAttrReq: " + syncFroProxy.getResultMsg(nssReadSyncAttrRsp.getResult()), nssReadSyncAttrRsp.getResult());
    }

    private static void checkTimeHoldoverAlarmConfig(Struct struct) throws MoAccessException {
        if (!(struct.getValue("enable") instanceof Boolean)) {
            throw new WrongAttributeTypeException("enable", "Synchronization");
        }
        if (!(struct.getValue("filterTime") instanceof Integer)) {
            throw new WrongAttributeTypeException("filterTime", "Synchronization");
        }
        int n = (Integer)struct.getValue("filterTime");
        if (n < 1 || n > 15) {
            throw new ValueOutOfRangeException("filterTime", "Synchronization");
        }
    }

    private static void checkFreqHoldoverAlarmConfig(Struct struct) throws MoAccessException {
        if (!(struct.getValue("enable") instanceof Boolean)) {
            throw new WrongAttributeTypeException("enable", "Synchronization");
        }
        if (!(struct.getValue("filterTime") instanceof Integer)) {
            throw new WrongAttributeTypeException("filterTime", "Synchronization");
        }
        int n = (Integer)struct.getValue("filterTime");
        if (n < 0 || n > 100) {
            throw new ValueOutOfRangeException("filterTime", "Synchronization");
        }
    }

    private static void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal == null) {
            throw new FroNotAccessibleException("Synchronization", "NssSynchronizationFro-LSV184");
        }
    }

    private int moTypeName2FroClassNo(SyncReservable syncReservable) throws MoAccessException {
        int n = 0;
        if (syncReservable instanceof TuSyncRefMo) {
            n = 1;
        } else if (syncReservable instanceof IpSyncReference) {
            n = 2;
        } else if (syncReservable instanceof PDHSyncReference) {
            n = 0;
        } else if (syncReservable instanceof GpsSyncRefMo) {
            n = 3;
        } else if (syncReservable instanceof PacketTimeSyncRefMo) {
            n = 4;
        } else if (syncReservable instanceof PacketFrequencySyncRefMo) {
            n = 5;
        } else if (syncReservable instanceof HptsiSyncRefMo) {
            n = 6;
        } else if (syncReservable instanceof GigabitEthernetRef) {
            n = 7;
        } else if (syncReservable instanceof GpsOutSyncLinkMo) {
            n = 8;
        } else if (syncReservable instanceof EthernetPortRef) {
            n = 10;
        } else {
            throw new InvalidReferenceException("Synchronization", (Object)syncReservable);
        }
        return n;
    }
}

