/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import java.util.Arrays;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.util.library.Lib;

public class AutoConfigurationAlarm {
    private AdditionalInfo[] previousAddInfo = null;

    public void raiseAlarm(AdditionalInfo[] additionalInfoArray, ManagedObject managedObject) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"raiseAlarm(AdditionalInfo[] additionalInfo, ManagedObject mo)", (String)("additionalInfo: " + Lib.toString((AdditionalInfo[])additionalInfoArray) + "\n\tmo: " + managedObject));
        if (Arrays.equals(this.previousAddInfo, additionalInfoArray)) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"Ignored because an Auto-configuration Alarm with same additionalInfo raised already.", (String)("ManagedObject: " + managedObject));
        } else {
            if (this.previousAddInfo != null) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"Clear the previous alarm.", (String)("ManagedObject: " + managedObject));
                AlarmManager.getReporter().ceaseAlarm(7, managedObject);
            }
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"Raise the alarm.", (String)("ManagedObject: " + managedObject));
            AlarmManager.getReporter().raiseAlarm(7, managedObject, "", "", additionalInfoArray, null, false, "");
            this.previousAddInfo = (AdditionalInfo[])additionalInfoArray.clone();
        }
    }

    public void clearAlarm(ManagedObject managedObject) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"clearAlarm(ManagedObject mo)", (String)("ManagedObject: " + managedObject));
        AlarmManager.getReporter().ceaseAlarm(7, managedObject);
        this.previousAddInfo = null;
    }
}

