/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import se.ericsson.cello.equipment.ShelfMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class ShelfMoImpl
extends ManagedObjectBase
implements ShelfMo {
    private MoData data;
    private static final int VERTICAL = 0;
    private static final int HORIZONTAL = 1;
    private static final int CONTENT_MIN_LENGTH = 0;
    private static final int CONTENT_MAX_LENGTH = 36;
    private static final int POSITION_MIN_LENGTH = 0;
    private static final int POSITION_MAX_LENGTH = 3;
    private static final int MO_DATA_REVISION_7 = 7000;
    private static final int MO_DATA_REVISION_LATEST = 7000;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Shelf", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Equipment");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Shelf", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"noOfPositions", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)20, (String)"Shelf");
        String string3 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"content", (AttrList)attrList, (boolean)false, (String)"", (String)"Shelf", (int)36, (int)0);
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"positionRef", (AttrList)attrList, (boolean)false, (String)"Shelf");
        String string4 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"position", (AttrList)attrList, (boolean)false, (String)"", (String)"Shelf", (int)3, (int)0);
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"boardOrientation", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"Shelf");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Shelf");
        return new ShelfMoImpl(managedObject, string, string2, n, string3, managedObject3, string4, n2, coordinator);
    }

    private ShelfMoImpl(ManagedObject managedObject, String string, String string2, int n, String string3, ManagedObject managedObject2, String string4, int n2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Shelf", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        if (managedObject2 != null) {
            if (managedObject2 instanceof Reservable) {
                ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
            } else {
                throw new WrongAttributeTypeException("positionRef", "Shelf");
            }
        }
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("positionRef", true, managedObject2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("boardOrientation", true, n2));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("content", true, string3));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("noOfPositions", true, n));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("position", false, string4));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.setRevision(7000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public ShelfMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(7000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("positionRef");
        moDataRecoveryHelper.assertAttribute("boardOrientation");
        moDataRecoveryHelper.assertAttribute("content");
        moDataRecoveryHelper.assertAttribute("noOfPositions");
        moDataRecoveryHelper.assertAttribute("position");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (((ManagedObject[])this.getAttribute("reservedBy", coordinator)).length != 0) {
            throw new MoReservedNotDeletableException("Shelf");
        }
        ManagedObject managedObject = (ManagedObject)this.getAttribute("positionRef", coordinator);
        if (managedObject != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public int getBoardOrientation(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("boardOrientation", coordinator);
    }

    public String getContent(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("content", coordinator);
    }

    public int getNoOfPositions(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("noOfPositions", coordinator);
    }

    public String getPosition(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("position", coordinator);
    }

    public ManagedObject getPositionRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("positionRef", coordinator);
    }

    public String getShelfId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ShelfId", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ShelfId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("boardOrientation")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("boardOrientation")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("content")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("content")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("noOfPositions")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("noOfPositions")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("position")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("position")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("positionRef")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("positionRef")).getValue(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Shelf");
        }
        return objectArray;
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public void setBoardOrientation(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("boardOrientation", new Integer(n), coordinator);
    }

    public void setContent(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("content", string, coordinator);
    }

    public void setNoOfPositions(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("noOfPositions", new Integer(n), coordinator);
    }

    public void setPositionRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("positionRef", managedObject, coordinator);
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? ShelfMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "Shelf");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"Shelf", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("content")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? ShelfMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("content", "Shelf");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"content", (String)"Shelf", (int)36, (int)0);
                ((StringAttribute)this.data.getAttribute("content")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("noOfPositions")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? ShelfMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("noOfPositions", "Shelf");
                }
                int n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"noOfPositions", (int)n, (int)0, (int)20, (String)"Shelf");
                ((IntegerAttribute)this.data.getAttribute("noOfPositions")).setValue(n);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("boardOrientation")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? ShelfMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("boardOrientation", "Shelf");
                }
                int n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"boardOrientation", (int)n, (int)0, (int)1, (String)"Shelf");
                ((IntegerAttribute)this.data.getAttribute("boardOrientation")).setValue(n);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("positionRef")) {
                if (objectArray[i] != null && !(objectArray[i] instanceof Reservable)) {
                    throw new WrongAttributeTypeException("positionRef", "Shelf");
                }
                ManagedObject managedObject = (ManagedObject)this.getAttribute("positionRef", coordinator);
                ManagedObject managedObject2 = (ManagedObject)objectArray[i];
                if (managedObject2 == null) {
                    if (managedObject != null) {
                        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                    }
                } else {
                    ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
                    if (managedObject != null) {
                        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                    }
                }
                ((ReferenceAttribute)this.data.getAttribute("positionRef")).setValue(managedObject2);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Shelf");
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public String getType() {
        return "Shelf";
    }
}

