/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import enea.ose.system.UnlinkedSignal;
import java.util.ArrayList;
import se.ericsson.cello.equipment.AppUnitMoImpl;
import se.ericsson.cello.equipment.AutoConfigurationAlarm;
import se.ericsson.cello.equipment.CaxFanUnitMo;
import se.ericsson.cello.equipment.EquipmentMoImpl;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.InterPiuLinkMo;
import se.ericsson.cello.equipment.OperationalProdData;
import se.ericsson.cello.equipment.PfmUnitMoImpl;
import se.ericsson.cello.equipment.PlugInUnitMoImpl;
import se.ericsson.cello.equipment.ReliableProgramUniterMarker;
import se.ericsson.cello.equipment.SlotMoImplInterface;
import se.ericsson.cello.equipment.SubrackMoImpl;
import se.ericsson.cello.equipment.SwAllocationMarker;
import se.ericsson.cello.equipment.eqaccess.ServiceControllerAccess;
import se.ericsson.cello.equipment.eqaccess.UpgradeBackupServiceInformation;
import se.ericsson.cello.equipment.fropxy.CmaSlotNotifyInd;
import se.ericsson.cello.equipment.fropxy.OsaSlotMgmntProxy;
import se.ericsson.cello.equipment.fropxy.OsaSlotNotifyInd;
import se.ericsson.cello.equipment.intma.AutoCreateMosAccess;
import se.ericsson.cello.equipment.suaccess.SubrackMoSU_Access;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandlerFactoryImpl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.SlotBuildIF;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConvertWeekOfYearToDate;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.util.library.Lib;

public class SlotMoImpl
extends CelloMao
implements SlotMoImplInterface {
    private IntegerAttribute resourceId;
    private StringAttribute userLabel;
    private IntegerAttribute upgradeGroupId;
    private StringAttribute upgradeGroupTypeName;
    private SequenceAttribute reservedBy;
    private ReferenceAttribute activeSwAllocation;
    private MoData data;
    private String previousSerialNo = "";
    private String serialNo = "";
    private static final int FIRST_ATTEPMT = 1;
    private static OsaSlotMgmntProxy roProxy = OsaSlotMgmntProxy.instance();
    private MaoFroIndicationHandler indicationHandler = MaoFroIndicationHandlerFactoryImpl.instance().create("CelloSlot", 1539);
    private FroProxy proxy = null;
    private AutoConfigurationAlarm anAutoConfigurationAlarm = new AutoConfigurationAlarm();
    private Coordinator coordinator = null;
    private static String[] fruProductDataNames = new String[]{"productName", "productNumber", "productRevision", "serialNumber", "productionDate"};
    private static String[] ATTRIBUTES_TO_REQUEST_FROM_FRO = new String[]{"productData", "slotNumber", "slotState", "asciportnumber", "integratedHardware", "fruProductData"};
    private static final String RESOURCE_ID = "resourceId";
    public static final String UPGRADE_GROUP_ID = "upgradeGroupId";
    public static final String UPGRADE_GROUP_TYPE_NAME = "upgradeGroupTypeName";
    public static final String UPGRADE_SERVICE_NAME = "SystemUpgrade";
    public static final String UPGRADE_SUB_FUNCTION = "Upgrade";
    static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2", "SU_3"};
    private static final int MO_REVISION = 1;
    private static final int MO_DATA_REVISION_31 = 3000;
    private static final int MO_DATA_REVISION_32 = 3001;
    private static final int MO_DATA_REVISION_7 = 7000;
    private static final int MO_DATA_REVISION_9 = 9000;
    private static final int MO_DATA_REVISION_LATEST = 9000;

    static SlotMoImpl create(int n, ManagedObject managedObject, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        UpgradeTrace.debug((Class)SlotMoImpl.class, (int)70, (String)"create(int slotNumber, ManagedObject parent, Coordinator c)", (String)("slotNumber: " + n + "\n\tparent: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Subrack");
        String string = "";
        String string2 = n + "";
        return new SlotMoImpl(string2, managedObject, n, string, coordinator, initialMaoContext, froProxy);
    }

    private SlotMoImpl(String string, ManagedObject managedObject, int n, String string2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        super(managedObject, "Slot", string, coordinator, initialMaoContext);
        this.proxy = froProxy;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"SlotMoImpl(String slotId, ManagedObject parent, int slotNumber, String usLabel, Coordinator c)", (String)("slotId: " + string + "\n\tparent: " + managedObject + "\n\tslotNumber: " + n + "\n\tusLabel: " + string2 + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        AttrListImpl attrListImpl = new AttrListImpl();
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl((AttrList)attrListImpl, coordinator);
        SubrackMoImpl subrackMoImpl = (SubrackMoImpl)managedObject;
        long l = subrackMoImpl.getResourceId(coordinator).longValue();
        setRequestContextImpl.addParameter(froProxy, (Parameter)new UnsignedIntParameter("clientRef", 0L));
        setRequestContextImpl.addParameter(froProxy, (Parameter)new UnsignedIntParameter("srInstanceId", l));
        setRequestContextImpl.addParameter(froProxy, (Parameter)new UnsignedIntParameter("slotNumber", (long)n));
        FroData froData = setRequestContextImpl.sendCreateRequest(froProxy);
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        int n2 = froData.getFroId();
        this.initData(n, n2, string2, null, coordinator);
        roProxy.registerForNotifications(coordinator, this, n2);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n2);
        ProductRepository.instance().registerHw((HardwareProductData)this, coordinator);
        EquipmentMoImpl.instance().actionTriggerLastHwPiChange(coordinator);
        this.getMaoContext().getServiceRepository().addService((Object)this, SlotBuildIF.class, coordinator);
    }

    SlotMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException, TransactionRequiredException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.proxy = froProxy;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"SlotMoImpl(MoData recoveredData)", (String)("recoveredData: " + moData));
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute(RESOURCE_ID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute(UPGRADE_GROUP_ID);
        moDataRecoveryHelper.assertAttribute(UPGRADE_GROUP_TYPE_NAME);
        moDataRecoveryHelper.assertAttribute("activeSwAllocation");
        this.resourceId = (IntegerAttribute)moData.getAttribute(RESOURCE_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.reservedBy = (SequenceAttribute)moData.getAttribute("reservedBy");
        this.upgradeGroupId = (IntegerAttribute)moData.getAttribute(UPGRADE_GROUP_ID);
        this.upgradeGroupTypeName = (StringAttribute)moData.getAttribute(UPGRADE_GROUP_TYPE_NAME);
        this.activeSwAllocation = (ReferenceAttribute)moData.getAttribute("activeSwAllocation");
        roProxy.registerForNotifications(null, this, this.resourceId.getValue(null));
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, this.resourceId.getValue(null));
        ProductRepository.instance().registerHw((HardwareProductData)this);
        this.getMaoContext().getServiceRepository().addService((Object)this, SlotBuildIF.class, null);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteTheSlot(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"deleteTheSlot( Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.reservedBy.isEmpty()) {
            throw new MoReservedNotDeletableException((ManagedObject)this, this.getReservedBy(coordinator)[0]);
        }
        this.proxy.delete(coordinator, this.resourceId.getValue(coordinator), null);
        roProxy.deregisterForNotifications(coordinator, this.resourceId.getValue(coordinator));
        ProductRepository.instance().deregisterHw((HardwareProductData)this, coordinator);
        EquipmentMoImpl.instance().actionTriggerLastHwPiChange(coordinator);
        this.getMaoContext().getServiceRepository().removeService((Object)this, SlotBuildIF.class, coordinator);
        this.data.delete(coordinator);
        super.delete(coordinator);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"deleteMo(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoIterator moIterator = this.getChildren();
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                PlugInUnitMoImpl plugInUnitMoImpl = (PlugInUnitMoImpl)moIterator.nextMo();
                plugInUnitMoImpl.delete(coordinator);
            }
        }
        this.deleteTheSlot(coordinator);
    }

    public String getType() {
        return "Slot";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUserLabel(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setUserLabel(String str, Coordinator context)", (String)("str: " + string + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getSlotState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSlotState(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return (Integer)this.getAttribute("slotState", coordinator);
    }

    public int getSlotNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSlotNumber(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return (Integer)this.getAttribute("slotNumber", coordinator);
    }

    public ManagedObject getActiveSwAllocation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getActiveSwAllocation(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return (ManagedObject)this.getAttribute("activeSwAllocation", coordinator);
    }

    public void actionUpdateConfiguration(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionUpdateConfiguration()", (String)("Action called for slot: " + this));
        this.resetPiuAutoConfigState(coordinator);
        this.registerResource(coordinator);
    }

    private void resetPiuAutoConfigState(Coordinator coordinator) throws MoAccessException {
        PlugInUnitMoImpl plugInUnitMoImpl = this.getCelloPlugInUnit();
        if (plugInUnitMoImpl != null) {
            plugInUnitMoImpl.setInterruptState(0, coordinator);
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"resetPiuAutoConfigState()", (String)("The configuration state is reset to initial state for PIU: " + plugInUnitMoImpl));
        } else {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"resetPiuAutoConfigState()", (String)("No CPP PlugInUnit configured in slot: " + this));
        }
    }

    private PlugInUnitMoImpl getCelloPlugInUnit() throws MoAccessException {
        MoIterator moIterator = this.getChildren();
        ManagedObject managedObject = null;
        PlugInUnitMoImpl plugInUnitMoImpl = null;
        if (moIterator != null && moIterator.hasMoreElements() && (managedObject = moIterator.nextMo()) instanceof PlugInUnitMoImpl) {
            plugInUnitMoImpl = (PlugInUnitMoImpl)managedObject;
        }
        return plugInUnitMoImpl;
    }

    public ManagedObject[] getSwAllocations(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSwAllocations(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!(managedObjectArray[i] instanceof SwAllocationMarker)) continue;
            arrayList.add(managedObjectArray[i]);
        }
        return arrayList.toArray(new ManagedObject[0]);
    }

    public ManagedObject getSwAllocation(Coordinator coordinator) throws MoAccessException {
        return this.getCalculatedSwAllocationForSU(coordinator);
    }

    public ManagedObject getCalculatedSwAllocationForSU(Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = this.getSwAllocations(coordinator);
        return managedObjectArray.length == 1 ? managedObjectArray[0] : this.getCalculatedSwAllocation(coordinator);
    }

    public ManagedObject getCalculatedSwAllocation(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject managedObject = null;
        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = this.getGenericUpgradeablePlugInUnit();
        ManagedObject[] managedObjectArray = this.getSwAllocations(coordinator);
        if (genericUpgradeablePlugInUnit != null && managedObjectArray.length > 0) {
            ManagedObject managedObject2 = genericUpgradeablePlugInUnit.getPiuType(coordinator);
            AutoCreateMosAccess autoCreateMosAccess = (AutoCreateMosAccess)ServiceLocatorFacade.getRepository().getService(AutoCreateMosAccess.class);
            managedObject = autoCreateMosAccess.findSwAllocationWithPiuType(managedObject2, managedObjectArray, coordinator);
        }
        return managedObject;
    }

    public int getAsciPortNumber(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("asciportnumber", coordinator);
    }

    public int getResourceId(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute(RESOURCE_ID, coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedBy(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public int getUpgradeGroupId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUpgradeGroupId(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return (Integer)this.getAttribute(UPGRADE_GROUP_ID, coordinator);
    }

    public void setUpgradeGroupId(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setUpgradeGroupId(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.setAttribute(UPGRADE_GROUP_ID, new Integer(n), coordinator);
    }

    public String getUpgradeGroupTypeName(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUpgradeGroupTypeName(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return (String)this.getAttribute(UPGRADE_GROUP_TYPE_NAME, coordinator);
    }

    public void setUpgradeGroupTypeName(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setUpgradeGroupTypeName(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.setAttribute(UPGRADE_GROUP_TYPE_NAME, string, coordinator);
    }

    public Struct getProductData(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductData(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return (Struct)this.getAttribute("productData", coordinator);
    }

    public String getProductionDate(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductionDate(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getProductDataForPISI(coordinator);
        String string = (String)struct.getValue("productionDate");
        if (string.length() == 8) {
            return string;
        }
        return ConvertWeekOfYearToDate.weekOfYearToDate((String)string);
    }

    public String getSerialNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSerialNumber(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getProductDataForPISI(coordinator);
        return (String)struct.getValue("serialNumber");
    }

    public SubrackMoSU_Access getSubrackMo(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSubrackMo(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        return (SubrackMoSU_Access)this.getParent();
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getSubrackId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSubrackId(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        SubrackMoImpl subrackMoImpl = (SubrackMoImpl)this.getParent();
        return subrackMoImpl.getSubrackPosition(coordinator);
    }

    public int getSlotPosition(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSlotPosition(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return this.getSlotNumber(coordinator);
    }

    public String getProductName(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductName(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getProductDataForPISI(coordinator);
        return (String)struct.getValue("productName");
    }

    private String formatProductName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.substring(0, 3);
        stringBuffer.append(string2);
        char[] cArray = string.toCharArray();
        if (string.startsWith("DUL") || string.startsWith("DUW")) {
            for (int i = 3; i < string.length(); ++i) {
                if (i == 3 || i == 5) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(cArray[i]);
            }
        } else if (string.startsWith("ODS")) {
            for (int i = 3; i < string.length(); ++i) {
                if (i == 3 || i == 6) {
                    stringBuffer.append(" ");
                }
                if (i == 5) {
                    stringBuffer.append(Character.toLowerCase(cArray[i]));
                    continue;
                }
                stringBuffer.append(cArray[i]);
            }
        }
        string2 = stringBuffer.toString();
        return string2;
    }

    private StructParameter formatProductData(StructParameter structParameter) {
        try {
            String string = ((StringParameter)structParameter.get("productName")).getValue().trim();
            if (string.startsWith("DUL") || string.startsWith("DUW") || string.startsWith("ODS")) {
                String string2 = this.formatProductName(string);
                String string3 = null;
                string3 = string.startsWith("ODS") ? this.formatProductNumber(((StringParameter)structParameter.get("productNumber")).getValue().trim()) : ((StringParameter)structParameter.get("productNumber")).getValue();
                StructParameter structParameter2 = new StructParameter(structParameter.getName());
                structParameter2.add((Parameter)new StringParameter("productName", string2));
                structParameter2.add((Parameter)new StringParameter("productNumber", string3));
                structParameter2.add((Parameter)((StringParameter)structParameter.get("productRevision")));
                structParameter2.add((Parameter)((StringParameter)structParameter.get("serialNumber")));
                structParameter2.add((Parameter)((StringParameter)structParameter.get("productionDate")));
                return structParameter2;
            }
        }
        catch (Exception exception) {
            MessageLog.trace((int)5, (Class)SlotMoImpl.class, (String)(" Exception while formatting product data, returning original productData -exception = " + exception));
        }
        return structParameter;
    }

    public String getProductNumberOpt(Coordinator coordinator) throws MoAccessException {
        return Lib.optimize((String)this.getProductNumber(coordinator));
    }

    public String getProductNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductNumber(Coordinator context)", (String)("context: " + coordinator));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getProductDataForPISI(coordinator);
        return (String)struct.getValue("productNumber");
    }

    private String formatProductNumber(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.substring(0, 3);
        stringBuffer.append(string2);
        char[] cArray = string.toCharArray();
        if (string.startsWith("KDU")) {
            for (int i = 3; i < string.length(); ++i) {
                if (i == 3 || i == 6) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(cArray[i]);
            }
            string2 = stringBuffer.toString();
            return string2;
        }
        return string;
    }

    public String getRStateOpt(Coordinator coordinator) throws MoAccessException {
        return Lib.optimize((String)this.getRState(coordinator));
    }

    public String getRState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRState(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getProductDataForPISI(coordinator);
        return (String)struct.getValue("productRevision");
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws InvalidReferenceException, MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserve(ManagedObject aUser, Coordinator context)", (String)("aUser: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        if (managedObject == null) {
            MessageLog.traceError(this.getClass(), (String)"reserve: userId is null", null);
            throw new InvalidReferenceException("Slot", (Object)managedObject);
        }
        if (managedObject instanceof SwAllocationMarker) {
            this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Slot", (MoData)this.data, (SequenceAttribute)this.reservedBy);
            this.registerResource(coordinator);
        } else if (managedObject instanceof ReliableProgramUniterMarker || managedObject instanceof InterPiuLinkMo) {
            this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Slot", (MoData)this.data, (SequenceAttribute)this.reservedBy);
        } else if (managedObject instanceof PfmUnitMoImpl) {
            this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Slot", (MoData)this.data, (SequenceAttribute)this.reservedBy);
        } else if (managedObject instanceof AppUnitMoImpl) {
            this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Slot", (MoData)this.data, (SequenceAttribute)this.reservedBy);
        } else if (managedObject instanceof CaxFanUnitMo) {
            this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Slot", (MoData)this.data, (SequenceAttribute)this.reservedBy);
        } else {
            throw new InvalidReferenceException("Slot", (Object)managedObject);
        }
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws InvalidReferenceException, MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"release( ManagedObject aUser, Coordinator context )", (String)("aUser: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        if (managedObject instanceof SwAllocationMarker && ReservableImpl.findReserver((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (SequenceAttribute)this.reservedBy) != null) {
            this.resetConfigStateIfRoleIsCleared(managedObject, coordinator);
        }
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Slot", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    private void resetConfigStateIfRoleIsCleared(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = this.getSwAllocations(coordinator);
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"resetConfigStateIfRoleIsCleared(ManagedObject aUser, Coordinator context)", (String)("release SwAllocation: " + managedObject + " current reservedBy sequence: " + Lib.toString((ManagedObject[])managedObjectArray) + ", current active swa: " + this.getActiveSwAllocation(coordinator)));
        if (managedObjectArray.length > 1) {
            ManagedObject managedObject2 = this.getActiveSwAllocation(coordinator);
            if (managedObject2 != null && managedObject2.equals(managedObject)) {
                this.resetPiuAutoConfigState(coordinator);
                this.updateActiveSwAllocation(null, coordinator);
            }
        } else {
            this.resetPiuAutoConfigState(coordinator);
            this.updateActiveSwAllocation(null, coordinator);
        }
    }

    public GenericUpgradeablePlugInUnit getGenericUpgradeablePlugInUnit() {
        MoIterator moIterator = this.getChildren();
        ManagedObject managedObject = null;
        if (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (managedObject instanceof GenericUpgradeablePlugInUnit) {
                MessageLog.trace((int)5, this.getClass(), (String)("getGenericUpgradeablePlugInUnit(), genericUpgradablePIU: " + managedObject));
                return (GenericUpgradeablePlugInUnit)managedObject;
            }
            MessageLog.trace((int)5, this.getClass(), (String)("getGenericUpgradeablePlugInUnit(), not a genericUpgradablePIU: " + managedObject));
        }
        return null;
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(RESOURCE_ID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        getRequestContextImpl.readAttributesFromProxy(this.proxy, this.getFroId(coordinator), ATTRIBUTES_TO_REQUEST_FROM_FRO);
        for (int i = 0; i < stringArray.length; ++i) {
            Object[] objectArray2;
            StructParameter structParameter;
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("productData")) {
                if (this.getSlotState(coordinator) == 1) {
                    structParameter = (StructParameter)getRequestContextImpl.getParameter("productData");
                    objectArray2 = new OperationalProdData(this.formatProductData(structParameter));
                    objectArray[i] = objectArray2.toStruct();
                    continue;
                }
                objectArray[i] = new StructImpl(OperationalProdData.ELEMENT_NAMES, OperationalProdData.ELEMENT_DEFAULTVALUES);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(RESOURCE_ID)) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute(RESOURCE_ID)).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("activeSwAllocation")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("activeSwAllocation")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("slotNumber")) {
                structParameter = (UnsignedIntParameter)getRequestContextImpl.getParameter("slotNumber");
                objectArray[i] = new Integer((int)structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("slotState")) {
                structParameter = (UnsignedIntParameter)getRequestContextImpl.getParameter("slotState");
                int n = (int)structParameter.getValue();
                if (n == 3) {
                    objectArray[i] = new Integer(2);
                    continue;
                }
                if (n == 2) {
                    objectArray[i] = new Integer(1);
                    continue;
                }
                objectArray[i] = new Integer(0);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(UPGRADE_GROUP_ID)) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute(UPGRADE_GROUP_ID)).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(UPGRADE_GROUP_TYPE_NAME)) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute(UPGRADE_GROUP_TYPE_NAME)).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("asciportnumber")) {
                structParameter = (UnsignedIntParameter)getRequestContextImpl.getParameter("asciportnumber");
                objectArray[i] = new Integer((int)structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("integratedHardware")) {
                structParameter = (UnsignedIntParameter)getRequestContextImpl.getParameter("integratedHardware");
                objectArray[i] = new Integer((int)structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("fruProductData")) {
                structParameter = (StructParameter)getRequestContextImpl.getParameter("fruProductData");
                objectArray2 = new Object[]{((StringParameter)structParameter.get("fruProductName")).getValue(), ((StringParameter)structParameter.get("fruProductNumber")).getValue(), ((StringParameter)structParameter.get("fruProductRevision")).getValue(), ((StringParameter)structParameter.get("fruSerialNumber")).getValue(), ((StringParameter)structParameter.get("fruProductionDate")).getValue()};
                objectArray[i] = new StructImpl(fruProductDataNames, objectArray2);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Slot");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"Slot", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(UPGRADE_GROUP_ID)) {
                ((IntegerAttribute)this.data.getAttribute(UPGRADE_GROUP_ID)).setValue((Integer)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(UPGRADE_GROUP_TYPE_NAME)) {
                ((StringAttribute)this.data.getAttribute(UPGRADE_GROUP_TYPE_NAME)).setValue((String)objectArray[i]);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Slot");
        }
    }

    private void initData(int n, int n2, String string, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"initData(int slNo, int resId, String usLabel, ManagedObject swAlloc, Coordinator c)", (String)("slNo: " + n + "\n\tresId: " + n2 + "\n\tusLabel: " + string + "\n\tswAlloc: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.resourceId = new IntegerAttribute(RESOURCE_ID, false);
        this.resourceId.setValue(n2);
        this.data.registerPersistentAttr((Attribute)this.resourceId);
        this.userLabel = new StringAttribute("userLabel", true);
        this.userLabel.setValue(string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.upgradeGroupId = new IntegerAttribute(UPGRADE_GROUP_ID, true);
        this.upgradeGroupId.setValue(0);
        this.data.registerPersistentAttr((Attribute)this.upgradeGroupId);
        this.upgradeGroupTypeName = new StringAttribute(UPGRADE_GROUP_TYPE_NAME, true);
        this.upgradeGroupTypeName.setValue("");
        this.data.registerPersistentAttr((Attribute)this.upgradeGroupTypeName);
        this.activeSwAllocation = new ReferenceAttribute("activeSwAllocation", true);
        this.activeSwAllocation.setValue(managedObject);
        this.data.registerPersistentAttr((Attribute)this.activeSwAllocation);
        this.data.setRevision(9000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public void raiseAutoConfigurationAlarm(AdditionalInfo[] additionalInfoArray) {
        this.anAutoConfigurationAlarm.raiseAlarm(additionalInfoArray, this);
    }

    public void clearAutoConfigurationAlarm() {
        if (AlarmManager.getReporter().getActiveAlarm(7, (ManagedObject)this) != null) {
            this.anAutoConfigurationAlarm.clearAlarm(this);
        }
    }

    public void eventRaised(UnlinkedSignal unlinkedSignal, String string) {
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"eventRaised()", (String)("Signal " + unlinkedSignal.getClass().getName() + " received for slot: " + this));
        if (unlinkedSignal instanceof OsaSlotNotifyInd) {
            try {
                EquipmentMoImpl.instance().actionTriggerLastHwPiChange(null);
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"Failed to TriggerLastHwPiChange", (Throwable)moAccessException);
            }
            try {
                UpgradeTrace.debug((Class)SlotMoImpl.class, (int)70, (String)" eventRaised(UnlinkedSignal sig, String proxyName) [OsaSlotNotifyInd] ", (String)("productNumber = " + ((OsaSlotNotifyInd)unlinkedSignal).getProductNumber() + ",  productRevision" + ((OsaSlotNotifyInd)unlinkedSignal).getProductRevision() + ",  serialNumber" + ((OsaSlotNotifyInd)unlinkedSignal).getSerialNumber()));
                this.dispatchProductData(((OsaSlotNotifyInd)unlinkedSignal).getProductNumber(), ((OsaSlotNotifyInd)unlinkedSignal).getProductRevision(), ((OsaSlotNotifyInd)unlinkedSignal).getSerialNumber(), 1);
            }
            catch (Throwable throwable) {
                UpgradeTrace.error(this.getClass(), (String)"eventRaised()", (String)("Auto Configuration failed to create/update PlugInUnit in slot: " + this + " due to: "), (Throwable)throwable);
            }
        } else if (unlinkedSignal instanceof CmaSlotNotifyInd) {
            try {
                UpgradeTrace.debug((Class)SlotMoImpl.class, (int)70, (String)" eventRaised(UnlinkedSignal sig, String proxyName) [CmaSlotNotifyInd] ", (String)("productNumber = " + ((CmaSlotNotifyInd)unlinkedSignal).getProductNumber() + ",  productRevision" + ((CmaSlotNotifyInd)unlinkedSignal).getProductRevision() + ",  serialNumber" + ((CmaSlotNotifyInd)unlinkedSignal).getSerialNumber()));
                this.dispatchProductData(((CmaSlotNotifyInd)unlinkedSignal).getProductNumber(), ((CmaSlotNotifyInd)unlinkedSignal).getProductRevision(), ((CmaSlotNotifyInd)unlinkedSignal).getSerialNumber(), ((CmaSlotNotifyInd)unlinkedSignal).getConfigurationAttempt());
            }
            catch (Throwable throwable) {
                UpgradeTrace.error(this.getClass(), (String)"eventRaised()", (String)("Auto Configuration failed to create/update PlugInUnit in slot: " + this + " due to: "), (Throwable)throwable);
            }
        } else {
            UpgradeTrace.error(this.getClass(), (String)"eventRaised()", (String)("Unexpected signal: " + unlinkedSignal.getClass().getName()));
        }
    }

    public synchronized void startAutoConfiguration() {
        try {
            int n = this.getSlotState(null);
            if (n == 1) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"startAutoConfiguration()", (String)("Auto Configuration started for slot: " + this));
                Struct struct = this.getProductData(null);
                String string = (String)struct.getValue("productNumber");
                String string2 = (String)struct.getValue("productRevision");
                String string3 = (String)struct.getValue("serialNumber");
                roProxy.addSlotNotifyIndToSignalQueue(this.getResourceId(null), string, string2, string3, 1);
            } else {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"startAutoConfiguration()", (String)("Auto Configuration started but the slotState indicates that this slot: " + this + ", is having state:" + n));
            }
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"startAutoConfiguration()", (String)("Failed to initiate Auto Configuration for slot: " + this), (Throwable)throwable);
        }
    }

    private void dispatchProductData(String string, String string2, String string3, int n) throws Exception {
        if (this.checkProductData(string, string2)) {
            this.savePreviousSerialNumber(string3);
            try {
                ServiceControllerAccess serviceControllerAccess = (ServiceControllerAccess)ServiceLocatorFacade.getRepository().getService(ServiceControllerAccess.class);
                UpgradeBackupServiceInformation upgradeBackupServiceInformation = serviceControllerAccess.getExecutingUpgradeBackupServiceInformation();
                if (upgradeBackupServiceInformation.isBusy() && upgradeBackupServiceInformation.getServiceName().equals(UPGRADE_SERVICE_NAME) && upgradeBackupServiceInformation.getSubFunction().equals(UPGRADE_SUB_FUNCTION)) {
                    UpgradeTrace.debug(this.getClass(), (int)71, (String)"dispatchProductData()", (String)"AutoConfiguration is stopped as upgrade is ongoing");
                    return;
                }
                AutoCreateMosAccess autoCreateMosAccess = (AutoCreateMosAccess)ServiceLocatorFacade.getRepository().getService(AutoCreateMosAccess.class);
                autoCreateMosAccess.create(string, string2, string3, this);
            }
            catch (FroNotAccessibleException froNotAccessibleException) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"dispatchProductData()", (String)("Caught exception " + (Object)((Object)froNotAccessibleException) + " at configuration of PIU in slot: " + this + ". Config attempt: " + n));
                if (n < 3) {
                    roProxy.addSlotNotifyIndToSignalQueue(this.getResourceId(null), string, string2, string3, n + 1);
                }
                throw froNotAccessibleException;
            }
        }
    }

    private boolean checkProductData(String string, String string2) throws MoAccessException {
        if (string == null || string.equals("")) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"checkProductData()", (String)("Auto configuration started for slot: " + super.getNamingAttributeValue() + " with empty productNumber. The data will be discarded."));
            return false;
        }
        if (string2 == null || string2.equals("")) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"checkProductData()", (String)("Auto configuration started for slot: " + super.getNamingAttributeValue() + " with empty productRevision. The data will be discarded."));
            return false;
        }
        return true;
    }

    private void savePreviousSerialNumber(String string) {
        this.previousSerialNo = this.serialNo.equals("") ? string : this.serialNo;
        this.serialNo = string;
    }

    public String getPreviousSerialNo() {
        return this.previousSerialNo;
    }

    private synchronized void registerResource(Coordinator coordinator) {
        if (this.coordinator == null || !this.coordinator.isSameTransaction(coordinator)) {
            this.coordinator = coordinator;
            try {
                this.coordinator.registerResource((Resource)new ResourceAutoConfigSlot());
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"registerResource failed due to an exception:", (Throwable)inactiveTransactionException);
            }
        }
    }

    public void updateActiveSwAllocation(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.activeSwAllocation.setValue(managedObject);
    }

    private Struct getProductDataForPISI(Coordinator coordinator) throws MoAccessException {
        Struct struct = null;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductDataForPISI(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        String[] stringArray = new String[]{"integratedHardware", "productData", "fruProductData"};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        int n = (Integer)objectArray[0];
        Struct struct2 = (Struct)objectArray[1];
        Struct struct3 = (Struct)objectArray[2];
        if (n == 1) {
            MessageLog.trace((int)5, this.getClass(), (String)" IntegratedHardware = 1, FRU-PID received");
            struct = struct3;
        } else {
            MessageLog.trace((int)5, this.getClass(), (String)" IntegratedHardware != 1, PID received");
            if (n != 0) {
                MessageLog.traceError(this.getClass(), (String)(" IntegratedHardware boot parameter value = [" + n + "] is not supported"));
            }
            struct = struct2;
        }
        return struct;
    }

    public int getIntegratedHardware(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getIntegratedHardware(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        String[] stringArray = new String[]{"integratedHardware"};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        int n = (Integer)objectArray[0];
        return n;
    }

    private class ResourceAutoConfigSlot
    implements Resource,
    Runnable {
        private static final String CMA_AUTOCONFIG_SINGLE_SLOT_SCAN_THREAD = "Cma_AutoConfig_Single_Slot_Scan_Thread";

        public void commit() {
            Thread thread = new Thread((Runnable)this, CMA_AUTOCONFIG_SINGLE_SLOT_SCAN_THREAD);
            thread.start();
            SlotMoImpl.this.coordinator = null;
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            SlotMoImpl.this.coordinator = null;
        }

        public void run() {
            SlotMoImpl.this.startAutoConfiguration();
        }
    }
}

