/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment.fropxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.UnlinkedSignal;
import se.ericsson.cello.common.fropxy.FroEmptySignal;
import se.ericsson.cello.common.fropxy.FroProxy;
import se.ericsson.cello.common.fropxy.FroReqU32U32;
import se.ericsson.cello.common.fropxy.MoEventable;
import se.ericsson.cello.common.fropxy.PnpSignalPort;
import se.ericsson.cello.common.fropxy.PnpSignalPortManager;
import se.ericsson.cello.equipment.fropxy.CmaSlotNotifyInd;
import se.ericsson.cello.equipment.fropxy.OsaSlotCreateCfm;
import se.ericsson.cello.equipment.fropxy.OsaSlotCreateReq;
import se.ericsson.cello.equipment.fropxy.OsaSlotDeleteCfm;
import se.ericsson.cello.equipment.fropxy.OsaSlotGetApnRsp;
import se.ericsson.cello.equipment.fropxy.OsaSlotGetAttributesRsp;
import se.ericsson.cello.equipment.fropxy.OsaSlotGetResourceIdListRsp;
import se.ericsson.cello.equipment.fropxy.OsaSlotNotifyInd;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.session.PVSession;
import se.ericsson.cello.session.PVSessionNotInitiatedException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;

public class OsaSlotMgmntProxy
extends FroProxy {
    private static final String PROTOCOL_VERSION_CELLO_4300_R1A = "R1A";
    private static final String PROTOCOL_VERSION_2 = "R2A";
    private static final String PROTOCOL_VERSION_LATEST = "R2A";
    public static final int CELLO_SLOT_OK = 1;
    public static final int CELLO_SLOT_DB_ERROR = 2;
    public static final int CELLO_SLOT_ALREADY_EXISTS = 3;
    public static final int CELLO_SLOT_DOES_NOT_EXIST = 4;
    public static final int CELLO_SLOT_CREATE_NOT_ALLOWED = 5;
    public static final int CELLO_SLOT_DELETE_NOT_ALLOWED = 6;
    public static final int CELLO_SLOT_SR_DOES_NOT_EXIST = 7;
    public static final int CELLO_SLOT_INVALID_SLOT_NO = 8;
    public static final int CELLO_SLOT_OCCUPIED = 9;
    public static final int CELLO_SLOT_INVALID_ADM_STATE = 10;
    public static final int CELLO_SLOT_SET_NOT_ALLOWED = 11;
    public static final int CELLO_SLOT_INVALID_ATTRIBUTE_ID = 12;
    public static final int CELLO_SLOT_IS_NOT_USED = 1;
    public static final int CELLO_SLOT_IS_USED = 2;
    public static final String CELLO_SLOT_CLASS_NAME = "CelloSlot";
    private PVSession session = null;
    private static OsaSlotMgmntProxy instance = null;
    private PnpSignalPort pnpSignalPort;
    private String serviceName;
    private String pvFirstWanted;
    private String pvSecondWanted;
    private String pvThirdWanted;
    private String moType;

    public OsaSlotCreateCfm sendOsaSlotCreateReq(long l, long l2, long l3, int n) throws FroNotAccessibleException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"sendOsaSlotCreateReq(long clientRef, long txId, long subrackInstanceId, int slotNo)", (String)("clientRef: " + l + "\n\ttxId: " + l2 + "\n\tsubrackInstanceId: " + l3 + "\n\tslotNo: " + n));
        OsaSlotCreateReq osaSlotCreateReq = new OsaSlotCreateReq(l, l2, l3, n);
        OsaSlotCreateCfm osaSlotCreateCfm = (OsaSlotCreateCfm)SignalHelper.sendAndReceive((OseProcess)this.getFroProcess(), (Signal)osaSlotCreateReq, (Class)OsaSlotCreateCfm.class);
        return osaSlotCreateCfm;
    }

    public OsaSlotDeleteCfm sendOsaSlotDeleteReq(long l, long l2) throws FroNotAccessibleException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"sendOsaSlotDeleteReq(long txId, long slotInstanceId)", (String)("txId: " + l + "\n\tslotInstanceId: " + l2));
        FroReqU32U32 froReqU32U32 = new FroReqU32U32(66037, (int)l, (int)l2);
        OsaSlotDeleteCfm osaSlotDeleteCfm = (OsaSlotDeleteCfm)SignalHelper.sendAndReceive((OseProcess)this.getFroProcess(), (Signal)froReqU32U32, (Class)OsaSlotDeleteCfm.class);
        return osaSlotDeleteCfm;
    }

    public OsaSlotGetResourceIdListRsp sendOsaSlotGetResourceIdListReq() throws FroNotAccessibleException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"sendOsaSlotGetResourceIdListReq(");
        FroEmptySignal froEmptySignal = new FroEmptySignal(66033);
        OsaSlotGetResourceIdListRsp osaSlotGetResourceIdListRsp = (OsaSlotGetResourceIdListRsp)SignalHelper.sendAndReceive((OseProcess)this.getFroProcess(), (Signal)froEmptySignal, (Class)OsaSlotGetResourceIdListRsp.class);
        return osaSlotGetResourceIdListRsp;
    }

    public OsaSlotGetAttributesRsp sendOsaSlotGetAttributesReq(long l, long l2) throws FroNotAccessibleException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"sendOsaSlotGetAttributesReq(long txId, long slotInstanceId)", (String)("txId: " + l + "\n\tslotInstanceId: " + l2));
        FroReqU32U32 froReqU32U32 = new FroReqU32U32(66039, (int)l, (int)l2);
        OsaSlotGetAttributesRsp osaSlotGetAttributesRsp = (OsaSlotGetAttributesRsp)SignalHelper.sendAndReceive((OseProcess)this.getFroProcess(), (Signal)froReqU32U32, (Class)OsaSlotGetAttributesRsp.class);
        return osaSlotGetAttributesRsp;
    }

    public OsaSlotGetApnRsp sendOsaSlotGetApnReq(long l, long l2) throws FroNotAccessibleException {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"sendOsaSlotGetApnReq(long txId, long slotInstanceId)", (String)("txId: " + l + "\n\tslotInstanceId: " + l2));
        FroReqU32U32 froReqU32U32 = new FroReqU32U32(68303, (int)l, (int)l2);
        OsaSlotGetApnRsp osaSlotGetApnRsp = (OsaSlotGetApnRsp)SignalHelper.sendAndReceive((OseProcess)this.getFroProcess(), (Signal)froReqU32U32, (Class)OsaSlotGetApnRsp.class);
        return osaSlotGetApnRsp;
    }

    public void signalReceived(InSignal inSignal) {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"signalReceived(enea.ose.system.InSignal sig)", (String)("sig: " + inSignal));
        if (inSignal instanceof OsaSlotNotifyInd) {
            OsaSlotNotifyInd osaSlotNotifyInd = (OsaSlotNotifyInd)inSignal;
            int n = (int)osaSlotNotifyInd.getSlotInstanceId();
            MoEventable moEventable = (MoEventable)this.subscriptions.get(new Integer(n));
            if (moEventable != null) {
                moEventable.eventRaised((UnlinkedSignal)((OsaSlotNotifyInd)inSignal), ((Object)((Object)this)).getClass().getName());
            }
        } else if (inSignal instanceof CmaSlotNotifyInd) {
            CmaSlotNotifyInd cmaSlotNotifyInd = (CmaSlotNotifyInd)inSignal;
            int n = (int)cmaSlotNotifyInd.getSlotInstanceId();
            MoEventable moEventable = (MoEventable)this.subscriptions.get(new Integer(n));
            if (moEventable != null) {
                moEventable.eventRaised((UnlinkedSignal)((CmaSlotNotifyInd)inSignal), ((Object)((Object)this)).getClass().getName());
            }
        } else {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("signalReceived(), unexpected signal: " + inSignal.getClass().getName()));
        }
    }

    public void serviceAdded() {
    }

    public void serviceRemoved() {
    }

    public String getResultMsg(int n) {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"getResultMsg(int code)", (String)("code: " + n));
        String string = "UNKNOWN RESULT CODE " + n;
        switch (n) {
            case 1: {
                string = "CELLO_SLOT_OK";
                break;
            }
            case 2: {
                string = "CELLO_SLOT_DB_ERROR";
                break;
            }
            case 3: {
                string = "CELLO_SLOT_ALREADY_EXISTS";
                break;
            }
            case 4: {
                string = "CELLO_SLOT_DOES_NOT_EXIST";
                break;
            }
            case 5: {
                string = "CELLO_SLOT_CREATE_NOT_ALLOWED";
                break;
            }
            case 6: {
                string = "CELLO_SLOT_DELETE_NOT_ALLOWED";
                break;
            }
            case 7: {
                string = "CELLO_SLOT_SR_DOES_NOT_EXIST";
                break;
            }
            case 8: {
                string = "CELLO_SLOT_INVALID_SLOT_NO";
                break;
            }
            case 9: {
                string = "CELLO_SLOT_OCCUPIED";
                break;
            }
            case 10: {
                string = "CELLO_SLOT_INVALID_ADM_STATE";
                break;
            }
            case 11: {
                string = "CELLO_SLOT_SET_NOT_ALLOWED";
                break;
            }
            case 12: {
                string = "CELLO_SLOT_INVALID_ATTRIBUTE_ID";
            }
        }
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)71, (String)"getResultMsg(int code)", (String)("Returns message: " + string));
        return string;
    }

    public String getUsedMsg(int n) {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"getUsedMsg(int code)", (String)("code: " + n));
        String string = "UNKNOWN RESULT CODE " + n;
        switch (n) {
            case 1: {
                string = "CELLO_SLOT_IS_NOT_USED";
                break;
            }
            case 2: {
                string = "CELLO_SLOT_IS_USED";
            }
        }
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)71, (String)"getUsedMsg(int code)", (String)("Returns message: " + string));
        return string;
    }

    public static synchronized OsaSlotMgmntProxy instance() {
        UpgradeTrace.debug((Class)OsaSlotMgmntProxy.class, (int)70, (String)"instance()");
        if (instance == null) {
            instance = new OsaSlotMgmntProxy(CELLO_SLOT_CLASS_NAME, "R2A", "R2A", "R2A", "Slot");
        }
        return instance;
    }

    private OsaSlotMgmntProxy(String string, String string2, String string3, String string4, String string5) {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"OsaSlotMgmntProxy()");
        this.serviceName = string;
        this.pvFirstWanted = string2;
        this.pvSecondWanted = string3;
        this.pvThirdWanted = string4;
        this.moType = string5;
        this.pnpSignalPort = PnpSignalPortManager.instance();
        this.pnpSignalPort.addSignalObserver((SignalObserver)this, OsaSlotNotifyInd.class);
        this.pnpSignalPort.addSignalObserver((SignalObserver)this, CmaSlotNotifyInd.class);
    }

    private OseProcess getFroProcess() throws FroNotAccessibleException {
        if (this.session == null) {
            throw new PVSessionNotInitiatedException("Slot", CELLO_SLOT_CLASS_NAME, "Session is not yet initiated");
        }
        return this.session.obtainSession().getFroProcess();
    }

    public synchronized void addSlotNotifyIndToSignalQueue(long l, String string, String string2, String string3, int n) {
        this.pnpSignalPort.addSignalToQueue((InSignal)new CmaSlotNotifyInd(l, string, string2, string3, n));
    }

    public void subscribeService() {
        UpgradeTrace.debug(((Object)((Object)this)).getClass(), (int)70, (String)"subscribeService ()");
        this.session = new PVSession(this.serviceName, this.pvFirstWanted, this.pvSecondWanted, this.pvThirdWanted, this.moType, 1539);
    }
}

