/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import se.ericsson.cello.nex.gui.treetable.AbstractCellEditor;
import se.ericsson.cello.nex.gui.treetable.TreeTableModel;
import se.ericsson.cello.nex.gui.treetable.TreeTableModelAdapter;

public class JTreeTable
extends JTable {
    private static final long serialVersionUID = 1564066989259241234L;
    protected TreeTableCellRenderer tree;
    protected TreeTableModel treeTableModel;
    protected TreeTableModelAdapter modeladapter;
    private int selected_column;

    public JTreeTable(TreeTableModel treeTableModelIn) {
        this.treeTableModel = treeTableModelIn;
        this.tree = new TreeTableCellRenderer(this.treeTableModel);
        this.modeladapter = new TreeTableModelAdapter(this.treeTableModel, this.tree);
        super.setModel(this.modeladapter);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(true);
        this.setGridColor(Color.black);
        this.setShowVerticalLines(true);
        this.setDoubleBuffered(true);
        this.setIntercellSpacing(new Dimension(1, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
    }

    public void resizeAndRepaintTable() {
        this.resizeAndRepaint();
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public void columnMoved(TableColumnModelEvent e) {
        this.updateUI();
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        this.selected_column = 0;
    }

    public void selectTheColumn(int columnNumber) {
        if (columnNumber > 0) {
            try {
                this.setColumnSelectionInterval(columnNumber, columnNumber);
                this.setRowSelectionInterval(0, this.getRowCount() - 1);
                this.selected_column = columnNumber;
            }
            catch (Exception exception) {}
        } else {
            this.selected_column = 0;
        }
    }

    public int getTheSelectedColumn() {
        return this.selected_column;
    }

    private void sortColumns(int rowIndex) {
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = -1073390187644180553L;
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.tree;
        }

        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (JTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                    MouseEvent me = (MouseEvent)e;
                    MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private static final long serialVersionUID = 7098645708770959532L;
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
            super.setOpaque(true);
            Font f = this.getFont();
            Font tfont = new Font(f.getName(), 1, f.getSize());
            this.setFont(tfont);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setBorderSelectionColor(null);
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }
    }
}

