/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.treetable;

public abstract class MergeSort {
    public void sort(Object[] array) {
        if (array != null && array.length > 1) {
            int maxLength = array.length;
            Object[] swapSpace = new Object[maxLength];
            Object[] toSort = array;
            this.mergeSort(0, maxLength - 1, toSort, swapSpace);
        }
    }

    public abstract int compareElementsAt(int var1, int var2, Object[] var3, Object[] var4);

    protected void mergeSort(int begin, int end, Object[] toSort, Object[] swapSpace) {
        if (begin != end) {
            int mid = (begin + end) / 2;
            this.mergeSort(begin, mid, toSort, swapSpace);
            this.mergeSort(mid + 1, end, toSort, swapSpace);
            this.merge(begin, mid, end, toSort, swapSpace);
        }
    }

    protected void merge(int begin, int middle, int end, Object[] toSort, Object[] swapSpace) {
        int count;
        int firstHalf = count = begin;
        int secondHalf = middle + 1;
        while (firstHalf <= middle && secondHalf <= end) {
            if (this.compareElementsAt(secondHalf, firstHalf, toSort, swapSpace) < 0) {
                swapSpace[count++] = toSort[secondHalf++];
                continue;
            }
            swapSpace[count++] = toSort[firstHalf++];
        }
        if (firstHalf <= middle) {
            while (firstHalf <= middle) {
                swapSpace[count++] = toSort[firstHalf++];
            }
        } else {
            while (secondHalf <= end) {
                swapSpace[count++] = toSort[secondHalf++];
            }
        }
        for (count = begin; count <= end; ++count) {
            toSort[count] = swapSpace[count];
        }
    }
}

