/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.nex.ConfigurationI;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.UI;
import se.ericsson.cello.nex.gui.view.GuiViewPreferences;
import se.ericsson.cello.nex.toolservices.StartFailureException;
import se.ericsson.cello.nex.toolservices.ToolServicesI;
import se.ericsson.cello.nex.viewservices.DeleteMoExecutor;
import se.ericsson.cello.nex.viewservices.ViewFactory;
import se.ericsson.cello.nex.viewservices.ViewI;
import se.ericsson.cello.nex.viewservices.ViewInfo;
import se.ericsson.cello.nex.viewservices.ViewModelFactory;
import se.ericsson.cello.nex.viewservices.ViewServicesI;
import se.ericsson.cello.nex.viewservices.model.Query;
import se.ericsson.cello.nex.viewservices.model.ViewElementDataI;
import se.ericsson.cello.nex.viewservices.model.ViewElementFactory;
import se.ericsson.cello.nex.viewservices.model.ViewElementI;
import se.ericsson.cello.nex.viewservices.model.ViewModelI;
import se.ericsson.cello.nex.viewservices.model.XmlModel;
import se.ericsson.cello.nex.viewservices.utils.MoClassResolver;
import se.ericsson.cello.nex.viewservices.utils.MoDeleteException;
import se.ericsson.cello.nex.viewservices.utils.MoDeletor;
import se.ericsson.cello.nex.viewservices.utils.ViewFileReaderException;
import se.ericsson.cello.nex.viewservices.utils.ViewJarfileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewServices
implements ViewServicesI {
    public static final String PRIVATE_VIEW_DIR_NAME = "UserDefinedViews";
    private ToolServicesI myToolServices = null;
    private UI myUI;
    private Map<String, ViewModelI> myPreDefViewModels;
    private Map<String, String> myPreDefViews;
    private ViewModelI myContainmentModel = null;
    private Map<String, File> myImportedViewFiles = null;
    private int myViewHistoryIndex = -1;
    private Vector<ViewI> myViewHistory = null;
    private ViewI myContaimentView = null;
    private ViewInfo myViewInfo = null;
    private MimModel myMim = null;
    private ConfigurationI myConfigReader = null;
    private volatile boolean haveFetchedPreDefViews = false;
    private boolean haveFetchedImportedViewNames = false;
    private static String CPP_BEGINNING = "CPP";
    private byte[] initPreDefinedViewsLock = new byte[0];

    public ViewServices(ToolServicesI toolServices, ConfigurationI configReader) {
        this.myConfigReader = configReader;
        this.myToolServices = toolServices;
        this.myViewInfo = new ViewInfo(this);
        this.myViewHistory = new Vector();
        this.myImportedViewFiles = new HashMap<String, File>();
        this.myPreDefViewModels = new HashMap<String, ViewModelI>();
        this.myPreDefViews = new HashMap<String, String>();
        this.createContainmentView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPreDefinedViews() {
        if (this.haveFetchedPreDefViews) {
            return;
        }
        byte[] byArray = this.initPreDefinedViewsLock;
        synchronized (this.initPreDefinedViewsLock) {
            NexLog.logger().fine("");
            if (!this.haveFetchedPreDefViews) {
                URL viewlistURL = this.myConfigReader.getViewListURL();
                URL viewRepository = this.myConfigReader.getViewRepositoryRoot();
                NexLog.logger().info("Read URL: " + viewlistURL);
                try {
                    ViewJarfileReader.fetchPreDefViews(viewlistURL, viewRepository, this.myToolServices, this.myPreDefViews);
                }
                catch (ViewFileReaderException exception) {
                    StringBuilder listOfTroublingFiles = new StringBuilder();
                    if (!exception.getJarFileName().equalsIgnoreCase("")) {
                        listOfTroublingFiles.append(exception.getJarFileName());
                        listOfTroublingFiles.append("\n");
                    }
                    Throwable tmp = exception;
                    while (tmp.getCause() != null) {
                        if (!((tmp = tmp.getCause()) instanceof ViewFileReaderException) || ((ViewFileReaderException)tmp).getJarFileName().equalsIgnoreCase("")) continue;
                        listOfTroublingFiles.append(((ViewFileReaderException)tmp).getJarFileName());
                        listOfTroublingFiles.append("\n");
                    }
                    this.myUI.setMessage("View constructing failure", "A problem occurred while trying to construct the predefined views. Some view(s) will not be available in the Element Manager.\n\n" + listOfTroublingFiles.toString(), exception, false);
                }
                finally {
                    this.haveFetchedPreDefViews = true;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public ViewModelI getViewModel(String viewName, ViewServicesI.ViewType type) {
        ViewModelI model = null;
        if ("Containment (MOM based)".equals(viewName) || type.equals((Object)ViewServicesI.ViewType.CONTAINMENT)) {
            return this.getContainmentModel();
        }
        if (type.equals((Object)ViewServicesI.ViewType.UNKNOWN)) {
            type = viewName.endsWith("  ") ? ViewServicesI.ViewType.IMPORTED : (viewName.endsWith(" ") ? ViewServicesI.ViewType.USERDEFINED : ViewServicesI.ViewType.PREDEFINED);
        }
        if (type.equals((Object)ViewServicesI.ViewType.PREDEFINED)) {
            return this.getPreDefViewModel(viewName);
        }
        File viewFile = null;
        if (type.equals((Object)ViewServicesI.ViewType.USERDEFINED)) {
            viewFile = this.getPrivateViewFile(viewName);
        } else if (type.equals((Object)ViewServicesI.ViewType.IMPORTED)) {
            viewFile = this.myImportedViewFiles.get(viewName);
        }
        if (null == viewFile) {
            this.myUI.setMessage("View constructing failure", "The view file was not found for: " + viewName, false);
        } else {
            boolean fileAvailable = false;
            try {
                fileAvailable = viewFile.exists();
            }
            catch (SecurityException secEx) {
                this.myUI.setMessage("View constructing failure", "No read access to the file: " + viewFile + "\nThe read access to the file has to be changed in order to open the view " + viewName, secEx, false);
                return model;
            }
            if (!fileAvailable) {
                this.myUI.setMessage("View constructing failure", "The file for the view " + viewName + " does not exist.\n" + viewFile, false);
            } else {
                String confirmationStatusMessage = null;
                try {
                    model = ViewModelFactory.createModelFromFile(viewFile, this.myToolServices);
                    NexLog.logger().info("Returning model:" + model + "   for view named >" + viewName + "<");
                }
                catch (FileNotFoundException e) {
                    this.myUI.setMessage("View constructing failure", "The view file was not found for: " + viewName, e, false);
                    NexLog.logger().log(Level.INFO, "Failed to create model. The view file was not found.\n" + viewName + "\n" + NexLog.stackToString(e));
                }
                catch (SAXException e) {
                    confirmationStatusMessage = "Validation error for view: " + viewFile.getAbsolutePath() + ".\n" + this.getLineAndColumnNumber(e) + "\n" + e.getMessage() + "\n\nDo you want to turn off validation for this view and proceed?\n";
                }
                catch (IOException e) {
                    this.myUI.setMessage("View constructing failure", "It was not possible to read the view file: " + viewFile, e, false);
                    NexLog.logger().log(Level.INFO, "Failed to create model.It was not possible to read the view file.\n" + viewFile + "\n" + NexLog.stackToString(e));
                }
                catch (ParserConfigurationException e) {
                    this.myUI.setMessage("View constructing failure", "It was not possible to configure the XML parser correctly.\nThe view could not be parsed: " + viewName, e, false);
                    NexLog.logger().log(Level.INFO, "Failed to create model. Configuring parser went wrong\n" + viewName + "\n" + NexLog.stackToString(e));
                }
                if (null != confirmationStatusMessage && this.myUI.getConfirmationToProceed("Validation Error", confirmationStatusMessage, "Yes", "No")) {
                    try {
                        ViewModelFactory.setValidate(false);
                        model = ViewModelFactory.createModelFromFile(viewFile, this.myToolServices);
                    }
                    catch (Exception e1) {
                        this.myUI.setMessage("Parsing failure", "It was not possible to open the view without validation: " + viewFile.getAbsolutePath() + this.getLineAndColumnNumber(e1), e1, false);
                        NexLog.logger().log(Level.INFO, "Failed to create model. The parsing went wrong\n" + viewFile + this.getLineAndColumnNumber(e1) + "\n" + NexLog.stackToString(e1));
                    }
                }
                return model;
            }
        }
        return model;
    }

    @Override
    public void setUI(UI ui) {
        this.myUI = ui;
    }

    @Override
    public Collection<String> getAvailableViewNames() {
        NexLog.logger().fine("");
        this.initPreDefinedViews();
        ArrayList<String> list = new ArrayList<String>();
        list.add("-------PREDEFINED VIEWS------");
        list.add("Containment (MOM based)");
        list.addAll(this.getPreDefViewNames());
        list.add("-------USER-DEFINED VIEWS-----");
        list.addAll(this.getUserDefViewNames());
        if (!this.haveFetchedImportedViewNames) {
            this.initImportedViewList();
        }
        if (this.myImportedViewFiles.size() > 0) {
            list.add("-------IMPORTED VIEWS----------");
            list.addAll(this.getImportedViewNames());
        }
        return list;
    }

    @Override
    public boolean startView(String viewname, String ldn) {
        NexLog.logger().info("startView:>" + viewname + "<");
        this.myUI.setStatusMessage("Opening view...");
        ViewServicesI.ViewType type = ViewServicesI.ViewType.UNKNOWN;
        if (null == viewname || viewname.equals("Containment (MOM based)")) {
            viewname = "Containment (MOM based)";
            type = ViewServicesI.ViewType.CONTAINMENT;
        } else {
            type = viewname.endsWith("  ") ? ViewServicesI.ViewType.IMPORTED : (viewname.endsWith(" ") ? ViewServicesI.ViewType.USERDEFINED : ViewServicesI.ViewType.PREDEFINED);
        }
        ViewModelFactory.setValidate(true);
        boolean successfulGetOfViewModel = this.startView(viewname, this.getViewModel(viewname, type), ldn);
        ViewModelFactory.setValidate(false);
        if (!successfulGetOfViewModel) {
            this.setCurrentView();
        }
        return successfulGetOfViewModel;
    }

    @Override
    public void importView(File viewFile) {
        try {
            ViewModelFactory.createModelFromFile(viewFile, this.myToolServices);
        }
        catch (FileNotFoundException e) {
            this.myUI.setMessage("The view file to import was not found", "" + viewFile, e, false);
            NexLog.logger().log(Level.INFO, "Failed to create model. The view file was not found.\n" + viewFile + "\n" + NexLog.stackToString(e));
            return;
        }
        catch (SAXException e) {
            this.myUI.setMessage("Parsing failure", "It was not possible to parse the view file: " + viewFile.getAbsolutePath() + this.getLineAndColumnNumber(e), e, false);
            NexLog.logger().log(Level.INFO, "Failed to create model. The parsing went wrong\n" + viewFile + this.getLineAndColumnNumber(e) + "\n" + NexLog.stackToString(e));
            return;
        }
        catch (IOException e) {
            this.myUI.setMessage("View reading failure", "It was not possible to read the view file: " + viewFile, e, false);
            NexLog.logger().log(Level.INFO, "Failed to create model.It was not possible to read the view file.\n" + viewFile + "\n" + NexLog.stackToString(e));
            return;
        }
        catch (ParserConfigurationException e) {
            this.myUI.setMessage("Parsing failure", "It was not possible to configure the parser correctly.\nThe view could not be parsed: " + viewFile, e, false);
            NexLog.logger().log(Level.INFO, "Failed to create model. Configuring parser went wrong\n" + viewFile + "\n" + NexLog.stackToString(e));
            return;
        }
        this.addViewFileToImportedViews(viewFile);
        this.myUI.updateViewNames(this.getAvailableViewNames());
    }

    private String getLineAndColumnNumber(Exception e) {
        String lineNumber = null;
        String columnNumber = null;
        String lineAndColumnNumber = "";
        if (e instanceof SAXParseException) {
            int intLineNumber = ((SAXParseException)e).getLineNumber();
            int intColumnNumber = ((SAXParseException)e).getColumnNumber();
            lineNumber = Integer.valueOf(intLineNumber).toString();
            columnNumber = Integer.valueOf(intColumnNumber).toString();
            if (lineNumber.equals("-1")) {
                lineNumber = "<not available>";
            }
            if (columnNumber.equals("-1")) {
                columnNumber = "<not available>";
            }
            lineAndColumnNumber = "\nLine number: " + lineNumber + "\nColumn number: " + columnNumber;
        }
        return lineAndColumnNumber;
    }

    @Override
    public void destroy() {
        for (ViewI viewToRemove : this.myViewHistory) {
            viewToRemove.destroy();
        }
        this.myViewHistory.clear();
        this.myToolServices = null;
        this.myUI = null;
        this.myViewInfo.destroy();
        this.myViewInfo = null;
    }

    @Override
    public void setNextView() {
        ViewI view = this.getViewFromHistory(1);
        if (null != view) {
            this.myUI.setView(view);
            this.updateButtonStatus();
        }
    }

    @Override
    public void setPreviousView() {
        ViewI view;
        ViewI currentView = this.getViewFromHistory(0);
        Collection<String> selectedLDNs = null;
        if (null != currentView) {
            selectedLDNs = currentView.getSelectedLDNsInCollection();
        }
        if (null != (view = this.getViewFromHistory(-1))) {
            if (view.getName().equals("Containment (MOM based)") && !view.isInitiated()) {
                this.initContainmentView();
            }
            this.myUI.setView(view);
            this.updateButtonStatus();
            if (view.getName().equals("Containment (MOM based)")) {
                view.selectLDNs(selectedLDNs);
            }
        }
    }

    private void setCurrentView() {
        ViewI currentView = this.getViewFromHistory(0);
        if (null != currentView) {
            Collection<String> selectedLDNs = null;
            selectedLDNs = currentView.getSelectedLDNsInCollection();
            String currentViewName = currentView.getName();
            if (currentViewName.equals("Containment (MOM based)") && !currentView.isInitiated()) {
                this.initContainmentView();
            }
            this.myUI.setView(currentView);
            this.updateButtonStatus();
            if (currentViewName.equals("Containment (MOM based)")) {
                currentView.selectLDNs(selectedLDNs);
            }
        }
    }

    @Override
    public ViewInfo getViewInfo() {
        return this.myViewInfo;
    }

    @Override
    public Collection<String> getPreDefViewNames() {
        this.initPreDefinedViews();
        TreeSet<String> retList = new TreeSet<String>();
        if (this.myPreDefViews.size() > 0) {
            if (this.myConfigReader.getCppViewsVisibility()) {
                Set<String> names = this.myPreDefViews.keySet();
                retList.addAll(names);
            } else {
                Set<String> names = this.myPreDefViews.keySet();
                for (String name : names) {
                    if (name.startsWith(CPP_BEGINNING)) continue;
                    retList.add(name);
                }
            }
        }
        return retList;
    }

    @Override
    public Collection<String> getUserDefViewNames() {
        NexLog.logger().fine("");
        File viewLib = new File(this.getUserDefDirectory());
        String[] files = viewLib.list();
        TreeSet<String> list = new TreeSet<String>();
        for (String file : files) {
            if (!file.endsWith(".xml")) continue;
            StringBuilder viewName = new StringBuilder();
            viewName.append(file.replace(".xml", ""));
            viewName.append(" ");
            list.add(viewName.toString());
        }
        NexLog.logger().info("List of user def. views contains " + list.size());
        return list;
    }

    @Override
    public Collection<String> getImportedViewNames() {
        TreeSet<String> list = new TreeSet<String>();
        list.addAll(this.myImportedViewFiles.keySet());
        return list;
    }

    @Override
    public String getUserDefDirectory() {
        String sep = System.getProperty("file.separator");
        return System.getProperty("user.home") + sep + "Ericsson" + sep + PRIVATE_VIEW_DIR_NAME;
    }

    @Override
    public void removeImportedView(String viewname) {
        if (this.myViewHistory.get(this.myViewHistoryIndex).getName().equals(viewname)) {
            this.setPreviousView();
        }
        this.myToolServices.getUserPreferences().removePreference(GuiViewPreferences.getAddedColumnsKey(viewname));
        this.removeViewFromHistory(viewname);
        this.myImportedViewFiles.remove(viewname);
        this.myUI.updateViewNames(this.getAvailableViewNames());
    }

    @Override
    public void prepareClose() {
        block3: {
            ArrayList<String> filePaths = new ArrayList<String>();
            for (File file : this.myImportedViewFiles.values()) {
                filePaths.add(file.getPath());
            }
            try {
                this.myConfigReader.storeImportedViewPaths(filePaths);
            }
            catch (Exception e) {
                NexLog.logger().warning("Problem saving settings to file at user home/Ericsson:\n" + NexLog.stackToString(e));
                if (null == this.myUI) break block3;
                this.myUI.setMessage("Imported view storage problem", "A problem arised when trying to save information about which views you have imported. They will not be imported automatically when the Element Manager is started next time.", e, false);
            }
        }
    }

    @Override
    public File getFileForImportedView(String viewName) {
        return this.myImportedViewFiles.get(viewName);
    }

    @Override
    public Collection<String> getMomAttributes() {
        TreeSet<String> attributeNames = new TreeSet<String>(new CaseInsensitiveComparator());
        MimModel mim = this.getMim();
        if (null != mim) {
            Iterator classIter = mim.getClasses();
            while (classIter.hasNext()) {
                MomClass moclass = (MomClass)classIter.next();
                Iterator attributesIter = moclass.getAttributes();
                while (attributesIter.hasNext()) {
                    MomAttribute attr = (MomAttribute)attributesIter.next();
                    if (attr.isInterfaceOnly()) continue;
                    attributeNames.add(attr.getName());
                }
            }
        } else {
            NexLog.logger().warning("MIM was null in ViewServices. getMomAttributes will return an empty list.");
        }
        return attributeNames;
    }

    @Override
    public void deleteMos(String ldns) {
        NodeServices myNodeService = null;
        boolean canProceedToDelete = true;
        MoDeletor myMoDeletor = null;
        try {
            myNodeService = this.myToolServices.getNodeServices();
        }
        catch (StartFailureException e) {
            canProceedToDelete = false;
        }
        if (canProceedToDelete) {
            try {
                myMoDeletor = new MoDeletor(myNodeService, ldns);
                myMoDeletor.preConditionCheck();
            }
            catch (MoDeleteException e) {
                String errorLdn = e.getLdn();
                this.myUI.setMessage("It is not possible to delete the MO ", errorLdn + "\nNo MO has been deleted.", e, false);
                NexLog.logger().log(Level.INFO, "It is not possible to delete the MO:" + errorLdn);
                canProceedToDelete = false;
            }
        }
        if (canProceedToDelete) {
            String theHostAddress = this.myToolServices.getHostName();
            String ldnList = myMoDeletor.getDeletedMosList();
            String deletionTitle = "Confirm Deletion";
            String messageText = "The following MO(s) will be deleted on the node " + theHostAddress + "\n" + ldnList + "\nDo you want to proceed?";
            if (this.myUI.getConfirmationToProceed(deletionTitle, messageText, "Delete", "Cancel")) {
                DeleteMoExecutor myDeleteRunner = new DeleteMoExecutor(myMoDeletor, this.myToolServices, this.myUI);
                new Thread((Runnable)myDeleteRunner, "DeleteMoExrcutor").start();
                this.myUI.setStatusMessage("Delete MO(s) requested...");
            }
        }
    }

    private boolean startView(String viewName, ViewModelI model, String ldn) {
        String className;
        NexLog.logger().info("Will open view with viewName: \"" + viewName + "\" ldn: \"" + ldn + "\" in thread: \"" + Thread.currentThread().getName() + "\"");
        if (viewName.equals("Containment (MOM based)")) {
            this.startContainmentView(ldn);
            return true;
        }
        if (null == model) {
            NexLog.logger().warning("Cannot open the view: " + viewName + "No model was found.");
            this.myUI.setMessage("The selected view cannot be opened", "Model can not be created", false);
            if (this.myViewHistory.size() < 2) {
                this.startContainmentView(ldn);
            }
            return false;
        }
        boolean foundTop = false;
        Mo topMo = null;
        NodeServices nodeServ = null;
        CmService cm = null;
        try {
            nodeServ = this.myToolServices.getNodeServices();
            cm = nodeServ.getNode().getCmService();
        }
        catch (StartFailureException e) {
            NexLog.logger().log(Level.SEVERE, "Failed to get NEAL node.\n" + NexLog.stackToString(e));
            this.myUI.setStatusMessage("");
            this.myUI.setMessage("Node connection is lost...", e, true);
            return false;
        }
        ViewElementDataI topData = model.getTopViewElementData();
        if (topData == null) {
            NexLog.logger().warning("Cannot open the view: " + viewName + "No top data was found.");
            this.myUI.setMessage("The selected view cannot be opened", "Model can not be parsed", false);
            if (this.myViewHistory.size() < 2) {
                this.startContainmentView(ldn);
            }
            return false;
        }
        Collection<Query> queries = topData.getQueries();
        if (null != ldn && !(className = MoClassResolver.resolveMoClassFromLdn(ldn)).equals("") && model.getTopMoClasses().contains(className) && 1 == queries.size() && queries.iterator().next().getSearchExpression().equals("")) {
            topMo = cm.getMo(ldn);
            if (topMo.exists()) {
                foundTop = true;
            } else {
                topMo = null;
            }
        }
        if (!foundTop) {
            LinkedList<Object> list = new LinkedList();
            list = this.getSubMOsAsSearchResult(queries, cm);
            if (!foundTop && list.isEmpty()) {
                StringBuilder classes = new StringBuilder();
                for (String aClass : model.getTopMoClasses()) {
                    classes.append(aClass);
                    classes.append(" ");
                }
                this.myUI.setStatusMessage("");
                this.myUI.setMessage("The selected view cannot be opened", "Found no MO of class " + classes.toString(), false);
                NexLog.logger().fine("Found no MO instance to top MO. Returning");
                return false;
            }
            if (!foundTop && list.size() > 1) {
                topMo = this.myUI.askForTopMo(list);
                if (null == topMo) {
                    this.myUI.setStatusMessage("");
                    NexLog.logger().fine("User did not select a top MO. Returning");
                    return false;
                }
                foundTop = true;
            } else if (!foundTop && 1 == list.size()) {
                topMo = (Mo)list.getFirst();
                foundTop = true;
            }
        }
        if (foundTop) {
            ViewElementI viewElem = ViewElementFactory.createViewElement(model, nodeServ, topData, topMo);
            ViewI view = ViewFactory.createView(viewName);
            view.init(viewElem, model, model.getEmbeddedClassNames(), this.myUI, this.myToolServices, this);
            NexLog.logger().fine("Setting the view " + view.getName() + " to the GUI");
            this.addViewToHistory(view);
            this.myUI.setView(view);
            view.expandToLevel(model.getExpandLevel());
        }
        NexLog.logger().fine("At end");
        return true;
    }

    private ViewI getViewFromHistory(int direction) {
        NexLog.logger().fine("direction: " + direction + " myViewHistoryIndex: " + this.myViewHistoryIndex);
        ViewI view = null;
        if (0 == direction) {
            return this.myViewHistory.get(this.myViewHistoryIndex);
        }
        if (direction > 0) {
            if (this.myViewHistoryIndex >= this.myViewHistory.size() - 1) {
                return null;
            }
            ++this.myViewHistoryIndex;
            view = this.myViewHistory.get(this.myViewHistoryIndex);
        } else if (direction < 0) {
            if (this.myViewHistoryIndex <= 0) {
                return null;
            }
            --this.myViewHistoryIndex;
            view = this.myViewHistory.get(this.myViewHistoryIndex);
        }
        return view;
    }

    private void removeViewFromHistory(String viewname) {
        NexLog.logger().fine("Will remove view from history: " + viewname);
        int place = 0;
        ListIterator<ViewI> iter = this.myViewHistory.listIterator(place);
        while (iter.hasNext()) {
            ViewI view = iter.next();
            if (view.getName().equals(viewname)) {
                if (place == this.myViewHistoryIndex) {
                    NexLog.logger().warning("Got a request to remove the view that is current view.");
                    return;
                }
                view.destroy();
                iter.remove();
                if (place >= this.myViewHistoryIndex) break;
                --this.myViewHistoryIndex;
                break;
            }
            ++place;
        }
        this.updateButtonStatus();
    }

    private void addViewToHistory(ViewI view) {
        NexLog.logger().fine("view: " + view.getName() + " myViewHistoryIndex: " + this.myViewHistoryIndex);
        ListIterator<ViewI> iter = this.myViewHistory.listIterator(this.myViewHistoryIndex + 1);
        while (iter.hasNext()) {
            ViewI viewToRemove = iter.next();
            viewToRemove.destroy();
            iter.remove();
        }
        this.myViewHistory.add(view);
        ++this.myViewHistoryIndex;
        this.updateButtonStatus();
    }

    private void updateButtonStatus() {
        if (null == this.myUI) {
            return;
        }
        if (this.myViewHistoryIndex < this.myViewHistory.size() - 1) {
            this.myUI.enableForwardView(true);
        } else {
            this.myUI.enableForwardView(false);
        }
        if (this.myViewHistoryIndex > 0) {
            this.myUI.enableBackwardView(true);
        } else {
            this.myUI.enableBackwardView(false);
        }
    }

    private File getPrivateViewFile(String viewName) {
        NexLog.logger().info("viewName: " + viewName);
        String sep = System.getProperty("file.separator");
        String viewLib = this.getUserDefDirectory();
        File viewFile = new File(viewLib + sep + viewName.trim() + ".xml");
        NexLog.logger().fine("View path: " + viewFile.getPath() + "\n absolute path: " + viewFile.getAbsolutePath());
        return viewFile;
    }

    private MimModel getMim() {
        if (null == this.myMim) {
            try {
                this.myMim = this.myToolServices.getNodeServices().getMimModel();
            }
            catch (StartFailureException e) {
                this.myMim = null;
            }
        }
        return this.myMim;
    }

    private LinkedList<Mo> getSubMOsAsSearchResult(Collection<Query> queries, CmService cm) {
        LinkedList<Mo> returnList = new LinkedList<Mo>();
        for (Query qu : queries) {
            ArrayList<String> moClasses;
            Mo rootMo;
            block10: {
                String searchRootLdn = null;
                searchRootLdn = qu.getSearchRoot();
                if (searchRootLdn == null || searchRootLdn.length() == 0) {
                    searchRootLdn = "ManagedElement=1";
                }
                rootMo = cm.getMo(searchRootLdn);
                if (qu.getMoClass().equals("ManagedElement")) {
                    returnList.add(rootMo);
                    continue;
                }
                String anMoClassExp = qu.getMoClass();
                moClasses = new ArrayList<String>();
                if (MoClassResolver.isRegExp(anMoClassExp)) {
                    try {
                        moClasses = MoClassResolver.resolveMoClass(this.getMim(), anMoClassExp);
                        break block10;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                moClasses.add(anMoClassExp);
            }
            for (String aClass : moClasses) {
                try {
                    Mo[] mos = rootMo.getChildren(aClass, qu.getSearchExpression(), qu.getSearchScope(), null);
                    for (int i = 0; i < mos.length; ++i) {
                        returnList.add(mos[i]);
                    }
                }
                catch (Exception e) {
                    NexLog.logger().warning("Can not get children mos for the MO:  " + rootMo.toString());
                }
            }
        }
        return returnList;
    }

    private ViewModelI getContainmentModel() {
        if (null == this.myContainmentModel) {
            this.myContainmentModel = ViewModelFactory.createContainmentModel();
        }
        return this.myContainmentModel;
    }

    private void startContainmentView(String ldn) {
        if (null == this.myContaimentView || !this.myContaimentView.isInitiated()) {
            this.initContainmentView();
        }
        this.myUI.setView(this.myContaimentView);
        this.myViewHistoryIndex = 0;
        this.updateButtonStatus();
        if (null != ldn && ldn.length() > 0) {
            String[] ldnArr = ldn.split(";");
            ArrayList<String> ldnCollection = new ArrayList<String>(ldnArr.length);
            for (int i = 0; i < ldnArr.length; ++i) {
                ldnCollection.add(ldnArr[i]);
            }
            this.myContaimentView.selectLDNs(ldnCollection);
        }
    }

    private ViewModelI getPreDefViewModel(String viewName) {
        NexLog.logger().fine("Getting predefined model for view: " + viewName);
        if (this.myPreDefViewModels.containsKey(viewName)) {
            return this.myPreDefViewModels.get(viewName);
        }
        XmlModel aModel = null;
        this.initPreDefinedViews();
        try {
            InputSource source = ViewJarfileReader.getViewInputSource(viewName, this.myPreDefViews);
            if (null == source) {
                NexLog.logger().warning("No source could be created for " + viewName);
                return null;
            }
            aModel = ViewModelFactory.createModelFromSource(source, this.myToolServices);
            this.myPreDefViewModels.put(viewName, aModel);
        }
        catch (ViewFileReaderException e) {
            if (e.isReadFile()) {
                this.myUI.setMessage("View constructing failure", "Problem reading the view: " + viewName, e, false);
            } else {
                this.myUI.setMessage("View constructing failure", "It was not possible to construct the view: " + viewName, e, false);
            }
            NexLog.logger().info("It was not possible to read the view file.\n" + viewName + "\n" + NexLog.stackToString(e));
        }
        catch (SAXException e) {
            this.myUI.setMessage("View constructing failure", "It was not possible to parse the view: " + viewName + this.getLineAndColumnNumber(e), e, false);
            NexLog.logger().info("It was not possible to parse the view file.\n" + viewName + this.getLineAndColumnNumber(e) + "\n" + NexLog.stackToString(e));
        }
        catch (IOException e) {
            this.myUI.setMessage("View constructing failure", "It was not possible to read the view: " + viewName, e, false);
            NexLog.logger().info("It was not possible to read the view file.\n" + viewName + "\n" + NexLog.stackToString(e));
        }
        catch (ParserConfigurationException e) {
            this.myUI.setMessage("View constructing failure", "It was not possible to configure the XML parser correctly.\nThe view could not be parsed: " + viewName, e, false);
            NexLog.logger().info("Parser configuration exception. View file:\n" + viewName + "\n" + NexLog.stackToString(e));
        }
        return aModel;
    }

    private void createContainmentView() {
        NexLog.logger().info("");
        this.myContaimentView = ViewFactory.createView("Containment (MOM based)");
        NexLog.logger().fine("Setting containment view to view history");
        this.addViewToHistory(this.myContaimentView);
    }

    private void initContainmentView() {
        NexLog.logger().info("");
        if (null == this.myContaimentView) {
            this.createContainmentView();
        }
        if (null != this.myContaimentView && !this.myContaimentView.isInitiated()) {
            ViewModelI model = this.getContainmentModel();
            Mo topMo = null;
            NodeServices nodeServ = null;
            CmService cm = null;
            try {
                nodeServ = this.myToolServices.getNodeServices();
                cm = nodeServ.getNode().getCmService();
            }
            catch (Exception e) {
                NexLog.logger().log(Level.SEVERE, "Failed to get NEAL node.\n" + NexLog.stackToString(e));
                this.myUI.setMessage("No contact whith the node. Please, exit and restart.", e, true);
                return;
            }
            topMo = cm.getMo("ManagedElement=1");
            ViewElementDataI data = model.getTopViewElementData();
            ViewElementI viewElem = ViewElementFactory.createViewElement(model, nodeServ, data, topMo);
            this.myContaimentView.init(viewElem, model, model.getEmbeddedClassNames(), this.myUI, this.myToolServices, this);
        }
    }

    private void initImportedViewList() {
        Collection<String> paths = this.myConfigReader.readImportedViewPaths();
        for (String path : paths) {
            this.addViewFileToImportedViews(new File(path));
        }
        this.haveFetchedImportedViewNames = true;
    }

    private void addViewFileToImportedViews(File viewFile) {
        String viewName = viewFile.getName();
        int end = viewFile.getName().lastIndexOf(".");
        if (end > -1) {
            viewName = viewFile.getName().substring(0, end);
        }
        viewName = viewName + "  ";
        this.myImportedViewFiles.put(viewName, viewFile);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CaseInsensitiveComparator
    implements Comparator<String> {
        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

