/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices.model;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.toolservices.ToolServicesI;
import se.ericsson.cello.nex.viewservices.model.ChPaAttrData;
import se.ericsson.cello.nex.viewservices.model.Query;
import se.ericsson.cello.nex.viewservices.model.Relation;
import se.ericsson.cello.nex.viewservices.model.Task;
import se.ericsson.cello.nex.viewservices.model.TreeNodeData;
import se.ericsson.cello.nex.viewservices.model.ViewElementDataI;
import se.ericsson.cello.nex.viewservices.model.ViewModelI;
import se.ericsson.cello.nex.viewservices.parser.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlModel
implements ViewModelI {
    private Parser parser;
    private static final String MO_ROOT = "MO";
    private static final String MO_CLASS = "MoClass";
    private static final String TABLE_ATTRIBUTE = "tableAttribute";
    private static final String MOATTRIBUTETABLE = "moAttributeTable";
    private static final String REFERENCE_ATTRIBUTE = "referencingAttribute";
    private static final String CHILDREN = "children";
    private static final String FOLDER = "MoFolder";
    private static final String DESCRIPTION = "description";
    private static final String FILTER = "filter";
    private static final String FOLDER_NAME = "folderName";
    private static final String REFERENCE = "reference";
    private static final String CONTAINMENT = "containment";
    private static final String PARENT = "parent";
    private static final String CONDITION = "condition";
    private static final String OPERATOR = "operator";
    private static final String SCOPE = "scope";
    private static final String ALL_LEVELS = "all";
    private static final String TASK = "task";
    private static final String ACTION = "action";
    private static final String COMMAND = "command";
    private static final String COMMAND_NAME = "commandName";
    private static final String TOOL = "tool";
    private static final String MO = "MO";
    private static final String PARENT_ATTR = "parentAttribute";
    private static final String CHILD_ATTR = "childAttribute";
    private static final String ATTRIBUTE_NAME = "attributeName";
    private static final String EMBEDDED = "embeddedApp";
    private static final String EMBEDDED_CLASS = "embeddedClass";
    private static final String DISPLAY_NAME = "displayName";
    private static final String EMTOOL = "emTool";
    private static final String IS_RESOURCE = "isResource";
    private static final String ARGUMENT = "argument";
    private static final String ARG_KEY = "argKey";
    private static final String ARG_VALUE = "argValue";
    private static final String EXPAND_LEVEL = "expandLevel";
    private static final String SEARCHROOT = "searchRoot";
    private static final String HIDE_EMPTY_FOLDER = "hideEmptyFolder";
    private ToolServicesI toolServices = null;
    private Document document = null;

    public XmlModel(InputSource source, ToolServicesI toolserv, boolean validate) throws SAXException, IOException, ParserConfigurationException {
        this.parser = new Parser(source, validate);
        this.toolServices = toolserv;
        this.document = this.parser.getDocument();
    }

    public XmlModel(InputSource source, ToolServicesI toolserv) throws SAXException, IOException, ParserConfigurationException {
        this(source, toolserv, false);
    }

    @Override
    public ViewElementDataI getTopViewElementData() {
        Element MO;
        ViewElementDataI data = null;
        Element root = this.parser.getRoot();
        if (root != null && (MO = (Element)root.getElementsByTagName("MO").item(0)) != null) {
            data = this.createTreeNodeData(MO);
        }
        return data;
    }

    @Override
    public Collection<String> getAttributeNames() {
        Collection<String> attributes = new ArrayList<String>();
        Element root = this.parser.getRoot();
        if (root != null) {
            NodeList table = root.getElementsByTagName(MOATTRIBUTETABLE);
            for (int i = 0; i < table.getLength(); ++i) {
                Node node = table.item(i);
                if (!node.getNodeName().equals(MOATTRIBUTETABLE)) continue;
                attributes = this.resolveTableAttribute(node);
                break;
            }
        }
        return attributes;
    }

    @Override
    public Collection<String> getEmbeddedClassNames() {
        ArrayList<String> returnCollection = new ArrayList<String>();
        Element root = this.parser.getRoot();
        if (root != null) {
            NodeList nodes = root.getElementsByTagName(EMBEDDED);
            for (int i = 0; i < nodes.getLength(); ++i) {
                NamedNodeMap theAttributes = nodes.item(i).getAttributes();
                Node javaNode = theAttributes.getNamedItem(EMBEDDED_CLASS);
                if (null == javaNode) continue;
                String javaClass = javaNode.getNodeValue();
                returnCollection.add(javaClass);
            }
        }
        return returnCollection;
    }

    @Override
    public String getDescription() {
        NodeList nodeList;
        Element root = this.parser.getRoot();
        if (root != null && (nodeList = root.getElementsByTagName(DESCRIPTION)).getLength() > 0 && nodeList.item(0).getFirstChild() != null) {
            return nodeList.item(0).getFirstChild().getNodeValue();
        }
        return "";
    }

    @Override
    public Collection<String> getTopMoClasses() {
        ViewElementDataI data = this.getTopViewElementData();
        LinkedList<String> retCollection = new LinkedList<String>();
        if (data != null) {
            for (Query qu : data.getQueries()) {
                retCollection.add(qu.getMoClass());
            }
        }
        return retCollection;
    }

    @Override
    public int getExpandLevel() {
        String attr;
        int retInt = 2;
        Element root = this.parser.getRoot();
        if (root != null && null != (attr = root.getAttribute(EXPAND_LEVEL)) && attr.length() > 0) {
            try {
                retInt = Integer.parseInt(attr);
            }
            catch (Exception numExep) {
                NexLog.logger().warning("Could not parse expand level to an integer: " + attr);
                retInt = 2;
            }
        }
        return retInt;
    }

    public ArrayList<Relation> getSubRelations(ViewElementDataI parent) {
        ArrayList<Relation> children = new ArrayList<Relation>();
        Element node = (Element)parent.getNode();
        if (node != null) {
            NodeList nodes = node.getChildNodes();
            int nrOfNodes = nodes.getLength();
            for (int i = 0; i < nrOfNodes; ++i) {
                Node n = nodes.item(i);
                int relation = this.getRelationValue(n);
                if (relation == -1) continue;
                ViewElementDataI tnd = this.createTreeNodeData(n);
                Relation rel = new Relation(relation, tnd);
                children.add(rel);
            }
        }
        return children;
    }

    @Override
    public String getXmlModelString() throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        DOMSource source = new DOMSource(this.document);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        return sw.toString();
    }

    private ViewElementDataI createTreeNodeData(Node n) {
        boolean isFolder = false;
        LinkedList<Query> queries = null;
        String aShortName = null;
        String description = null;
        int scope = -1;
        String referencingAttribute = null;
        LinkedList<Task> taskList = null;
        Collection<String> tableAttributeList = null;
        boolean hasChildren = this.hasValidChildren(n);
        NamedNodeMap map = n.getAttributes();
        String moClass = null;
        String name = n.getNodeName();
        LinkedList<ChPaAttrData> chPaAttr = new LinkedList();
        String hideEmptyFolder = "";
        if (name.equals(CHILDREN) || name.equals(PARENT)) {
            moClass = map.getNamedItem(MO_CLASS) == null ? null : map.getNamedItem(MO_CLASS).getNodeValue();
            chPaAttr = this.findChildOrParentAttributes(n);
        } else if (name.equals("MO")) {
            queries = new LinkedList<Query>();
            NodeList subNodes = n.getChildNodes();
            int len = subNodes.getLength();
            for (int j = 0; j < len; ++j) {
                Node classNode;
                Node sNode = subNodes.item(j);
                int searchLevel = -1;
                String aSearchString = "";
                if (sNode == null || !sNode.getNodeName().equals(FILTER)) continue;
                ArrayList<String> attributes = new ArrayList<String>();
                aSearchString = this.composeSearchString(sNode, attributes);
                Node scopeNode = sNode.getAttributes().getNamedItem(SCOPE);
                if (scopeNode != null) {
                    searchLevel = this.resolveScope(scopeNode.getNodeValue());
                }
                if ((classNode = sNode.getAttributes().getNamedItem(MO_CLASS)) == null) continue;
                moClass = classNode.getNodeValue();
                Query aQuery = new Query(moClass, aSearchString, searchLevel, attributes);
                Node searchRootNode = sNode.getAttributes().getNamedItem(SEARCHROOT);
                if (searchRootNode != null) {
                    aQuery.setSearchRoot(searchRootNode.getNodeValue());
                }
                queries.add(aQuery);
            }
            chPaAttr = this.findChildOrParentAttributes(n);
        } else if (name.equals(FOLDER)) {
            if (map.getNamedItem(FOLDER_NAME) != null) {
                aShortName = map.getNamedItem(FOLDER_NAME).getNodeValue();
            }
            if (map.getNamedItem(HIDE_EMPTY_FOLDER) != null) {
                hideEmptyFolder = map.getNamedItem(HIDE_EMPTY_FOLDER).getNodeValue();
            }
            isFolder = true;
            NodeList folderNodes = n.getChildNodes();
            int nodeLength = folderNodes.getLength();
            for (int i = 0; i < nodeLength; ++i) {
                Node folderNode = folderNodes.item(i);
                if (!folderNode.getNodeName().equals(DESCRIPTION)) continue;
                description = folderNode.getFirstChild() != null ? folderNode.getFirstChild().getNodeValue() : "";
            }
        } else if (name.equals(REFERENCE)) {
            Node moType = map.getNamedItem(MO_CLASS);
            if (moType != null) {
                moClass = moType.getNodeValue();
            }
            referencingAttribute = map.getNamedItem(REFERENCE_ATTRIBUTE).getNodeValue();
            chPaAttr = this.findChildOrParentAttributes(n);
        }
        taskList = this.resolveTask(n);
        tableAttributeList = this.resolveTableAttribute(n);
        TreeNodeData data = new TreeNodeData(n, hasChildren, moClass, referencingAttribute, aShortName, isFolder, description, queries, scope, taskList, tableAttributeList, chPaAttr, hideEmptyFolder);
        return data;
    }

    private LinkedList<ChPaAttrData> findChildOrParentAttributes(Node n) {
        LinkedList<ChPaAttrData> list = new LinkedList<ChPaAttrData>();
        NodeList attrNodes = n.getChildNodes();
        int nodeLength = attrNodes.getLength();
        for (int i = 0; i < nodeLength; ++i) {
            Node typeNode;
            Node nNode;
            String childAttribute = null;
            String parentAttribute = null;
            int scopeAttr = 1;
            String typeAttr = null;
            Node attrNode = attrNodes.item(i);
            boolean isAttrNode = false;
            String nodeName = attrNode.getNodeName();
            if (nodeName.equals(CHILD_ATTR)) {
                nNode = attrNode.getAttributes().getNamedItem(ATTRIBUTE_NAME);
                if (nNode != null) {
                    childAttribute = nNode.getNodeValue();
                }
                isAttrNode = true;
            } else if (nodeName.equals(PARENT_ATTR)) {
                nNode = attrNode.getAttributes().getNamedItem(ATTRIBUTE_NAME);
                if (nNode != null) {
                    parentAttribute = nNode.getNodeValue();
                }
                isAttrNode = true;
            }
            if (!isAttrNode) continue;
            Node scopeNode = attrNode.getAttributes().getNamedItem(SCOPE);
            if (scopeNode != null) {
                scopeAttr = this.resolveScope(scopeNode.getNodeValue());
            }
            if ((typeNode = attrNode.getAttributes().getNamedItem(MO_CLASS)) != null) {
                typeAttr = typeNode.getNodeValue();
            }
            list.add(new ChPaAttrData(parentAttribute, childAttribute, typeAttr, scopeAttr));
        }
        return list;
    }

    private LinkedList<Task> resolveTask(Node n) {
        NodeList childNodes = n.getChildNodes();
        int nodeLength = childNodes.getLength();
        LinkedList<Task> taskList = new LinkedList<Task>();
        for (int i = 0; i < nodeLength; ++i) {
            Node node = childNodes.item(i);
            if (!node.getNodeName().equals(TASK)) continue;
            NodeList taskNodes = node.getChildNodes();
            for (int j = 0; j < taskNodes.getLength(); ++j) {
                String name;
                node = taskNodes.item(j);
                if (node.getNodeName().equals(ACTION)) {
                    String action = node.getFirstChild().getNodeValue();
                    taskList.add(new Task(0, action, action, new Properties(), this.toolServices));
                    continue;
                }
                if (node.getNodeName().equals(COMMAND)) {
                    name = node.getAttributes().getNamedItem(COMMAND_NAME).getNodeValue();
                    if (!node.hasChildNodes()) continue;
                    String cmdString = node.getFirstChild().getNodeValue();
                    taskList.add(new Task(1, name, cmdString, new Properties(), this.toolServices));
                    continue;
                }
                if (!node.getNodeName().equals(TOOL)) continue;
                name = node.getAttributes().getNamedItem(DISPLAY_NAME).getNodeValue();
                boolean isResource = this.isResource(node);
                String tool = node.getAttributes().getNamedItem(EMTOOL).getNodeValue();
                NodeList subNodes = node.getChildNodes();
                int len = subNodes.getLength();
                Properties props = new Properties();
                for (int a = 0; a < len; ++a) {
                    Node argNode = subNodes.item(a);
                    if (!argNode.getNodeName().equals(ARGUMENT)) continue;
                    String argKey = null;
                    String argValue = "";
                    Node keyNode = argNode.getAttributes().getNamedItem(ARG_KEY);
                    Node valNode = argNode.getAttributes().getNamedItem(ARG_VALUE);
                    if (keyNode != null && valNode != null) {
                        argKey = keyNode.getNodeValue();
                        argValue = valNode.getNodeValue();
                    }
                    props.setProperty(argKey, argValue);
                }
                taskList.add(new Task(2, name, tool, isResource, props, this.toolServices));
            }
        }
        return taskList;
    }

    private boolean isResource(Node node) {
        return node.getAttributes().getNamedItem(IS_RESOURCE) != null && node.getAttributes().getNamedItem(IS_RESOURCE).getNodeValue().equalsIgnoreCase("true");
    }

    private Collection<String> resolveTableAttribute(Node n) {
        NodeList childNodes = n.getChildNodes();
        int nodeLength = childNodes.getLength();
        ArrayList<String> tableAttrList = new ArrayList<String>();
        for (int i = 0; i < nodeLength; ++i) {
            Node node = childNodes.item(i);
            if (!node.getNodeName().equals(TABLE_ATTRIBUTE)) continue;
            String column = node.getFirstChild().getNodeValue();
            tableAttrList.add(column);
        }
        return tableAttrList;
    }

    private int getRelationValue(Node node) {
        String name = node.getNodeName();
        int relationValue = -1;
        if (name.equals(PARENT)) {
            relationValue = 2;
        } else if (name.equals(CHILDREN)) {
            relationValue = 1;
        } else if (name.equals(FOLDER)) {
            relationValue = 4;
        } else if (name.equals(REFERENCE)) {
            relationValue = 3;
        } else if (name.equals(CONTAINMENT)) {
            relationValue = 5;
        } else if (name.equals("MO")) {
            relationValue = 6;
        }
        return relationValue;
    }

    private String composeSearchString(Node node, ArrayList<String> attributes) {
        StringBuffer searchString = new StringBuffer();
        NodeList searchNodes = node.getChildNodes();
        int searchLength = searchNodes.getLength();
        for (int i = 0; i < searchLength; ++i) {
            Node no = searchNodes.item(i);
            String NodeName = no.getNodeName();
            if (NodeName.equals(CONDITION)) {
                String condition = no.getFirstChild().getNodeValue();
                searchString.append(condition);
                attributes.add(this.getAttributeFromCondition(condition));
                searchString.append(" ");
                continue;
            }
            if (!NodeName.equals(OPERATOR)) continue;
            Node value = no.getAttributes().getNamedItem("value");
            searchString.append(value.getNodeValue());
            searchString.append(" ");
        }
        return searchString.toString().trim();
    }

    private String getAttributeFromCondition(String condition) {
        String attribute = "";
        StringTokenizer queryAttributeTokenizer = new StringTokenizer(condition, "!=><", false);
        if (queryAttributeTokenizer.hasMoreTokens()) {
            attribute = queryAttributeTokenizer.nextToken().trim();
        }
        return attribute;
    }

    private int resolveScope(String scope) {
        int s = -1;
        if (ALL_LEVELS.equals(scope)) {
            s = -1;
        } else {
            try {
                Integer integ = new Integer(scope);
                s = integ;
            }
            catch (NumberFormatException exep) {
                s = -1;
            }
        }
        return s;
    }

    private boolean hasValidChildren(Node n) {
        if (n == null) {
            return false;
        }
        if (!n.hasChildNodes()) {
            return false;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String name = children.item(i).getNodeName();
            if (!name.equals(CHILDREN) && !name.equals(REFERENCE) && !name.equals(PARENT) && !name.equals(FOLDER) && !name.equals(CONTAINMENT) && !name.equals("MO")) continue;
            return true;
        }
        return false;
    }
}

