/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.viewservices.utils.MoDeleteException;
import se.ericsson.security.utils.EmLogger;

public class MoDeletor {
    private MimModel myMimModel = null;
    private Node myNode = null;
    private NodeServices myNodeServices = null;
    private Logger myLog = EmLogger.NEX.getLogger();
    private String[] myLdnList = null;
    private Mo[] childrenMos = null;
    private static final String LDN_DELIMITER = ";";
    protected static final String noConnection = "No connection to node.";
    protected static final String ldnMissing = "No LDN received for deletion.";
    protected static final String systemCreated = "The MO is system created and can only be deleted by the system.";
    protected static final String onlySystemCreatedChildren = "Only system created children.";
    protected static final String deleteChildFirst = "The MO has a child that is not system created. Delete the child first:";
    protected static final String ldnInvalid = "The LDN is invalid";
    private StringBuilder preConditonReport = null;

    public MoDeletor(NodeServices aNodeServices, String aLdns) throws MoDeleteException {
        this.myNodeServices = aNodeServices;
        this.myMimModel = this.myNodeServices.getMimModel();
        this.myNode = this.myNodeServices.getNode();
        if (this.myMimModel == null || this.myNode == null) {
            this.myLog.log(Level.SEVERE, noConnection);
            MoDeleteException aMoDeleteException = new MoDeleteException(noConnection);
            aMoDeleteException.setLdn(aLdns);
            throw aMoDeleteException;
        }
        this.myLdnList = this.splitLdns(aLdns);
        this.preConditonReport = new StringBuilder();
        this.myLog.log(Level.INFO, "MoDeletor constructor done.");
    }

    private String[] splitLdns(String aLdns) {
        String[] ldnsArray = aLdns.split(LDN_DELIMITER);
        return ldnsArray;
    }

    public String preConditionCheck() throws MoDeleteException {
        this.myLog.log(Level.INFO, "MoDeletor preConditionCheck...");
        if (this.myLdnList.length == 0) {
            MoDeleteException aMoDeleteException = new MoDeleteException(ldnMissing);
            aMoDeleteException.setLdn("LDN not supplied");
            throw aMoDeleteException;
        }
        boolean isSystemCreated = false;
        String aLdn = null;
        for (int i = 0; i < this.myLdnList.length; ++i) {
            aLdn = this.myLdnList[i];
            isSystemCreated = this.isSystemCreated(aLdn);
            if (!isSystemCreated) continue;
            MoDeleteException aMoDeleteException = new MoDeleteException(systemCreated);
            aMoDeleteException.setLdn(aLdn);
            throw aMoDeleteException;
        }
        this.myLog.log(Level.FINE, "No system created MOs found for the selected MOs.");
        this.preConditonReport.append("\nNo system created MOs found for the selected MOs.");
        String bLdn = null;
        Mo[] mos = null;
        for (int j = 0; j < this.myLdnList.length; ++j) {
            bLdn = this.myLdnList[j];
            mos = this.getChildren(bLdn);
            if (mos != null && mos.length > 0) {
                String childLdn = null;
                Mo aMo = null;
                for (int k = 0; k < mos.length; ++k) {
                    aMo = mos[k];
                    childLdn = aMo.getLdn();
                    if (this.isHidden(aMo)) {
                        NexLog.logger().info("Found a child MO that is not present in the MOM. Supposing that this is a hidden MO that has been created by the system and will be deleted by the system when the parent is deleted. The LDN of this child is: " + childLdn);
                        continue;
                    }
                    if (this.isSystemCreated(childLdn)) continue;
                    String reason = "The MO has a child that is not system created. Delete the child first:\n" + childLdn;
                    MoDeleteException aMoDeleteException = new MoDeleteException(reason);
                    aMoDeleteException.setLdn(bLdn);
                    throw aMoDeleteException;
                }
                this.myLog.log(Level.FINE, "OK to delete. Only system created children. for " + bLdn);
                this.preConditonReport.append("\nOK to delete. Only system created children. for " + bLdn);
                continue;
            }
            this.myLog.log(Level.FINE, "OK to delete. No Children for: " + bLdn);
            this.preConditonReport.append("\nOK to delete. No Children for: " + bLdn);
        }
        this.myLog.log(Level.INFO, "OK to delete selected MOs");
        this.preConditonReport.append("\nOK to delete selected MOs");
        return this.preConditonReport.toString();
    }

    private boolean isSystemCreated(String aLdn) throws MoDeleteException {
        Mo mo = this.myNode.getCmService().getMo(aLdn);
        MomClass momClass = this.myMimModel.getClass(mo.getType());
        if (momClass == null) {
            String reason = ldnInvalid;
            MoDeleteException aMoDeleteException = new MoDeleteException(reason);
            aMoDeleteException.setLdn(aLdn);
            throw aMoDeleteException;
        }
        boolean isSysMo = momClass.isSystemCreated();
        return isSysMo;
    }

    private boolean isHidden(Mo mo) {
        MomClass momClass = this.myMimModel.getClass(mo.getType());
        return momClass == null;
    }

    private Mo[] getChildren(final String aLdn) {
        long timeout = 20000L;
        this.childrenMos = null;
        Thread myGetter = new Thread("MoDeletot's GetChildrenThread"){

            public void run() {
                CmService cm = MoDeletor.this.myNode.getCmService();
                Mo moRef = cm.getMo(aLdn);
                MoDeletor.access$102(MoDeletor.this, moRef.getChildren("", "", Scope.ONE_LEVEL, null));
            }
        };
        myGetter.start();
        try {
            myGetter.join(timeout);
        }
        catch (InterruptedException e) {
            this.myLog.log(Level.INFO, "Can not getChildren Mo in MoDeletor.");
            this.childrenMos = null;
        }
        return this.childrenMos;
    }

    public void deleteAll() throws Exception {
        int timeoutTime = 3600000;
        Transaction userTx = this.myNode.getCmService().createTransaction(timeoutTime);
        try {
            this.myLog.log(Level.INFO, "quering for deleting...");
            String aLdn = null;
            Mo aMo = null;
            for (int i = 0; i < this.myLdnList.length; ++i) {
                aLdn = this.myLdnList[i];
                aMo = this.myNode.getCmService().getMo(aLdn);
                aMo.delete(userTx);
            }
            this.myLog.log(Level.INFO, " delete. before userTx.commit();");
            userTx.commit();
            this.myLog.log(Level.INFO, " delete. after userTx.commit();");
        }
        catch (Exception e) {
            this.myLog.log(Level.INFO, " failed to delete MOs. Rollback...");
            try {
                userTx.rollback();
            }
            catch (CmException cmEx) {
                this.myLog.log(Level.INFO, " not possible to perform transaction rollback");
            }
            throw e;
        }
        finally {
            this.myMimModel = null;
            this.myNode = null;
            this.myNodeServices = null;
            this.myLog = null;
        }
    }

    public String getDeletedMosList() {
        StringBuffer ldnList = new StringBuffer();
        for (int i = 0; i < this.myLdnList.length; ++i) {
            ldnList.append(this.myLdnList[i]).append("\n");
        }
        return ldnList.toString();
    }

    public String[] getMosList() {
        return this.myLdnList;
    }

    static /* synthetic */ Mo[] access$102(MoDeletor x0, Mo[] x1) {
        x0.childrenMos = x1;
        return x1;
    }
}

