/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices.viewlist.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import se.ericsson.cello.nex.viewservices.viewlist.model.ViewLoadModuleData;
import se.ericsson.cello.nex.viewservices.viewlist.model.ViewlistModelI;
import se.ericsson.cello.nex.viewservices.viewlist.parser.ViewlistParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewlistXmlModel
implements ViewlistModelI {
    private ViewlistParser parser = new ViewlistParser();
    private static final String LOAD_MODULE = "LoadModule";
    private static final String PRODUCT_NAME = "productName";
    private static final String PRODUCT_NUMBER = "productNumber";
    private static final String PRODUCT_REVISION = "productRevision";
    private static final String PATH = "Path";
    private Collection<ViewLoadModuleData> loadModules = null;

    public ViewlistXmlModel(InputSource source, boolean validate) throws SAXException, IOException, ParserConfigurationException {
        this.parser.parse(source, validate);
    }

    @Override
    public Collection<ViewLoadModuleData> getAllViewLoadModules() {
        this.loadModules = new ArrayList<ViewLoadModuleData>();
        NodeList loadModuleList = this.parser.getRoot().getElementsByTagName(LOAD_MODULE);
        int numberOfLoadModules = loadModuleList.getLength();
        for (int i = 0; i < numberOfLoadModules; ++i) {
            String pathValue = "";
            String productName = "";
            String productNumber = "";
            String productRevision = "";
            Node loadModule = loadModuleList.item(i);
            if (loadModule != null && loadModule.getNodeName().equals(LOAD_MODULE)) {
                NamedNodeMap jarFileAttributes = loadModule.getAttributes();
                if (jarFileAttributes != null) {
                    Node revisionAttribute;
                    Node numberAttribute;
                    Node nameAttribute = jarFileAttributes.getNamedItem(PRODUCT_NAME);
                    if (nameAttribute != null) {
                        productName = nameAttribute.getNodeValue();
                    }
                    if ((numberAttribute = jarFileAttributes.getNamedItem(PRODUCT_NUMBER)) != null) {
                        productNumber = numberAttribute.getNodeValue();
                    }
                    if ((revisionAttribute = jarFileAttributes.getNamedItem(PRODUCT_REVISION)) != null) {
                        productRevision = revisionAttribute.getNodeValue();
                    }
                }
                NodeList subNodes = loadModule.getChildNodes();
                int numberOfSubNodes = subNodes.getLength();
                for (int a = 0; a < numberOfSubNodes; ++a) {
                    Node path;
                    Node pathOnNode = subNodes.item(a);
                    if (pathOnNode == null || !pathOnNode.getNodeName().equals(PATH) || (path = pathOnNode.getFirstChild()) == null) continue;
                    pathValue = path.getNodeValue();
                }
            }
            this.loadModules.add(new ViewLoadModuleData(pathValue, productName, productNumber, productRevision));
        }
        return this.loadModules;
    }
}

