/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.codec;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import se.ericsson.security.login.codec.CodecException;
import se.ericsson.security.login.codec.CodecFactory;
import se.ericsson.security.login.codec.CodecFactorySpi;
import se.ericsson.security.login.codec.PKCS5AlgorithmParameters;
import se.ericsson.security.login.codec.PKCS5AlgorithmParametersSpi;

class PKCS8Provider
extends CodecFactorySpi {
    private static final String KEY_HEADER = "-----BEGIN ENCRYPTED PRIVATE KEY-----\n";
    private static final String KEY_FOOTER = "\n-----END ENCRYPTED PRIVATE KEY-----";
    private static final byte[] defaultSalt = new byte[]{-54, -2, -70, -66, -70, -83, 18, 52};

    PKCS8Provider() {
    }

    public byte[] engineEncode(Object object) throws CodecException {
        if (!(object instanceof PrivateKey)) {
            throw new CodecException("Unknown Key Object Class: " + object.getClass().getName());
        }
        PrivateKey privateKey = (PrivateKey)object;
        return this.der2pem(privateKey.getEncoded());
    }

    public byte[] engineEncodeAndEncrypt(Object object, char[] cArray) throws CodecException {
        if (!(object instanceof PrivateKey)) {
            throw new CodecException("Unknown Key Object Class: " + object.getClass().getName());
        }
        PrivateKey privateKey = (PrivateKey)object;
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(defaultSalt, 3);
            SecretKey secretKey = this.generateSecretKey(cArray);
            Cipher cipher = Cipher.getInstance("PBEWithMD5AndDES", "SunJCE");
            cipher.init(1, (Key)secretKey, pBEParameterSpec);
            byte[] byArray = cipher.doFinal(pKCS8EncodedKeySpec.getEncoded());
            PKCS5AlgorithmParameters pKCS5AlgorithmParameters = new PKCS5AlgorithmParameters(new PKCS5AlgorithmParametersSpi());
            pKCS5AlgorithmParameters.init(pBEParameterSpec);
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(pKCS5AlgorithmParameters, byArray);
            return this.der2pem(encryptedPrivateKeyInfo.getEncoded());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CodecException("Failed to encrypt Private key", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new CodecException("Failed to encrypt Private key", iOException);
        }
    }

    public Object engineDecode(byte[] byArray) throws CodecException {
        return this.der2PrivateKey(this.pem2der(byArray));
    }

    public Object engineDecodeAndDecrypt(byte[] byArray, char[] cArray) throws CodecException {
        byte[] byArray2 = this.pem2der(byArray);
        try {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray2);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(defaultSalt, 3);
            SecretKey secretKey = this.generateSecretKey(cArray);
            Cipher cipher = Cipher.getInstance("PBEWithMD5AndDES", "SunJCE");
            cipher.init(2, (Key)secretKey, pBEParameterSpec);
            byte[] byArray3 = cipher.doFinal(encryptedPrivateKeyInfo.getEncryptedData());
            return this.der2PrivateKey(byArray3);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CodecException("Failed to decrypt Private key", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new CodecException("Failed to decrypt Private key", iOException);
        }
    }

    private PrivateKey der2PrivateKey(byte[] byArray) throws CodecException {
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CodecException("Failed to generate Private key from DER representation", generalSecurityException);
        }
    }

    private byte[] pem2der(byte[] byArray) throws CodecException {
        String string = null;
        try {
            string = new String(byArray, this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodecException("Failed to der decode key", unsupportedEncodingException);
        }
        int n = string.indexOf(KEY_HEADER);
        if (n < 0) {
            throw new CodecException("Could not find PEM Key header");
        }
        int n2 = string.indexOf(KEY_FOOTER);
        if (n2 < 0) {
            throw new CodecException("Could not find PEM key footer");
        }
        int n3 = n + KEY_HEADER.length();
        CodecFactory codecFactory = CodecFactory.getInstance("BASE64");
        return (byte[])codecFactory.decode(string.substring(n3, n2));
    }

    private byte[] der2pem(byte[] byArray) throws CodecException {
        CodecFactory codecFactory = CodecFactory.getInstance("BASE64");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(KEY_HEADER);
        stringBuffer.append(codecFactory.encodeAsString(byArray));
        stringBuffer.append(KEY_FOOTER);
        try {
            return stringBuffer.toString().getBytes(this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodecException("Failed to pem encode key", unsupportedEncodingException);
        }
    }

    private SecretKey generateSecretKey(char[] cArray) throws CodecException {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES", "SunJCE");
            return secretKeyFactory.generateSecret(pBEKeySpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CodecException("Failed to generate secret key from password", generalSecurityException);
        }
    }
}

