/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.creds;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.security.login.Log;
import se.ericsson.security.login.codec.CodecException;
import se.ericsson.security.login.codec.CodecFactory;
import se.ericsson.security.login.creds.Credentials;

class XMLCredentialsHandler
extends DefaultHandler {
    private static Log logger = Log.getInstance();
    private final Credentials credentials;
    private Properties properties;
    private List certChain;
    private Set trustedCertificates;
    private StringBuffer buffer;
    private CodecFactory x509;
    private final char[] passwd;

    XMLCredentialsHandler(Credentials credentials, char[] cArray) {
        this.credentials = credentials;
        this.passwd = cArray;
    }

    public void startDocument() throws SAXException {
        try {
            this.x509 = CodecFactory.getInstance("X509");
        }
        catch (CodecException codecException) {
            throw new SAXException("Failed to initialize parser", codecException);
        }
    }

    public void endDocument() {
        this.x509 = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        logger.debug("Start of element " + string3);
        if (string3.equals("certificatechain")) {
            this.certChain = new Vector();
            return;
        }
        if (string3.equals("trustedcertificates")) {
            this.trustedCertificates = new HashSet();
            return;
        }
        if (string3.equals("certificate") || string3.equals("privatekey")) {
            this.buffer = new StringBuffer();
            return;
        }
        if (string3.equals("properties")) {
            this.properties = new Properties();
            return;
        }
        if (attributes != null) {
            this.parseAttributes(attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        logger.debug("End of element " + string3);
        if (string3.equals("certificatechain")) {
            object = new X509Certificate[this.certChain.size()];
            this.certChain.toArray((T[])object);
            this.credentials.setCertificateChain((Certificate[])object);
            String string4 = null;
            for (int i = 0; i < ((Certificate[])object).length; ++i) {
                try {
                    string4 = ((X509Certificate)object[i]).getSubjectDN().getName();
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            String string5 = "";
            if (string4 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken().trim();
                    if (!string6.startsWith("CN")) continue;
                    int n = string6.indexOf("=");
                    if (n == -1) break;
                    if (!string5.equals("")) {
                        string5 = string5 + ",";
                    }
                    string5 = string5 + string6.substring(n + 1);
                    break;
                }
                if (!string5.equals("")) {
                    System.setProperty("ssu.user.name", string5);
                }
            }
            this.certChain.clear();
            this.certChain = null;
        }
        if (string3.equals("trustedcertificates")) {
            object = new X509Certificate[this.trustedCertificates.size()];
            this.trustedCertificates.toArray((T[])object);
            this.credentials.setTrustedCertificates((Certificate[])object);
            this.trustedCertificates.clear();
            this.trustedCertificates = null;
        }
        try {
            if (string3.equals("certificate") && this.certChain != null) {
                this.certChain.add((X509Certificate)this.x509.decode(this.buffer.toString()));
                this.buffer = null;
                return;
            }
            if (string3.equals("certificate") && this.trustedCertificates != null) {
                this.trustedCertificates.add((X509Certificate)this.x509.decode(this.buffer.toString()));
                this.buffer = null;
                return;
            }
            if (string3.equals("privatekey")) {
                object = CodecFactory.getInstance("PKCS#8");
                if (this.passwd != null) {
                    this.credentials.setPrivateKey((PrivateKey)((CodecFactory)object).decodeAndDecrypt(this.buffer.toString(), this.passwd));
                } else {
                    this.credentials.setPrivateKey((PrivateKey)((CodecFactory)object).decode(this.buffer.toString()));
                }
                this.buffer = null;
                return;
            }
        }
        catch (CodecException codecException) {
            throw new SAXException("Failed to parse data", codecException);
        }
        if (string3.equals("properties")) {
            this.credentials.setProperties(this.properties);
            return;
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.buffer != null) {
            this.buffer.append(cArray, n, n2);
        }
    }

    private void parseAttributes(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i);
            if ("name".equals(string)) {
                this.buffer = new StringBuffer(string2);
            }
            if (!"value".equals(string)) continue;
            this.properties.setProperty(this.buffer.toString(), string2);
            this.buffer = null;
        }
    }
}

