/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.portc;

import java.util.StringTokenizer;
import se.ericsson.security.portc.PortException;
import se.ericsson.security.portc.PortProtocol;

class Reply {
    private final int packetLength;
    private final int packetId;
    private final int replyType;
    private final String payload;
    private final int errorCode;

    Reply(byte[] byArray) throws PortException {
        String string = new String(byArray);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, new String("|"));
            this.packetLength = Integer.parseInt(stringTokenizer.nextToken());
            this.replyType = Integer.parseInt(stringTokenizer.nextToken());
            this.packetId = Integer.parseInt(stringTokenizer.nextToken());
            switch (this.replyType) {
                case 101: {
                    this.payload = stringTokenizer.nextToken();
                    this.errorCode = Integer.parseInt(stringTokenizer.nextToken());
                    break;
                }
                case 103: 
                case 199: {
                    this.payload = null;
                    this.errorCode = Integer.parseInt(stringTokenizer.nextToken());
                    break;
                }
                default: {
                    throw new PortException("Unkown reply type:" + this.replyType);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PortException("Failed to parse reply message " + string, numberFormatException);
        }
    }

    int getPacketLength() {
        return this.packetLength;
    }

    int getPacketId() {
        return this.packetId;
    }

    int getReplyType() {
        return this.replyType;
    }

    int getErrorCode() {
        return this.errorCode;
    }

    String getErrorMessage() {
        return PortProtocol.err2Text(this.errorCode);
    }

    String getPayload() {
        return this.payload;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("REPLY[ ");
        stringBuffer.append("Length=").append(this.packetLength);
        stringBuffer.append(" Type=(").append(this.replyType).append(") ");
        switch (this.replyType) {
            case 101: {
                stringBuffer.append("REQUEST_PORT_PEPLY");
                break;
            }
            case 103: {
                stringBuffer.append("REQUEST_PORT_RELEASE_PEPLY");
                break;
            }
            case 199: {
                stringBuffer.append("FATAL_ERROR");
                break;
            }
            default: {
                stringBuffer.append("UNKNOWN_TYPE");
            }
        }
        stringBuffer.append(" ID=").append(this.packetId);
        stringBuffer.append(" ERRORCODE=(").append(this.errorCode);
        stringBuffer.append(") ").append(this.getErrorMessage());
        if (this.payload != null) {
            stringBuffer.append(" PAYLOAD = ").append(this.payload);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

