/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.portc;

import se.ericsson.security.portc.PortException;
import se.ericsson.security.portc.Reply;
import se.ericsson.security.portc.Request;

class RequestPortPacket
extends Request {
    private int port;

    RequestPortPacket() {
        super(100, 101);
        this.init(System.getProperty("user.name"));
    }

    int getPort() throws PortException {
        return this.port;
    }

    void parseReply(Reply reply) throws PortException {
        super.parseReply(reply);
        try {
            this.port = Integer.parseInt(reply.getPayload());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PortException("Couldn't parse portnumber: " + reply.getPayload(), numberFormatException);
        }
        if (this.port == -1) {
            throw new PortException("Received port was " + this.port);
        }
    }
}

