/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.usaal;

import se.ericsson.cello.atm.aal2.UniSaalTpBuildIF;
import se.ericsson.cello.atm.terminations.Aal5TpVccTpMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.UniSaalTpRepository;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.DynamicReserver;
import se.ericsson.cello.mao.DynamicallyReservable;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.usaal.UniSaalProfileMo;
import se.ericsson.cello.usaal.UniSaalProfileMoImpl;
import se.ericsson.cello.usaal.UniSaalTpMo;
import se.ericsson.cello.usaal.UniSaalTpRepositoryImpl;
import se.ericsson.cello.usaal.fropxy.ActUsaalCepCreateFroRsp;
import se.ericsson.cello.usaal.fropxy.ActUsaalCepDeleteFroRsp;
import se.ericsson.cello.usaal.fropxy.ActUsaalCepGetAttrRsp;
import se.ericsson.cello.usaal.fropxy.ActUsaalCepGetPmCountersFroRsp;
import se.ericsson.cello.usaal.fropxy.ActUsaalCepProxy;
import se.ericsson.cello.usaal.fropxy.ActUsaalCepSetAttrRsp;

public class UniSaalTpMoImpl
extends ManagedObjectBase
implements UniSaalTpMo,
UniSaalTpBuildIF,
DynamicReserver {
    private static final int MAX_SDU_SIZE_MIN = 128;
    private static final int MAX_SDU_SIZE_MAX = 2044;
    private static final int MAX_SDU_SIZE_DEFAULT = 128;
    private static final int MAX_NO_UNISAAL_TP_PER_NODE = 4800;
    private static ActUsaalCepProxy usaalCepProxy = ActUsaalCepProxy.instance();
    private static UniSaalTpRepository myFroIdRepository = UniSaalTpRepositoryImpl.instance();
    private ActUsaalCepGetAttrRsp usaalCepGetAttrRspSig;
    private ActUsaalCepGetPmCountersFroRsp usaalCepGetPmRspSig;
    private static final String USAAL_CEP_FRO_ID = "usaalCepFroId";
    private StringAttribute userLabel;
    private ReferenceAttribute uniSaalProfileMo;
    private ReferenceAttribute aal5TpVccTpMo;
    private IntegerAttribute usaalCepFroId;
    private ReferenceAttribute reservedBy;
    private MoData data;
    private static final int MO_DATA_REVISION_51 = 5100;
    private static final int MO_DATA_REVISION_LATEST = 5100;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"UniSaalTp", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        UniSaalProfileMo uniSaalProfileMo = (UniSaalProfileMo)MoAttributeValidator.checkAndGetReferenceAttribute((String)"uniSaalProfileId", (AttrList)attrList, (boolean)true, (Class)UniSaalProfileMo.class, (String)"UniSaalTp");
        Aal5TpVccTpMo aal5TpVccTpMo = (Aal5TpVccTpMo)MoAttributeValidator.checkAndGetReferenceAttribute((String)"aal5TpVccTpId", (AttrList)attrList, (boolean)true, (Class)Aal5TpVccTpMo.class, (String)"UniSaalTp");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"UniSaalTp", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maxSduSize", (AttrList)attrList, (boolean)false, (int)128, (int)128, (int)2044, (String)"UniSaalTp");
        MoAttributeValidator.checkCardinality((String)"UniSaalTp", (int)4800);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"UniSaalTp");
        return new UniSaalTpMoImpl(managedObject, uniSaalProfileMo, uniSaalProfileMo.getProfileData(coordinator), aal5TpVccTpMo, n, string2, string, coordinator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private UniSaalTpMoImpl(ManagedObject managedObject, UniSaalProfileMo uniSaalProfileMo, Struct struct, Aal5TpVccTpMo aal5TpVccTpMo, int n, String string, String string2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "UniSaalTp", string2, coordinator);
        int n2;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.checkMaxSduSize(coordinator, n, (ManagedObject)aal5TpVccTpMo);
        this.checkMaxStat(coordinator, struct, (ManagedObject)aal5TpVccTpMo);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.uniSaalProfileMo = new ReferenceAttribute("uniSaalProfileId", true, (ManagedObject)uniSaalProfileMo);
        this.data.registerPersistentAttr((Attribute)this.uniSaalProfileMo);
        this.aal5TpVccTpMo = new ReferenceAttribute("aal5TpVccTpId", false, (ManagedObject)aal5TpVccTpMo);
        this.data.registerPersistentAttr((Attribute)this.aal5TpVccTpMo);
        this.reservedBy = new ReferenceAttribute("reservedBy", true);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        aal5TpVccTpMo.reserve((ManagedObject)this, coordinator);
        ((UniSaalProfileMoImpl)uniSaalProfileMo).reserve(this, coordinator);
        if (aal5TpVccTpMo.getProcessorId(coordinator) != null) {
            if (!(aal5TpVccTpMo.getProcessorId(coordinator) instanceof PlugInUnitMo)) throw new WrongAttributeTypeException("aal5TpVccTpId", "UniSaalTp");
            PlugInUnitMo plugInUnitMo = (PlugInUnitMo)aal5TpVccTpMo.getProcessorId(coordinator);
            int n3 = ((PiuTypeMo)plugInUnitMo.getPiuType(coordinator)).getRole(coordinator);
            if (n3 != 1) {
                throw new ConfigurationMismatchException("Given Aal5TpVccTp must execute on an MP.", "UniSaalTp");
            }
            n2 = plugInUnitMo.getResourceId(coordinator);
        } else {
            n2 = 0;
        }
        int n4 = this.createUsaalCepFro(coordinator, aal5TpVccTpMo.getAal5CepFroId(coordinator), n2, (Integer)struct.getValue("timerPoll"), (Integer)struct.getValue("maxCC"), (Integer)struct.getValue("maxPD"), (Integer)struct.getValue("maxStat"), (Integer)struct.getValue("initialCredit"), (Integer)struct.getValue("timerKeepAlive"), (Integer)struct.getValue("timerNoResponse"), (Integer)struct.getValue("timerIdle"), (Integer)struct.getValue("timerCC"), (Integer)struct.getValue("congestionOnSet"), (Integer)struct.getValue("congestionAbatement"), n);
        this.usaalCepFroId = new IntegerAttribute(USAAL_CEP_FRO_ID, false, n4);
        this.data.registerPersistentAttr((Attribute)this.usaalCepFroId);
        myFroIdRepository.addInstance(n4, (ManagedObject)this, coordinator);
        usaalCepProxy.registerForNotifications(coordinator, this, this.usaalCepFroId.getValue(coordinator));
        this.data.setRevision(5100);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public UniSaalTpMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(5100);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("uniSaalProfileId");
        moDataRecoveryHelper.assertAttribute("aal5TpVccTpId");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute(USAAL_CEP_FRO_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.uniSaalProfileMo = (ReferenceAttribute)moData.getAttribute("uniSaalProfileId");
        this.aal5TpVccTpMo = (ReferenceAttribute)moData.getAttribute("aal5TpVccTpId");
        this.reservedBy = (ReferenceAttribute)moData.getAttribute("reservedBy");
        this.usaalCepFroId = (IntegerAttribute)moData.getAttribute(USAAL_CEP_FRO_ID);
        myFroIdRepository.addInstance(this.usaalCepFroId.getValue(null), (ManagedObject)this);
        usaalCepProxy.registerForNotifications(null, this, this.usaalCepFroId.getValue(null));
    }

    public void recoverReservations() throws MoAccessException {
        ManagedObject managedObject = this.uniSaalProfileMo.getValue(null);
        if (managedObject != null && managedObject instanceof DynamicallyReservable) {
            ((DynamicallyReservable)managedObject).recoverReservation((ManagedObject)this);
        }
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator) != null) {
            throw new MoReservedNotDeletableException("UniSaalTp");
        }
        ((Aal5TpVccTpMo)this.aal5TpVccTpMo.getValue(coordinator)).release((ManagedObject)this, coordinator);
        ((UniSaalProfileMoImpl)this.uniSaalProfileMo.getValue(coordinator)).release(this, coordinator);
        usaalCepProxy.deregisterForNotifications(coordinator, this.usaalCepFroId.getValue(coordinator));
        this.deleteUsaalCepFro(coordinator);
        myFroIdRepository.removeInstance(this.usaalCepFroId.getValue(coordinator), coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"UniSaalTp", (MoData)this.data, (ReferenceAttribute)this.reservedBy);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"UniSaalTp", (MoData)this.data, (ReferenceAttribute)this.reservedBy);
    }

    public int getPmNoOfUnsuccReTransmissions(Coordinator coordinator) throws MoAccessException {
        return this.getUsaalPmAttributes(coordinator).getPmNoOfUnsuccReTransmissions();
    }

    public String getUniSaalTpId(Coordinator coordinator) {
        return this.getNamingAttributeValue();
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"UniSaalTp", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getUsaalCepFroId(Coordinator coordinator) throws MoAccessException {
        return this.getFroId(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.usaalCepFroId.getValue(coordinator);
    }

    public ManagedObject getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        try {
            ManagedObject managedObject = this.reservedBy.getValue(coordinator);
            return managedObject;
        }
        catch (MoRemovedException moRemovedException) {
            MessageLog.info(this.getClass(), (String)" Database might be corrupt.");
            return null;
        }
    }

    public ManagedObject getUniSaalProfileId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return (UniSaalProfileMo)this.uniSaalProfileMo.getValue(coordinator);
    }

    public void setUniSaalProfileId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!managedObject.getType().equals("UniSaalProfile")) {
            throw new WrongAttributeTypeException("uniSaalProfileId", "UniSaalTp");
        }
        Struct struct = ((UniSaalProfileMoImpl)managedObject).getProfileData(coordinator);
        this.checkMaxStat(coordinator, struct, this.aal5TpVccTpMo.getValue(coordinator));
        ((UniSaalProfileMoImpl)this.uniSaalProfileMo.getValue(coordinator)).release(this, coordinator);
        this.uniSaalProfileMo.setValue(managedObject);
        ((UniSaalProfileMoImpl)this.uniSaalProfileMo.getValue(coordinator)).reserve(this, coordinator);
        this.setUsaalCepAttributes(coordinator, struct, this.getMaxSduSize(coordinator));
    }

    public ManagedObject getAal5TpVccTpId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.aal5TpVccTpMo.getValue(coordinator);
    }

    public int getMaxSduSize(Coordinator coordinator) throws MoAccessException {
        ActUsaalCepGetAttrRsp actUsaalCepGetAttrRsp = this.getUsaalCepAttributes(coordinator);
        return actUsaalCepGetAttrRsp.getMaxSduSize();
    }

    public void setMaxSduSize(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoAttributeValidator.checkIntegerAttribute((String)"maxSduSize", (int)n, (int)128, (int)2044, (String)"UniSaalTp");
        this.checkMaxSduSize(coordinator, n, this.getAal5TpVccTpId(coordinator));
        UniSaalProfileMo uniSaalProfileMo = (UniSaalProfileMo)this.getUniSaalProfileId(coordinator);
        this.setUsaalCepAttributes(coordinator, uniSaalProfileMo.getProfileData(coordinator), n);
        this.sendNotification("maxSduSize", new Integer(n), coordinator);
    }

    public String getIdentity(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getNamingAttributeValue();
    }

    public String getType() {
        return "UniSaalTp";
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        ActUsaalCepGetAttrRsp actUsaalCepGetAttrRsp = this.getUsaalCepAttributes(coordinator);
        return actUsaalCepGetAttrRsp.getOperState();
    }

    public int getPmNoOfSentSDUs(Coordinator coordinator) throws MoAccessException {
        return this.getUsaalPmAttributes(coordinator).getPmNoOfSentSDUs();
    }

    public int getPmNoOfReceivedSDUs(Coordinator coordinator) throws MoAccessException {
        return this.getUsaalPmAttributes(coordinator).getPmNoOfReceivedSDUs();
    }

    public int getPmLinkInServiceTime(Coordinator coordinator) throws MoAccessException {
        return this.getUsaalPmAttributes(coordinator).getPmLinkInServiceTime();
    }

    public int getPmNoOfAllSLFailures(Coordinator coordinator) throws MoAccessException {
        return this.getUsaalPmAttributes(coordinator).getPmNoOfAllSLFailures();
    }

    public int getPmNoOfNoResponses(Coordinator coordinator) throws MoAccessException {
        return this.getUsaalPmAttributes(coordinator).getPmNoOfNoResponses();
    }

    public int getPmNoOfLocalCongestions(Coordinator coordinator) throws MoAccessException {
        return this.getUsaalPmAttributes(coordinator).getPmNoOfLocalCongestions();
    }

    public int getPmNoOfRemoteCongestions(Coordinator coordinator) throws MoAccessException {
        return this.getUsaalPmAttributes(coordinator).getPmNoOfRemoteCongestions();
    }

    public int getPmNoOfSequenceDataLosses(Coordinator coordinator) throws MoAccessException {
        return this.getUsaalPmAttributes(coordinator).getPmNoOfSequenceDataLosses();
    }

    public int getPmNoOfProtocolErrors(Coordinator coordinator) throws MoAccessException {
        return this.getUsaalPmAttributes(coordinator).getPmNoOfProtocolErrors();
    }

    public int getPmNoOfUnSuccReTransmissions(Coordinator coordinator) throws MoAccessException {
        return this.getUsaalPmAttributes(coordinator).getPmNoOfUnsuccReTransmissions();
    }

    public int getPmNoOfOtherErrors(Coordinator coordinator) throws MoAccessException {
        return this.getUsaalPmAttributes(coordinator).getPmNoOfOtherErrors();
    }

    private void deleteUsaalCepFro(Coordinator coordinator) throws MoAccessException {
        ActUsaalCepDeleteFroRsp actUsaalCepDeleteFroRsp = usaalCepProxy.sendDeleteFroReq(coordinator.getTransactionID(), this.usaalCepFroId.getValue(coordinator));
        if (actUsaalCepDeleteFroRsp == null) {
            throw new FroNotAccessibleException("UniSaalTp", "UsaalCep");
        }
        if (actUsaalCepDeleteFroRsp.getResult() != 1) {
            throw new FroRequestFailedException("UniSaalTp", "UniSaalCep", "DeleteFroReq: " + usaalCepProxy.getResultMsg(actUsaalCepDeleteFroRsp.getResult()), actUsaalCepDeleteFroRsp.getResult());
        }
    }

    private int createUsaalCepFro(Coordinator coordinator, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) throws MoAccessException {
        ActUsaalCepCreateFroRsp actUsaalCepCreateFroRsp = usaalCepProxy.sendCreateFroReq(coordinator.getTransactionID(), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14);
        if (actUsaalCepCreateFroRsp == null) {
            super.delete(coordinator);
            this.data.delete(coordinator);
            throw new FroNotAccessibleException("UniSaalTp", "UsaalCep");
        }
        if (actUsaalCepCreateFroRsp.getResult() != 1) {
            super.delete(coordinator);
            this.data.delete(coordinator);
            throw new FroRequestFailedException("UniSaalTp", "UniSaalCep", "CreateFroReq: " + usaalCepProxy.getResultMsg(actUsaalCepCreateFroRsp.getResult()), actUsaalCepCreateFroRsp.getResult());
        }
        return actUsaalCepCreateFroRsp.getFroId();
    }

    private ActUsaalCepGetAttrRsp getUsaalCepAttributes(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        this.usaalCepGetAttrRspSig = usaalCepProxy.sendGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.usaalCepFroId.getValue(coordinator));
        if (this.usaalCepGetAttrRspSig == null) {
            throw new FroNotAccessibleException("UniSaalTp", "UsaalCep");
        }
        if (this.usaalCepGetAttrRspSig.getResult() != 1) {
            throw new FroRequestFailedException("UniSaalTp", "UniSaalCep", "GetAttrReq: " + usaalCepProxy.getResultMsg(this.usaalCepGetAttrRspSig.getResult()), this.usaalCepGetAttrRspSig.getResult());
        }
        return this.usaalCepGetAttrRspSig;
    }

    private ActUsaalCepGetPmCountersFroRsp getUsaalPmAttributes(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        this.usaalCepGetPmRspSig = usaalCepProxy.sendGetPmCountersReq(this.usaalCepFroId.getValue(coordinator));
        if (this.usaalCepGetPmRspSig == null) {
            throw new FroNotAccessibleException("UniSaalTp", "UsaalCep");
        }
        if (this.usaalCepGetPmRspSig.getResult() != 1) {
            if (this.usaalCepGetPmRspSig.getResult() == 100) {
                this.usaalCepGetPmRspSig.setPmCountersUnavailable();
            } else {
                throw new FroRequestFailedException("UniSaalTp", "UniSaalCep", "GetPmCountersReq: " + usaalCepProxy.getResultMsg(this.usaalCepGetPmRspSig.getResult()), this.usaalCepGetPmRspSig.getResult());
            }
        }
        return this.usaalCepGetPmRspSig;
    }

    private void setUsaalCepAttributes(Coordinator coordinator, Struct struct, int n) throws MoAccessException {
        ActUsaalCepSetAttrRsp actUsaalCepSetAttrRsp = usaalCepProxy.sendSetAttrReq(coordinator.getTransactionID(), this.usaalCepFroId.getValue(coordinator), (Integer)struct.getValue("timerPoll"), (Integer)struct.getValue("maxCC"), (Integer)struct.getValue("maxPD"), (Integer)struct.getValue("maxStat"), (Integer)struct.getValue("initialCredit"), (Integer)struct.getValue("timerKeepAlive"), (Integer)struct.getValue("timerNoResponse"), (Integer)struct.getValue("timerIdle"), (Integer)struct.getValue("timerCC"), (Integer)struct.getValue("congestionOnSet"), (Integer)struct.getValue("congestionAbatement"), n);
        if (actUsaalCepSetAttrRsp == null) {
            throw new FroNotAccessibleException("UniSaalTp", "UsaalCep");
        }
        if (actUsaalCepSetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("UniSaalTp", "UniSaalCep", "SetAttrReq: " + usaalCepProxy.getResultMsg(actUsaalCepSetAttrRsp.getResult()), actUsaalCepSetAttrRsp.getResult());
        }
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        Object[] objectArray = new Object[stringArray.length];
        boolean bl = false;
        boolean bl2 = false;
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = this.userLabel.getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("UniSaalTpId")) {
                objectArray[i] = this.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("uniSaalProfileId")) {
                objectArray[i] = this.uniSaalProfileMo.getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal5TpVccTpId")) {
                objectArray[i] = this.aal5TpVccTpMo.getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = this.reservedBy.getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                bl = this.getAttrFromRes(bl, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetAttrRspSig.getOperState());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxSduSize")) {
                bl = this.getAttrFromRes(bl, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetAttrRspSig.getMaxSduSize());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmLinkInServiceTime")) {
                bl2 = this.getPmFromRes(bl2, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetPmRspSig.getPmLinkInServiceTime());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfSentSDUs")) {
                bl2 = this.getPmFromRes(bl2, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetPmRspSig.getPmNoOfSentSDUs());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfReceivedSDUs")) {
                bl2 = this.getPmFromRes(bl2, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetPmRspSig.getPmNoOfReceivedSDUs());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfAllSLFailures")) {
                bl2 = this.getPmFromRes(bl2, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetPmRspSig.getPmNoOfAllSLFailures());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfLocalCongestions")) {
                bl2 = this.getPmFromRes(bl2, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetPmRspSig.getPmNoOfLocalCongestions());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfNoResponses")) {
                bl2 = this.getPmFromRes(bl2, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetPmRspSig.getPmNoOfNoResponses());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfOtherErrors")) {
                bl2 = this.getPmFromRes(bl2, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetPmRspSig.getPmNoOfOtherErrors());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfProtocolErrors")) {
                bl2 = this.getPmFromRes(bl2, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetPmRspSig.getPmNoOfProtocolErrors());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfRemoteCongestions")) {
                bl2 = this.getPmFromRes(bl2, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetPmRspSig.getPmNoOfRemoteCongestions());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfSequenceDataLosses")) {
                bl2 = this.getPmFromRes(bl2, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetPmRspSig.getPmNoOfSequenceDataLosses());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfUnsuccReTransmissions")) {
                bl2 = this.getPmFromRes(bl2, coordinator);
                objectArray[i] = new Integer(this.usaalCepGetPmRspSig.getPmNoOfUnsuccReTransmissions());
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "UniSaalTp");
        }
        return objectArray;
    }

    private boolean getAttrFromRes(boolean bl, Coordinator coordinator) throws MoAccessException {
        if (!bl) {
            this.getUsaalCepAttributes(coordinator);
            bl = true;
        }
        return bl;
    }

    private boolean getPmFromRes(boolean bl, Coordinator coordinator) throws MoAccessException {
        if (!bl) {
            this.getUsaalPmAttributes(coordinator);
            bl = true;
        }
        return bl;
    }

    private void checkMaxSduSize(Coordinator coordinator, int n, ManagedObject managedObject) throws MoAccessException {
        int n2 = this.getLowestMaxSduSizeOfAal5(coordinator, managedObject);
        int n3 = n2 - (n2 % 4 + 4);
        if (n > n3) {
            throw new ValueOutOfRangeException("maxSduSize", "UniSaalTp");
        }
    }

    private int getLowestMaxSduSizeOfAal5(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        int n;
        int n2 = ((Aal5TpVccTpMo)managedObject).getFromUserMaxSduSize(coordinator);
        int n3 = n2 < (n = ((Aal5TpVccTpMo)managedObject).getToUserMaxSduSize(coordinator)) ? n2 : n;
        return n3;
    }

    private void checkMaxStat(Coordinator coordinator, Struct struct, ManagedObject managedObject) throws MoAccessException {
        int n = (Integer)struct.getValue("maxStat");
        if ((n = 4 * n + 12) > this.getLowestMaxSduSizeOfAal5(coordinator, managedObject)) {
            throw new ValueOutOfRangeException("maxStat", "UniSaalProfile");
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }
}

