/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba.interceptor;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import se.ericsson.security.corba.interceptor.TraceErrorLogger;

public class ClientAuthorizationInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private ORB orb;
    private byte[] sharedSecret;
    private static TraceErrorLogger logger = new TraceErrorLogger();

    public ClientAuthorizationInterceptor(ORB oRB, byte[] byArray) {
        this.orb = oRB;
        this.sharedSecret = byArray;
    }

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        ObjectImpl objectImpl = (ObjectImpl)clientRequestInfo.effective_target();
        if (!objectImpl._is_local()) {
            logger.trace(1, ((Object)((Object)this)).getClass(), "Call is external, do nothing");
        } else {
            logger.trace(1, ((Object)((Object)this)).getClass(), "Call is local, sending shared secret.");
            clientRequestInfo.add_request_service_context(new ServiceContext(1000, this.sharedSecret), true);
            Integer n = new Integer(Thread.currentThread().hashCode());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeInt(n);
                clientRequestInfo.add_request_service_context(new ServiceContext(1001, byteArrayOutputStream.toByteArray()), true);
            }
            catch (IOException iOException) {
                logger.trace(1, ((Object)((Object)this)).getClass(), "Could not set thread id in ClientAuthorizationInterceptor " + iOException);
            }
        }
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    public String name() {
        return "ClientAuthorizationInterceptor";
    }

    public void destroy() {
    }
}

