/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba.interceptor;

import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import se.ericsson.security.corba.AccessControlEnabler;
import se.ericsson.security.corba.interceptor.TraceErrorLogger;

public class Level1AuthorizationInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    public static final int NO_AUTHORIZATION = 10000;
    private static AccessControlEnabler impl = null;
    private byte[] sharedSecret = null;
    private ORB orb = null;
    private static final String DUMMY_USERNAME = "seclevel1user";
    private static TraceErrorLogger logger = new TraceErrorLogger();

    public Level1AuthorizationInterceptor(ORB oRB, byte[] byArray) throws INITIALIZE {
        this.orb = oRB;
        this.sharedSecret = byArray;
        try {
            impl = (AccessControlEnabler)oRB.resolve_initial_references("AccessControlEnabler");
        }
        catch (InvalidName invalidName) {
            logger.info(((Object)((Object)this)).getClass(), "Could not resolve AccessControlEnabler");
            throw new INITIALIZE("Could not resolve AccessControlEnabler");
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        String string = serverRequestInfo.operation();
        String string2 = serverRequestInfo.target_most_derived_interface();
        try {
            ServiceContext serviceContext = null;
            boolean bl = false;
            serviceContext = serverRequestInfo.get_request_service_context(1000);
            if (serviceContext != null) {
                bl = this.validateSecret(serviceContext.context_data);
            }
            if (bl) {
                logger.trace(1, ((Object)((Object)this)).getClass(), "Call is local => no access control performed.");
                return;
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
        if (!impl.isAuthorized(DUMMY_USERNAME, null, string2, string)) {
            logger.trace(1, ((Object)((Object)this)).getClass(), string2 + "." + string + " is not allowed for security level 1 dummy username.");
            throw new NO_PERMISSION(10000, CompletionStatus.COMPLETED_NO);
        }
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public String name() {
        return "Level1AuthorizationInterceptor";
    }

    public void destroy() {
    }

    private boolean validateSecret(byte[] byArray) {
        if (byArray.length != this.sharedSecret.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == this.sharedSecret[i]) continue;
            return false;
        }
        return true;
    }
}

