/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.HashMap;
import java.util.List;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueAntFeederCableInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AntFeederCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.upfwk.data.BooleanAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.IntegerAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.StringAttribute;

public class AntFeederCableReconfigurationAue
extends BoamSubAueBase {
    private static final Class SELF = AntFeederCableReconfigurationAue.class;
    private static final String DCI_REFERENCE = "9/109 26-CRH 109 0239-2";
    private static final int LOW_VERSION = 8000000;
    private static final int HIGH_VERSION = 13090199;
    private static final AntFeederCableReconfigurationAue INSTANCE = new AntFeederCableReconfigurationAue();
    private static final String BRANCH_B = "B";
    private static final String BRANCH_A = "A";
    private static final String FEEDER_CABLE_RXB_NAME = "B_EXT";
    private static final String FEEDER_CABLE_RX_NAME_EXT = "_EXT";

    private AntFeederCableReconfigurationAue() {
        super(SELF);
    }

    public static AntFeederCableReconfigurationAue instance() {
        return INSTANCE;
    }

    public int getLowVersion() {
        return 8000000;
    }

    public int getHighVersion() {
        return 13090199;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerConvert(List commands) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)("triggerConvert() in " + SELF.getName()));
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        Coordinator context = tw.getCoordinator();
        HashMap<Integer, AntFeederCableMo> froIDMap = new HashMap<Integer, AntFeederCableMo>();
        MoIterator it = BoamHelper.findMOs((String)"Sector");
        while (it.hasMoreElements()) {
            SectorMo sector = (SectorMo)it.nextMo();
            int rbb = sector.getRadioBuildingBlock(context);
            if (rbb == 6 || rbb == 7) {
                String sectorNo = sector.getNamingAttributeValue();
                MoIterator iterator = BoamHelper.findMOs((String)"AntFeederCable");
                while (iterator.hasMoreElements()) {
                    AntFeederCableMo antFeederCable = (AntFeederCableMo)iterator.nextMo();
                    this.trace("AntFeederCable=" + antFeederCable.getNamingAttributeValue());
                    if (antFeederCable.getNamingAttributeValue().equals(sectorNo + BRANCH_A) && rbb == 6) {
                        Integer froid = (Integer)antFeederCable.getAttribute("AntFeederCableFroId", context);
                        froIDMap.put(froid, antFeederCable);
                        continue;
                    }
                    if (!antFeederCable.getNamingAttributeValue().equals(sectorNo + BRANCH_B)) continue;
                    String LDN = antFeederCable.getLocalDistinguishedName();
                    CMoData cMoData = new CMoData(LDN, antFeederCable.getType(), true, context);
                    cMoData.registerPersistentAttr(new StringAttribute("NEWNAME", false, sectorNo + FEEDER_CABLE_RXB_NAME));
                    cMoData.registerPersistentAttr(new BooleanAttribute("UpdateLDN", false, true));
                    cMoData.handleTransaction(context, CMoData.WRITE_ACCESS);
                }
                continue;
            }
            this.trace("Radio Building Block for sector " + sector.getNamingAttributeValue() + " is not RBB11_1A or RBB10_1A, AntFeederCableReconfigurationAue will not execute.");
        }
        if (froIDMap.size() > 0) {
            this.trace("create AntFeederCable");
            Integer[] froIDs = froIDMap.keySet().toArray(new Integer[froIDMap.size()]);
            MpswTaAueAntFeederCableInfoT[] antFeederCableInfo = AueProxy.instance().createAntFeederCableFros(froIDs);
            if (antFeederCableInfo != null && antFeederCableInfo.length > 0) {
                for (int i = 0; i < antFeederCableInfo.length; ++i) {
                    this.trace("Create AntFeederCable: new froID=" + antFeederCableInfo[i].createdFroId + ", old froID=" + antFeederCableInfo[i].originalFroId);
                    int newAntFeederCableFroID = antFeederCableInfo[i].createdFroId;
                    AntFeederCableMo antFeederCable = (AntFeederCableMo)froIDMap.get(new Integer(antFeederCableInfo[i].originalFroId));
                    CMoData cMoData = new CMoData(antFeederCable.getLocalDistinguishedName() + FEEDER_CABLE_RX_NAME_EXT, antFeederCable.getType(), true, context);
                    cMoData.registerPersistentAttr(new IntegerAttribute("AntFeederCableFroId", false, newAntFeederCableFroID));
                    cMoData.handleTransaction(context, CMoData.WRITE_ACCESS);
                }
            }
        }
        return true;
    }
}

