/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueParentFroIdInfoT;
import se.ericsson.wcdma.rbs.boam.aue.impl.CreateMoHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AntennaBranchMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class SectorAntennaAue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "9/109 26-CRH 109 042/1-5";
    public static final int LOW_VERSION = 6000000;
    private static final int HIGH_VERSION = 7059999;
    public static final String FRO_ID = "froId";
    private static SectorAntennaAue instance = new SectorAntennaAue();

    private SectorAntennaAue() {
        super(SectorAntennaAue.class);
    }

    public static SectorAntennaAue instance() {
        return instance;
    }

    public int getLowVersion() {
        return 6000000;
    }

    public int getHighVersion() {
        return 7059999;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerConvert(List commands) throws Exception {
        this.traceEnter("triggerConvert(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        Coordinator context = tw.getCoordinator();
        AueProxy.instance();
        ArrayList<SectorAntennaMo> sasNeedingFroId = new ArrayList<SectorAntennaMo>();
        MoIterator it = FindMo.findMOs("SectorAntenna");
        while (it.hasMoreElements()) {
            SectorAntennaMo sa = (SectorAntennaMo)it.nextMo();
            MoData moData = SectorAntennaAue.getMoData(sa);
            if (SectorAntennaAue.hasFroId(moData)) continue;
            sasNeedingFroId.add(sa);
        }
        int[] saFroIds = this.sendCreateSaReq(sasNeedingFroId.size());
        if (saFroIds.length != sasNeedingFroId.size()) {
            throw new IllegalStateException("requested " + sasNeedingFroId.size() + " FroIds, got " + saFroIds.length + " FroIds");
        }
        int i = 0;
        Iterator it2 = sasNeedingFroId.iterator();
        while (it2.hasNext()) {
            SectorAntennaMo sa = (SectorAntennaMo)it2.next();
            this.setFroId(SectorAntennaAue.getMoData(sa), saFroIds[i], context);
            ++i;
        }
        ArrayList<MpswTaAueParentFroIdInfoT> froIdInfosList = new ArrayList<MpswTaAueParentFroIdInfoT>();
        MoIterator it3 = FindMo.findMOs("AntennaBranch");
        while (it3.hasMoreElements()) {
            AntennaBranchMo ab = (AntennaBranchMo)it3.nextMo();
            ManagedObject abParent = ab.getParent();
            if (!sasNeedingFroId.contains(abParent)) continue;
            SectorAntennaMo sa = (SectorAntennaMo)abParent;
            int froId = SectorAntennaAue.getFroId(SectorAntennaAue.getMoData(sa), context);
            try {
                int abFroId = ab.getAbFroId(context);
                froIdInfosList.add(new MpswTaAueParentFroIdInfoT(abFroId, froId));
            }
            catch (MoAccessException e) {
                this.traceError("failed to get AntennaBranch FroId", e);
                throw new RuntimeException("failed to get all AntennaBranch FroIds");
            }
        }
        MpswTaAueParentFroIdInfoT[] froIdInfos = froIdInfosList.toArray(new MpswTaAueParentFroIdInfoT[0]);
        this.sendSetParentFroIdRequest(froIdInfos);
        return true;
    }

    private int[] sendCreateSaReq(int nFroIds) throws MoAccessException {
        if (nFroIds == 0) {
            this.info("zero FroIds requested, not sending MPSW_TA_AUE_CREATE_SA request");
            return new int[0];
        }
        return CreateMoHelper.createSectorAntennaFroIdsRequest(nFroIds);
    }

    private void sendSetParentFroIdRequest(MpswTaAueParentFroIdInfoT[] parentFroIdInfos) throws MoAccessException {
        int length = parentFroIdInfos.length;
        if (length == 0) {
            this.info("empty array, not sending MPSW_TA_AUE_SET_PARENTID_AB request");
        } else {
            CreateMoHelper.setParentFroIdRequest(parentFroIdInfos);
        }
    }

    public static boolean hasFroId(MoData moData) {
        Attribute attr = moData.getAttribute(FRO_ID);
        if (attr == null) {
            return false;
        }
        if (attr instanceof IntegerAttribute) {
            return true;
        }
        throw new IllegalStateException("FroId attribute exists but is not IntegerAttribute");
    }

    private static int getFroId(MoData moData, Coordinator context) {
        Attribute attr = moData.getAttribute(FRO_ID);
        if (attr == null) {
            throw new IllegalStateException("FroId missing");
        }
        if (!(attr instanceof IntegerAttribute)) {
            throw new IllegalStateException("FroId attribute is of wrong type");
        }
        return ((IntegerAttribute)attr).getValue(context);
    }

    private void setFroId(MoData moData, int i, Coordinator context) throws Exception {
        this.traceEnter("setFroId(), setting value: " + i);
        moData.handleTransaction(context, MoData.WRITE_ACCESS);
        IntegerAttribute intAttr = (IntegerAttribute)moData.getAttribute(FRO_ID);
        if (intAttr == null) {
            intAttr = new IntegerAttribute(FRO_ID, false);
            moData.registerPersistentAttr((Attribute)intAttr);
        }
        intAttr.setValue(i);
    }

    private static MoData getMoData(Object saObject) throws Exception {
        Class<?> saClass = saObject.getClass();
        Method m = saClass.getMethod("getMyMoData", new Class[0]);
        return (MoData)m.invoke(saObject, new Object[0]);
    }
}

